/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.fadada.dto.FadadaCreateMemberDTO;
import com.els.modules.electronsign.fadada.entity.SaleFadadaOrg;
import com.els.modules.electronsign.fadada.entity.SaleFadadaOrgPsn;
import com.els.modules.electronsign.fadada.entity.SaleFadadaPersonal;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaOrgMapper;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaOrgPsnMapper;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaPersonalMapper;
import com.els.modules.electronsign.fadada.service.SaleFadadaOrgPsnService;
import com.els.modules.electronsign.fadada.util.FadadaCallUtil;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleFadadaOrgPsnServiceImpl
extends BaseServiceImpl<SaleFadadaOrgPsnMapper, SaleFadadaOrgPsn>
implements SaleFadadaOrgPsnService {
    @Autowired
    private FadadaCallUtil fadadaCallUtil;
    @Autowired
    private SaleFadadaPersonalMapper saleFadadaPersonalMapper;
    @Autowired
    private SaleFadadaOrgMapper saleFadadaOrgMapper;

    @Override
    public void add(SaleFadadaOrgPsn saleFadadaOrgPsn) {
        String elsAccount = TenantContext.getTenant();
        QueryWrapper saleFadadaPersonalQueryWrapper = new QueryWrapper();
        saleFadadaPersonalQueryWrapper.eq((Object)"els_account", (Object)elsAccount);
        saleFadadaPersonalQueryWrapper.eq((Object)"client_user_id", (Object)saleFadadaOrgPsn.getClientUserId());
        SaleFadadaPersonal personal = (SaleFadadaPersonal)((Object)this.saleFadadaPersonalMapper.selectOne((Wrapper)saleFadadaPersonalQueryWrapper));
        if (personal == null) {
            throw new ELSBootException("\u8bf7\u9009\u62e9\u5458\u5de5");
        }
        saleFadadaOrgPsn.setMemberStatus("enable");
        saleFadadaOrgPsn.setActive("0");
        saleFadadaOrgPsn.setOpenUserId(personal.getOpenUserId());
        QueryWrapper saleFadadaOrgQueryWrapper = new QueryWrapper();
        saleFadadaOrgQueryWrapper.eq((Object)"els_account", (Object)elsAccount);
        saleFadadaOrgQueryWrapper.eq((Object)"client_corp_id", (Object)saleFadadaOrgPsn.getClientCorpId());
        SaleFadadaOrg purchaseFadadaOrg = (SaleFadadaOrg)((Object)this.saleFadadaOrgMapper.selectOne((Wrapper)saleFadadaOrgQueryWrapper));
        if (purchaseFadadaOrg == null) {
            throw new ELSBootException("\u8bf7\u9009\u62e9\u673a\u6784");
        }
        saleFadadaOrgPsn.setOpenCorpId(purchaseFadadaOrg.getOpenCorpId());
        FadadaCreateMemberDTO fadadaCreateMemberDTO = new FadadaCreateMemberDTO(saleFadadaOrgPsn);
        String requestStr = JSONObject.toJSONString((Object)fadadaCreateMemberDTO);
        JSONObject requestObject = JSONObject.parseObject((String)requestStr);
        requestObject.put("currentAccount", (Object)saleFadadaOrgPsn.getBusAccount());
        JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_create_member");
        JSONArray array = response.getJSONArray("data");
        JSONObject memberObject = JSONArray.parseObject((String)array.get(0).toString());
        saleFadadaOrgPsn.setMemberId(memberObject.getString("memberId"));
        saleFadadaOrgPsn.setMemberActiveUrl(memberObject.getString("memberActiveUrl"));
        saleFadadaOrgPsn.setMemberActiveEmbedUrl(memberObject.getString("memberActiveEmbedUrl"));
        ((SaleFadadaOrgPsnMapper)this.baseMapper).insert((Object)saleFadadaOrgPsn);
    }

    @Override
    public void edit(SaleFadadaOrgPsn saleFadadaOrgPsn) {
        if (StringUtils.isNotBlank((CharSequence)saleFadadaOrgPsn.getId())) {
            int count = ((SaleFadadaOrgPsnMapper)this.baseMapper).updateById((Object)saleFadadaOrgPsn);
            Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        } else {
            this.add(saleFadadaOrgPsn);
        }
    }

    @Override
    public void delete(String id) {
        SaleFadadaOrgPsn saleFadadaOrgPsn = (SaleFadadaOrgPsn)((Object)this.getById((Serializable)((Object)id)));
        if (StringUtils.isNotBlank((CharSequence)saleFadadaOrgPsn.getMemberId())) {
            JSONObject request = new JSONObject();
            request.put("openCorpId", (Object)saleFadadaOrgPsn.getOpenCorpId());
            String[] memberIds = new String[]{saleFadadaOrgPsn.getMemberId()};
            request.put("memberIds", (Object)memberIds);
            request.put("currentAccount", (Object)saleFadadaOrgPsn.getBusAccount());
            JSONObject response = this.fadadaCallUtil.call(request.toJSONString(), "fadada_delete_member");
            ((SaleFadadaOrgPsnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        } else {
            ((SaleFadadaOrgPsnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        }
    }

    @Override
    public void deleteBatch(List<String> idList) {
        for (String id : idList) {
            this.delete(id);
        }
    }

    @Override
    public void disabled(String id, String status) {
        SaleFadadaOrgPsn saleFadadaOrgPsn = (SaleFadadaOrgPsn)((Object)this.getById((Serializable)((Object)id)));
        if (StringUtils.isNotBlank((CharSequence)saleFadadaOrgPsn.getMemberId())) {
            JSONObject request = new JSONObject();
            request.put("openCorpId", (Object)saleFadadaOrgPsn.getOpenCorpId());
            String[] memberIds = new String[]{saleFadadaOrgPsn.getMemberId()};
            request.put("memberIds", (Object)memberIds);
            request.put("memberStatus", (Object)status);
            request.put("currentAccount", (Object)saleFadadaOrgPsn.getBusAccount());
            this.fadadaCallUtil.call(request.toJSONString(), "fadada_set_member_status");
        }
    }
}

