/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.electronsign.esign.enumerate.SignerVindicateStatusEnum;
import com.els.modules.electronsign.fadada.dto.FadadaDocDTO;
import com.els.modules.electronsign.fadada.dto.FadadaFileSignTaskCreateDTO;
import com.els.modules.electronsign.fadada.dto.FadadaSignTaskActorDTO;
import com.els.modules.electronsign.fadada.entity.FadadaSignAttachmenPurchase;
import com.els.modules.electronsign.fadada.entity.FadadaSignAttachmenSale;
import com.els.modules.electronsign.fadada.entity.FadadaSignTaskPurchase;
import com.els.modules.electronsign.fadada.entity.FadadaSignTaskSale;
import com.els.modules.electronsign.fadada.entity.FadadaTaskActorPurchase;
import com.els.modules.electronsign.fadada.enums.FadadaJudgeEnum;
import com.els.modules.electronsign.fadada.enums.FadadaSealFieldTypeEnum;
import com.els.modules.electronsign.fadada.enums.FadadaSignTaskStatusEnum;
import com.els.modules.electronsign.fadada.mapper.FadadaSignTaskPurchaseMapper;
import com.els.modules.electronsign.fadada.mapper.PurchaseFadadaSealMapper;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaSealMapper;
import com.els.modules.electronsign.fadada.service.FadadaSignAttachmenPurchaseService;
import com.els.modules.electronsign.fadada.service.FadadaSignAttachmenSaleService;
import com.els.modules.electronsign.fadada.service.FadadaSignTaskPurchaseService;
import com.els.modules.electronsign.fadada.service.FadadaSignTaskSaleService;
import com.els.modules.electronsign.fadada.service.FadadaTaskActorPurchaseService;
import com.els.modules.electronsign.fadada.util.FadadaCallUtil;
import com.els.modules.electronsign.fadada.vo.FadadaSignTaskPurchaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class FadadaSignTaskPurchaseServiceImpl
extends BaseServiceImpl<FadadaSignTaskPurchaseMapper, FadadaSignTaskPurchase>
implements FadadaSignTaskPurchaseService {
    @Resource
    private FadadaTaskActorPurchaseService fadadaTaskActorPurchaseService;
    @Resource
    private FadadaSignAttachmenPurchaseService fadadaSignAttachmenPurchaseService;
    @Resource
    private FadadaSignTaskSaleService fadadaSignTaskSaleService;
    @Resource
    private FadadaSignAttachmenSaleService fadadaSignAttachmenSaleService;
    @Resource
    private PurchaseFadadaSealMapper purchaseFadadaSealMapper;
    @Resource
    private SaleFadadaSealMapper saleFadadaSealMapper;
    @Autowired
    private FadadaCallUtil fadadaCallUtil;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(FadadaSignTaskPurchase fadadaSignTaskPurchase, List<FadadaTaskActorPurchase> fadadaTaskActorPurchaseList, List<FadadaSignAttachmenPurchase> fadadaSignAttachmenPurchaseList, List<FadadaSignAttachmenPurchase> fadadaSignAttachmenPurchaseBackList) {
        LoginUser loginUser = SysUtil.getLoginUser();
        fadadaSignTaskPurchase.setBusAccount(loginUser.getElsAccount());
        fadadaSignTaskPurchase.setPurchaseName(loginUser.getEnterpriseName());
        fadadaSignTaskPurchase.setSignTaskStatus(FadadaSignTaskStatusEnum.task_created.getValue());
        fadadaSignTaskPurchase.setAutoStart(FadadaJudgeEnum.TRUE.getValue());
        fadadaSignTaskPurchase.setAutoFinish(FadadaJudgeEnum.TRUE.getValue());
        fadadaSignTaskPurchase.setSignerVindicateStatus(SignerVindicateStatusEnum.NO_MAINTENANCE.getValue());
        fadadaSignTaskPurchase.setSendStatus("0");
        fadadaSignTaskPurchase.setSignInOrder(FadadaJudgeEnum.TRUE.getValue());
        fadadaSignTaskPurchase.setSignFileUploaded("0");
        ((FadadaSignTaskPurchaseMapper)this.baseMapper).insert((Object)fadadaSignTaskPurchase);
        super.setHeadDefaultValue((BaseEntity)fadadaSignTaskPurchase);
        this.insertData(fadadaSignTaskPurchase, fadadaTaskActorPurchaseList, fadadaSignAttachmenPurchaseList, fadadaSignAttachmenPurchaseBackList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(FadadaSignTaskPurchase fadadaSignTaskPurchase, List<FadadaTaskActorPurchase> fadadaTaskActorPurchaseList, List<FadadaSignAttachmenPurchase> fadadaSignAttachmenPurchaseList, List<FadadaSignAttachmenPurchase> fadadaSignAttachmenPurchaseBackList) {
        int count = ((FadadaSignTaskPurchaseMapper)this.baseMapper).updateById((Object)fadadaSignTaskPurchase);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.fadadaTaskActorPurchaseService.deleteByMainId(fadadaSignTaskPurchase.getId());
        this.fadadaSignAttachmenPurchaseService.deleteByMainId(fadadaSignTaskPurchase.getId());
        this.insertData(fadadaSignTaskPurchase, fadadaTaskActorPurchaseList, fadadaSignAttachmenPurchaseList, fadadaSignAttachmenPurchaseBackList);
    }

    private void insertData(FadadaSignTaskPurchase fadadaSignTaskPurchase, List<FadadaTaskActorPurchase> fadadaTaskActorPurchaseList, List<FadadaSignAttachmenPurchase> fadadaSignAttachmenPurchaseList, List<FadadaSignAttachmenPurchase> fadadaSignAttachmenPurchaseBackList) {
        if (!CollectionUtils.isEmpty(fadadaTaskActorPurchaseList)) {
            boolean salesSigner = false;
            boolean purchaseSigner = false;
            for (FadadaTaskActorPurchase entity : fadadaTaskActorPurchaseList) {
                entity.setHeadId(fadadaSignTaskPurchase.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)fadadaSignTaskPurchase);
                if (StringUtils.isBlank((CharSequence)entity.getOwning())) {
                    entity.setOwning("purchase");
                }
                if ("mobile".equals(entity.getNotifyWay())) {
                    entity.setNotifyAddress(entity.getMobile());
                } else {
                    entity.setNotifyAddress(entity.getEmail());
                }
                if ("corp".equals(entity.getActorType())) {
                    entity.setActorName(entity.getCorpName());
                    entity.setActorOpenId(entity.getOpenCorpId());
                } else {
                    entity.setActorName(entity.getUseName());
                    entity.setActorOpenId(entity.getOpenUserId());
                }
                if ("sale".equals(entity.getOwning())) {
                    salesSigner = true;
                    continue;
                }
                if (!"purchase".equals(entity.getOwning())) continue;
                purchaseSigner = true;
            }
            this.fadadaTaskActorPurchaseService.saveBatch(fadadaTaskActorPurchaseList, 2000);
            if ("0".equals(fadadaSignTaskPurchase.getOnlineSealed())) {
                fadadaSignTaskPurchase.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
            } else if (salesSigner && purchaseSigner) {
                fadadaSignTaskPurchase.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
            } else if (!salesSigner && purchaseSigner) {
                fadadaSignTaskPurchase.setSignerVindicateStatus(SignerVindicateStatusEnum.SALE_NO_MAINTENANCE.getValue());
            } else if (salesSigner && !purchaseSigner) {
                fadadaSignTaskPurchase.setSignerVindicateStatus(SignerVindicateStatusEnum.PURCHASE_NO_MAINTENANCE.getValue());
            }
        } else {
            fadadaSignTaskPurchase.setSignerVindicateStatus(SignerVindicateStatusEnum.NO_MAINTENANCE.getValue());
        }
        if (!CollectionUtils.isEmpty(fadadaSignAttachmenPurchaseList)) {
            for (FadadaSignAttachmenPurchase entity : fadadaSignAttachmenPurchaseList) {
                entity.setHeadId(fadadaSignTaskPurchase.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)fadadaSignTaskPurchase);
            }
            this.fadadaSignAttachmenPurchaseService.saveBatch(fadadaSignAttachmenPurchaseList, 2000);
        }
        if (!CollectionUtils.isEmpty(fadadaSignAttachmenPurchaseBackList)) {
            for (FadadaSignAttachmenPurchase entity : fadadaSignAttachmenPurchaseBackList) {
                entity.setHeadId(fadadaSignTaskPurchase.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)fadadaSignTaskPurchase);
            }
            this.fadadaSignAttachmenPurchaseService.saveBatch(fadadaSignAttachmenPurchaseBackList, 2000);
        }
        this.updateById((Object)fadadaSignTaskPurchase);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.fadadaTaskActorPurchaseService.deleteByMainId(id);
        this.fadadaSignAttachmenPurchaseService.deleteByMainId(id);
        ((FadadaSignTaskPurchaseMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.fadadaTaskActorPurchaseService.deleteByMainId(serializable.toString());
            this.fadadaSignAttachmenPurchaseService.deleteByMainId(serializable.toString());
            ((FadadaSignTaskPurchaseMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public void send(FadadaSignTaskPurchase fadadaSignTaskPurchase, List<FadadaTaskActorPurchase> fadadaTaskActorPurchaseList, List<FadadaSignAttachmenPurchase> fadadaSignAttachmenPurchaseList) {
        if (CollectionUtils.isEmpty(fadadaSignAttachmenPurchaseList)) {
            throw new ELSBootException("\u7b7e\u7f72\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FadadaSignTaskSale fadadaSignTaskSale = (FadadaSignTaskSale)((Object)SysUtil.copyProperties((Object)((Object)fadadaSignTaskPurchase), FadadaSignTaskSale.class));
        fadadaSignTaskSale.setId(null);
        fadadaSignTaskSale.setElsAccount(fadadaSignTaskPurchase.getToElsAccount());
        fadadaSignTaskSale.setToElsAccount(fadadaSignTaskPurchase.getElsAccount());
        fadadaSignTaskSale.setRelationId(fadadaSignTaskPurchase.getId());
        ArrayList<FadadaSignAttachmenSale> fadadaSignAttachmenSales = new ArrayList<FadadaSignAttachmenSale>();
        for (FadadaSignAttachmenPurchase entity : fadadaSignAttachmenPurchaseList) {
            FadadaSignAttachmenSale fadadaSignAttachmenSale = (FadadaSignAttachmenSale)((Object)SysUtil.copyProperties((Object)((Object)entity), FadadaSignAttachmenSale.class));
            fadadaSignAttachmenSale.setElsAccount(fadadaSignTaskSale.getElsAccount());
            fadadaSignAttachmenSale.setReceiveStatus("1");
            fadadaSignAttachmenSale.setRelationId(entity.getId());
            fadadaSignAttachmenSales.add(fadadaSignAttachmenSale);
            entity.setSendStatus("1");
        }
        this.fadadaSignTaskSaleService.saveMain(fadadaSignTaskSale, null, fadadaSignAttachmenSales);
        this.fadadaTaskActorPurchaseService.deleteByMainId(fadadaSignTaskPurchase.getId());
        this.fadadaSignAttachmenPurchaseService.deleteByMainId(fadadaSignTaskPurchase.getId());
        fadadaSignTaskPurchase.setSendStatus("1");
        fadadaSignTaskPurchase.setRelationId(fadadaSignTaskSale.getId());
        this.insertData(fadadaSignTaskPurchase, fadadaTaskActorPurchaseList, fadadaSignAttachmenPurchaseList, null);
    }

    @Override
    public void signHandle(FadadaSignTaskPurchaseVO fadadaSignTaskPurchasePage) {
        FadadaSignTaskPurchase fadadaSignTaskPurchase = new FadadaSignTaskPurchase();
        BeanUtils.copyProperties((Object)((Object)fadadaSignTaskPurchasePage), (Object)((Object)fadadaSignTaskPurchase));
        List<Object> taskActorPurchaseList = new ArrayList();
        if ("1".equals(fadadaSignTaskPurchase.getOnlineSealed())) {
            if (CollectionUtils.isEmpty(fadadaSignTaskPurchasePage.getFadadaTaskActorPurchaseList()) || CollectionUtils.isEmpty(fadadaSignTaskPurchasePage.getFadadaTaskActorSaleList())) {
                throw new ELSBootException("\u7b7e\u7f72\u4eba\u672a\u5b8c\u5168\u7ef4\u62a4\u5b8c\u6210");
            }
            taskActorPurchaseList.addAll(fadadaSignTaskPurchasePage.getFadadaTaskActorSaleList());
            taskActorPurchaseList.addAll(fadadaSignTaskPurchasePage.getFadadaTaskActorPurchaseList());
        } else {
            if (CollectionUtils.isEmpty(fadadaSignTaskPurchasePage.getFadadaTaskActorPurchaseList())) {
                throw new ELSBootException("\u7b7e\u7f72\u4eba\u672a\u5b8c\u5168\u7ef4\u62a4\u5b8c\u6210");
            }
            taskActorPurchaseList = fadadaSignTaskPurchasePage.getFadadaTaskActorPurchaseList();
        }
        boolean corpSeal = false;
        boolean corp_seal_cross_page = false;
        String idType = null;
        String openId = null;
        boolean freeVisaSign = false;
        HashMap<String, List<FadadaTaskActorPurchase>> docFiledMap = new HashMap<String, List<FadadaTaskActorPurchase>>();
        for (FadadaTaskActorPurchase fadadaTaskActorPurchase : taskActorPurchaseList) {
            List<FadadaTaskActorPurchase> actorPurchases;
            if (FadadaSealFieldTypeEnum.corp_seal_cross_page.getValue().equals(fadadaTaskActorPurchase.getFieldType())) {
                corp_seal_cross_page = true;
            }
            if (FadadaSealFieldTypeEnum.corp_seal.getValue().equals(fadadaTaskActorPurchase.getFieldType())) {
                corpSeal = true;
            }
            if ("1".equals(fadadaTaskActorPurchase.getFbk1())) {
                idType = fadadaTaskActorPurchase.getActorType();
                openId = "corp".equals(idType) ? fadadaTaskActorPurchase.getOpenCorpId() : fadadaTaskActorPurchase.getOpenUserId();
            }
            if (docFiledMap.get(fadadaTaskActorPurchase.getFieldDocId()) != null) {
                actorPurchases = (List)docFiledMap.get(fadadaTaskActorPurchase.getFieldDocId());
                actorPurchases.add(fadadaTaskActorPurchase);
                docFiledMap.put(fadadaTaskActorPurchase.getFieldDocId(), actorPurchases);
            } else {
                actorPurchases = new ArrayList<FadadaTaskActorPurchase>();
                actorPurchases.add(fadadaTaskActorPurchase);
                docFiledMap.put(fadadaTaskActorPurchase.getFieldDocId(), actorPurchases);
            }
            if (!FadadaJudgeEnum.TRUE.getValue().equals(fadadaTaskActorPurchase.getRequestVerifyFree())) continue;
            freeVisaSign = true;
            if ("purchase".equals(fadadaTaskActorPurchase.getOwning())) {
                QueryWrapper purchaseFadadaSealQueryWrapper = new QueryWrapper();
                purchaseFadadaSealQueryWrapper.eq((Object)"els_account", (Object)fadadaSignTaskPurchase.getElsAccount());
                purchaseFadadaSealQueryWrapper.eq((Object)"visa_free", (Object)"1");
                purchaseFadadaSealQueryWrapper.eq((Object)"seal_id", (Object)fadadaTaskActorPurchase.getSealId());
                if (this.purchaseFadadaSealMapper.selectCount((Wrapper)purchaseFadadaSealQueryWrapper) >= 1) continue;
                throw new ELSBootException("\u673a\u6784\u3010" + fadadaTaskActorPurchase.getCorpName() + "\u3011\u7684\u5370\u7ae0\u3010" + fadadaTaskActorPurchase.getSealName() + "\u3011\u672a\u8bbe\u7f6e\u514d\u7b7e");
            }
            QueryWrapper saleFadadaSealQueryWrapper = new QueryWrapper();
            saleFadadaSealQueryWrapper.eq((Object)"els_account", (Object)fadadaSignTaskPurchase.getToElsAccount());
            saleFadadaSealQueryWrapper.eq((Object)"visa_free", (Object)"1");
            saleFadadaSealQueryWrapper.eq((Object)"seal_id", (Object)fadadaTaskActorPurchase.getSealId());
            if (this.saleFadadaSealMapper.selectCount((Wrapper)saleFadadaSealQueryWrapper) >= 1) continue;
            throw new ELSBootException("\u673a\u6784\u3010" + fadadaTaskActorPurchase.getCorpName() + "\u3011\u7684\u5370\u7ae0\u3010" + fadadaTaskActorPurchase.getSealName() + "\u3011\u672a\u8bbe\u7f6e\u514d\u7b7e");
        }
        if (freeVisaSign && StringUtils.isBlank((CharSequence)fadadaSignTaskPurchase.getBusinessId())) {
            throw new ELSBootException("\u7b7e\u7f72\u4eba\u4e2d\u5b58\u5728\u81ea\u52a8\u843d\u7ae0\u573a\u666f\uff0c\u514d\u7b7e\u573a\u666f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (corp_seal_cross_page && !corpSeal) {
            throw new ELSBootException("\u7b7e\u7f72\u5b58\u5728\u9a91\u7f1d\u7ae0\u5219\u5fc5\u987b\u540c\u65f6\u5b58\u5728\u4f01\u4e1a\u516c\u7ae0");
        }
        ArrayList<FadadaSignAttachmenPurchase> docAttachment = new ArrayList<FadadaSignAttachmenPurchase>();
        ArrayList<FadadaSignAttachmenPurchase> arrayList = new ArrayList<FadadaSignAttachmenPurchase>();
        if (!"1".equals(fadadaSignTaskPurchase.getOnlineSealed()) && "sale".equals(fadadaSignTaskPurchase.getFirstSeal())) {
            for (FadadaSignAttachmenPurchase entity : fadadaSignTaskPurchasePage.getFadadaSignAttachmenPurchaseBackList()) {
                if ("doc".equals(entity.getSignType())) {
                    docAttachment.add(entity);
                    continue;
                }
                arrayList.add(entity);
            }
        } else {
            for (FadadaSignAttachmenPurchase entity : fadadaSignTaskPurchasePage.getFadadaSignAttachmenPurchaseList()) {
                if ("doc".equals(entity.getSignType())) {
                    docAttachment.add(entity);
                    continue;
                }
                arrayList.add(entity);
            }
        }
        fadadaSignTaskPurchase.setIdType(idType);
        fadadaSignTaskPurchase.setOpenId(openId);
        FadadaFileSignTaskCreateDTO fileSignTaskCreateDTO = this.signData(idType, openId, fadadaSignTaskPurchase, taskActorPurchaseList, docAttachment, arrayList, docFiledMap);
        String requestStr = JSONObject.toJSONString((Object)fileSignTaskCreateDTO);
        JSONObject response = this.fadadaCallUtil.call(requestStr, "fadada_sign");
        fadadaSignTaskPurchase.setSignTaskId(response.getString("signTaskId"));
        fadadaSignTaskPurchase.setIsAutoStart("1");
        this.updateById((Object)fadadaSignTaskPurchase);
        this.fadadaTaskActorPurchaseService.updateBatchById(taskActorPurchaseList);
    }

    @Override
    public void refresh(String id) {
        FadadaSignTaskPurchase signTaskPurchase = (FadadaSignTaskPurchase)((Object)this.getById((Serializable)((Object)id)));
        if (signTaskPurchase != null) {
            JSONObject requestObject = new JSONObject();
            requestObject.put("signTaskId", (Object)signTaskPurchase.getSignTaskId());
            requestObject.put("currentAccount", (Object)signTaskPurchase.getElsAccount());
            JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_sign_detail");
            signTaskPurchase.setSignTaskStatus(response.getString("signTaskStatus"));
            FadadaSignTaskSale signTaskSale = null;
            if (("1".equals(signTaskPurchase.getOnlineSealed()) || !"1".equals(signTaskPurchase.getOnlineSealed()) && "sale".equals(signTaskPurchase.getFirstSeal())) && StringUtils.isNotBlank((CharSequence)signTaskPurchase.getRelationId())) {
                signTaskSale = (FadadaSignTaskSale)((Object)this.fadadaSignTaskSaleService.getById((Serializable)((Object)signTaskPurchase.getRelationId())));
                signTaskSale.setSignTaskStatus(signTaskPurchase.getSignTaskStatus());
                if (FadadaSignTaskStatusEnum.task_finished.getValue().equals(response.getString("signTaskStatus"))) {
                    signTaskPurchase.setIsAutoFinish("1");
                    signTaskSale.setIsAutoFinish(signTaskPurchase.getIsAutoFinish());
                }
                this.fadadaSignTaskSaleService.updateById((Object)signTaskSale);
            }
            this.updateById((Object)signTaskPurchase);
            if (FadadaSignTaskStatusEnum.task_finished.getValue().equals(response.getString("signTaskStatus"))) {
                this.saveSignFile(signTaskPurchase, signTaskSale);
            }
        }
    }

    @Override
    public void saveSignFile(FadadaSignTaskPurchase taskPurchase, FadadaSignTaskSale signTaskSale) {
        QueryWrapper signAttachmenPurchaseQueryWrapper = new QueryWrapper();
        if (!"1".equals(taskPurchase.getOnlineSealed()) && "sale".equals(taskPurchase.getFirstSeal())) {
            signAttachmenPurchaseQueryWrapper.eq((Object)"head_id", (Object)taskPurchase.getId());
            signAttachmenPurchaseQueryWrapper.eq((Object)"receive_status", (Object)"1");
            signAttachmenPurchaseQueryWrapper.isNotNull((Object)"file_id");
        } else {
            signAttachmenPurchaseQueryWrapper.eq((Object)"head_id", (Object)taskPurchase.getId());
            signAttachmenPurchaseQueryWrapper.and(o -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)o.isNotNull((Object)"receive_status")).or()).eq((Object)"receive_status", (Object)"")).or()).eq((Object)"receive_status", (Object)"0");
            });
            signAttachmenPurchaseQueryWrapper.isNotNull((Object)"file_id");
        }
        List signAttachmenPurchases = this.fadadaSignAttachmenPurchaseService.list((Wrapper)signAttachmenPurchaseQueryWrapper);
        if (!signAttachmenPurchases.isEmpty()) {
            ArrayList<FadadaSignAttachmenSale> signAttachmenSales = new ArrayList<FadadaSignAttachmenSale>();
            for (FadadaSignAttachmenPurchase entity : signAttachmenPurchases) {
                FadadaSignAttachmenSale signAttachmenSale;
                entity.setExistSignFile("1");
                if (signTaskSale == null || (signAttachmenSale = (FadadaSignAttachmenSale)((Object)this.fadadaSignAttachmenSaleService.getById((Serializable)((Object)entity.getRelationId())))) == null) continue;
                signAttachmenSale.setExistSignFile("1");
                signAttachmenSales.add(signAttachmenSale);
            }
            this.fadadaSignAttachmenPurchaseService.updateBatchById(signAttachmenPurchases);
            if (!CollectionUtils.isEmpty(signAttachmenSales)) {
                this.fadadaSignAttachmenSaleService.updateBatchById(signAttachmenSales);
            }
        }
    }

    @Override
    public void listSend(String id) {
        FadadaSignTaskPurchase fadadaSignTaskPurchase = (FadadaSignTaskPurchase)((Object)this.getById((Serializable)((Object)id)));
        List<FadadaTaskActorPurchase> signTaskPurchases = this.fadadaTaskActorPurchaseService.selectByMainId(id);
        List<FadadaSignAttachmenPurchase> signAttachmenPurchases = this.fadadaSignAttachmenPurchaseService.selectByMainId(id);
        this.send(fadadaSignTaskPurchase, signTaskPurchases, signAttachmenPurchases);
    }

    @Override
    public void back(String id, String sendBackReason) {
        FadadaSignTaskPurchase signTaskPurchase = (FadadaSignTaskPurchase)((Object)this.getById((Serializable)((Object)id)));
        signTaskPurchase.setSendBack("1");
        signTaskPurchase.setSendBackReson(sendBackReason);
        signTaskPurchase.setSaleFileUploaded("0");
        FadadaSignTaskSale signTaskSale = (FadadaSignTaskSale)((Object)this.fadadaSignTaskSaleService.getById((Serializable)((Object)signTaskPurchase.getRelationId())));
        signTaskSale.setSendBack("1");
        signTaskSale.setSendBackReson(sendBackReason);
        signTaskSale.setSaleFileUploaded("0");
        this.fadadaSignTaskSaleService.updateById((Object)signTaskSale);
        this.updateById((Object)signTaskPurchase);
        this.fadadaSignAttachmenPurchaseService.deleteSaleFileByMainId(id);
    }

    @Override
    public String signFileDownload(String id, String fileId) {
        FadadaSignTaskPurchase signTaskPurchase = (FadadaSignTaskPurchase)((Object)this.getById((Serializable)((Object)id)));
        JSONObject requestObject = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)fileId)) {
            FadadaSignAttachmenPurchase signAttachmenPurchase = (FadadaSignAttachmenPurchase)((Object)this.fadadaSignAttachmenPurchaseService.getById((Serializable)((Object)fileId)));
            requestObject.put("fileType", (Object)signAttachmenPurchase.getSignType());
            requestObject.put("id", (Object)signAttachmenPurchase.getFileId());
        }
        requestObject.put("signTaskId", (Object)signTaskPurchase.getSignTaskId());
        requestObject.put("currentAccount", (Object)signTaskPurchase.getElsAccount());
        JSONObject ownerId = new JSONObject();
        ownerId.put("idType", (Object)signTaskPurchase.getIdType());
        ownerId.put("openId", (Object)signTaskPurchase.getOpenId());
        requestObject.put("ownerId", (Object)ownerId);
        JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_sign_file");
        return response.getString("downloadUrl");
    }

    public FadadaFileSignTaskCreateDTO signData(String idType, String openId, FadadaSignTaskPurchase fadadaSignTaskPurchase, List<FadadaTaskActorPurchase> taskActorPurchaseList, List<FadadaSignAttachmenPurchase> docAttachment, List<FadadaSignAttachmenPurchase> attachsAttachment, Map<String, List<FadadaTaskActorPurchase>> docFiledMap) {
        FadadaFileSignTaskCreateDTO signTaskCreateDTO = new FadadaFileSignTaskCreateDTO(idType, openId, fadadaSignTaskPurchase.getBusinessId(), fadadaSignTaskPurchase, attachsAttachment);
        ArrayList<FadadaDocDTO> docs = new ArrayList<FadadaDocDTO>();
        for (FadadaSignAttachmenPurchase entity : docAttachment) {
            FadadaDocDTO docDTO = new FadadaDocDTO(entity, docFiledMap.get(entity.getFileId()));
            docs.add(docDTO);
        }
        signTaskCreateDTO.setDocs(docs);
        ArrayList<FadadaSignTaskActorDTO> actors = new ArrayList<FadadaSignTaskActorDTO>();
        int orderNo = 1;
        for (FadadaTaskActorPurchase entity : taskActorPurchaseList) {
            FadadaSignTaskActorDTO taskActorDTO = new FadadaSignTaskActorDTO(entity, orderNo);
            actors.add(taskActorDTO);
            ++orderNo;
        }
        signTaskCreateDTO.setActors(actors);
        return signTaskCreateDTO;
    }
}

