/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.util.UUIDGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.fadada.dto.FadadaOrgSealCreateDTO;
import com.els.modules.electronsign.fadada.entity.SaleFadadaOrgPsn;
import com.els.modules.electronsign.fadada.entity.SaleFadadaSeal;
import com.els.modules.electronsign.fadada.enums.FadadaSealStatusEnum;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaOrgPsnMapper;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaPersonalMapper;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaSealMapper;
import com.els.modules.electronsign.fadada.service.SaleFadadaSealService;
import com.els.modules.electronsign.fadada.util.FadadaCallUtil;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleFadadaSealServiceImpl
extends BaseServiceImpl<SaleFadadaSealMapper, SaleFadadaSeal>
implements SaleFadadaSealService {
    @Autowired
    private FadadaCallUtil fadadaCallUtil;
    @Autowired
    private SaleFadadaOrgPsnMapper saleFadadaOrgPsnMapper;
    @Autowired
    private SaleFadadaPersonalMapper saleFadadaPersonalMapper;

    @Override
    public void add(SaleFadadaSeal saleFadadaSeal) {
        this.handDefaultData(saleFadadaSeal);
        ((SaleFadadaSealMapper)this.baseMapper).insert((Object)saleFadadaSeal);
    }

    public SaleFadadaSeal handDefaultData(SaleFadadaSeal saleFadadaSeal) {
        String elsAccount = TenantContext.getTenant();
        QueryWrapper saleFadadaOrgPsnQueryWrapper = new QueryWrapper();
        saleFadadaOrgPsnQueryWrapper.eq((Object)"open_corp_id", (Object)saleFadadaSeal.getOpenCorpId());
        saleFadadaOrgPsnQueryWrapper.like((Object)"role_type", (Object)"super_admin");
        saleFadadaOrgPsnQueryWrapper.eq((Object)"els_account", (Object)elsAccount);
        SaleFadadaOrgPsn saleFadadaOrgPsn = (SaleFadadaOrgPsn)((Object)this.saleFadadaOrgPsnMapper.selectOne((Wrapper)saleFadadaOrgPsnQueryWrapper));
        if (saleFadadaOrgPsn != null) {
            saleFadadaSeal.setUserName(saleFadadaOrgPsn.getMemberName());
            saleFadadaSeal.setClientUserId(saleFadadaOrgPsn.getClientUserId());
        }
        if (StringUtils.isBlank((CharSequence)saleFadadaSeal.getCreateSerialNo())) {
            saleFadadaSeal.setCreateSerialNo(UUIDGenerator.generate());
        }
        return saleFadadaSeal;
    }

    @Override
    public void edit(SaleFadadaSeal saleFadadaSeal) {
        this.handDefaultData(saleFadadaSeal);
        int count = ((SaleFadadaSealMapper)this.baseMapper).updateById((Object)saleFadadaSeal);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        SaleFadadaSeal saleFadadaSeal = (SaleFadadaSeal)((Object)this.getById((Serializable)((Object)id)));
        if (saleFadadaSeal != null) {
            if (StringUtils.isNotBlank((CharSequence)saleFadadaSeal.getSealId())) {
                JSONObject requestObject = new JSONObject();
                requestObject.put("openCorpId", (Object)saleFadadaSeal.getOpenCorpId());
                requestObject.put("sealId", (Object)saleFadadaSeal.getSealId());
                requestObject.put("currentAccount", (Object)saleFadadaSeal.getBusAccount());
                this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_seal_delete");
            }
            ((SaleFadadaSealMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        }
    }

    @Override
    public void deleteBatch(List<String> idList) {
        for (String id : idList) {
            this.delete(id);
        }
    }

    @Override
    public String create(SaleFadadaSeal saleFadadaSeal) {
        if (StringUtils.isNotBlank((CharSequence)saleFadadaSeal.getId())) {
            this.edit(saleFadadaSeal);
        } else {
            this.add(saleFadadaSeal);
        }
        FadadaOrgSealCreateDTO fadadaOrgSealCreateDTO = (FadadaOrgSealCreateDTO)SysUtil.copyProperties((Object)((Object)saleFadadaSeal), FadadaOrgSealCreateDTO.class);
        fadadaOrgSealCreateDTO.setRedirectUrl(this.fadadaCallUtil.getRedirectUrl());
        String requestStr = JSONObject.toJSONString((Object)fadadaOrgSealCreateDTO);
        JSONObject requestObject = JSONObject.parseObject((String)requestStr);
        requestObject.put("currentAccount", (Object)saleFadadaSeal.getBusAccount());
        JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_seal_create");
        saleFadadaSeal.setSealCreateUrl(response.getString("sealCreateUrl"));
        this.updateById((Object)saleFadadaSeal);
        return saleFadadaSeal.getSealCreateUrl();
    }

    @Override
    public void status(String id, String status) {
        SaleFadadaSeal saleFadadaSeal = (SaleFadadaSeal)((Object)this.getById((Serializable)((Object)id)));
        FadadaSealStatusEnum.getDescByValue(status);
        if (saleFadadaSeal != null) {
            JSONObject requestObject = new JSONObject();
            requestObject.put("openCorpId", (Object)saleFadadaSeal.getOpenCorpId());
            requestObject.put("sealId", (Object)saleFadadaSeal.getSealId());
            requestObject.put("sealStatus", (Object)status);
            requestObject.put("currentAccount", (Object)saleFadadaSeal.getBusAccount());
            this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_seal_status");
            saleFadadaSeal.setSealStatus(status);
            this.updateById((Object)saleFadadaSeal);
        }
    }

    @Override
    public SaleFadadaSeal freeSign(SaleFadadaSeal saleFadadaSeal) {
        SaleFadadaSeal seal = (SaleFadadaSeal)((Object)this.getById((Serializable)((Object)saleFadadaSeal.getId())));
        if (seal != null) {
            JSONObject requestObject = new JSONObject();
            requestObject.put("openCorpId", (Object)seal.getOpenCorpId());
            requestObject.put("clientUserId", (Object)seal.getClientUserId());
            Long[] sealIds = new Long[]{Long.parseLong(seal.getSealId())};
            requestObject.put("sealIds", (Object)sealIds);
            requestObject.put("businessId", (Object)saleFadadaSeal.getSceneCode());
            requestObject.put("email", (Object)saleFadadaSeal.getEmail());
            if (saleFadadaSeal.getExpiresTime() != null) {
                requestObject.put("expiresTime", (Object)saleFadadaSeal.getExpiresTime().getTime());
            }
            requestObject.put("currentAccount", (Object)saleFadadaSeal.getBusAccount());
            requestObject.put("redirectUrl", (Object)this.fadadaCallUtil.getRedirectUrl());
            JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_seal_free_sign");
            saleFadadaSeal.setFreeSignUrl(response.getString("freeSignUrl"));
            saleFadadaSeal.setSceneCode(this.fadadaCallUtil.businessId);
            this.updateById((Object)saleFadadaSeal);
        }
        return saleFadadaSeal;
    }
}

