/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.util;

import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.contract.dto.SaleContractHeadDTO;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.electronsign.contractlock.enumerate.CLBusTypeEnum;
import com.els.modules.electronsign.esign.rpc.service.EsignInvokeContractRpcService;
import com.els.modules.electronsign.esign.rpc.service.EsignInvokeOrderRpcService;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.enumerate.EsignFinalStatusEnum;
import com.els.modules.order.api.enumerate.OrderEsignStatusEnum;
import com.els.modules.system.rpc.service.InvokeBaseRpcService;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ESignUtil {
    private static final Logger log = LoggerFactory.getLogger(ESignUtil.class);
    @Autowired
    private EsignInvokeContractRpcService contractRpcService;
    @Autowired
    private EsignInvokeOrderRpcService orderRpcService;
    @Resource
    private InvokeBaseRpcService baseRpcService;

    public void handleBusType(String busType, String relationId, String signStatus, CLBusTypeEnum type, String signType) {
        switch (busType) {
            case "contract": {
                this.handleContractStatus(relationId, signStatus, type, signType);
                break;
            }
            case "order": {
                this.handleOrderStatus(relationId, type, signType);
                break;
            }
        }
    }

    private void handleContractStatus(String relationId, String signStatus, CLBusTypeEnum type, String signType) {
        PurchaseContractHeadDTO contractHead = this.contractRpcService.getPurchaseContractById(relationId);
        if (contractHead != null) {
            if ("1".equals(contractHead.getStartSign()) && CLBusTypeEnum.isAdd(type)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rtFIhARPWWqKCJPeWQLhARvsmA_dae99d52", (String)"\u8be5\u5355\u636e\u5df2\u53d1\u8d77\u8fc7\u7b7e\u7f72\uff0c\u53ef\u5728\u7535\u5b50\u7b7e\u7ae0-\u6d41\u7a0b\u53d1\u8d77\u7ba1\u7406\u4e2d\u67e5\u770b"));
            }
            if (CLBusTypeEnum.isAdd(type)) {
                contractHead.setStartSign("1");
                contractHead.setSignType(signType);
            }
            if (CLBusTypeEnum.isFINISH(type)) {
                contractHead.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
                contractHead.setEndSign(signStatus);
            }
            if (CLBusTypeEnum.isReturn(type)) {
                contractHead.setStartSign("0");
            }
            if (CLBusTypeEnum.isRevoke(type)) {
                contractHead.setEndSign(signStatus);
            }
            this.contractRpcService.updatePurchaseEntityById(contractHead);
            SaleContractHeadDTO saleContractHead = this.contractRpcService.getSaleContractById(contractHead.getRelationId());
            if (saleContractHead != null) {
                if (CLBusTypeEnum.isAdd(type)) {
                    saleContractHead.setStartSign("1");
                }
                if (CLBusTypeEnum.isFINISH(type)) {
                    saleContractHead.setContractStatus(contractHead.getContractStatus());
                    saleContractHead.setEndSign(contractHead.getEndSign());
                }
                if (CLBusTypeEnum.isReturn(type)) {
                    saleContractHead.setEndSign(contractHead.getEndSign());
                }
                this.contractRpcService.updateSaleEntityById(saleContractHead);
            }
        }
    }

    private void handleOrderStatus(String relationId, CLBusTypeEnum type, String singType) {
        PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.orderRpcService.getPurchaseOrderById(relationId);
        if (purchaseOrderHeadDTO != null) {
            if (CLBusTypeEnum.isAdd(type) && (OrderEsignStatusEnum.START_END.getValue().equals(purchaseOrderHeadDTO.getEsignStartStatus()) || OrderEsignStatusEnum.CHANGED_START_END.getValue().equals(purchaseOrderHeadDTO.getEsignStartStatus()))) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rtFIhARPWWqKCJPeWQLhARvsmA_dae99d52", (String)"\u8be5\u5355\u636e\u5df2\u53d1\u8d77\u8fc7\u7b7e\u7f72\uff0c\u53ef\u5728\u7535\u5b50\u7b7e\u7ae0-\u6d41\u7a0b\u53d1\u8d77\u7ba1\u7406\u4e2d\u67e5\u770b"));
            }
            if (CLBusTypeEnum.isAdd(type)) {
                purchaseOrderHeadDTO.setEsignStartStatus("1".equals(purchaseOrderHeadDTO.getOrderVersion()) ? OrderEsignStatusEnum.START_END.getValue() : OrderEsignStatusEnum.CHANGED_START_END.getValue());
                purchaseOrderHeadDTO.setSignType(singType);
            }
            if (CLBusTypeEnum.isReturn(type)) {
                purchaseOrderHeadDTO.setEsignStartStatus("1".equals(purchaseOrderHeadDTO.getOrderVersion()) ? OrderEsignStatusEnum.NO_START.getValue() : OrderEsignStatusEnum.CHANGED_NO_START.getValue());
            }
        }
        if (CLBusTypeEnum.isFINISH(type)) {
            purchaseOrderHeadDTO.setEsignFinalStatus(EsignFinalStatusEnum.FINAL.getValue());
            this.orderRpcService.updateSaleOrderByRelationId(purchaseOrderHeadDTO);
        }
        this.orderRpcService.updatePurchaseOrderById(purchaseOrderHeadDTO);
    }

    public String getOnlineSealed(String busType, String toElsAccount) {
        List<ElsCompanySetDTO> list = this.baseRpcService.getCompanySetList(toElsAccount);
        JSONObject object = this.getObjBySet(list);
        if (object == null || StringUtils.isBlank((CharSequence)object.getString("electronicSignature"))) {
            return "0";
        }
        List<String> rules = Arrays.asList(object.getString("electronicSignature").split(","));
        return rules.contains(busType) ? "1" : "0";
    }

    private JSONObject getObjBySet(List<ElsCompanySetDTO> list) {
        JSONObject result = new JSONObject();
        if (list != null) {
            for (ElsCompanySetDTO set : list) {
                result.put(set.getItemCode(), (Object)set.getDefaultValue());
            }
        }
        return result;
    }
}

