/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.electronsign.fadada.entity.FadadaSignAttachmenPurchase;
import com.els.modules.electronsign.fadada.entity.FadadaSignAttachmenSale;
import com.els.modules.electronsign.fadada.entity.FadadaSignTaskPurchase;
import com.els.modules.electronsign.fadada.entity.FadadaSignTaskSale;
import com.els.modules.electronsign.fadada.entity.FadadaTaskActorSale;
import com.els.modules.electronsign.fadada.mapper.FadadaSignAttachmenPurchaseMapper;
import com.els.modules.electronsign.fadada.mapper.FadadaSignTaskPurchaseMapper;
import com.els.modules.electronsign.fadada.mapper.FadadaSignTaskSaleMapper;
import com.els.modules.electronsign.fadada.service.FadadaSignAttachmenSaleService;
import com.els.modules.electronsign.fadada.service.FadadaSignTaskSaleService;
import com.els.modules.electronsign.fadada.service.FadadaTaskActorSaleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class FadadaSignTaskSaleServiceImpl
extends BaseServiceImpl<FadadaSignTaskSaleMapper, FadadaSignTaskSale>
implements FadadaSignTaskSaleService {
    @Resource
    private FadadaTaskActorSaleService fadadaTaskActorSaleService;
    @Resource
    private FadadaSignAttachmenSaleService fadadaSignAttachmenSaleService;
    @Autowired
    private FadadaSignTaskPurchaseMapper fadadaSignTaskPurchaseMapper;
    @Autowired
    private FadadaSignAttachmenPurchaseMapper fadadaSignAttachmenPurchaseMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(FadadaSignTaskSale fadadaSignTaskSale, List<FadadaTaskActorSale> fadadaTaskActorSaleList, List<FadadaSignAttachmenSale> fadadaSignAttachmenSaleList) {
        ((FadadaSignTaskSaleMapper)this.baseMapper).insert((Object)fadadaSignTaskSale);
        super.setHeadDefaultValue((BaseEntity)fadadaSignTaskSale);
        this.insertData(fadadaSignTaskSale, fadadaTaskActorSaleList, fadadaSignAttachmenSaleList, null);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(FadadaSignTaskSale fadadaSignTaskSale, List<FadadaTaskActorSale> fadadaTaskActorSaleList, List<FadadaSignAttachmenSale> fadadaSignAttachmenSaleList, List<FadadaSignAttachmenSale> fadadaSignAttachmenSaleBackList) {
        int count = ((FadadaSignTaskSaleMapper)this.baseMapper).updateById((Object)fadadaSignTaskSale);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.fadadaTaskActorSaleService.deleteByMainId(fadadaSignTaskSale.getId());
        this.fadadaSignAttachmenSaleService.deleteByMainId(fadadaSignTaskSale.getId());
        this.insertData(fadadaSignTaskSale, fadadaTaskActorSaleList, fadadaSignAttachmenSaleList, fadadaSignAttachmenSaleBackList);
    }

    private void insertData(FadadaSignTaskSale fadadaSignTaskSale, List<FadadaTaskActorSale> fadadaTaskActorSaleList, List<FadadaSignAttachmenSale> fadadaSignAttachmenSaleList, List<FadadaSignAttachmenSale> fadadaSignAttachmenSaleBackList) {
        if (!CollectionUtils.isEmpty(fadadaTaskActorSaleList)) {
            for (FadadaTaskActorSale fadadaTaskActorSale : fadadaTaskActorSaleList) {
                fadadaTaskActorSale.setHeadId(fadadaSignTaskSale.getId());
                SysUtil.setSysParam((BaseEntity)fadadaTaskActorSale, (BaseEntity)fadadaSignTaskSale);
                if (StringUtils.isBlank((CharSequence)fadadaTaskActorSale.getOwning())) {
                    fadadaTaskActorSale.setOwning("sale");
                }
                if ("mobile".equals(fadadaTaskActorSale.getNotifyWay())) {
                    fadadaTaskActorSale.setNotifyAddress(fadadaTaskActorSale.getMobile());
                } else {
                    fadadaTaskActorSale.setNotifyAddress(fadadaTaskActorSale.getEmail());
                }
                if ("corp".equals(fadadaTaskActorSale.getActorType())) {
                    fadadaTaskActorSale.setActorName(fadadaTaskActorSale.getCorpName());
                    fadadaTaskActorSale.setActorOpenId(fadadaTaskActorSale.getOpenCorpId());
                    continue;
                }
                fadadaTaskActorSale.setActorName(fadadaTaskActorSale.getUseName());
                fadadaTaskActorSale.setActorOpenId(fadadaTaskActorSale.getOpenUserId());
            }
            this.fadadaTaskActorSaleService.saveBatch(fadadaTaskActorSaleList, 2000);
        }
        if (!CollectionUtils.isEmpty(fadadaSignAttachmenSaleList)) {
            for (FadadaSignAttachmenSale fadadaSignAttachmenSale : fadadaSignAttachmenSaleList) {
                fadadaSignAttachmenSale.setHeadId(fadadaSignTaskSale.getId());
                SysUtil.setSysParam((BaseEntity)fadadaSignAttachmenSale, (BaseEntity)fadadaSignTaskSale);
            }
            this.fadadaSignAttachmenSaleService.saveBatch(fadadaSignAttachmenSaleList, 2000);
        }
        if (!CollectionUtils.isEmpty(fadadaSignAttachmenSaleBackList)) {
            for (FadadaSignAttachmenSale fadadaSignAttachmenSale : fadadaSignAttachmenSaleBackList) {
                fadadaSignAttachmenSale.setHeadId(fadadaSignTaskSale.getId());
                fadadaSignAttachmenSale.setSendStatus("1");
                SysUtil.setSysParam((BaseEntity)fadadaSignAttachmenSale, (BaseEntity)fadadaSignTaskSale);
            }
            this.fadadaSignAttachmenSaleService.saveBatch(fadadaSignAttachmenSaleBackList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.fadadaTaskActorSaleService.deleteByMainId(id);
        this.fadadaSignAttachmenSaleService.deleteByMainId(id);
        ((FadadaSignTaskSaleMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.fadadaTaskActorSaleService.deleteByMainId(serializable.toString());
            this.fadadaSignAttachmenSaleService.deleteByMainId(serializable.toString());
            ((FadadaSignTaskSaleMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public void passBack(FadadaSignTaskSale fadadaSignTaskSale, List<FadadaSignAttachmenSale> fadadaSignAttachmenSaleBackList) {
        FadadaSignTaskPurchase signTaskPurchase = (FadadaSignTaskPurchase)((Object)this.fadadaSignTaskPurchaseMapper.selectById((Serializable)((Object)(fadadaSignTaskSale = (FadadaSignTaskSale)((Object)this.getById((Serializable)((Object)fadadaSignTaskSale.getId())))).getRelationId())));
        if (signTaskPurchase != null) {
            fadadaSignTaskSale.setSendBack("0");
            fadadaSignTaskSale.setSaleFileUploaded("1");
            signTaskPurchase.setSaleFileUploaded("1");
            signTaskPurchase.setSendBack("0");
            signTaskPurchase.setSendBackReson("");
            signTaskPurchase.setRelationId(fadadaSignTaskSale.getId());
            ArrayList<FadadaSignAttachmenPurchase> signAttachmenPurchases = new ArrayList<FadadaSignAttachmenPurchase>();
            for (FadadaSignAttachmenSale entity : fadadaSignAttachmenSaleBackList) {
                FadadaSignAttachmenPurchase signAttachmenPurchase = (FadadaSignAttachmenPurchase)((Object)SysUtil.copyProperties((Object)((Object)entity), FadadaSignAttachmenPurchase.class));
                signAttachmenPurchase.setReceiveStatus("1");
                signAttachmenPurchase.setRelationId(entity.getId());
                signAttachmenPurchase.setHeadId(signTaskPurchase.getId());
                signAttachmenPurchase.setElsAccount(signTaskPurchase.getElsAccount());
                signAttachmenPurchases.add(signAttachmenPurchase);
                entity.setSendStatus("1");
            }
            this.fadadaSignAttachmenPurchaseMapper.insertBatchSomeColumn(signAttachmenPurchases);
            this.fadadaSignAttachmenSaleService.saveOrUpdateBatch(fadadaSignAttachmenSaleBackList);
            this.fadadaSignTaskPurchaseMapper.updateById((Object)signTaskPurchase);
            this.updateById((Object)fadadaSignTaskSale);
        }
    }

    @Override
    public void maintainSigner(FadadaSignTaskSale fadadaSignTaskSale, List<FadadaTaskActorSale> fadadaTaskActorSales) {
        fadadaSignTaskSale = (FadadaSignTaskSale)((Object)this.getById((Serializable)((Object)fadadaSignTaskSale.getId())));
    }
}

