/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ThirdAuth;
import com.els.modules.system.mapper.ThirdAuthMapper;
import com.els.modules.system.service.ThirdAuthService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ThirdAuthServiceImpl
extends BaseServiceImpl<ThirdAuthMapper, ThirdAuth>
implements ThirdAuthService {
    public static final String REDIS_KEY = "sys:thirdAuth:";
    @Resource
    private RedisUtil redisUtil;

    private String getRedisKey(String elsAccount, String appType) {
        StringBuilder redisKey = new StringBuilder(REDIS_KEY);
        redisKey.append(elsAccount);
        redisKey.append(appType);
        return redisKey.toString();
    }

    @Override
    public void saveThirdAuth(ThirdAuth thirdAuth) {
        ThirdAuth auth = (ThirdAuth)((Object)((ThirdAuthMapper)this.baseMapper).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"app_type", (Object)thirdAuth.getAppType())));
        if (auth != null) {
            throw new ELSBootException("\u5df2\u7ecf\u5b58\u5728\u5e94\u7528\u7c7b\u578b\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        ((ThirdAuthMapper)this.baseMapper).insert((Object)thirdAuth);
    }

    @Override
    public void updateThirdAuth(ThirdAuth thirdAuth) {
        thirdAuth.setAppType(null);
        ((ThirdAuthMapper)this.baseMapper).updateById((Object)thirdAuth);
        this.redisUtil.del(new String[]{this.getRedisKey(thirdAuth.getElsAccount(), thirdAuth.getAppType())});
    }

    @Override
    public void delThirdAuth(String id) {
        ThirdAuth thirdAuth = (ThirdAuth)((Object)((ThirdAuthMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        ((ThirdAuthMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.redisUtil.del(new String[]{this.getRedisKey(thirdAuth.getElsAccount(), thirdAuth.getAppType())});
    }

    @Override
    public ThirdAuth getThirdAuthByType(String elsAccount, String appType) {
        ThirdAuth auth = (ThirdAuth)((Object)this.redisUtil.get(this.getRedisKey(elsAccount, appType)));
        if (auth != null) {
            return auth;
        }
        auth = (ThirdAuth)((Object)((ThirdAuthMapper)this.baseMapper).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"app_type", (Object)appType)));
        if (auth != null) {
            this.redisUtil.set(this.getRedisKey(elsAccount, appType), (Object)auth, 14400L);
        }
        return auth;
    }

    @Override
    public List<ThirdAuth> getAllPoolConfig(String elsAccount, String appType) {
        List authList = ((ThirdAuthMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"app_type", (Object)appType));
        return authList;
    }

    @Override
    public ThirdAuth getPoolConfigByCode(String elsAccount, String appType, String code) {
        ThirdAuth auth = (ThirdAuth)((Object)((ThirdAuthMapper)this.baseMapper).selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"app_type", (Object)appType)).eq((Object)"app_key", (Object)code)));
        return auth;
    }
}

