/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.service.JobRpcService;
import com.els.modules.electronsign.fadada.entity.PurchaseFadadaSeal;
import com.els.modules.electronsign.fadada.entity.SaleFadadaSeal;
import com.els.modules.electronsign.fadada.service.PurchaseFadadaSealService;
import com.els.modules.electronsign.fadada.service.SaleFadadaSealService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SealVisaFreeJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(SealVisaFreeJob.class);
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    @Resource
    private PurchaseFadadaSealService purchaseFadadaSealService;
    @Resource
    private SaleFadadaSealService saleFadadaSealService;

    public void execute(String parameter) {
        String today = this.simpleDateFormat.format(new Date());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lt((Object)"expires_time", (Object)today);
        List purchaseFadadaSealList = this.purchaseFadadaSealService.list((Wrapper)queryWrapper);
        if (!purchaseFadadaSealList.isEmpty()) {
            for (PurchaseFadadaSeal entity : purchaseFadadaSealList) {
                entity.setVisaFree("0");
                entity.setExpiresTime(null);
            }
            this.purchaseFadadaSealService.updateBatchById(purchaseFadadaSealList);
        }
        QueryWrapper sealQueryWrapper = new QueryWrapper();
        sealQueryWrapper.lt((Object)"expires_time", (Object)today);
        List saleFadadaSeals = this.saleFadadaSealService.list((Wrapper)sealQueryWrapper);
        if (!saleFadadaSeals.isEmpty()) {
            for (SaleFadadaSeal entity : saleFadadaSeals) {
                entity.setVisaFree("0");
                entity.setExpiresTime(null);
            }
            this.saleFadadaSealService.updateBatchById(saleFadadaSeals);
        }
    }
}

