/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.util.UUIDGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.fadada.dto.FadadaGetOrgAuthUrlDTO;
import com.els.modules.electronsign.fadada.entity.SaleFadadaOrg;
import com.els.modules.electronsign.fadada.entity.SaleFadadaOrgPsn;
import com.els.modules.electronsign.fadada.entity.SaleFadadaSeal;
import com.els.modules.electronsign.fadada.entity.SaleFadadaSealPsn;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaOrgMapper;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaOrgPsnMapper;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaSealMapper;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaSealPsnMapper;
import com.els.modules.electronsign.fadada.service.SaleFadadaOrgService;
import com.els.modules.electronsign.fadada.util.FadadaCallUtil;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.system.rpc.service.SystemInvokeOrganizationInfoRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleFadadaOrgServiceImpl
extends BaseServiceImpl<SaleFadadaOrgMapper, SaleFadadaOrg>
implements SaleFadadaOrgService {
    @Autowired
    private FadadaCallUtil fadadaCallUtil;
    @Autowired
    private SystemInvokeOrganizationInfoRpcService systemInvokeOrganizationInfoRpcService;
    @Autowired
    private SaleFadadaOrgPsnMapper saleFadadaOrgPsnMapper;
    @Autowired
    private SaleFadadaSealMapper saleFadadaSealMapper;
    @Autowired
    private SaleFadadaSealPsnMapper saleFadadaSealPsnMapper;

    @Override
    public void add(SaleFadadaOrg saleFadadaOrg) {
        this.handleOrgCode(saleFadadaOrg);
        this.saveFlag(saleFadadaOrg);
        ((SaleFadadaOrgMapper)this.baseMapper).insert((Object)saleFadadaOrg);
    }

    public SaleFadadaOrg handleOrgCode(SaleFadadaOrg saleFadadaOrg) {
        saleFadadaOrg.setCorpNonEditableInfo("corpName,corpIdentType,corpIdentNo");
        if ("1".equals(saleFadadaOrg.getLoadingOrg())) {
            PurchaseOrganizationInfoDTO organizationInfo = this.systemInvokeOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", saleFadadaOrg.getOrgCode());
            Assert.isTrue((boolean)true, (String)I18nUtil.translate((String)"i18n_alert_RCIH_264a3c82", (String)"\u516c\u53f8\u5f02\u5e38"));
            if (organizationInfo != null) {
                saleFadadaOrg.setCorpName(organizationInfo.getOrgName());
            }
        }
        saleFadadaOrg.setClientCorpId(saleFadadaOrg.getCorpIdentNo());
        return saleFadadaOrg;
    }

    public void saveFlag(SaleFadadaOrg saleFadadaOrg) {
        QueryWrapper saleFadadaOrgQueryWrapper = new QueryWrapper();
        saleFadadaOrgQueryWrapper.eq((Object)"corp_name", (Object)saleFadadaOrg.getCorpName());
        saleFadadaOrgQueryWrapper.eq((Object)"bus_account", (Object)saleFadadaOrg.getBusAccount());
        saleFadadaOrgQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        if (this.getOne((Wrapper)saleFadadaOrgQueryWrapper) != null) {
            throw new ELSBootException("\u673a\u6784\u3010" + saleFadadaOrg.getCorpName() + "\u3011\u5df2\u88ab\u521b\u5efa\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa");
        }
    }

    @Override
    public void edit(SaleFadadaOrg saleFadadaOrg) {
        this.handleOrgCode(saleFadadaOrg);
        this.editFlag(saleFadadaOrg);
        int count = ((SaleFadadaOrgMapper)this.baseMapper).updateById((Object)saleFadadaOrg);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    public void editFlag(SaleFadadaOrg saleFadadaOrg) {
        QueryWrapper saleFadadaOrgQueryWrapper = new QueryWrapper();
        saleFadadaOrgQueryWrapper.eq((Object)"corp_name", (Object)saleFadadaOrg.getCorpName());
        saleFadadaOrgQueryWrapper.eq((Object)"bus_account", (Object)saleFadadaOrg.getBusAccount());
        saleFadadaOrgQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        SaleFadadaOrg fadadaOrg = (SaleFadadaOrg)((Object)this.getOne((Wrapper)saleFadadaOrgQueryWrapper));
        if (fadadaOrg != null && !fadadaOrg.getId().equals(saleFadadaOrg.getId())) {
            throw new ELSBootException(saleFadadaOrg.getCorpName() + "\u5df2\u88ab\u521b\u5efa\uff0c\u53ef\u6362\u5176\u4ed6\u673a\u6784");
        }
    }

    @Override
    public void delete(String id) {
        ((SaleFadadaOrgMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleFadadaOrgMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void auth(SaleFadadaOrg saleFadadaOrg) {
        if (StringUtils.isBlank((CharSequence)saleFadadaOrg.getId())) {
            this.add(saleFadadaOrg);
        } else {
            this.edit(saleFadadaOrg);
        }
        String redirectUrl = this.fadadaCallUtil.getRedirectUrl();
        FadadaGetOrgAuthUrlDTO fadadaGetOrgAuthUrlDTO = new FadadaGetOrgAuthUrlDTO(saleFadadaOrg, redirectUrl);
        String requestStr = JSONObject.toJSONString((Object)fadadaGetOrgAuthUrlDTO);
        JSONObject requestObject = JSONObject.parseObject((String)requestStr);
        requestObject.put("currentAccount", (Object)saleFadadaOrg.getBusAccount());
        JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_org_auth_url");
        if ("210002".equals(response.getString("code"))) {
            saleFadadaOrg.setAuthFailedReason("exist");
            this.getAuthInfo(saleFadadaOrg);
        } else {
            saleFadadaOrg.setAuthUrl(response.getString("authUrl"));
            ((SaleFadadaOrgMapper)this.baseMapper).updateById((Object)saleFadadaOrg);
        }
    }

    public void syncOrgMember(SaleFadadaOrg saleFadadaOrg) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("openCorpId", (Object)saleFadadaOrg.getOpenCorpId());
        requestObject.put("currentAccount", (Object)saleFadadaOrg.getBusAccount());
        JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_list_member");
        if (StringUtils.isNotBlank((CharSequence)response.getString("employeeInfos"))) {
            JSONArray employeeInfos = response.getJSONArray("employeeInfos");
            ArrayList<SaleFadadaOrgPsn> fadadaOrgPsns = new ArrayList<SaleFadadaOrgPsn>();
            for (Object object : employeeInfos) {
                JSONObject memberObject = JSONObject.parseObject((String)object.toString());
                QueryWrapper saleFadadaOrgPsnQueryWrapper = new QueryWrapper();
                saleFadadaOrgPsnQueryWrapper.eq((Object)"member_id", (Object)memberObject.getString("memberId"));
                saleFadadaOrgPsnQueryWrapper.eq((Object)"els_account", (Object)saleFadadaOrg.getElsAccount());
                if (!this.saleFadadaOrgPsnMapper.selectList((Wrapper)saleFadadaOrgPsnQueryWrapper).isEmpty()) continue;
                SaleFadadaOrgPsn fadadaOrgPsn = (SaleFadadaOrgPsn)((Object)SysUtil.copyProperties((Object)memberObject, SaleFadadaOrgPsn.class));
                fadadaOrgPsn.setElsAccount(saleFadadaOrg.getElsAccount());
                fadadaOrgPsn.setClientUserId(saleFadadaOrg.getClientUserId());
                fadadaOrgPsn.setClientCorpId(saleFadadaOrg.getClientCorpId());
                fadadaOrgPsn.setOpenUserId(saleFadadaOrg.getOpenUserId());
                fadadaOrgPsn.setBusAccount(saleFadadaOrg.getBusAccount());
                fadadaOrgPsn.setOpenCorpId(saleFadadaOrg.getOpenCorpId());
                fadadaOrgPsn.setActive("1");
                fadadaOrgPsn.setOrgName(saleFadadaOrg.getCorpName());
                fadadaOrgPsn.setCompanyName(saleFadadaOrg.getCompanyName());
                fadadaOrgPsn.setDeleted(CommonConstant.DEL_FLAG_0);
                fadadaOrgPsn.setMemberDeptids(this.fadadaCallUtil.arrayToString(memberObject.getJSONArray("memberDeptIds")));
                fadadaOrgPsn.setRoleType(this.fadadaCallUtil.arrayToString(memberObject.getJSONArray("roleType")));
                fadadaOrgPsns.add(fadadaOrgPsn);
            }
            if (fadadaOrgPsns.size() > 0) {
                this.saleFadadaOrgPsnMapper.insertBatchSomeColumn(fadadaOrgPsns);
            }
        }
    }

    public void syncSeal(SaleFadadaOrg entity) {
        if (entity.getAuthTime() == 1) {
            JSONObject requestObject = new JSONObject();
            requestObject.put("openCorpId", (Object)entity.getOpenCorpId());
            requestObject.put("currentAccount", (Object)entity.getBusAccount());
            JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_seal_list");
            JSONArray sealInfos = response.getJSONArray("sealInfos");
            for (Object object : sealInfos) {
                JSONObject sealInfo = JSONObject.parseObject((String)object.toString());
                SaleFadadaSeal saleFadadaSeal = (SaleFadadaSeal)((Object)SysUtil.copyProperties((Object)sealInfo, SaleFadadaSeal.class));
                saleFadadaSeal.setElsAccount(entity.getElsAccount());
                saleFadadaSeal.setOpenCorpId(entity.getOpenCorpId());
                saleFadadaSeal.setClientUserId(entity.getClientUserId());
                saleFadadaSeal.setUserName(entity.getUserName());
                saleFadadaSeal.setOrgName(entity.getCorpName());
                saleFadadaSeal.setBusAccount(entity.getBusAccount());
                saleFadadaSeal.setId(UUIDGenerator.generate());
                saleFadadaSeal.setCompanyName(entity.getCompanyName());
                saleFadadaSeal.setDeleted(CommonConstant.DEL_FLAG_0);
                saleFadadaSeal.setPicFileUrl(this.fadadaCallUtil.getByUrl(saleFadadaSeal.getId(), entity.getElsAccount(), sealInfo));
                this.saleFadadaSealMapper.insert((Object)saleFadadaSeal);
                if (!StringUtils.isNotBlank((CharSequence)sealInfo.getString("sealUsers"))) continue;
                JSONArray sealUsersArray = JSONArray.parseArray((String)sealInfo.getString("sealUsers"));
                for (Object ent : sealUsersArray) {
                    SaleFadadaSealPsn saleFadadaSealPsn = (SaleFadadaSealPsn)((Object)SysUtil.copyProperties(ent, SaleFadadaSealPsn.class));
                    saleFadadaSealPsn.setElsAccount(entity.getElsAccount());
                    saleFadadaSealPsn.setOpenCorpId(saleFadadaSeal.getOpenCorpId());
                    saleFadadaSealPsn.setSealId(saleFadadaSeal.getSealId());
                    saleFadadaSealPsn.setSealName(saleFadadaSeal.getSealName());
                    saleFadadaSealPsn.setBusAccount(entity.getBusAccount());
                    saleFadadaSealPsn.setCompanyName(entity.getCompanyName());
                    saleFadadaSealPsn.setCategoryType(saleFadadaSeal.getCategoryType());
                    saleFadadaSealPsn.setPicFileUrl(saleFadadaSeal.getPicFileUrl());
                    saleFadadaSealPsn.setCertcaOrg(saleFadadaSeal.getCertcaOrg());
                    saleFadadaSealPsn.setCorpName(entity.getCorpName());
                    saleFadadaSealPsn.setDeleted(CommonConstant.DEL_FLAG_0);
                    saleFadadaSealPsn.setCertEncryptType(saleFadadaSeal.getCertEncryptType());
                    this.saleFadadaSealPsnMapper.insert((Object)saleFadadaSealPsn);
                }
            }
        }
    }

    @Override
    public void getAuthInfo(SaleFadadaOrg saleFadadaOrg) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("clientCorpId", (Object)saleFadadaOrg.getClientCorpId());
        requestObject.put("currentAccount", (Object)saleFadadaOrg.getBusAccount());
        JSONObject authInfo = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_org_auth_info");
        saleFadadaOrg.setAvailableStatus(authInfo.getString("availableStatus"));
        saleFadadaOrg.setRealnameStatus(authInfo.getString("identStatus"));
        saleFadadaOrg.setAuthResult(authInfo.getString("bindingStatus"));
        saleFadadaOrg.setOpenCorpId(authInfo.getString("openCorpId"));
        requestObject = new JSONObject();
        requestObject.put("openCorpId", (Object)saleFadadaOrg.getOpenCorpId());
        requestObject.put("currentAccount", (Object)saleFadadaOrg.getBusAccount());
        JSONObject identInfo = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_org_ident_info");
        if ("legal_rep".equals(identInfo.getString("corpIdentMethod"))) {
            saleFadadaOrg.setCorpIdentMethod("legalRep");
        } else {
            saleFadadaOrg.setCorpIdentMethod(identInfo.getString("corpIdentMethod"));
        }
        JSONObject corpIdentInfo = identInfo.getJSONObject("corpIdentInfo");
        saleFadadaOrg.setCorpName(corpIdentInfo.getString("corpName"));
        saleFadadaOrg.setCorpIdentType(corpIdentInfo.getString("corpIdentType"));
        saleFadadaOrg.setCorpIdentNo(corpIdentInfo.getString("corpIdentNo"));
        saleFadadaOrg.setLegalRepName(corpIdentInfo.getString("legalRepName"));
        JSONObject corpIdentInfoExtend = identInfo.getJSONObject("corpIdentInfoExtend");
        saleFadadaOrg.setBankAccountNo(corpIdentInfoExtend.getString("bankAccountNo"));
        saleFadadaOrg.setAuthFailedReason("");
        saleFadadaOrg.setAuthTime(saleFadadaOrg.getAuthTime() + 1);
        this.updateById((Object)saleFadadaOrg);
        this.syncOrgMember(saleFadadaOrg);
        this.syncSeal(saleFadadaOrg);
    }

    @Override
    public void updateAuthStatus(SaleFadadaOrg saleFadadaOrg) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("clientCorpId", (Object)saleFadadaOrg.getClientCorpId());
        requestObject.put("currentAccount", (Object)saleFadadaOrg.getBusAccount());
        JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_org_auth_info");
        saleFadadaOrg.setAvailableStatus(response.getString("availableStatus"));
        saleFadadaOrg.setRealnameStatus(response.getString("identStatus"));
        saleFadadaOrg.setAuthResult(response.getString("bindingStatus"));
        this.updateById((Object)saleFadadaOrg);
    }
}

