/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.common.util.UUIDGenerator;
import com.els.modules.electronsign.contractlock.enumerate.CLBusTypeEnum;
import com.els.modules.electronsign.contractlock.enumerate.ClContractSignStatusEmun;
import com.els.modules.electronsign.fadada.entity.FadadaSignTaskPurchase;
import com.els.modules.electronsign.fadada.entity.FadadaSignTaskSale;
import com.els.modules.electronsign.fadada.entity.FadadaTaskActorPurchase;
import com.els.modules.electronsign.fadada.entity.FadadaTaskActorSale;
import com.els.modules.electronsign.fadada.entity.PurchaseFadadaOrg;
import com.els.modules.electronsign.fadada.entity.PurchaseFadadaOrgPsn;
import com.els.modules.electronsign.fadada.entity.PurchaseFadadaPersonal;
import com.els.modules.electronsign.fadada.entity.PurchaseFadadaSeal;
import com.els.modules.electronsign.fadada.entity.PurchaseFadadaSealPsn;
import com.els.modules.electronsign.fadada.entity.SaleFadadaOrg;
import com.els.modules.electronsign.fadada.entity.SaleFadadaOrgPsn;
import com.els.modules.electronsign.fadada.entity.SaleFadadaPersonal;
import com.els.modules.electronsign.fadada.entity.SaleFadadaSeal;
import com.els.modules.electronsign.fadada.entity.SaleFadadaSealPsn;
import com.els.modules.electronsign.fadada.enums.FadadaEventEnums;
import com.els.modules.electronsign.fadada.enums.FadadaSealStatusEnum;
import com.els.modules.electronsign.fadada.enums.FadadaSignTaskStatusEnum;
import com.els.modules.electronsign.fadada.service.FadadaCallBackService;
import com.els.modules.electronsign.fadada.service.FadadaSignAttachmenPurchaseService;
import com.els.modules.electronsign.fadada.service.FadadaSignAttachmenSaleService;
import com.els.modules.electronsign.fadada.service.FadadaSignTaskPurchaseService;
import com.els.modules.electronsign.fadada.service.FadadaSignTaskSaleService;
import com.els.modules.electronsign.fadada.service.FadadaTaskActorPurchaseService;
import com.els.modules.electronsign.fadada.service.FadadaTaskActorSaleService;
import com.els.modules.electronsign.fadada.service.PurchaseFadadaOrgPsnService;
import com.els.modules.electronsign.fadada.service.PurchaseFadadaOrgService;
import com.els.modules.electronsign.fadada.service.PurchaseFadadaPersonalService;
import com.els.modules.electronsign.fadada.service.PurchaseFadadaSealPsnService;
import com.els.modules.electronsign.fadada.service.PurchaseFadadaSealService;
import com.els.modules.electronsign.fadada.service.SaleFadadaOrgPsnService;
import com.els.modules.electronsign.fadada.service.SaleFadadaOrgService;
import com.els.modules.electronsign.fadada.service.SaleFadadaPersonalService;
import com.els.modules.electronsign.fadada.service.SaleFadadaSealPsnService;
import com.els.modules.electronsign.fadada.service.SaleFadadaSealService;
import com.els.modules.electronsign.fadada.util.FadadaCallUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;

@Service
public class FadadaCallBackServiceImpl
implements FadadaCallBackService {
    @Autowired
    private PurchaseFadadaPersonalService purchaseFadadaPersonalService;
    @Autowired
    private SaleFadadaPersonalService saleFadadaPersonalService;
    @Autowired
    private PurchaseFadadaOrgService purchaseFadadaOrgService;
    @Autowired
    private SaleFadadaOrgService saleFadadaOrgService;
    @Autowired
    private PurchaseFadadaOrgPsnService purchaseFadadaOrgPsnService;
    @Autowired
    private SaleFadadaOrgPsnService saleFadadaOrgPsnService;
    @Autowired
    private FadadaCallUtil fadadaCallUtil;
    @Autowired
    private PurchaseFadadaSealService purchaseFadadaSealService;
    @Autowired
    private SaleFadadaSealService saleFadadaSealService;
    @Autowired
    private PurchaseFadadaSealPsnService purchaseFadadaSealPsnService;
    @Autowired
    private SaleFadadaSealPsnService saleFadadaSealPsnService;
    @Autowired
    private FadadaSignTaskPurchaseService fadadaSignTaskPurchaseService;
    @Autowired
    private FadadaSignTaskSaleService fadadaSignTaskSaleService;
    @Autowired
    private FadadaTaskActorPurchaseService fadadaTaskActorPurchaseService;
    @Autowired
    private FadadaTaskActorSaleService fadadaTaskActorSaleService;
    @Autowired
    private FadadaSignAttachmenPurchaseService fadadaSignAttachmenPurchaseService;
    @Autowired
    private FadadaSignAttachmenSaleService fadadaSignAttachmenSaleService;
    String[] sealVerifys = new String[]{FadadaEventEnums.seal_verify_successed.getKey(), FadadaEventEnums.seal_verify_failed.getKey(), FadadaEventEnums.seal_verify_cancel.getKey()};

    @Override
    public void callBack(HttpHeaders headers, String bizContent) {
        String event = headers.getFirst("X-FASC-Event");
        JSONObject object = JSONObject.parseObject((String)bizContent);
        switch (event) {
            case "user-authorize": {
                this.userAuthorize(object);
                break;
            }
            case "corp-authorize": {
                this.corpAuthorize(object);
                break;
            }
            case "user-cancel-authorization": {
                this.userCancelAuthorization(object);
                break;
            }
            case "corp-cancel-authorization": {
                this.corpCancelAuthorization(object, event);
                break;
            }
            case "user-four-element-verify": {
                this.corpCancelAuthorization(object, event);
                break;
            }
            case "user-three-element-verify": {
                this.corpCancelAuthorization(object, event);
                break;
            }
            case "organization-member-active": {
                this.organizationMemberActive(object, event);
                break;
            }
            case "organization-member-enable": {
                this.organizationMemberActive(object, event);
                break;
            }
            case "organization-member-disable": {
                this.organizationMemberActive(object, event);
                break;
            }
            case "seal-create": {
                this.createSeal(object);
                break;
            }
            case "seal-verify-successed": {
                this.updateSealStatus(object, event);
                break;
            }
            case "seal-verify-failed": {
                this.updateSealStatus(object, event);
                break;
            }
            case "seal-verify-cancel": {
                this.updateSealStatus(object, event);
                break;
            }
            case "seal-enable": {
                this.updateSealStatus(object, event);
                break;
            }
            case "seal-disable": {
                this.updateSealStatus(object, event);
                break;
            }
            case "seal-delete": {
                this.updateSealStatus(object, event);
                break;
            }
            case "seal-authorize-free-sign": {
                this.sealAuthorizeFreeSign(object, event);
                break;
            }
            case "seal-authorize-free-sign-cancel": {
                this.sealAuthorizeFreeSign(object, event);
                break;
            }
            case "seal-authorize-member": {
                this.sealAuthorizeMember(object, event);
                break;
            }
            case "seal-authorize-member-cancel": {
                this.sealAuthorizeMember(object, event);
                break;
            }
            case "sign-task-signed": {
                this.signTask(object, event);
                break;
            }
            case "sign-task-sign-failed": {
                this.signTask(object, event);
                break;
            }
            case "sign-task-sign-rejected": {
                this.signTask(object, event);
                break;
            }
            case "sign-task-start": {
                this.signTask(object, event);
                break;
            }
            case "sign-task-finished": {
                this.signTask(object, event);
                break;
            }
            case "sign-task-canceled": {
                this.signTask(object, event);
                break;
            }
            case "sign-task-expire": {
                this.signTask(object, event);
                break;
            }
            case "sign-task-abolish": {
                this.signTask(object, event);
                break;
            }
        }
    }

    public void signTask(JSONObject object, String event) {
        String signTaskId = object.getString("signTaskId");
        String reason = StringUtils.isNotBlank((CharSequence)object.getString("signRejectReason")) ? object.getString("signRejectReason") : object.getString("signFailedReason");
        QueryWrapper signTaskPurchaseQueryWrapper = new QueryWrapper();
        signTaskPurchaseQueryWrapper.eq((Object)"sign_task_id", (Object)signTaskId);
        List signTaskPurchases = this.fadadaSignTaskPurchaseService.list((Wrapper)signTaskPurchaseQueryWrapper);
        if (!signTaskPurchases.isEmpty()) {
            String signTaskStatus = object.getString("signTaskStatus");
            for (FadadaSignTaskPurchase entity : signTaskPurchases) {
                FadadaTaskActorPurchase taskActorPurchase;
                entity.setSignTaskStatus(signTaskStatus);
                entity.setReason(reason);
                String actorId = object.getString("actorId");
                FadadaSignTaskSale signTaskSale = null;
                if (("1".equals(entity.getOnlineSealed()) || !"1".equals(entity.getOnlineSealed()) && "sale".equals(entity.getFirstSeal())) && StringUtils.isNotBlank((CharSequence)entity.getRelationId())) {
                    signTaskSale = (FadadaSignTaskSale)((Object)this.fadadaSignTaskSaleService.getById((Serializable)((Object)entity.getRelationId())));
                    signTaskSale.setSignTaskId(signTaskId);
                    signTaskSale.setSignTaskStatus(signTaskStatus);
                    signTaskSale.setReason(reason);
                    signTaskSale.setIsAutoFinish(entity.getIsAutoFinish());
                    this.fadadaSignTaskSaleService.updateById((Object)signTaskSale);
                }
                CLBusTypeEnum typeEnum = CLBusTypeEnum.OTHER;
                String signStatus = ClContractSignStatusEmun.UNFINISHED.getValue();
                if (FadadaEventEnums.sign_task_finished.getKey().equals(event)) {
                    entity.setIsAutoFinish("1");
                    this.fadadaSignTaskPurchaseService.saveSignFile(entity, signTaskSale);
                    typeEnum = CLBusTypeEnum.FINISH;
                    signStatus = ClContractSignStatusEmun.FINISHED.getValue();
                }
                if (FadadaEventEnums.sign_task_canceled.getKey().equals(event) || FadadaEventEnums.sign_task_abolish.getKey().equals(event) || FadadaEventEnums.sign_task_expire.getKey().equals(event)) {
                    typeEnum = CLBusTypeEnum.REVOKE;
                    signStatus = ClContractSignStatusEmun.UNDONE.getValue();
                }
                if (StringUtils.isNotBlank((CharSequence)actorId) && (taskActorPurchase = (FadadaTaskActorPurchase)((Object)this.fadadaTaskActorPurchaseService.getById((Serializable)((Object)actorId)))) != null) {
                    taskActorPurchase.setSignTaskStatus(signTaskStatus);
                    if (signTaskStatus.equals(FadadaSignTaskStatusEnum.sign_progress.getValue())) {
                        taskActorPurchase.setSignTaskStatus(FadadaSignTaskStatusEnum.sign_completed.getValue());
                    }
                    taskActorPurchase.setEvent(event);
                    taskActorPurchase.setEventreason(reason);
                    this.fadadaTaskActorPurchaseService.updateById((Object)taskActorPurchase);
                    FadadaTaskActorSale taskActorSale = (FadadaTaskActorSale)((Object)this.fadadaTaskActorSaleService.getById((Serializable)((Object)taskActorPurchase.getRelationId())));
                    if (taskActorSale != null) {
                        taskActorSale.setSignTaskStatus(taskActorPurchase.getSignTaskStatus());
                        taskActorSale.setEventreason(reason);
                        taskActorSale.setEvent(event);
                        this.fadadaTaskActorSaleService.updateById((Object)taskActorSale);
                    }
                }
                this.fadadaSignTaskPurchaseService.updateById((Object)entity);
                this.fadadaSignTaskPurchaseService.handleBusType(entity.getBusType(), entity.getBusId(), signStatus, typeEnum);
            }
        }
    }

    public void sealAuthorizeMember(JSONObject object, String event) {
        ArrayList sealIds = SysUtil.copyProperties((List)object.getJSONArray("sealIds"), String.class);
        ArrayList memberIds = SysUtil.copyProperties((List)object.getJSONArray("memberIds"), String.class);
        for (String sealId : sealIds) {
            for (String memberId : memberIds) {
                QueryWrapper purchaseFadadaSealPsnQueryWrapper = new QueryWrapper();
                purchaseFadadaSealPsnQueryWrapper.eq((Object)"open_corp_id", (Object)object.getString("openCorpId"));
                purchaseFadadaSealPsnQueryWrapper.eq((Object)"member_id", (Object)memberId);
                purchaseFadadaSealPsnQueryWrapper.eq((Object)"seal_id", (Object)sealId);
                List purchaseFadadaSealPsns = this.purchaseFadadaSealPsnService.list((Wrapper)purchaseFadadaSealPsnQueryWrapper);
                if (!purchaseFadadaSealPsns.isEmpty()) {
                    for (PurchaseFadadaSealPsn entity : purchaseFadadaSealPsns) {
                        if (FadadaEventEnums.seal_authorize_member.getKey().equals(event)) {
                            entity.setGrantStatus(FadadaSealStatusEnum.effective.getValue());
                            entity.setGrantTime(new Date());
                        }
                        if (!FadadaEventEnums.seal_authorize_member_cancel.getKey().equals(event)) continue;
                        entity.setGrantStatus(FadadaSealStatusEnum.ineffective.getValue());
                    }
                    this.purchaseFadadaSealPsnService.updateBatchById(purchaseFadadaSealPsns);
                    continue;
                }
                QueryWrapper saleFadadaSealPsnQueryWrapper = new QueryWrapper();
                saleFadadaSealPsnQueryWrapper.eq((Object)"open_corp_id", (Object)object.getString("openCorpId"));
                saleFadadaSealPsnQueryWrapper.eq((Object)"member_id", (Object)memberId);
                saleFadadaSealPsnQueryWrapper.eq((Object)"seal_id", (Object)sealId);
                List saleFadadaSealPsns = this.saleFadadaSealPsnService.list((Wrapper)saleFadadaSealPsnQueryWrapper);
                if (saleFadadaSealPsns.isEmpty()) continue;
                for (SaleFadadaSealPsn entity : saleFadadaSealPsns) {
                    if (FadadaEventEnums.seal_authorize_member.getKey().equals(event)) {
                        entity.setGrantStatus(FadadaSealStatusEnum.effective.getValue());
                        entity.setGrantTime(new Date());
                    }
                    if (!FadadaEventEnums.seal_authorize_member_cancel.getKey().equals(event)) continue;
                    entity.setGrantStatus(FadadaSealStatusEnum.ineffective.getValue());
                }
                this.saleFadadaSealPsnService.updateBatchById(saleFadadaSealPsns);
            }
        }
    }

    public void sealAuthorizeFreeSign(JSONObject object, String event) {
        QueryWrapper purchaseFadadaSealQueryWrapper = new QueryWrapper();
        purchaseFadadaSealQueryWrapper.eq((Object)"open_corp_id", (Object)object.getString("openCorpId"));
        purchaseFadadaSealQueryWrapper.eq((Object)"scene_code", (Object)object.getString("businessId"));
        purchaseFadadaSealQueryWrapper.eq((Object)"seal_id", (Object)object.getString("sealId"));
        PurchaseFadadaSeal purchaseFadadaSeal = (PurchaseFadadaSeal)((Object)this.purchaseFadadaSealService.getOne((Wrapper)purchaseFadadaSealQueryWrapper));
        if (purchaseFadadaSeal != null) {
            if (FadadaEventEnums.seal_authorize_free_sign.getKey().equals(event)) {
                purchaseFadadaSeal.setVisaFree("1");
            } else {
                purchaseFadadaSeal.setSceneCode("");
                purchaseFadadaSeal.setVisaFree("0");
                purchaseFadadaSeal.setExpiresTime(null);
            }
            this.purchaseFadadaSealService.updateById((Object)purchaseFadadaSeal);
        } else {
            QueryWrapper saleFadadaSealQueryWrapper = new QueryWrapper();
            saleFadadaSealQueryWrapper.eq((Object)"open_corp_id", (Object)object.getString("openCorpId"));
            saleFadadaSealQueryWrapper.eq((Object)"scene_code", (Object)object.getString("businessId"));
            saleFadadaSealQueryWrapper.eq((Object)"seal_id", (Object)object.getString("sealId"));
            SaleFadadaSeal saleFadadaSeal = (SaleFadadaSeal)((Object)this.saleFadadaSealService.getOne((Wrapper)saleFadadaSealQueryWrapper));
            if (saleFadadaSeal != null) {
                if (FadadaEventEnums.seal_authorize_free_sign.getKey().equals(event)) {
                    saleFadadaSeal.setVisaFree("1");
                } else {
                    saleFadadaSeal.setSceneCode("");
                    saleFadadaSeal.setVisaFree("0");
                    saleFadadaSeal.setExpiresTime(null);
                }
                this.saleFadadaSealService.updateById((Object)saleFadadaSeal);
            }
        }
    }

    void updateSealStatus(JSONObject object, String event) {
        QueryWrapper purchaseFadadaSealQueryWrapper = new QueryWrapper();
        purchaseFadadaSealQueryWrapper.eq((Object)"open_corp_id", (Object)object.getString("openCorpId"));
        if (Arrays.asList(this.sealVerifys).contains(event)) {
            purchaseFadadaSealQueryWrapper.eq((Object)"verify_id", (Object)object.getString("verifyId"));
        } else {
            purchaseFadadaSealQueryWrapper.eq((Object)"seal_id", (Object)object.getString("sealId"));
        }
        List purchaseFadadaSeals = this.purchaseFadadaSealService.list((Wrapper)purchaseFadadaSealQueryWrapper);
        if (!purchaseFadadaSeals.isEmpty()) {
            for (PurchaseFadadaSeal entity : purchaseFadadaSeals) {
                if (FadadaEventEnums.seal_verify_successed.getKey().equals(event)) {
                    entity.setAudit("successed");
                }
                if (FadadaEventEnums.seal_verify_failed.getKey().equals(event)) {
                    entity.setAudit("failed");
                }
                if (FadadaEventEnums.seal_verify_cancel.getKey().equals(event)) {
                    entity.setAudit("cancel");
                }
                if (FadadaEventEnums.seal_enable.getKey().equals(event)) {
                    entity.setSealStatus("enable");
                }
                if (FadadaEventEnums.seal_disable.getKey().equals(event)) {
                    entity.setSealStatus("disable");
                }
                if (!FadadaEventEnums.seal_delete.getKey().equals(event)) continue;
                entity.setSealStatus("disable");
                entity.setDeleted(CommonConstant.DEL_FLAG_1);
            }
            this.purchaseFadadaSealService.updateBatchById(purchaseFadadaSeals);
        } else {
            QueryWrapper saleFadadaSealQueryWrapper = new QueryWrapper();
            saleFadadaSealQueryWrapper.eq((Object)"open_corp_id", (Object)object.getString("openCorpId"));
            if (Arrays.asList(this.sealVerifys).contains(event)) {
                saleFadadaSealQueryWrapper.eq((Object)"verify_id", (Object)object.getString("verifyId"));
            } else {
                saleFadadaSealQueryWrapper.eq((Object)"seal_id", (Object)object.getString("sealId"));
            }
            List saleFadadaSeals = this.saleFadadaSealService.list((Wrapper)saleFadadaSealQueryWrapper);
            if (!saleFadadaSeals.isEmpty()) {
                for (SaleFadadaSeal entity : saleFadadaSeals) {
                    if (FadadaEventEnums.seal_verify_successed.getKey().equals(event)) {
                        entity.setAudit("successed");
                    }
                    if (FadadaEventEnums.seal_verify_failed.getKey().equals(event)) {
                        entity.setAudit("failed");
                    }
                    if (FadadaEventEnums.seal_verify_cancel.getKey().equals(event)) {
                        entity.setAudit("cancel");
                    }
                    if (FadadaEventEnums.seal_enable.getKey().equals(event)) {
                        entity.setSealStatus("enable");
                    }
                    if (FadadaEventEnums.seal_disable.getKey().equals(event)) {
                        entity.setSealStatus("disable");
                    }
                    if (!FadadaEventEnums.seal_delete.getKey().equals(event)) continue;
                    entity.setSealStatus("disable");
                    entity.setDeleted(CommonConstant.DEL_FLAG_1);
                }
                this.saleFadadaSealService.updateBatchById(saleFadadaSeals);
            }
        }
    }

    public void createSeal(JSONObject object) {
        if (StringUtils.isNotBlank((CharSequence)object.getString("createSerialNo"))) {
            QueryWrapper purchaseFadadaSealQueryWrapper = new QueryWrapper();
            purchaseFadadaSealQueryWrapper.eq((Object)"open_corp_id", (Object)object.getString("openCorpId"));
            purchaseFadadaSealQueryWrapper.eq((Object)"create_serial_no", (Object)object.getString("createSerialNo"));
            List purchaseFadadaSeals = this.purchaseFadadaSealService.list((Wrapper)purchaseFadadaSealQueryWrapper);
            if (!purchaseFadadaSeals.isEmpty()) {
                ArrayList<PurchaseFadadaSeal> purchaseFadadaSealList = new ArrayList<PurchaseFadadaSeal>();
                for (PurchaseFadadaSeal entity : purchaseFadadaSeals) {
                    JSONObject response = this.getSealDetail(object, entity.getElsAccount());
                    PurchaseFadadaSeal purchaseFadadaSeal = (PurchaseFadadaSeal)((Object)SysUtil.copyProperties((Object)response, PurchaseFadadaSeal.class));
                    purchaseFadadaSeal.setId(entity.getId());
                    purchaseFadadaSeal.setVerifyId(object.getString("verifyId"));
                    purchaseFadadaSeal.setPicFileUrl(this.fadadaCallUtil.getByUrl(entity.getId(), entity.getElsAccount(), response));
                    purchaseFadadaSealList.add(purchaseFadadaSeal);
                }
                this.purchaseFadadaSealService.updateBatchById(purchaseFadadaSealList);
            } else {
                QueryWrapper saleFadadaSealQueryWrapper = new QueryWrapper();
                saleFadadaSealQueryWrapper.eq((Object)"open_corp_id", (Object)object.getString("openCorpId"));
                saleFadadaSealQueryWrapper.eq((Object)"create_serial_no", (Object)object.getString("createSerialNo"));
                List saleFadadaSeals = this.saleFadadaSealService.list((Wrapper)saleFadadaSealQueryWrapper);
                if (!saleFadadaSeals.isEmpty()) {
                    ArrayList<SaleFadadaSeal> saleFadadaSealList = new ArrayList<SaleFadadaSeal>();
                    for (SaleFadadaSeal entity : saleFadadaSeals) {
                        JSONObject response = this.getSealDetail(object, entity.getBusAccount());
                        SaleFadadaSeal saleFadadaSeal = (SaleFadadaSeal)((Object)SysUtil.copyProperties((Object)response, SaleFadadaSeal.class));
                        saleFadadaSeal.setId(entity.getId());
                        saleFadadaSeal.setVerifyId(object.getString("verifyId"));
                        saleFadadaSeal.setPicFileUrl(this.fadadaCallUtil.getByUrl(entity.getId(), entity.getElsAccount(), response));
                        saleFadadaSealList.add(saleFadadaSeal);
                    }
                    this.saleFadadaSealService.updateBatchById(saleFadadaSealList);
                }
            }
        }
    }

    public JSONObject getSealDetail(JSONObject object, String elsAccount) {
        if (StringUtils.isNotBlank((CharSequence)object.getString("sealId"))) {
            JSONObject requestObject = new JSONObject();
            requestObject.put("openCorpId", (Object)object.getString("openCorpId"));
            requestObject.put("sealId", (Object)object.getString("sealId"));
            requestObject.put("currentAccount", (Object)elsAccount);
            return this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_seal_detail").getJSONObject("sealInfo");
        }
        return object;
    }

    public void createDefaultSeal(JSONObject object) {
        block3: {
            block2: {
                QueryWrapper purchaseFadadaOrgQueryWrapper = new QueryWrapper();
                purchaseFadadaOrgQueryWrapper.eq((Object)"open_corp_id", (Object)object.getString("openCorpId"));
                List purchaseFadadaOrgList = this.purchaseFadadaOrgService.list((Wrapper)purchaseFadadaOrgQueryWrapper);
                if (purchaseFadadaOrgList.isEmpty()) break block2;
                for (PurchaseFadadaOrg eneity : purchaseFadadaOrgList) {
                    JSONObject response = this.getSealDetail(object, eneity.getElsAccount());
                    PurchaseFadadaSeal purchaseFadadaSeal = (PurchaseFadadaSeal)((Object)SysUtil.copyProperties((Object)response, PurchaseFadadaSeal.class));
                    purchaseFadadaSeal.setPicFileUrl(this.fadadaCallUtil.getByUrl(eneity.getId(), eneity.getElsAccount(), response));
                    purchaseFadadaSeal.setElsAccount(eneity.getElsAccount());
                    purchaseFadadaSeal.setOpenCorpId(object.getString("openCorpId"));
                    this.purchaseFadadaSealService.save((Object)purchaseFadadaSeal);
                }
                break block3;
            }
            QueryWrapper saleFadadaOrgQueryWrapper = new QueryWrapper();
            saleFadadaOrgQueryWrapper.eq((Object)"open_corp_id", (Object)object.getString("openCorpId"));
            List saleFadadaOrgList = this.saleFadadaOrgService.list((Wrapper)saleFadadaOrgQueryWrapper);
            if (saleFadadaOrgList.isEmpty()) break block3;
            for (SaleFadadaOrg eneity : saleFadadaOrgList) {
                JSONObject response = this.getSealDetail(object, eneity.getBusAccount());
                SaleFadadaSeal saleFadadaSeal = (SaleFadadaSeal)((Object)SysUtil.copyProperties((Object)response, SaleFadadaSeal.class));
                saleFadadaSeal.setPicFileUrl(this.fadadaCallUtil.getByUrl(eneity.getId(), eneity.getElsAccount(), response));
                saleFadadaSeal.setElsAccount(eneity.getElsAccount());
                saleFadadaSeal.setOpenCorpId(object.getString("openCorpId"));
                saleFadadaSeal.setBusAccount(eneity.getBusAccount());
                this.saleFadadaSealService.save((Object)saleFadadaSeal);
            }
        }
    }

    public void organizationMemberActive(JSONObject object, String event) {
        String openCorpId = object.getString("openCorpId");
        String memberId = object.getString("memberId");
        QueryWrapper purchaseFadadaOrgPsnQueryWrapper = new QueryWrapper();
        purchaseFadadaOrgPsnQueryWrapper.eq((Object)"open_corp_id", (Object)openCorpId);
        purchaseFadadaOrgPsnQueryWrapper.eq((Object)"member_id", (Object)memberId);
        List purchaseFadadaOrgPsns = this.purchaseFadadaOrgPsnService.list((Wrapper)purchaseFadadaOrgPsnQueryWrapper);
        if (!purchaseFadadaOrgPsns.isEmpty()) {
            if (FadadaEventEnums.organization_member_delete.getKey().equals(event)) {
                List<String> ids = purchaseFadadaOrgPsns.stream().map(BaseEntity::getId).collect(Collectors.toList());
                this.purchaseFadadaPersonalService.deleteBatch(ids);
            } else {
                for (PurchaseFadadaOrgPsn entity : purchaseFadadaOrgPsns) {
                    if (FadadaEventEnums.organization_member_active.getKey().equals(event)) {
                        entity.setActive("1");
                        entity.setMemberStatus("enable");
                    }
                    if (FadadaEventEnums.organization_member_enable.getKey().equals(event)) {
                        entity.setMemberStatus("enable");
                    }
                    if (!FadadaEventEnums.organization_member_disable.getKey().equals(event)) continue;
                    entity.setMemberStatus("disabled");
                }
                this.purchaseFadadaOrgPsnService.updateBatchById(purchaseFadadaOrgPsns);
            }
        } else {
            QueryWrapper saleFadadaOrgPsnQueryWrapper = new QueryWrapper();
            purchaseFadadaOrgPsnQueryWrapper.eq((Object)"open_corp_id", (Object)openCorpId);
            purchaseFadadaOrgPsnQueryWrapper.eq((Object)"member_id", (Object)memberId);
            List saleFadadaOrgPsns = this.saleFadadaOrgPsnService.list((Wrapper)saleFadadaOrgPsnQueryWrapper);
            if (!saleFadadaOrgPsns.isEmpty()) {
                if (FadadaEventEnums.organization_member_delete.getKey().equals(event)) {
                    List<String> ids = saleFadadaOrgPsns.stream().map(BaseEntity::getId).collect(Collectors.toList());
                    this.saleFadadaOrgPsnService.deleteBatch(ids);
                } else {
                    for (SaleFadadaOrgPsn entity : saleFadadaOrgPsns) {
                        if (FadadaEventEnums.organization_member_active.getKey().equals(event)) {
                            entity.setActive("1");
                            entity.setMemberStatus("enable");
                        }
                        if (FadadaEventEnums.organization_member_enable.getKey().equals(event)) {
                            entity.setMemberStatus("enable");
                        }
                        if (!FadadaEventEnums.organization_member_disable.getKey().equals(event)) continue;
                        entity.setMemberStatus("disabled");
                    }
                    this.saleFadadaOrgPsnService.updateBatchById(saleFadadaOrgPsns);
                }
            }
        }
    }

    public void corpCancelAuthorization(JSONObject object, String event) {
        List purchaseFadadaOrgList;
        String clientCorpId = object.getString("clientCorpId");
        String openCorpId = object.getString("openCorpId");
        QueryWrapper purchaseFadadaOrgQueryWrapper = new QueryWrapper();
        purchaseFadadaOrgQueryWrapper.eq((Object)"client_corp_id", (Object)clientCorpId);
        if (StringUtils.isNotBlank((CharSequence)openCorpId)) {
            purchaseFadadaOrgQueryWrapper.eq((Object)"open_corp_id", (Object)openCorpId);
        }
        if (!(purchaseFadadaOrgList = this.purchaseFadadaOrgService.list((Wrapper)purchaseFadadaOrgQueryWrapper)).isEmpty()) {
            for (PurchaseFadadaOrg entity : purchaseFadadaOrgList) {
                entity.setAuthResult("disauthorization");
                entity.setAuthFailedReason("\u89e3\u9664\u6388\u6743");
                if (!FadadaEventEnums.user_four_element_verify.getKey().equals(event) && !FadadaEventEnums.user_three_element_verify.getKey().equals(event)) continue;
                entity.setVerifyId(object.getString("verifyResult"));
                entity.setVerifyResult(object.getString("verifyResult"));
            }
            this.purchaseFadadaOrgService.updateBatchById(purchaseFadadaOrgList);
        } else {
            List saleFadadaOrgList;
            QueryWrapper saleFadadaOrgQueryWrapper = new QueryWrapper();
            saleFadadaOrgQueryWrapper.eq((Object)"client_corp_id", (Object)clientCorpId);
            if (StringUtils.isNotBlank((CharSequence)openCorpId)) {
                saleFadadaOrgQueryWrapper.eq((Object)"open_corp_id", (Object)openCorpId);
            }
            if (!(saleFadadaOrgList = this.saleFadadaOrgService.list((Wrapper)saleFadadaOrgQueryWrapper)).isEmpty()) {
                for (SaleFadadaOrg entity : saleFadadaOrgList) {
                    entity.setAuthResult("disauthorization");
                    entity.setAuthFailedReason("\u89e3\u9664\u6388\u6743");
                    if (!FadadaEventEnums.user_four_element_verify.getKey().equals(event) && !FadadaEventEnums.user_three_element_verify.getKey().equals(event)) continue;
                    entity.setVerifyId(object.getString("verifyResult"));
                    entity.setVerifyResult(object.getString("verifyResult"));
                }
                this.saleFadadaOrgService.updateBatchById(saleFadadaOrgList);
            }
        }
    }

    public void userCancelAuthorization(JSONObject object) {
        String clientUserId = object.getString("clientUserId");
        String openUserId = object.getString("openUserId");
        QueryWrapper purchaseFadadaPersonalQueryWrapper = new QueryWrapper();
        purchaseFadadaPersonalQueryWrapper.eq((Object)"client_user_id", (Object)clientUserId);
        purchaseFadadaPersonalQueryWrapper.eq((Object)"open_user_id", (Object)openUserId);
        List purchaseFadadaPersonalList = this.purchaseFadadaPersonalService.list((Wrapper)purchaseFadadaPersonalQueryWrapper);
        if (!purchaseFadadaPersonalList.isEmpty()) {
            for (PurchaseFadadaPersonal entity : purchaseFadadaPersonalList) {
                entity.setAuthResult("disauthorization");
                entity.setAuthFailedReason("\u89e3\u9664\u6388\u6743");
            }
            this.purchaseFadadaPersonalService.updateBatchById(purchaseFadadaPersonalList);
        } else {
            QueryWrapper saleFadadaPersonalQueryWrapper = new QueryWrapper();
            saleFadadaPersonalQueryWrapper.eq((Object)"client_user_id", (Object)clientUserId);
            saleFadadaPersonalQueryWrapper.eq((Object)"open_user_id", (Object)openUserId);
            List saleFadadaPersonalList = this.saleFadadaPersonalService.list((Wrapper)saleFadadaPersonalQueryWrapper);
            if (!saleFadadaPersonalList.isEmpty()) {
                for (SaleFadadaPersonal entity : saleFadadaPersonalList) {
                    entity.setAuthResult("disauthorization");
                    entity.setAuthFailedReason("\u89e3\u9664\u6388\u6743");
                }
                this.saleFadadaPersonalService.updateBatchById(saleFadadaPersonalList);
            }
        }
    }

    public void corpAuthorize(JSONObject object) {
        String clientCorpId = object.getString("clientCorpId");
        QueryWrapper purchaseFadadaOrgQueryWrapper = new QueryWrapper();
        purchaseFadadaOrgQueryWrapper.eq((Object)"client_corp_id", (Object)clientCorpId);
        List purchaseFadadaOrgList = this.purchaseFadadaOrgService.list((Wrapper)purchaseFadadaOrgQueryWrapper);
        if (!purchaseFadadaOrgList.isEmpty()) {
            for (PurchaseFadadaOrg entity : purchaseFadadaOrgList) {
                entity.setAuthFailedReason(object.getString("authFailedReason"));
                entity.setAuthResult(object.getString("authResult"));
                entity.setOpenCorpId(object.getString("openCorpId"));
                entity.setCorpIdentProcessStatus(object.getString("corpIdentProcessStatus"));
                if ("legal_rep".equals(object.getString("corpIdentMethod"))) {
                    entity.setCorpIdentMethod("legalRep");
                } else {
                    entity.setCorpIdentMethod(object.getString("corpIdentMethod"));
                }
                entity.setAuthTime(entity.getAuthTime() + 1);
                if ("exist".equals(object.getString("authFailedReason"))) continue;
                this.savePurchaseOrgMember(entity);
                this.savePurchaseSeal(entity);
            }
            this.purchaseFadadaOrgService.updateBatchById(purchaseFadadaOrgList);
        } else {
            QueryWrapper saleFadadaOrgQueryWrapper = new QueryWrapper();
            purchaseFadadaOrgQueryWrapper.eq((Object)"client_corp_id", (Object)clientCorpId);
            List saleFadadaOrgList = this.saleFadadaOrgService.list((Wrapper)saleFadadaOrgQueryWrapper);
            if (!saleFadadaOrgList.isEmpty()) {
                for (SaleFadadaOrg entity : saleFadadaOrgList) {
                    entity = this.handleOrg(entity, object);
                    if ("exist".equals(object.getString("authFailedReason"))) continue;
                    this.saveSaleOrgMember(entity);
                    this.saveSaleSeal(entity);
                }
                this.saleFadadaOrgService.updateBatchById(saleFadadaOrgList);
            }
        }
    }

    public SaleFadadaOrg handleOrg(SaleFadadaOrg entity, JSONObject object) {
        entity.setAuthFailedReason(object.getString("authFailedReason"));
        entity.setAuthResult(object.getString("authResult"));
        entity.setOpenCorpId(object.getString("openCorpId"));
        entity.setCorpIdentProcessStatus(object.getString("corpIdentProcessStatus"));
        if ("legal_rep".equals(object.getString("corpIdentMethod"))) {
            entity.setCorpIdentMethod("legalRep");
        } else {
            entity.setCorpIdentMethod(object.getString("corpIdentMethod"));
        }
        entity.setAuthTime(entity.getAuthTime() + 1);
        return entity;
    }

    public void savePurchaseSeal(PurchaseFadadaOrg entity) {
        if (entity.getAuthTime() == 1) {
            JSONObject requestObject = new JSONObject();
            requestObject.put("openCorpId", (Object)entity.getOpenCorpId());
            requestObject.put("currentAccount", (Object)entity.getElsAccount());
            JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_seal_list");
            JSONArray sealInfos = response.getJSONArray("sealInfos");
            for (Object object : sealInfos) {
                JSONObject sealInfo = JSONObject.parseObject((String)object.toString());
                PurchaseFadadaSeal purchaseFadadaSeal = (PurchaseFadadaSeal)((Object)SysUtil.copyProperties((Object)sealInfo, PurchaseFadadaSeal.class));
                purchaseFadadaSeal.setElsAccount(entity.getElsAccount());
                purchaseFadadaSeal.setOpenCorpId(entity.getOpenCorpId());
                purchaseFadadaSeal.setClientUserId(entity.getClientUserId());
                purchaseFadadaSeal.setUserName(entity.getUserName());
                purchaseFadadaSeal.setOrgName(entity.getCorpName());
                purchaseFadadaSeal.setId(UUIDGenerator.generate());
                purchaseFadadaSeal.setPicFileUrl(this.fadadaCallUtil.getByUrl(purchaseFadadaSeal.getId(), entity.getElsAccount(), sealInfo));
                this.purchaseFadadaSealService.save((Object)purchaseFadadaSeal);
                if (!StringUtils.isNotBlank((CharSequence)sealInfo.getString("sealUsers"))) continue;
                JSONArray sealUsersArray = JSONArray.parseArray((String)sealInfo.getString("sealUsers"));
                for (Object ent : sealUsersArray) {
                    PurchaseFadadaSealPsn purchaseFadadaSealPsn = (PurchaseFadadaSealPsn)((Object)SysUtil.copyProperties(ent, PurchaseFadadaSealPsn.class));
                    purchaseFadadaSealPsn.setElsAccount(entity.getElsAccount());
                    purchaseFadadaSealPsn.setOpenCorpId(purchaseFadadaSeal.getOpenCorpId());
                    purchaseFadadaSealPsn.setSealId(purchaseFadadaSeal.getSealId());
                    purchaseFadadaSealPsn.setSealName(purchaseFadadaSeal.getSealName());
                    purchaseFadadaSealPsn.setCategoryType(purchaseFadadaSeal.getCategoryType());
                    purchaseFadadaSealPsn.setPicFileUrl(purchaseFadadaSeal.getPicFileUrl());
                    purchaseFadadaSealPsn.setCertcaOrg(purchaseFadadaSeal.getCertcaOrg());
                    purchaseFadadaSealPsn.setCorpName(entity.getCorpName());
                    purchaseFadadaSealPsn.setCertEncryptType(purchaseFadadaSeal.getCertEncryptType());
                    this.purchaseFadadaSealPsnService.save((Object)purchaseFadadaSealPsn);
                }
            }
        }
    }

    public void saveSaleSeal(SaleFadadaOrg entity) {
        if ("success".equals(entity.getAuthResult()) && entity.getAuthTime() == 1) {
            JSONObject requestObject = new JSONObject();
            requestObject.put("openCorpId", (Object)entity.getOpenCorpId());
            requestObject.put("currentAccount", (Object)entity.getBusAccount());
            JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_seal_list");
            JSONArray sealInfos = response.getJSONArray("sealInfos");
            for (Object object : sealInfos) {
                JSONObject sealInfo = JSONObject.parseObject((String)object.toString());
                SaleFadadaSeal saleFadadaSeal = (SaleFadadaSeal)((Object)SysUtil.copyProperties((Object)sealInfo, SaleFadadaSeal.class));
                saleFadadaSeal.setElsAccount(entity.getElsAccount());
                saleFadadaSeal.setOpenCorpId(entity.getOpenCorpId());
                saleFadadaSeal.setBusAccount(entity.getBusAccount());
                saleFadadaSeal.setClientUserId(entity.getClientUserId());
                saleFadadaSeal.setUserName(entity.getUserName());
                saleFadadaSeal.setOrgName(entity.getCorpName());
                saleFadadaSeal.setCompanyName(entity.getCompanyName());
                saleFadadaSeal.setId(UUIDGenerator.generate());
                saleFadadaSeal.setPicFileUrl(this.fadadaCallUtil.getByUrl(saleFadadaSeal.getId(), entity.getElsAccount(), sealInfo));
                this.saleFadadaSealService.save((Object)saleFadadaSeal);
                if (!StringUtils.isNotBlank((CharSequence)sealInfo.getString("sealUsers"))) continue;
                JSONArray sealUsersArray = JSONArray.parseArray((String)sealInfo.getString("sealUsers"));
                for (Object ent : sealUsersArray) {
                    SaleFadadaSealPsn saleFadadaSealPsn = (SaleFadadaSealPsn)((Object)SysUtil.copyProperties(ent, SaleFadadaSealPsn.class));
                    saleFadadaSealPsn.setElsAccount(entity.getElsAccount());
                    saleFadadaSealPsn.setOpenCorpId(saleFadadaSeal.getOpenCorpId());
                    saleFadadaSealPsn.setSealId(saleFadadaSeal.getSealId());
                    saleFadadaSealPsn.setSealName(saleFadadaSeal.getSealName());
                    saleFadadaSealPsn.setCategoryType(saleFadadaSeal.getCategoryType());
                    saleFadadaSealPsn.setPicFileUrl(saleFadadaSeal.getPicFileUrl());
                    saleFadadaSealPsn.setCertcaOrg(saleFadadaSeal.getCertcaOrg());
                    saleFadadaSealPsn.setCertEncryptType(saleFadadaSeal.getCertEncryptType());
                    saleFadadaSealPsn.setBusAccount(entity.getBusAccount());
                    saleFadadaSealPsn.setCorpName(entity.getCorpName());
                    saleFadadaSealPsn.setCompanyName(entity.getCompanyName());
                    this.saleFadadaSealPsnService.save((Object)saleFadadaSealPsn);
                }
            }
        }
    }

    public void savePurchaseOrgMember(PurchaseFadadaOrg entity) {
        if ("success".equals(entity.getAuthResult()) && entity.getAuthTime() == 1) {
            JSONObject requestObject = new JSONObject();
            requestObject.put("openCorpId", (Object)entity.getOpenCorpId());
            requestObject.put("currentAccount", (Object)entity.getElsAccount());
            JSONObject listFilter = new JSONObject();
            listFilter.put("roleType", (Object)"super_admin");
            requestObject.put("listFilter", (Object)listFilter);
            JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_list_member");
            if (StringUtils.isNotBlank((CharSequence)response.getString("employeeInfos"))) {
                JSONArray employeeInfos = response.getJSONArray("employeeInfos");
                ArrayList<PurchaseFadadaOrgPsn> fadadaOrgPsns = new ArrayList<PurchaseFadadaOrgPsn>();
                for (Object object : employeeInfos) {
                    JSONObject memberObject = JSONObject.parseObject((String)object.toString());
                    QueryWrapper orgPsnQueryWrapper = new QueryWrapper();
                    orgPsnQueryWrapper.eq((Object)"member_id", (Object)memberObject.getString("memberId"));
                    orgPsnQueryWrapper.eq((Object)"els_account", (Object)entity.getElsAccount());
                    if (!this.purchaseFadadaOrgPsnService.list((Wrapper)orgPsnQueryWrapper).isEmpty()) continue;
                    PurchaseFadadaOrgPsn fadadaOrgPsn = (PurchaseFadadaOrgPsn)((Object)SysUtil.copyProperties((Object)memberObject, PurchaseFadadaOrgPsn.class));
                    fadadaOrgPsn.setElsAccount(entity.getElsAccount());
                    fadadaOrgPsn.setClientUserId(entity.getClientUserId());
                    fadadaOrgPsn.setClientCorpId(entity.getClientCorpId());
                    fadadaOrgPsn.setOpenUserId(entity.getOpenUserId());
                    fadadaOrgPsn.setOpenCorpId(entity.getOpenCorpId());
                    fadadaOrgPsn.setActive("1");
                    fadadaOrgPsn.setOrgName(entity.getCorpName());
                    fadadaOrgPsn.setMemberDeptids(this.fadadaCallUtil.arrayToString(memberObject.getJSONArray("memberDeptIds")));
                    fadadaOrgPsn.setRoleType(this.fadadaCallUtil.arrayToString(memberObject.getJSONArray("roleType")));
                    fadadaOrgPsns.add(fadadaOrgPsn);
                }
                if (fadadaOrgPsns.size() > 0) {
                    this.purchaseFadadaOrgPsnService.saveBatch(fadadaOrgPsns);
                }
            }
        }
    }

    public void saveSaleOrgMember(SaleFadadaOrg entity) {
        if (entity.getAuthTime() == 1) {
            JSONObject requestObject = new JSONObject();
            requestObject.put("openCorpId", (Object)entity.getOpenCorpId());
            requestObject.put("currentAccount", (Object)entity.getBusAccount());
            JSONObject listFilter = new JSONObject();
            listFilter.put("roleType", (Object)"super_admin");
            requestObject.put("listFilter", (Object)listFilter);
            JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_list_member");
            if (StringUtils.isNotBlank((CharSequence)response.getString("employeeInfos"))) {
                JSONArray employeeInfos = response.getJSONArray("employeeInfos");
                ArrayList<SaleFadadaOrgPsn> fadadaOrgPsns = new ArrayList<SaleFadadaOrgPsn>();
                for (Object object : employeeInfos) {
                    JSONObject memberObject = JSONObject.parseObject((String)object.toString());
                    QueryWrapper orgPsnQueryWrapper = new QueryWrapper();
                    orgPsnQueryWrapper.eq((Object)"member_id", (Object)memberObject.getString("memberId"));
                    orgPsnQueryWrapper.eq((Object)"els_account", (Object)entity.getElsAccount());
                    orgPsnQueryWrapper.eq((Object)"bus_account", (Object)entity.getBusAccount());
                    if (!this.saleFadadaOrgPsnService.list((Wrapper)orgPsnQueryWrapper).isEmpty()) continue;
                    SaleFadadaOrgPsn fadadaOrgPsn = (SaleFadadaOrgPsn)((Object)SysUtil.copyProperties((Object)memberObject, SaleFadadaOrgPsn.class));
                    fadadaOrgPsn.setElsAccount(entity.getElsAccount());
                    fadadaOrgPsn.setCompanyName(entity.getCompanyName());
                    fadadaOrgPsn.setBusAccount(entity.getBusAccount());
                    fadadaOrgPsn.setClientCorpId(entity.getClientCorpId());
                    fadadaOrgPsn.setClientUserId(entity.getClientUserId());
                    fadadaOrgPsn.setOpenUserId(entity.getOpenUserId());
                    fadadaOrgPsn.setOpenCorpId(entity.getOpenCorpId());
                    fadadaOrgPsn.setActive("1");
                    fadadaOrgPsn.setOrgName(entity.getCorpName());
                    fadadaOrgPsn.setRoleType(this.fadadaCallUtil.arrayToString(memberObject.getJSONArray("roleType")));
                    fadadaOrgPsns.add(fadadaOrgPsn);
                }
                if (fadadaOrgPsns.size() > 0) {
                    this.saleFadadaOrgPsnService.saveBatch(fadadaOrgPsns);
                }
            }
        }
    }

    public void userAuthorize(JSONObject object) {
        String clientUserId = object.getString("clientUserId");
        QueryWrapper personalQueryWrapper = new QueryWrapper();
        personalQueryWrapper.eq((Object)"client_user_id", (Object)clientUserId);
        List purchaseFadadaPersonalList = this.purchaseFadadaPersonalService.list((Wrapper)personalQueryWrapper);
        if (!purchaseFadadaPersonalList.isEmpty()) {
            for (PurchaseFadadaPersonal entity : purchaseFadadaPersonalList) {
                entity.setAuthResult(object.getString("authResult"));
                entity.setAuthFailedReason(object.getString("authFailedReason"));
                entity.setIdentProcessStatus(object.getString("identProcessStatus"));
                entity.setOpenUserId(object.getString("openUserId"));
            }
            this.purchaseFadadaPersonalService.updateBatchById(purchaseFadadaPersonalList);
        } else {
            QueryWrapper saleFadadaPersonalQueryWrapper = new QueryWrapper();
            saleFadadaPersonalQueryWrapper.eq((Object)"client_user_id", (Object)clientUserId);
            List saleFadadaPersonalList = this.saleFadadaPersonalService.list((Wrapper)saleFadadaPersonalQueryWrapper);
            if (!saleFadadaPersonalList.isEmpty()) {
                for (SaleFadadaPersonal entity : saleFadadaPersonalList) {
                    entity.setAuthResult(object.getString("authResult"));
                    entity.setAuthFailedReason(object.getString("authFailedReason"));
                    entity.setIdentProcessStatus(object.getString("identProcessStatus"));
                    entity.setOpenUserId(object.getString("openUserId"));
                }
                this.saleFadadaPersonalService.updateBatchById(saleFadadaPersonalList);
            }
        }
    }

    private void handleEistUser(String clientUserId, JSONObject object) {
        QueryWrapper personalQueryWrapper = new QueryWrapper();
        personalQueryWrapper.eq((Object)"client_user_id", (Object)clientUserId);
        List purchaseFadadaPersonalList = this.purchaseFadadaPersonalService.list((Wrapper)personalQueryWrapper);
        if (!purchaseFadadaPersonalList.isEmpty()) {
            for (PurchaseFadadaPersonal entity : purchaseFadadaPersonalList) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"account_name", (Object)entity.getAccountName());
                wrapper.isNotNull((Object)"open_user_id");
                List personals = this.purchaseFadadaPersonalService.list((Wrapper)wrapper);
                if (!personals.isEmpty()) {
                    entity.setOpenUserId(((PurchaseFadadaPersonal)((Object)personals.get(0))).getOpenUserId());
                    entity.setClientUserId(((PurchaseFadadaPersonal)((Object)personals.get(0))).getClientUserId());
                    entity.setAuthResult(((PurchaseFadadaPersonal)((Object)personals.get(0))).getAuthResult());
                    entity.setIdentProcessStatus(((PurchaseFadadaPersonal)((Object)personals.get(0))).getIdentProcessStatus());
                    continue;
                }
                entity.setAuthResult(object.getString("authResult"));
                entity.setAuthFailedReason(object.getString("authFailedReason"));
                entity.setIdentProcessStatus(object.getString("identProcessStatus"));
                entity.setOpenUserId(object.getString("openUserId"));
            }
            this.purchaseFadadaPersonalService.updateBatchById(purchaseFadadaPersonalList);
        } else {
            QueryWrapper saleFadadaPersonalQueryWrapper = new QueryWrapper();
            saleFadadaPersonalQueryWrapper.eq((Object)"client_user_id", (Object)clientUserId);
            List saleFadadaPersonalList = this.saleFadadaPersonalService.list((Wrapper)saleFadadaPersonalQueryWrapper);
            if (!saleFadadaPersonalList.isEmpty()) {
                for (SaleFadadaPersonal entity : saleFadadaPersonalList) {
                    QueryWrapper wrapper = new QueryWrapper();
                    wrapper.eq((Object)"account_name", (Object)entity.getAccountName());
                    wrapper.isNotNull((Object)"open_user_id");
                    List personals = this.saleFadadaPersonalService.list((Wrapper)wrapper);
                    if (!personals.isEmpty()) {
                        entity.setOpenUserId(((SaleFadadaPersonal)((Object)personals.get(0))).getOpenUserId());
                        entity.setClientUserId(((SaleFadadaPersonal)((Object)personals.get(0))).getClientUserId());
                        entity.setAuthResult(((SaleFadadaPersonal)((Object)personals.get(0))).getAuthResult());
                        entity.setIdentProcessStatus(((SaleFadadaPersonal)((Object)personals.get(0))).getIdentProcessStatus());
                        continue;
                    }
                    entity.setAuthResult(object.getString("authResult"));
                    entity.setAuthFailedReason(object.getString("authFailedReason"));
                    entity.setIdentProcessStatus(object.getString("identProcessStatus"));
                    entity.setOpenUserId(object.getString("openUserId"));
                }
                this.saleFadadaPersonalService.updateBatchById(saleFadadaPersonalList);
            }
        }
    }
}

