/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.entity.PermissionGroup;
import com.els.modules.system.entity.UserPermissionGroup;
import com.els.modules.system.mapper.PermissionGroupMapper;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.service.PermissionGroupService;
import com.els.modules.system.service.UserPermissionGroupService;
import com.els.modules.system.vo.PermissionGroupVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PermissionGroupServiceImpl
extends BaseServiceImpl<PermissionGroupMapper, PermissionGroup>
implements PermissionGroupService {
    public static final String PERMISSION_GROUP_DATA_KEY = "sys:permissionData:group:";
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private UserPermissionGroupService userPermissionGroupService;
    @Resource
    private PermissionDataService permissionDataService;

    @Override
    public void add(PermissionGroupVO groupVO) {
        PermissionGroup permissionGroup = new PermissionGroup();
        BeanUtils.copyProperties((Object)((Object)groupVO), (Object)((Object)permissionGroup));
        ((PermissionGroupMapper)this.baseMapper).insert((Object)permissionGroup);
        groupVO.setId(permissionGroup.getId());
        List<PermissionData> permissionDataList = groupVO.getPermissionDataList();
        for (PermissionData permissionData : permissionDataList) {
            permissionData.setGroupId(permissionGroup.getId());
        }
        if (!permissionDataList.isEmpty()) {
            this.permissionDataService.saveBatch(permissionDataList);
        }
    }

    @Override
    @Transactional
    public void edit(PermissionGroupVO groupVO) {
        PermissionGroup permissionGroup = new PermissionGroup();
        BeanUtils.copyProperties((Object)((Object)groupVO), (Object)((Object)permissionGroup));
        ((PermissionGroupMapper)this.baseMapper).updateById((Object)permissionGroup);
        List<PermissionData> permissionDataList = groupVO.getPermissionDataList();
        for (PermissionData permissionData : permissionDataList) {
            permissionData.setGroupId(permissionGroup.getId());
        }
        this.permissionDataService.deleteByGroupId(permissionGroup.getId());
        if (!permissionDataList.isEmpty()) {
            this.permissionDataService.saveBatch(permissionDataList);
        }
        List userIdList = this.userPermissionGroupService.list((Wrapper)new QueryWrapper().eq((Object)"group_id", (Object)permissionGroup.getId())).stream().map(UserPermissionGroup::getUserId).collect(Collectors.toList());
        for (String userId : userIdList) {
            this.redisUtil.del(new String[]{PERMISSION_GROUP_DATA_KEY + userId});
        }
    }

    @Override
    public void delete(String id) {
        int count = this.userPermissionGroupService.count((Wrapper)new QueryWrapper().eq((Object)"group_id", (Object)id));
        if (count > 0) {
            throw new ELSBootException("\u5f53\u524d\u6743\u9650\u7ec4\u5b58\u5728\u5173\u8054\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        ((PermissionGroupMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public List<PermissionData> getPermissionDatasByUserId(String userId) {
        List dataList = (ArrayList)this.redisUtil.get(PERMISSION_GROUP_DATA_KEY + userId);
        if (dataList == null) {
            dataList = new ArrayList();
            List groupIdList = this.userPermissionGroupService.list((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId)).stream().map(UserPermissionGroup::getGroupId).collect(Collectors.toList());
            if (!groupIdList.isEmpty()) {
                dataList = this.permissionDataService.list((Wrapper)new QueryWrapper().in((Object)"group_id", groupIdList));
            }
            this.redisUtil.set(PERMISSION_GROUP_DATA_KEY + userId, dataList);
        }
        return dataList;
    }

    @Override
    public List<PermissionData> getPermissionDatasByUserIdAndBusinessType(String userId, String businessType) {
        List<PermissionData> dataList = this.getPermissionDatasByUserId(userId);
        List<PermissionData> resultList = dataList.parallelStream().filter(data -> data.getBusinessType().equals(businessType) || "all".equals(data.getBusinessType())).collect(Collectors.toList());
        return resultList;
    }

    @Override
    public void copy(PermissionGroup group) {
        String id = group.getId();
        List<PermissionData> permissionDataList = this.permissionDataService.selectByGroupId(id);
        group.setId(IdWorker.getIdStr());
        this.save((Object)group);
        for (PermissionData permissionData : permissionDataList) {
            permissionData.setId(IdWorker.getIdStr());
            permissionData.setGroupId(group.getId());
        }
        if (!permissionDataList.isEmpty()) {
            this.permissionDataService.saveBatch(permissionDataList);
        }
    }
}

