/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.fadada.entity.PurchaseFadadaOrg;
import com.els.modules.electronsign.fadada.entity.PurchaseFadadaSealPsn;
import com.els.modules.electronsign.fadada.enums.FadadaSealStatusEnum;
import com.els.modules.electronsign.fadada.mapper.PurchaseFadadaOrgMapper;
import com.els.modules.electronsign.fadada.mapper.PurchaseFadadaSealPsnMapper;
import com.els.modules.electronsign.fadada.service.PurchaseFadadaSealPsnService;
import com.els.modules.electronsign.fadada.util.FadadaCallUtil;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseFadadaSealPsnServiceImpl
extends BaseServiceImpl<PurchaseFadadaSealPsnMapper, PurchaseFadadaSealPsn>
implements PurchaseFadadaSealPsnService {
    @Autowired
    private FadadaCallUtil fadadaCallUtil;
    @Autowired
    private PurchaseFadadaOrgMapper purchaseFadadaOrgMapper;

    @Override
    public void add(PurchaseFadadaSealPsn purchaseFadadaSealPsn) {
        QueryWrapper purchaseFadadaSealPsnQueryWrapper = new QueryWrapper();
        purchaseFadadaSealPsnQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        purchaseFadadaSealPsnQueryWrapper.eq((Object)"seal_id", (Object)purchaseFadadaSealPsn.getSealId());
        purchaseFadadaSealPsnQueryWrapper.eq((Object)"member_id", (Object)purchaseFadadaSealPsn.getMemberId());
        if (this.getOne((Wrapper)purchaseFadadaSealPsnQueryWrapper) != null) {
            throw new ELSBootException("\u6210\u5458 " + purchaseFadadaSealPsn.getMemberName() + " \u7684 " + purchaseFadadaSealPsn.getSealName() + " \u6743\u9650\u5df2\u5b58\u5728");
        }
        ((PurchaseFadadaSealPsnMapper)this.baseMapper).insert((Object)purchaseFadadaSealPsn);
    }

    @Override
    public void edit(PurchaseFadadaSealPsn purchaseFadadaSealPsn) {
        this.editHandle(purchaseFadadaSealPsn);
        int count = ((PurchaseFadadaSealPsnMapper)this.baseMapper).updateById((Object)purchaseFadadaSealPsn);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    public void editHandle(PurchaseFadadaSealPsn purchaseFadadaSealPsn) {
        QueryWrapper purchaseFadadaSealPsnQueryWrapper = new QueryWrapper();
        purchaseFadadaSealPsnQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        purchaseFadadaSealPsnQueryWrapper.eq((Object)"seal_id", (Object)purchaseFadadaSealPsn.getSealId());
        purchaseFadadaSealPsnQueryWrapper.eq((Object)"member_id", (Object)purchaseFadadaSealPsn.getMemberId());
        PurchaseFadadaSealPsn fadadaSealPsn = (PurchaseFadadaSealPsn)((Object)this.getOne((Wrapper)purchaseFadadaSealPsnQueryWrapper));
        if (fadadaSealPsn != null && !fadadaSealPsn.getId().equals(purchaseFadadaSealPsn.getId())) {
            throw new ELSBootException("\u6210\u5458 " + purchaseFadadaSealPsn.getMemberName() + " \u7684 " + purchaseFadadaSealPsn.getSealName() + " \u6743\u9650\u5df2\u5b58\u5728");
        }
    }

    @Override
    public void delete(String id) {
        ((PurchaseFadadaSealPsnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseFadadaSealPsnMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void sealGrantUrl(PurchaseFadadaSealPsn purchaseFadadaSealPsn) {
        if (StringUtils.isBlank((CharSequence)purchaseFadadaSealPsn.getId())) {
            this.add(purchaseFadadaSealPsn);
        } else {
            this.edit(purchaseFadadaSealPsn);
        }
        JSONObject requestObject = new JSONObject();
        requestObject.put("openCorpId", (Object)purchaseFadadaSealPsn.getOpenCorpId());
        requestObject.put("sealId", (Object)purchaseFadadaSealPsn.getSealId());
        requestObject.put("redirectUrl", (Object)this.fadadaCallUtil.getRedirectUrl());
        QueryWrapper purchaseFadadaOrgQueryWrapper = new QueryWrapper();
        purchaseFadadaOrgQueryWrapper.eq((Object)"open_corp_id", (Object)purchaseFadadaSealPsn.getOpenCorpId());
        purchaseFadadaOrgQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        PurchaseFadadaOrg purchaseFadadaOrg = (PurchaseFadadaOrg)((Object)this.purchaseFadadaOrgMapper.selectOne((Wrapper)purchaseFadadaOrgQueryWrapper));
        if (purchaseFadadaOrg != null) {
            requestObject.put("clientUserId", (Object)purchaseFadadaOrg.getClientUserId());
        }
        JSONObject memberInfo = new JSONObject();
        Long[] memberIds = new Long[]{Long.parseLong(purchaseFadadaSealPsn.getMemberId())};
        memberInfo.put("memberIds", (Object)memberIds);
        if (purchaseFadadaSealPsn.getGrantStartTime() != null) {
            memberInfo.put("grantStartTime", (Object)purchaseFadadaSealPsn.getGrantStartTime().getTime());
        }
        if (purchaseFadadaSealPsn.getGrantEndTime() != null) {
            memberInfo.put("grantEndTime", (Object)purchaseFadadaSealPsn.getGrantEndTime().getTime());
        }
        requestObject.put("memberInfo", (Object)memberInfo);
        JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_seal_grant");
        purchaseFadadaSealPsn.setSealGrantUrl(response.getString("sealGrantUrl"));
        purchaseFadadaSealPsn.setGrantStatus(FadadaSealStatusEnum.to_be_effective.getValue());
        ((PurchaseFadadaSealPsnMapper)this.baseMapper).updateById((Object)purchaseFadadaSealPsn);
    }
}

