/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.contractlock.controller;

import cn.hutool.core.lang.Assert;
import cn.hutool.crypto.digest.MD5;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.IpaasConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.contractlock.dto.SealDto;
import com.els.modules.electronsign.contractlock.entity.PurchaseCLCompanyInfo;
import com.els.modules.electronsign.contractlock.entity.PurchaseClPersonalInfo;
import com.els.modules.electronsign.contractlock.service.PurchaseCLCompanyInfoService;
import com.qiyuesuo.sdk.v2.utils.CryptUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5951\u7ea6\u9501-\u4f01\u4e1a\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/contractLock/purchaseCLCompanyInfo"})
public class PurchaseCLCompanyInfoController
extends BaseController<PurchaseCLCompanyInfo, PurchaseCLCompanyInfoService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseCLCompanyInfoController.class);
    @Autowired
    private PurchaseCLCompanyInfoService purchaseCLCompanyInfoService;
    @Autowired
    private IpaasConfig ipaasConfig;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"contractLock#purchaseCompanyInfo:list"})
    public Result<?> queryPageList(PurchaseCLCompanyInfo PurchaseCLCompanyInfo2, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)PurchaseCLCompanyInfo2), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseCLCompanyInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u5355\u70b9\u767b\u5f55\u5230\u5951\u7ea6\u9501", value="\u5355\u70b9\u767b\u5f55\u5230\u5951\u7ea6\u9501")
    @ApiOperation(value="\u5355\u70b9\u767b\u5f55\u5230\u5951\u7ea6\u9501", notes="\u5355\u70b9\u767b\u5f55\u5230\u5951\u7ea6\u9501")
    @GetMapping(value={"/signUrl"})
    @RequiresPermissions(value={"contractLock#purchaseCompanyInfo:detail"})
    public Result<?> signUrl(@RequestParam(name="id") String id) {
        return Result.ok((String)this.purchaseCLCompanyInfoService.signUrl(id));
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/getSignList"})
    @RequiresPermissions(value={"contractLock#purchaseCompanyInfo:detail"})
    public Result<?> getSignList(PurchaseCLCompanyInfo PurchaseCLCompanyInfo2, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)PurchaseCLCompanyInfo2), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.isNotNull((Object)"company_id");
        IPage pageList = this.purchaseCLCompanyInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(busModule="\u5951\u7ea6\u9501-\u91c7\u65b9\u4f01\u4e1a\u4fe1\u606f", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"contractLock#purchaseCompanyInfo:add", "contractLock#purchaseCompanyInfo:edit"}, logical=Logical.OR)
    public Result<?> add(@RequestBody PurchaseCLCompanyInfo purchaseCLCompanyInfo) {
        this.purchaseCLCompanyInfoService.add(purchaseCLCompanyInfo);
        return Result.ok((Object)((Object)purchaseCLCompanyInfo));
    }

    @SrmValidated
    @AutoLog(busModule="\u5951\u7ea6\u9501-\u91c7\u65b9\u4f01\u4e1a\u4fe1\u606f", value="\u6dfb\u52a0\u5458\u5de5")
    @ApiOperation(value="\u6dfb\u52a0\u5458\u5de5", notes="\u6dfb\u52a0\u5458\u5de5")
    @PostMapping(value={"/addStaff"})
    @RequiresPermissions(value={"contractLock#purchaseCompanyInfo:staffManage"})
    public Result<?> addStaff(@RequestBody PurchaseClPersonalInfo purchaseClPersonalInfo) {
        this.purchaseCLCompanyInfoService.addStaff(purchaseClPersonalInfo);
        return Result.ok((Object)2);
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501-\u91c7\u65b9\u4f01\u4e1a\u4fe1\u606f", value="\u79fb\u9664\u5458\u5de5")
    @ApiOperation(value="\u79fb\u9664\u5458\u5de5", notes="\u79fb\u9664\u5458\u5de5")
    @PostMapping(value={"/removeStaff"})
    @RequiresPermissions(value={"contractLock#purchaseCompanyInfo:staffManage"})
    public Result<?> removeStaff(@RequestBody PurchaseClPersonalInfo purchaseClPersonalInfo) {
        this.purchaseCLCompanyInfoService.removeStaff(purchaseClPersonalInfo);
        return Result.ok();
    }

    @SrmValidated
    @AutoLog(busModule="\u5951\u7ea6\u9501-\u91c7\u65b9\u4f01\u4e1a\u4fe1\u606f", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"contractLock#purchaseCompanyInfo:edit"})
    public Result<?> edit(@RequestBody PurchaseCLCompanyInfo PurchaseCLCompanyInfo2) {
        this.purchaseCLCompanyInfoService.edit(PurchaseCLCompanyInfo2);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501-\u91c7\u65b9\u4f01\u4e1a\u4fe1\u606f", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"contractLock#purchaseCompanyInfo:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseCLCompanyInfoService.delete(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"contractLock#purchaseCompanyInfo:detail"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseCLCompanyInfo PurchaseCLCompanyInfo2 = (PurchaseCLCompanyInfo)((Object)this.purchaseCLCompanyInfoService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)PurchaseCLCompanyInfo2));
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501-\u91c7\u65b9\u4f01\u4e1a\u4fe1\u606f", value="\u4f01\u4e1a\u8ba4\u8bc1\u56de\u8c03")
    @ApiOperation(value="\u4f01\u4e1a\u8ba4\u8bc1\u56de\u8c03", notes="\u4f01\u4e1a\u8ba4\u8bc1\u56de\u8c03")
    @PostMapping(value={"/noToken/callback/authCompany"})
    public void callbackAuthCompany(@RequestParam Map<String, String> params) {
        log.info("\u4f01\u4e1a\u8ba4\u8bc1\u56de\u8c03-purchase-req:{}", params);
        String signature = params.get("signature");
        String timestamp = params.get("timestamp");
        String secretKey = (String)this.ipaasConfig.getConfig().get("contract-lock.secretkey");
        Assert.isTrue((boolean)signature.equals(MD5.create().digestHex(timestamp + secretKey)), (String)I18nUtil.translate((String)"i18n_field_uhVV_4678aea2", (String)"\u975e\u6cd5\u8bf7\u6c42"), (Object[])new Object[0]);
        String content = params.get("content");
        try {
            String contents = CryptUtils.aesDerypt((String)content, (String)secretKey);
            this.purchaseCLCompanyInfoService.handleCallBackAuth(contents);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501-\u5951\u7ea6\u9501\u5355\u70b9\u767b\u5f55\u56de\u8c03", value="\u5951\u7ea6\u9501\u5355\u70b9\u767b\u5f55\u56de\u8c03")
    @ApiOperation(value="\u5951\u7ea6\u9501\u5355\u70b9\u767b\u5f55\u56de\u8c03", notes="\u5951\u7ea6\u9501\u5355\u70b9\u767b\u5f55\u56de\u8c03")
    @PostMapping(value={"/noToken/casVerifyUrl"})
    public Result<?> noTokenCasVerifyUrl(@RequestParam Map<String, String> params) {
        log.info("\u5951\u7ea6\u9501\u5355\u70b9\u767b\u5f55\u56de\u8c03req:{}", params);
        return Result.ok((Object)this.purchaseCLCompanyInfoService.handleCasVerify(params.get("ticket")));
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501-\u91c7\u65b9\u4f01\u4e1a\u4fe1\u606f", value="\u63d0\u4ea4\u8ba4\u8bc1")
    @ApiOperation(value="\u63d0\u4ea4\u8ba4\u8bc1", notes="\u63d0\u4ea4\u8ba4\u8bc1")
    @PostMapping(value={"/submitCertification"})
    @RequiresPermissions(value={"contractLock#purchaseCompanyInfo:submitCertification"})
    public Result<?> submitCertification(@RequestBody PurchaseCLCompanyInfo req) {
        this.purchaseCLCompanyInfoService.submitCertification(req);
        return Result.ok((Object)((Object)req));
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501-\u91c7\u65b9\u4f01\u4e1a\u4fe1\u606f", value="\u83b7\u53d6\u8ba4\u8bc1\u4fe1\u606f")
    @ApiOperation(value="\u83b7\u53d6\u8ba4\u8bc1\u4fe1\u606f", notes="\u83b7\u53d6\u8ba4\u8bc1\u4fe1\u606f")
    @GetMapping(value={"/getCertificationInfo"})
    @RequiresPermissions(value={"contractLock#purchaseCompanyInfo:refreshStatus"})
    public Result<?> getCertificationInfo(@RequestParam(name="id") String id) {
        this.purchaseCLCompanyInfoService.getCertificationInfo(id);
        return Result.ok();
    }

    @AutoLog(busModule="\u5951\u7ea6\u9501-\u91c7\u65b9\u4f01\u4e1a\u4fe1\u606f", value="\u6388\u6743")
    @ApiOperation(value="\u83b7\u53d6\u8ba4\u8bc1\u4fe1\u606f", notes="\u6388\u6743")
    @GetMapping(value={"/getAuthPage"})
    @RequiresPermissions(value={"contractLock#purchaseCompanyInfo:auth"})
    public Result<?> getAuthPage(@RequestParam(name="id") String id) {
        return Result.ok((Object)((Object)this.purchaseCLCompanyInfoService.getAuthPage(id)));
    }

    @PostMapping(value={"/generateDefaultSeal"})
    @RequiresPermissions(value={"contractLock#purchaseCompanyInfo:defaultSealAdmin"})
    public Result<?> generateDefaultSeal(@RequestBody SealDto sealRq) {
        this.purchaseCLCompanyInfoService.generateDefaultSeal(sealRq);
        return Result.ok();
    }

    @GetMapping(value={"/defaultSeal"})
    @RequiresPermissions(value={"contractLock#purchaseCompanyInfo:defaultSealAdmin"})
    public Result<?> defaultSeal(@RequestParam(value="id") String id) {
        return Result.ok((Object)this.purchaseCLCompanyInfoService.defaultSeal(id));
    }

    @GetMapping(value={"/roleAdmin"})
    @RequiresPermissions(value={"contractLock#purchaseCompanyInfo:staffManage"})
    public Result<?> roleAdmin(@RequestParam(value="id") String id, @RequestParam(value="operate") String operate) {
        this.purchaseCLCompanyInfoService.roleAdmin(id, operate);
        return Result.ok();
    }
}

