/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esign.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.esign.entity.SaleSignReturnAttachment;
import com.els.modules.electronsign.esign.service.SaleSignReturnAttachmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"\u4f9b\u5e94\u5546\u56de\u4f20\u9644\u4ef6"})
@RestController
@RequestMapping(value={"/esign/saleSignReturnAttachment"})
public class SaleSignReturnAttachmentController
extends BaseController<SaleSignReturnAttachment, SaleSignReturnAttachmentService> {
    private static final Logger log = LoggerFactory.getLogger(SaleSignReturnAttachmentController.class);
    @Autowired
    private SaleSignReturnAttachmentService saleSignReturnAttachmentService;
    @Value(value="${els.path.upload}")
    private String uploadpath;
    private static final String STR_FORMAT = "yyyyMMdd";
    private static final String STR_SPLIT = "_";
    private static final String STR_DOT = ".";

    @AutoLog(value="\u4f9b\u5e94\u5546\u56de\u4f20\u9644\u4ef6-\u4e0a\u4f20", operateType=2)
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6", notes="\u4e0a\u4f20\u6587\u4ef6")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"esign#saleEsign:editDoc", "esign#purchaseEsign:add", "esign#purchaseEsign:edit"}, logical=Logical.OR)
    public Result<?> upload(HttpServletRequest request) {
        String businessType = request.getParameter("businessType");
        Assert.hasText((String)businessType, (String)I18nUtil.translate((String)"i18n_alert_RRESAc_50983d0e", (String)"\u7f3a\u5c11\u4e1a\u52a1\u7c7b\u578b"));
        String headId = request.getParameter("headId");
        Assert.hasText((String)headId, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a"));
        String itemNumber = request.getParameter("itemNumber");
        String fileType = request.getParameter("fileType");
        String attachmentVersion = request.getParameter("attachmentVersion");
        attachmentVersion = "null".equals(attachmentVersion) ? "" : attachmentVersion;
        String bizPath = "files";
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        String nowDay = dtf.format(time);
        String elsAccount = this.getTenantId();
        File file = new File(this.uploadpath + File.separator + bizPath + File.separator + elsAccount + File.separator + nowDay);
        if (!file.exists()) {
            file.mkdirs();
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        try {
            for (Map.Entry entity : fileMap.entrySet()) {
                MultipartFile uploadFile = (MultipartFile)entity.getValue();
                String documentName = uploadFile.getOriginalFilename();
                String documentType = "";
                String fileName = "";
                int suffixLocation = documentName.lastIndexOf(STR_DOT);
                if (suffixLocation > 0) {
                    documentType = documentName.substring(suffixLocation + 1);
                    fileName = documentName.substring(0, documentName.lastIndexOf(STR_DOT)) + STR_SPLIT + System.currentTimeMillis() + STR_DOT + documentType;
                } else {
                    fileName = documentName + STR_SPLIT + System.currentTimeMillis();
                }
                String documentLocation = File.separator + bizPath + File.separator + elsAccount + File.separator + nowDay + File.separator + fileName;
                if (documentLocation.contains("\\")) {
                    documentLocation = documentLocation.replace("\\", "/");
                }
                String savePath = file.getPath() + File.separator + fileName;
                File savefile = new File(savePath);
                FileCopyUtils.copy((byte[])uploadFile.getBytes(), (File)savefile);
                SaleSignReturnAttachment attachment = new SaleSignReturnAttachment();
                attachment.setBusinessType(businessType);
                attachment.setHeadId(headId);
                attachment.setItemNumber(itemNumber);
                attachment.setFileType(fileType);
                attachment.setUploadSubAccount(this.getCurrentUser().getSubAccount());
                attachment.setUploadElsAccount(elsAccount);
                attachment.setFileName(documentName);
                attachment.setFileSize(String.valueOf(uploadFile.getSize()));
                attachment.setFilePath(documentLocation);
                attachment.setSendStatus("0");
                attachment.setReceiveStatus("0");
                attachment.setUploadTime(new Date());
                attachment.setAttachmentVersion(attachmentVersion);
                boolean result = this.saleSignReturnAttachmentService.save((Object)attachment);
                if (!result) continue;
                return Result.ok((Object)((Object)attachment));
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25"));
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u56de\u4f20\u9644\u4ef6-\u4e0b\u8f7d", operateType=1)
    @GetMapping(value={"/download"})
    @RequiresPermissions(value={"esign#saleEsign:editDoc", "esign#purchaseEsign:add", "esign#purchaseEsign:edit"}, logical=Logical.OR)
    public void download(@RequestParam(name="id") String id, HttpServletResponse response) {
        SaleSignReturnAttachment attachment = (SaleSignReturnAttachment)((Object)this.saleSignReturnAttachmentService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        String downloadFilePath = this.uploadpath + File.separator + attachment.getFilePath();
        File file = new File(downloadFilePath);
        Assert.isTrue((boolean)file.exists(), (String)I18nUtil.translate((String)"i18n_alert_BIxMKSIqQG_748441c8", (String)"\u9644\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664"));
        try (ServletOutputStream outputStream = response.getOutputStream();
             BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            int len;
            response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)inputStream).read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
            outputStream.flush();
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u6279\u91cf\u5220\u9664", operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"esign#saleEsign:editDoc", "esign#purchaseEsign:add", "esign#purchaseEsign:edit"}, logical=Logical.OR)
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.saleSignReturnAttachmentService.delBatchSaleSignRetrunAttachment(idList);
        return this.commonSuccessResult(4);
    }
}

