/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.esignv3.dto.CallBackDto;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3OrgPsn;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3Personal;
import com.els.modules.electronsign.esignv3.enums.RealNameStatusEnum;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3OrgPsnService;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3OrgService;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3PersonalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"E\u7b7e\u5b9dv3\u4e2a\u4eba"})
@RestController
@RequestMapping(value={"/esignv3/purchaseEsignV3Personal"})
public class PurchaseEsignV3PersonalController
extends BaseController<PurchaseEsignV3Personal, PurchaseEsignV3PersonalService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEsignV3PersonalController.class);
    @Autowired
    private PurchaseEsignV3PersonalService purchaseEsignV3PersonalService;
    @Autowired
    private PurchaseEsignV3OrgPsnService purchaseEsignV3OrgPsnService;
    @Autowired
    private PurchaseEsignV3OrgService orgService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"esignv3#purchaseEsignV3Personal:list"})
    public Result<?> queryPageList(PurchaseEsignV3Personal purchaseEsignV3Personal, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseEsignV3Personal), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseEsignV3PersonalService.page((IPage)page, (Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)pageList) && CollUtil.isNotEmpty((Collection)pageList.getRecords())) {
            List ids = pageList.getRecords().stream().map(x -> x.getId()).collect(Collectors.toList());
            List purchaseEsignV3OrgPsns = this.purchaseEsignV3OrgPsnService.list((Wrapper)Wrappers.lambdaQuery().in(PurchaseEsignV3OrgPsn::getPsnId, ids));
            if (CollUtil.isNotEmpty((Collection)purchaseEsignV3OrgPsns)) {
                Map<String, List<PurchaseEsignV3OrgPsn>> psnOrgMaps = purchaseEsignV3OrgPsns.stream().collect(Collectors.groupingBy(PurchaseEsignV3OrgPsn::getPsnId));
                List orgIds = purchaseEsignV3OrgPsns.stream().map(x -> x.getOrgId()).distinct().collect(Collectors.toList());
                List purchaseEsignV3Orgs = this.orgService.listByIds(orgIds);
                Map<String, String> orgNamsMaps = purchaseEsignV3Orgs.stream().collect(Collectors.toMap(x -> x.getId(), y -> y.getOrgName()));
                pageList.getRecords().forEach(row -> {
                    List org = (List)psnOrgMaps.get(row.getId());
                    if (CollUtil.isNotEmpty((Collection)org)) {
                        row.setCompanyName(org.stream().map(x -> (String)orgNamsMaps.get(x.getOrgId())).collect(Collectors.joining(",")));
                    }
                });
            }
        }
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryList"})
    @RequiresPermissions(value={"esignv3#purchaseEsignV3Personal:list"})
    @PermissionDataView(businessType="contractLock")
    public Result<?> queryList(String name) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.like(StrUtil.isNotBlank((CharSequence)name), (Object)"psn_name", (Object)(name + "%"));
        queryWrapper.eq((Object)"realname_status", (Object)RealNameStatusEnum.REAL_NAME.getCode());
        List list = this.purchaseEsignV3PersonalService.list((Wrapper)queryWrapper);
        return Result.ok((Object)list);
    }

    @AutoLog(value="E\u7b7e\u5b9dv3\u4e2a\u4eba-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"esignv3#purchaseEsignV3Personal:add"})
    public Result<?> add(@RequestBody PurchaseEsignV3Personal purchaseEsignV3Personal) {
        this.purchaseEsignV3PersonalService.add(purchaseEsignV3Personal);
        return Result.ok((Object)((Object)purchaseEsignV3Personal));
    }

    @AutoLog(value="E\u7b7e\u5b9dv3\u4e2a\u4eba-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"esignv3#purchaseEsignV3Personal:add"})
    public Result<?> edit(@RequestBody PurchaseEsignV3Personal purchaseEsignV3Personal) {
        this.purchaseEsignV3PersonalService.edit(purchaseEsignV3Personal);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="E\u7b7e\u5b9dv3\u4e2a\u4eba-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"esignv3#purchaseEsignV3Personal:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseEsignV3PersonalService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="E\u7b7e\u5b9dv3\u4e2a\u4eba-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"esignv3#purchaseEsignV3Personal:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseEsignV3PersonalService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"esignv3#purchaseEsignV3Personal:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseEsignV3Personal purchaseEsignV3Personal = (PurchaseEsignV3Personal)((Object)this.purchaseEsignV3PersonalService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)purchaseEsignV3Personal));
    }

    @ApiOperation(value="\u63d0\u4ea4\u8ba4\u8bc1", notes="\u63d0\u4ea4\u8ba4\u8bc1")
    @PostMapping(value={"/submitCertification"})
    @RequiresPermissions(value={"esignv3#purchaseEsignV3Personal:submitCertification"})
    public Result<?> submitCertification(@RequestBody PurchaseEsignV3Personal purchaseEsignV3Personal, @RequestParam(name="needSave", defaultValue="1", required=false) String needSave) {
        return Result.ok((Object)((Object)this.purchaseEsignV3PersonalService.submitCertification(purchaseEsignV3Personal, needSave)));
    }

    @PostMapping(value={"/noToken/callback"})
    public Result<?> callback(@RequestBody CallBackDto.PersonalAuth params) {
        log.info("purchaseEsignV3Personal callback receive : [{}]", (Object)JSON.toJSONString((Object)params));
        this.purchaseEsignV3PersonalService.handleCallBack(params);
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u6388\u6743\u94fe\u63a5", notes="\u83b7\u53d6\u6388\u6743\u94fe\u63a5")
    @PostMapping(value={"/getAuth"})
    @RequiresPermissions(value={"esignv3#purchaseEsignV3Personal:getAuth"})
    public Result<?> getAuth(@RequestBody PurchaseEsignV3Personal personalData) {
        return Result.ok((String)this.purchaseEsignV3PersonalService.getAuth(personalData));
    }

    @ApiOperation(value="\u5237\u65b0\u8ba4\u8bc1\u72b6\u6001", notes="\u5237\u65b0\u8ba4\u8bc1\u72b6\u6001")
    @GetMapping(value={"/refreshRealNameStatus"})
    @RequiresPermissions(value={"esignv3#purchaseEsignV3Personal:refresh"})
    public Result<?> refreshRealNameStatus(@RequestParam(name="id") String id) {
        this.purchaseEsignV3PersonalService.refreshRealNameStatus(id);
        return Result.ok();
    }
}

