/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.justauth.cache;

import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import me.zhyd.oauth.cache.AuthStateCache;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class CustomRedisStateCache
implements AuthStateCache {
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    private static final String REDIS_KEY = "sys::auth::state::";

    public void cache(String key, String value) {
        this.cache(key, value, 1800000L);
    }

    public void cache(String key, String value, long timeout) {
        this.redisTemplate.opsForValue().set((Object)(REDIS_KEY + key), (Object)value, timeout, TimeUnit.MILLISECONDS);
    }

    public String get(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)(REDIS_KEY + key));
    }

    public boolean containsKey(String key) {
        Long expire = this.redisTemplate.getExpire((Object)(REDIS_KEY + key), TimeUnit.MILLISECONDS);
        return expire > 0L;
    }
}

