/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ElsBusinessRuleDTO;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.model.SsoModel;
import com.els.modules.system.model.ThirdLoginModel;
import com.els.modules.system.rpc.service.InvokeBaseRpcService;
import com.els.modules.system.rpc.service.InvokeSmsRpcService;
import com.els.modules.system.service.ElsPasswordSecurityService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.vo.ElsSubAccountVO;
import com.els.shiro.authc.JwtToken;
import com.xkcoding.justauth.AuthRequestFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.utils.AuthStateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/old-account/thirdLogin"})
@Api(tags={"\u7b2c\u4e09\u65b9\u767b\u5f55"})
@Deprecated
public class ThirdLoginOldController {
    private static final Logger log = LoggerFactory.getLogger(ThirdLoginOldController.class);
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private ThirdAccountService thirdAccountService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private AuthRequestFactory factory;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Resource
    private InvokeBaseRpcService baseDubboService;
    @Autowired
    private ElsTenantService elsTenantService;
    @Resource
    private InvokeSmsRpcService invokeSmsRpcService;
    @Autowired
    private ElsPasswordSecurityService pwSecurityService;
    private static final String STATE_KEY = "sys:thirdLogin:state:";

    @AutoLog(value="\u7b2c\u4e09\u65b9\u767b\u5f55-\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165render")
    @GetMapping(value={"/render/{source}"})
    public void render(@PathVariable(value="source") String source, @RequestParam(name="routeUri", required=false) String routeUri, HttpServletResponse response) throws IOException {
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165render\uff1a" + source);
        AuthRequest authRequest = this.factory.get(source);
        String state = AuthStateUtils.createState();
        String authorizeUrl = authRequest.authorize(state);
        JSONObject object = new JSONObject();
        if (StrUtil.isNotBlank((CharSequence)routeUri)) {
            object.put("routeUri", (Object)routeUri);
            this.redisUtil.set(STATE_KEY + state, (Object)object);
        }
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8ba4\u8bc1\u5730\u5740\uff1a" + authorizeUrl);
        response.sendRedirect(authorizeUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoLog(value="\u7b2c\u4e09\u65b9\u767b\u5f55-\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback")
    @GetMapping(value={"/{source}/callback"})
    public Result<?> loginThird(@PathVariable(value="source") String source, AuthCallback callback) {
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\uff1a" + source + " params\uff1a" + JSONObject.toJSONString((Object)callback));
        AuthRequest authRequest = this.factory.get(source);
        AuthResponse response = authRequest.login(callback);
        log.info(JSONObject.toJSONString((Object)response));
        Result result = new Result();
        if (response.getCode() == 2000) {
            JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()));
            String username = data.getString("username");
            String avatar = data.getString("avatar");
            String uuid = data.getString("uuid");
            ThirdLoginModel tlm = new ThirdLoginModel(source, uuid, username, avatar);
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(ThirdAccount::getThirdUserUuid, (Object)uuid);
            List thridList = this.thirdAccountService.list((Wrapper)query).stream().filter(o -> StrUtil.isNotBlank((CharSequence)o.getUserId())).collect(Collectors.toList());
            ThirdAccount user = null;
            if (thridList.isEmpty()) {
                log.info(":::Third callback first thirdUserUuid:{}", (Object)tlm.getUuid());
                user = this.saveThirdUser(tlm);
                JSONObject obj = new JSONObject();
                obj.put("thirdUserUuid", (Object)user.getThirdUserUuid());
                result.setResult((Object)obj);
                result.success("\u64cd\u4f5c\u6210\u529f\u4f46\u6ca1\u6709\u7ed1\u5b9a\u8d26\u53f7\uff01");
            } else {
                user = (ThirdAccount)((Object)thridList.get(0));
                String userId = user.getUserId();
                ElsSubAccount account = (ElsSubAccount)((Object)this.elsSubAccountService.getById((Serializable)((Object)userId)));
                JSONObject busObj = (JSONObject)this.redisUtil.get(STATE_KEY + callback.getState());
                try {
                    TenantContext.setTenant((String)account.getElsAccount());
                    this.userInfo(account, (Result<JSONObject>)result, busObj);
                }
                finally {
                    TenantContext.clear();
                }
            }
        } else {
            result.setSuccess(false);
            result.setMessage("\u7b2c\u4e09\u65b9\u767b\u5f55\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458:" + response.getMsg());
        }
        return result;
    }

    private Result<JSONObject> userInfo(ElsSubAccount sysUser, Result<JSONObject> result, JSONObject busObj) {
        String syspassword = sysUser.getPassword();
        String elsAccount = sysUser.getElsAccount();
        String subAccount = sysUser.getSubAccount();
        String token = JwtUtil.sign((String)(elsAccount + "_" + subAccount), (String)syspassword);
        this.redisUtil.set("sys:token:" + token, (Object)token);
        this.redisUtil.expire("sys:token:" + token, 3600L);
        this.redisUtil.set("sys:token:" + elsAccount + "_" + subAccount, (Object)token);
        this.redisUtil.expire("sys:token:" + elsAccount + "_" + subAccount, 3600L);
        String adminFlag = this.userRoleService.getAdminFlag(elsAccount, subAccount);
        this.redisUtil.set("sys:token:role:" + token, (Object)adminFlag);
        List<ElsCompanySetDTO> list = this.baseRpcService.getCompanySetList(elsAccount);
        ElsTenant byElsAccount = this.elsTenantService.findByElsAccount(elsAccount);
        ElsCompanySetDTO elsCompanySetDTO1 = new ElsCompanySetDTO();
        elsCompanySetDTO1.setItemCode("companyShortName");
        elsCompanySetDTO1.setDefaultValue(byElsAccount != null ? byElsAccount.getCompanyShortName() : "");
        list.add(elsCompanySetDTO1);
        ElsCompanySetDTO elsCompanySetDTO2 = new ElsCompanySetDTO();
        elsCompanySetDTO2.setItemCode("companyLogo");
        elsCompanySetDTO2.setDefaultValue(byElsAccount != null ? byElsAccount.getCompanyLogo() : "");
        list.add(elsCompanySetDTO2);
        JSONObject companySetObj = this.getObjBySet(list);
        ElsSubAccountVO elsSubAccountVO = new ElsSubAccountVO();
        BeanUtils.copyProperties((Object)((Object)sysUser), (Object)((Object)elsSubAccountVO));
        List userRole = this.userRoleService.list((Wrapper)new QueryWrapper().lambda().eq(UserRole::getUserId, (Object)sysUser.getId()));
        StringBuilder str = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)userRole)) {
            for (UserRole sysUserRole : userRole) {
                if (str.length() == 0) {
                    str.append(sysUserRole.getRoleId());
                    continue;
                }
                str.append(",").append(sysUserRole.getRoleId());
            }
        }
        elsSubAccountVO.setSelectedroles(str.toString());
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        elsSubAccountVO.setSerivceUrl((String)config.get("service.address"));
        Map<String, String> map = this.elsSubAccountService.getLogoSetByElsAccount(elsAccount);
        if (map != null) {
            elsSubAccountVO.setAliasName(map.get("alias"));
            elsSubAccountVO.setEnterpriseName(map.get("name"));
            elsSubAccountVO.setEnterpriseLogo(companySetObj.getString("enterpriseLogo") != null && "1".equals(companySetObj.getString("enterpriseLogo")) && map.get("enterprise_logo") != null ? map.get("enterprise_logo") : "");
        }
        List<ElsBusinessRuleDTO> businessRulets = this.baseRpcService.getBusinessRuletList(elsAccount);
        JSONArray businessRuleList = this.getBusinessRuleList(businessRulets);
        companySetObj.put("businessRuleList", (Object)businessRuleList);
        JSONObject obj = new JSONObject();
        obj.put("token", (Object)token);
        obj.put("userInfo", (Object)elsSubAccountVO);
        obj.put("companySet", (Object)companySetObj);
        if (busObj != null) {
            obj.put("busObj", (Object)busObj);
        }
        result.setResult((Object)obj);
        result.success("\u767b\u5f55\u6210\u529f");
        JwtToken jwtToken = new JwtToken(token);
        SecurityUtils.getSubject().login((AuthenticationToken)jwtToken);
        return result;
    }

    private JSONArray getBusinessRuleList(List<ElsBusinessRuleDTO> list) {
        JSONArray jsonArray = new JSONArray();
        JSONObject object = null;
        String type = null;
        String action = null;
        String defaultValue = null;
        for (ElsBusinessRuleDTO ruleDTO : list) {
            object = new JSONObject();
            type = ruleDTO.getItemType();
            defaultValue = ruleDTO.getDefaultValue();
            if (!"switch".equals(type) || !"0".equals(defaultValue)) continue;
            action = ruleDTO.getBusinessType() + ":" + "hideBtn" + ":" + ruleDTO.getItemCode();
            object.put("action", (Object)action);
            object.put("status", (Object)defaultValue);
            object.put("type", (Object)type);
            object.put("describe", (Object)ruleDTO.getItemName());
            jsonArray.add((Object)object);
        }
        return jsonArray.isEmpty() ? new JSONArray() : jsonArray;
    }

    private Result<JSONObject> userInfo1(ElsSubAccount sysUser, Result<JSONObject> result, JSONObject busObj) {
        String syspassword = sysUser.getPassword();
        String elsAccount = sysUser.getElsAccount();
        String subAccount = sysUser.getSubAccount();
        String token = JwtUtil.sign((String)(elsAccount + "_" + subAccount), (String)syspassword);
        this.redisUtil.set("sys:token:" + token, (Object)token);
        this.redisUtil.expire("sys:token:" + token, 3600L);
        TenantContext.setTenant((String)elsAccount);
        String adminFlag = this.userRoleService.getAdminFlag(elsAccount, subAccount);
        this.redisUtil.set("sys:token:role:" + token, (Object)adminFlag);
        List<ElsCompanySetDTO> list = this.baseDubboService.getCompanySetList(elsAccount);
        JSONObject obj = new JSONObject();
        obj.put("token", (Object)token);
        obj.put("userInfo", (Object)sysUser);
        obj.put("companySet", (Object)this.getObjBySet(list));
        if (busObj != null) {
            obj.put("busObj", (Object)busObj);
        }
        result.setResult((Object)obj);
        result.success("\u767b\u5f55\u6210\u529f");
        JwtToken jwtToken = new JwtToken(token);
        SecurityUtils.getSubject().login((AuthenticationToken)jwtToken);
        return result;
    }

    private JSONObject getObjBySet(List<ElsCompanySetDTO> list) {
        JSONObject result = new JSONObject();
        for (ElsCompanySetDTO set : list) {
            result.put(set.getItemCode(), (Object)set.getDefaultValue());
        }
        return result;
    }

    @AutoLog(busModule="\u7b2c\u4e09\u65b9\u767b\u5f55", value="\u83b7\u53d6ssoToken")
    @ApiOperation(value="\u83b7\u53d6ssoToken", notes="\u83b7\u53d6ssoToken")
    @PostMapping(value={"/ssoToken"})
    public Result<?> ssoToken(@RequestBody SsoModel ssoModel) {
        String clientId = ssoModel.getClientId();
        if (StrUtil.isBlank((CharSequence)clientId)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_value_not_empty", (String)"${0}\u4e0d\u80fd\u4e3a\u7a7a"), new String[]{"clientId"});
        }
        String[] clientArray = clientId.split("_");
        if (clientArray.length == 1 || !clientId.contains("App_")) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWWWWWWmKxiRWWiRmKWWWWWWWWWWWW_939fab2d", (String)"clientId \u683c\u5f0f\u4e0d\u6b63\u786e\uff01\uff0c\u6b63\u786e\u683c\u5f0f\uff1axxx_App_xxx"));
        }
        String secret = ssoModel.getSecret();
        if (StrUtil.isBlank((CharSequence)secret)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWWWWWWmKxiRWWiRmKWWWWWWWWWWWW_939fab2d", (String)"clientId \u683c\u5f0f\u4e0d\u6b63\u786e\uff01\uff0c\u6b63\u786e\u683c\u5f0f\uff1axxx_App_xxx"));
        }
        String subAccount = ssoModel.getSubAccount();
        if (StrUtil.isBlank((CharSequence)subAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_value_not_empty", (String)"${0}\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[]{"subAccount "}));
        }
        String elsAccount = clientArray[0];
        ElsSubAccount account = this.elsSubAccountService.getUserByAccount(clientId);
        if (account == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_title_ClientIdDoesNotExist", (String)"Client Id\u4e0d\u5b58\u5728"));
        }
        String userpassword = PasswordUtil.encrypt((String)clientId, (String)secret, (String)account.getSalt());
        String syspassword = account.getPassword();
        if (!syspassword.equals(userpassword)) {
            throw new ELSBootException("clientId " + I18nUtil.translate((String)"i18n_alert_WWWWWWWWWLiKmW_75264f56", (String)"\u8ba4\u8bc1\u5931\u8d25\uff01"));
        }
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getByAccount(elsAccount, subAccount);
        if (elsSubAccount == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JeyxMKW_ff3f2765", (String)"\u5b50\u8d26\u53f7\u4e0d\u5b58\u5728\uff01"));
        }
        JSONObject result = new JSONObject();
        result.put("token", (Object)this.saveToken(elsSubAccount));
        return Result.ok((Object)result);
    }

    private ThirdAccount saveThirdUser(ThirdLoginModel tlm) {
        ThirdAccount user = new ThirdAccount();
        user.setId(IdWorker.getIdStr());
        user.setDeleted(CommonConstant.DEL_FLAG_0);
        user.setStatus(1);
        user.setThirdType(tlm.getSource());
        user.setAvatar(tlm.getAvatar());
        user.setRealname(tlm.getUsername());
        user.setThirdUserUuid(tlm.getUuid());
        this.thirdAccountService.save((Object)user);
        return user;
    }

    private String saveToken(ElsSubAccount account) {
        String token = JwtUtil.sign((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)account.getPassword());
        this.redisUtil.set("sys:token:" + token, (Object)token);
        this.redisUtil.expire("sys:token:" + token, 1800L);
        return token;
    }
}

