/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.ConvertUtils;
import com.els.common.util.PasswordUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ThirdAccountDTO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.mapper.RoleMapper;
import com.els.modules.system.mapper.ThirdAccountMapper;
import com.els.modules.system.mapper.UserRoleMapper;
import com.els.modules.system.service.ThirdAccountService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ThirdAccountServiceImpl
extends ServiceImpl<ThirdAccountMapper, ThirdAccount>
implements ThirdAccountService {
    @Autowired
    private ThirdAccountMapper thirdAccountMapper;
    @Autowired
    private ElsSubAccountMapper elsSubAccountMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;

    @Override
    public void updateThirdUserId(ElsSubAccount subAccount, String thirdUserUuid) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)query.eq(ThirdAccount::getThirdUserUuid, (Object)thirdUserUuid)).last(" limit 1");
        ThirdAccount account = (ThirdAccount)((Object)this.thirdAccountMapper.selectOne((Wrapper)query));
        ThirdAccount sysThirdAccount = new ThirdAccount();
        sysThirdAccount.setUserId(subAccount.getId());
        LambdaQueryWrapper thirdQuery = new LambdaQueryWrapper();
        thirdQuery.eq(ThirdAccount::getUserId, (Object)subAccount.getId());
        thirdQuery.eq(ThirdAccount::getThirdType, (Object)account.getThirdType());
        ((LambdaQueryWrapper)thirdQuery.eq(BaseEntity::getElsAccount, (Object)account.getElsAccount())).last(" limit 1");
        ThirdAccount sysThirdAccounts = (ThirdAccount)((Object)this.thirdAccountMapper.selectOne((Wrapper)thirdQuery));
        if (sysThirdAccounts != null) {
            this.thirdAccountMapper.deleteById((Serializable)((Object)sysThirdAccounts.getId()));
        }
        this.thirdAccountMapper.update((Object)sysThirdAccount, (Wrapper)query);
    }

    @Override
    public ElsSubAccount createUser(String phone, String thirdUserUuid, String subAccount) {
        String elsAccount = TenantContext.getTenant();
        if (StrUtil.isBlank((CharSequence)subAccount) && StrUtil.isBlank((CharSequence)(subAccount = phone))) {
            subAccount = "srm" + RandomUtil.randomNumbers((int)4);
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(ThirdAccount::getThirdUserUuid, (Object)thirdUserUuid);
        ((LambdaQueryWrapper)query.eq(BaseEntity::getElsAccount, (Object)elsAccount)).last(" limit 1");
        ThirdAccount account = (ThirdAccount)((Object)this.thirdAccountMapper.selectOne((Wrapper)query));
        ElsSubAccount user = new ElsSubAccount();
        user.setActivitiSync("0");
        user.setDeleted(CommonConstant.DEL_FLAG_0);
        user.setStatus(1);
        user.setElsAccount(elsAccount);
        user.setSubAccount(subAccount);
        user.setPhone(phone);
        String salt = ConvertUtils.randomGen((int)8);
        user.setSalt(salt);
        String passwordEncode = PasswordUtil.encrypt((String)(elsAccount + "_" + subAccount), (String)"123", (String)salt);
        user.setPassword(passwordEncode);
        user.setRealname(account.getRealname());
        user.setAvatar(account.getAvatar());
        String id = this.saveThirdUser(user);
        ThirdAccount thirdAccount = new ThirdAccount();
        thirdAccount.setUserId(id);
        this.thirdAccountMapper.update((Object)thirdAccount, (Wrapper)query);
        return user;
    }

    @Override
    public List<ThirdAccountDTO> getThirdAccount(String busAccount, String accountId, String thirdType) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdAccount::getUserId, (Object)accountId)).eq(ThirdAccount::getThirdType, (Object)thirdType)).eq(ThirdAccount::getBusAccount, (Object)busAccount);
        List thirdAccounts = ((ThirdAccountMapper)this.baseMapper).selectList((Wrapper)wrapper);
        return Convert.toList(ThirdAccountDTO.class, (Object)thirdAccounts);
    }

    @Override
    public List<ThirdAccountDTO> getThirdAccount(List<String> busAccountList, String accountId, String thirdType) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdAccount::getUserId, (Object)accountId)).eq(ThirdAccount::getThirdType, (Object)thirdType)).in(ThirdAccount::getBusAccount, busAccountList);
        List thirdAccounts = ((ThirdAccountMapper)this.baseMapper).selectList((Wrapper)wrapper);
        return Convert.toList(ThirdAccountDTO.class, (Object)thirdAccounts);
    }

    @Override
    @Transactional
    public void saveThirdUser(ThirdAccount user) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdAccount::getUserId, (Object)user.getUserId())).eq(ThirdAccount::getThirdType, (Object)user.getThirdType())).eq(ThirdAccount::getBusAccount, (Object)user.getBusAccount());
        ((ThirdAccountMapper)this.baseMapper).delete((Wrapper)wrapper);
        ((ThirdAccountMapper)this.baseMapper).insert((Object)user);
    }

    public String saveThirdUser(ElsSubAccount subAccount) {
        String userid = IdWorker.getIdStr();
        subAccount.setId(userid);
        this.elsSubAccountMapper.insert((Object)subAccount);
        Role role = (Role)this.roleMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Role::getRoleCode, (Object)"thirdRole")).last(" limit 1"));
        UserRole userRole = new UserRole();
        userRole.setRoleId(role.getId());
        userRole.setUserId(userid);
        this.userRoleMapper.insert(userRole);
        return userid;
    }
}

