/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.util.UUIDGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.fadada.dto.FadadaOrgSealCreateDTO;
import com.els.modules.electronsign.fadada.entity.PurchaseFadadaOrgPsn;
import com.els.modules.electronsign.fadada.entity.PurchaseFadadaSeal;
import com.els.modules.electronsign.fadada.enums.FadadaSealStatusEnum;
import com.els.modules.electronsign.fadada.mapper.PurchaseFadadaOrgPsnMapper;
import com.els.modules.electronsign.fadada.mapper.PurchaseFadadaPersonalMapper;
import com.els.modules.electronsign.fadada.mapper.PurchaseFadadaSealMapper;
import com.els.modules.electronsign.fadada.service.PurchaseFadadaSealService;
import com.els.modules.electronsign.fadada.util.FadadaCallUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseFadadaSealServiceImpl
extends BaseServiceImpl<PurchaseFadadaSealMapper, PurchaseFadadaSeal>
implements PurchaseFadadaSealService {
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private FadadaCallUtil fadadaCallUtil;
    @Autowired
    private PurchaseFadadaOrgPsnMapper purchaseFadadaOrgPsnMapper;
    @Autowired
    private PurchaseFadadaPersonalMapper purchaseFadadaPersonalMapper;

    @Override
    public void add(PurchaseFadadaSeal purchaseFadadaSeal) {
        this.handDefaultData(purchaseFadadaSeal);
        ((PurchaseFadadaSealMapper)this.baseMapper).insert((Object)purchaseFadadaSeal);
    }

    public PurchaseFadadaSeal handDefaultData(PurchaseFadadaSeal purchaseFadadaSeal) {
        String elsAccount = TenantContext.getTenant();
        QueryWrapper purchaseFadadaOrgPsnQueryWrapper = new QueryWrapper();
        purchaseFadadaOrgPsnQueryWrapper.eq((Object)"open_corp_id", (Object)purchaseFadadaSeal.getOpenCorpId());
        purchaseFadadaOrgPsnQueryWrapper.like((Object)"role_type", (Object)"super_admin");
        purchaseFadadaOrgPsnQueryWrapper.eq((Object)"els_account", (Object)elsAccount);
        PurchaseFadadaOrgPsn purchaseFadadaOrgPsn = (PurchaseFadadaOrgPsn)((Object)this.purchaseFadadaOrgPsnMapper.selectOne((Wrapper)purchaseFadadaOrgPsnQueryWrapper));
        if (purchaseFadadaOrgPsn != null) {
            purchaseFadadaSeal.setUserName(purchaseFadadaOrgPsn.getMemberName());
            purchaseFadadaSeal.setClientUserId(purchaseFadadaOrgPsn.getClientUserId());
        }
        if (StringUtils.isBlank((CharSequence)purchaseFadadaSeal.getCreateSerialNo())) {
            purchaseFadadaSeal.setCreateSerialNo(UUIDGenerator.generate());
        }
        return purchaseFadadaSeal;
    }

    @Override
    public void edit(PurchaseFadadaSeal purchaseFadadaSeal) {
        this.handDefaultData(purchaseFadadaSeal);
        int count = ((PurchaseFadadaSealMapper)this.baseMapper).updateById((Object)purchaseFadadaSeal);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        PurchaseFadadaSeal purchaseFadadaSeal = (PurchaseFadadaSeal)((Object)this.getById((Serializable)((Object)id)));
        if (purchaseFadadaSeal != null) {
            if (StringUtils.isNotBlank((CharSequence)purchaseFadadaSeal.getSealId())) {
                JSONObject requestObject = new JSONObject();
                requestObject.put("openCorpId", (Object)purchaseFadadaSeal.getOpenCorpId());
                requestObject.put("sealId", (Object)purchaseFadadaSeal.getSealId());
                requestObject.put("currentAccount", (Object)purchaseFadadaSeal.getElsAccount());
                this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_seal_delete");
            }
            ((PurchaseFadadaSealMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        }
    }

    @Override
    public void deleteBatch(List<String> idList) {
        for (String id : idList) {
            this.delete(id);
        }
    }

    @Override
    public String create(PurchaseFadadaSeal purchaseFadadaSeal) {
        if (StringUtils.isNotBlank((CharSequence)purchaseFadadaSeal.getId())) {
            this.edit(purchaseFadadaSeal);
        } else {
            this.add(purchaseFadadaSeal);
        }
        FadadaOrgSealCreateDTO fadadaOrgSealCreateDTO = (FadadaOrgSealCreateDTO)SysUtil.copyProperties((Object)((Object)purchaseFadadaSeal), FadadaOrgSealCreateDTO.class);
        fadadaOrgSealCreateDTO.setRedirectUrl(this.fadadaCallUtil.getRedirectUrl());
        String requestStr = JSONObject.toJSONString((Object)fadadaOrgSealCreateDTO);
        JSONObject response = this.fadadaCallUtil.call(requestStr, "fadada_seal_create");
        purchaseFadadaSeal.setSealCreateUrl(response.getString("sealCreateUrl"));
        this.updateById((Object)purchaseFadadaSeal);
        return purchaseFadadaSeal.getSealCreateUrl();
    }

    @Override
    public void status(String id, String status) {
        PurchaseFadadaSeal purchaseFadadaSeal = (PurchaseFadadaSeal)((Object)this.getById((Serializable)((Object)id)));
        FadadaSealStatusEnum.getDescByValue(status);
        if (purchaseFadadaSeal != null) {
            JSONObject requestObject = new JSONObject();
            requestObject.put("openCorpId", (Object)purchaseFadadaSeal.getOpenCorpId());
            requestObject.put("sealId", (Object)purchaseFadadaSeal.getSealId());
            requestObject.put("sealStatus", (Object)status);
            requestObject.put("currentAccount", (Object)purchaseFadadaSeal.getElsAccount());
            this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_seal_status");
            purchaseFadadaSeal.setSealStatus(status);
            this.updateById((Object)purchaseFadadaSeal);
        }
    }

    @Override
    public PurchaseFadadaSeal freeSign(PurchaseFadadaSeal purchaseFadadaSeal) {
        PurchaseFadadaSeal seal = (PurchaseFadadaSeal)((Object)this.getById((Serializable)((Object)purchaseFadadaSeal.getId())));
        if (seal != null) {
            JSONObject requestObject = new JSONObject();
            requestObject.put("openCorpId", (Object)seal.getOpenCorpId());
            requestObject.put("clientUserId", (Object)seal.getClientUserId());
            Long[] sealIds = new Long[]{Long.parseLong(seal.getSealId())};
            requestObject.put("sealIds", (Object)sealIds);
            requestObject.put("businessId", (Object)purchaseFadadaSeal.getSceneCode());
            requestObject.put("email", (Object)purchaseFadadaSeal.getEmail());
            if (purchaseFadadaSeal.getExpiresTime() != null) {
                String today = this.simpleDateFormat.format(new Date());
                Date date = null;
                try {
                    date = this.simpleDateFormat.parse(today);
                }
                catch (Exception e) {
                    date = new Date();
                }
                if (purchaseFadadaSeal.getExpiresTime().compareTo(date) < 0) {
                    throw new ELSBootException("[\u514d\u9a8c\u8bc1\u7b7e\u6388\u6743\u7684\u6709\u6548\u671f]\u4e0d\u80fd\u5c0f\u4e8e" + today);
                }
                requestObject.put("expiresTime", (Object)purchaseFadadaSeal.getExpiresTime().getTime());
            }
            requestObject.put("currentAccount", (Object)purchaseFadadaSeal.getElsAccount());
            requestObject.put("redirectUrl", (Object)this.fadadaCallUtil.getRedirectUrl());
            JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_seal_free_sign");
            purchaseFadadaSeal.setFreeSignUrl(response.getString("freeSignUrl"));
            this.updateById((Object)purchaseFadadaSeal);
        }
        return purchaseFadadaSeal;
    }

    @Override
    public List<String> getDisableSealIds(String openCorpId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"open_corp_id", (Object)openCorpId);
        queryWrapper.eq((Object)"seal_status", (Object)"enable");
        List seals = this.list((Wrapper)queryWrapper);
        if (!seals.isEmpty()) {
            return seals.stream().map(PurchaseFadadaSeal::getSealId).collect(Collectors.toList());
        }
        return null;
    }
}

