/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.system.entity.ElsPasswordPolicy;
import com.els.modules.system.entity.ElsPasswordRecord;
import com.els.modules.system.mapper.ElsPasswordPolicyMapper;
import com.els.modules.system.mapper.ElsPasswordRecordMapper;
import com.els.modules.system.mapper.ElsPasswordSecurityMapper;
import com.els.modules.system.service.ElsPasswordPolicyService;
import com.els.modules.system.util.PwVerifyUtil;
import com.els.modules.system.vo.ElsPwComplexityAndMinLenVo;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ElsPasswordPolicyServiceImpl
extends BaseServiceImpl<ElsPasswordPolicyMapper, ElsPasswordPolicy>
implements ElsPasswordPolicyService {
    @Resource
    private ElsPasswordSecurityMapper pwSecurityMapper;
    @Resource
    private ElsPasswordRecordMapper pwRecordMapper;

    private void pwComplexityAndLenVerify(String elsAccount, String pwString) {
        String queryElsAccount = "cloud".equals(SysUtil.getDeployWay()) ? elsAccount : SysUtil.getPurchaseAccount();
        ElsPwComplexityAndMinLenVo complexityAndMinLenVo = this.pwSecurityMapper.getComplexityAndMinLen(queryElsAccount);
        if (complexityAndMinLenVo == null) {
            return;
        }
        PwVerifyUtil.pwComplexityVerify(complexityAndMinLenVo.getComplexity(), complexityAndMinLenVo.getMinLength(), pwString);
    }

    private void addPwUpdateRecord(String elsAccount, String elsSubAccount, String userName, String loginSubAccount, String password, String salt) {
        ElsPasswordRecord elsPasswordRecord = new ElsPasswordRecord();
        Date now = new Date();
        elsPasswordRecord.setElsSubAccount(elsSubAccount).setUserName(userName).setPassword(password).setSalt(salt).setElsAccount(elsAccount).setCreateBy(loginSubAccount).setUpdateBy(loginSubAccount).setCreateTime(now).setUpdateTime(now);
        this.pwRecordMapper.insert((Object)elsPasswordRecord);
    }

    private void updatePwPolicy(String elsAccount, String elsSubAccount, String userName, String loginSubAccount, Date pwCreateDate) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ElsPasswordPolicy::getElsSubAccount, (Object)elsSubAccount)).last(" limit 1");
        ElsPasswordPolicy record = (ElsPasswordPolicy)((Object)((ElsPasswordPolicyMapper)this.baseMapper).selectOne((Wrapper)lambdaQueryWrapper));
        if (record != null) {
            record.setChangeTime((record.getChangeTime() == null ? 0 : record.getChangeTime()) + 1).setUpdateBy(loginSubAccount);
            ((ElsPasswordPolicyMapper)this.baseMapper).updateById((Object)record);
            return;
        }
        record = new ElsPasswordPolicy();
        record.setElsSubAccount(elsSubAccount).setUserName(userName).setPasswordCreateDate(pwCreateDate).setChangeTime(0).setElsAccount(elsAccount).setCreateBy(loginSubAccount).setUpdateBy(loginSubAccount);
        ((ElsPasswordPolicyMapper)this.baseMapper).insert((Object)record);
    }

    @Override
    public void saveElsPasswordPolicy(ElsPasswordPolicy elsPasswordPolicy) {
        ((ElsPasswordPolicyMapper)this.baseMapper).insert((Object)elsPasswordPolicy);
    }

    @Override
    public void updateElsPasswordPolicy(ElsPasswordPolicy elsPasswordPolicy) {
        ((ElsPasswordPolicyMapper)this.baseMapper).updateById((Object)elsPasswordPolicy);
    }

    @Override
    public void delElsPasswordPolicy(String id) {
        ((ElsPasswordPolicyMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsPasswordPolicy(List<String> idList) {
        ((ElsPasswordPolicyMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void updatePasswordOper(String elsAccount, String subAccount, String realName, String loginAccount, String newpassword, Date createTime, String password, String salt) {
        this.pwComplexityAndLenVerify(elsAccount, newpassword);
        this.addPwUpdateRecord(elsAccount, subAccount, realName, loginAccount, password, salt);
        this.updatePwPolicy(elsAccount, subAccount, realName, loginAccount, createTime);
    }

    @Override
    public ElsPwComplexityAndMinLenVo getComplexityAndMinLen(String elsAccount) {
        return this.pwSecurityMapper.getComplexityAndMinLen(elsAccount);
    }
}

