/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.wechat;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.XML;
import com.alibaba.fastjson.JSON;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.wp.WechatEnterpriseApiUtil;
import com.els.common.system.wp.WechatEnterpriseProperties;
import com.els.modules.justauth.entity.JustAuthConfig;
import com.els.modules.justauth.service.JustAuthConfigService;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.mapper.ThirdAccountMapper;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.wechat.aes.AesException;
import com.els.modules.wechat.aes.WXBizMsgCrypt;
import com.els.modules.wechat.aes.WechatMessageUtil;
import com.els.modules.wechat.enums.AccountBindingEventEnum;
import com.els.modules.wechat.enums.WechatMsgTypeEnum;
import com.els.modules.wechat.vo.AccountBindingVO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/wechat"})
public class WechatController {
    private static final Logger log = LoggerFactory.getLogger(WechatController.class);
    @Resource
    private ThirdAccountService thirdAccountService;
    @Resource
    private ThirdAccountMapper thirdAccountMapper;
    @Autowired
    private JustAuthConfigService justAuthConfigService;
    @Autowired
    private WechatEnterpriseApiUtil wechatEnterpriseApiUtil;
    @Resource(name="asyncExecutor")
    private Executor executor;
    @Autowired
    private WechatEnterpriseProperties wechatEnterpriseProperties;

    @GetMapping(value={"/noToken/generationDevelopment/{busAccount}/callback"})
    public void callbackGet(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="msg_signature") String msgSignature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce, @RequestParam(value="echostr") String echostr, @PathVariable(value="busAccount") String busAccount) throws AesException {
        String cropId = request.getParameter("corpId");
        if (CharSequenceUtil.isNotBlank((CharSequence)cropId) && "$CORPID$".contains(cropId.toUpperCase())) {
            cropId = null;
        }
        log.info(":::\u4f01\u4e1a\u5fae\u4fe1\u56de\u8c03==>cropId:{},msg_signature:{},timestamp:{},nonce:{},echostr:{},busAccount:{}", new Object[]{cropId, msgSignature, timestamp, nonce, echostr, busAccount});
        JustAuthConfig wechatMp = this.justAuthConfigService.getOneConfig(CharSequenceUtil.emptyToDefault((CharSequence)busAccount, (String)"100000"), "WECHAT_ENTERPRISE_DEVELOP");
        if (null == wechatMp && null == (wechatMp = this.justAuthConfigService.getOneConfig("100000", "WECHAT_ENTERPRISE_DEVELOP", "templateConfig"))) {
            throw new ELSBootException("\u4e0d\u5b58\u5728\u5fae\u4fe1\u4f01\u4e1a\u4ee3\u5f00\u53d1\u5e94\u7528\u914d\u7f6e");
        }
        WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(wechatMp.getCustomAppToken(), wechatMp.getCustomAppKey(), CharSequenceUtil.emptyToDefault((CharSequence)cropId, (String)wechatMp.getSuiteId()));
        try {
            String sEchoStr = wxcpt.VerifyURL(msgSignature, timestamp, nonce, echostr);
            response.getOutputStream().print(sEchoStr);
            response.setStatus(200);
            response.flushBuffer();
        }
        catch (Exception e) {
            log.error(":::callbackGet \u4f01\u4e1a\u5fae\u4fe1\u56de\u8c03\u5931\u8d25:{}", (Object)e.getMessage());
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)cropId) && CharSequenceUtil.isNotBlank((CharSequence)busAccount)) {
            this.justAuthConfigService.bindAuth(cropId, wechatMp.getSuiteId(), busAccount);
        }
    }

    @PostMapping(value={"/noToken/generationDevelopment/{busAccount}/callback"})
    public void callbackPost(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="msg_signature") String msgSignature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce, @PathVariable(value="busAccount") String busAccount) throws IOException {
        String authCropId = request.getParameter("corpId");
        if (CharSequenceUtil.isNotBlank((CharSequence)authCropId) && "$CORPID$".contains(authCropId.toUpperCase())) {
            authCropId = null;
        }
        log.info(":::\u4f01\u4e1a\u5fae\u4fe1\u6570\u636e\u63a8\u9001==>(\u52a0\u5bc6)cropId:{},msg_signature:{},timestamp:{},nonce:{},busAccount:{}", new Object[]{authCropId, msgSignature, timestamp, nonce, busAccount});
        try {
            ServletInputStream inputStream = request.getInputStream();
            String sPostData = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            JustAuthConfig wechatMp = this.justAuthConfigService.getOneConfig(CharSequenceUtil.emptyToDefault((CharSequence)busAccount, (String)"100000"), "WECHAT_ENTERPRISE_DEVELOP");
            if (null == wechatMp && null == (wechatMp = this.justAuthConfigService.getOneConfig("100000", "WECHAT_ENTERPRISE_DEVELOP", "templateConfig"))) {
                throw new ELSBootException("\u4e0d\u5b58\u5728\u5fae\u4fe1\u4f01\u4e1a\u4ee3\u5f00\u53d1\u5e94\u7528\u914d\u7f6e");
            }
            WXBizMsgCrypt msgCrypt = new WXBizMsgCrypt(wechatMp.getCustomAppToken(), wechatMp.getCustomAppKey(), CharSequenceUtil.emptyToDefault((CharSequence)authCropId, (String)wechatMp.getSuiteId()));
            Map<String, String> allData = WechatMessageUtil.parseXml(sPostData);
            String sMsg = msgCrypt.DecryptMsg(msgSignature, timestamp, nonce, sPostData);
            Map<String, String> dataMap = WechatMessageUtil.parseXml(sMsg);
            String finalAuthCropId = authCropId;
            JustAuthConfig finalWechatMp = wechatMp;
            this.executor.execute(() -> this.doCallbackPost(allData, dataMap, finalAuthCropId, finalWechatMp, busAccount));
        }
        catch (Exception e) {
            log.error(":::callbackGet \u4f01\u4e1a\u5fae\u4fe1\u81ea\u5efa\u5e94\u7528\u4ee3\u5f00\u53d1\u6570\u636e\u63a8\u9001\u5931\u8d25:{}", (Object)e.getMessage());
        }
        response.getOutputStream().print("success");
        response.setStatus(200);
        response.flushBuffer();
    }

    private void doCallbackPost(Map<String, String> allData, Map<String, String> dataMap, String authCropId, JustAuthConfig wechatMp, String busAccount) {
        String infoType = dataMap.get("InfoType");
        String event = dataMap.get("Event");
        log.info(":::busAccount:{},infoType:{},event:{},\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001\u6570\u636e:{}", new Object[]{busAccount, infoType, event, JSON.toJSONString(dataMap)});
        if (CharSequenceUtil.isNotEmpty((CharSequence)event) && "change_app_admin".equals(event)) {
            return;
        }
        switch (infoType) {
            case "suite_ticket": {
                this.wechatEnterpriseApiUtil.setSuiteTicket(dataMap);
                break;
            }
            case "create_auth": {
                com.alibaba.fastjson.JSONObject jsonObject = this.wechatEnterpriseApiUtil.createAuth(wechatMp.getSuitesSecret(), dataMap);
                this.justAuthConfigService.createAuth(wechatMp, jsonObject);
                break;
            }
            case "change_auth": {
                this.wechatEnterpriseApiUtil.changeAuth(wechatMp.getSuitesSecret(), dataMap);
                break;
            }
            case "cancel_auth": {
                this.wechatEnterpriseApiUtil.cancelAuth(dataMap);
                String authCorpId = dataMap.get("AuthCorpId");
                this.justAuthConfigService.cancelAuth(authCorpId, wechatMp.getSuiteId(), busAccount, "WECHAT_ENTERPRISE_DEVELOP");
                break;
            }
            case "reset_permanent_code": {
                com.alibaba.fastjson.JSONObject jsonObject = this.wechatEnterpriseApiUtil.resetPermanentCode(wechatMp.getSuitesSecret(), dataMap);
                this.justAuthConfigService.resetAuth(wechatMp, jsonObject);
                break;
            }
            case "change_contact": {
                this.wechatEnterpriseApiUtil.changeContact(wechatMp.getSuitesSecret(), dataMap);
                break;
            }
            case "share_agent_change": {
                this.wechatEnterpriseApiUtil.shareAgentChange(authCropId, wechatMp.getSuitesSecret(), dataMap);
                break;
            }
            default: {
                log.info(":::\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u4ee3\u521b\u5efa\u63a8\u9001\u6570\u636e\u7c7b\u578b:{}", (Object)infoType);
            }
        }
    }

    @GetMapping(value={"/auth/{elsAccount}/{subAccount}"})
    public void auth(@PathVariable String elsAccount, @PathVariable String subAccount, @RequestParam(value="code") String code) {
        log.info("\u8fdb\u5165auth\u65b9\u6cd5\u3002\u3002\u3002\u3002\u3002");
        log.info("code={}", (Object)code);
        JustAuthConfig config = this.justAuthConfigService.getOneConfig(subAccount, "WECHAT_MP");
        log.info(":::JustAuthConfig{}", (Object)config);
        String appID = config.getClientId();
        String appsecret = config.getClientSecret();
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + appID + "&secret=" + appsecret + "&code=" + code + "&grant_type=authorization_code";
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity respon = restTemplate.getForEntity(url, String.class, new Object[0]);
        log.info("respon={}", (Object)respon);
        if (HttpStatus.OK == respon.getStatusCode()) {
            String body = (String)respon.getBody();
            com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)body);
            if (jsonObject.containsKey((Object)"errcode")) {
                log.error("WechatController->auth \u6709\u8bef\uff1a{},{}", (Object)jsonObject.getString("errcode"), (Object)jsonObject.getString("errmsg"));
                return;
            }
            ThirdAccount user = new ThirdAccount();
            user.setDeleted(CommonConstant.DEL_FLAG_0);
            user.setStatus(1);
            user.setThirdType("WECHAT");
            user.setThirdUserUuid(jsonObject.getString("openid"));
            user.setUserId(subAccount);
            user.setElsAccount(elsAccount);
            user.setCreateTime(new Date());
            this.thirdAccountService.save((Object)user);
        }
    }

    @RequestMapping(value={"/signature/{busAccount}"})
    public void get(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="busAccount") String busAccount) {
        log.info("\u5fae\u4fe1\u516c\u4f17\u53f7\u5173\u6ce8\u56de\u8c03:{}", (Object)busAccount);
        String wechatToken = "Droo3C5oiomm5G1z" + busAccount;
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        if (StrUtil.isNotBlank((CharSequence)echostr)) {
            this.wechatSignature(response, wechatToken, signature, timestamp, nonce, echostr);
        } else {
            this.accountBinding(request, busAccount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accountBinding(HttpServletRequest request, String busAccount) {
        ServletInputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            is = request.getInputStream();
            isr = new InputStreamReader((InputStream)is, "utf-8");
            br = new BufferedReader(isr);
            String str = null;
            StringBuffer returnXml = new StringBuffer();
            while ((str = br.readLine()) != null) {
                returnXml.append(str);
            }
            JSONObject object = XML.toJSONObject((String)returnXml.toString());
            log.info(object.toString());
            JSONObject xmlVO = object.getJSONObject((Object)"xml");
            xmlVO.getStr((Object)"FromUserName");
            AccountBindingVO vo = (AccountBindingVO)object.getBean((Object)"xml", AccountBindingVO.class);
            if (WechatMsgTypeEnum.EVENT.getCode().equals(vo.getMsgType())) {
                if (AccountBindingEventEnum.SUBSCRIBE.getCode().equals(vo.getEvent())) {
                    String[] elsAccounts = StrUtil.subAfter((CharSequence)vo.getEventKey(), (CharSequence)"qrscene_", (boolean)true).split("-");
                    this.saveAccountBinding(vo, elsAccounts, busAccount);
                } else if (AccountBindingEventEnum.SCAN.getCode().equals(vo.getEvent())) {
                    String[] elsAccounts = vo.getEventKey().split("-");
                    this.saveAccountBinding(vo, elsAccounts, busAccount);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
                if (null != isr) {
                    isr.close();
                }
                if (null != br) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wechatSignature(HttpServletResponse response, String wechatToken, String signature, String timestamp, String nonce, String echostr) {
        try (PrintWriter out = null;){
            out = response.getWriter();
            if (WechatController.checkSignature(wechatToken, signature, timestamp, nonce)) {
                out.print(echostr);
            }
        }
    }

    public static boolean checkSignature(String wechatToken, String signature, String timestamp, String nonce) {
        Object[] arr = new String[]{wechatToken, timestamp, nonce};
        Arrays.sort(arr);
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            content.append((String)arr[i]);
        }
        MessageDigest md = null;
        String tmpStr = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(content.toString().getBytes());
            tmpStr = WechatController.byteToStr(digest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        content = null;
        return tmpStr != null ? tmpStr.equals(signature.toUpperCase()) : false;
    }

    private static String byteToStr(byte[] byteArray) {
        String strDigest = "";
        for (int i = 0; i < byteArray.length; ++i) {
            strDigest = strDigest + WechatController.byteToHexStr(byteArray[i]);
        }
        return strDigest;
    }

    private static String byteToHexStr(byte mByte) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] tempArr = new char[]{Digit[mByte >>> 4 & 0xF], Digit[mByte & 0xF]};
        String s = new String(tempArr);
        return s;
    }

    private void saveAccountBinding(AccountBindingVO vo, String[] elsAccounts, String busAccount) {
        log.info("\u5fae\u4fe1\u516c\u4f17\u53f7\u5173\u6ce8\u56de\u8c03\u7ed1\u5b9a:{},{}", (Object)vo, (Object)elsAccounts);
        ThirdAccount user = new ThirdAccount();
        user.setDeleted(CommonConstant.DEL_FLAG_0);
        user.setStatus(1);
        user.setThirdType("WECHAT_MP");
        user.setThirdUserUuid(vo.getFromUserName());
        user.setElsAccount(elsAccounts[0]);
        user.setBusAccount(busAccount);
        user.setUserId(elsAccounts[1]);
        user.setCreateTime(new Date());
        this.thirdAccountService.saveThirdUser(user);
        log.info("\u5fae\u4fe1\u516c\u4f17\u53f7\u5173\u6ce8\u65b0\u589e\u7b2c\u4e09\u65b9\u8d26\u53f7:{}", (Object)user);
    }
}

