/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.ElsEmailConfigDTO;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.CommonConstant;
import com.els.common.email.ElsEmailBuilder;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.common.validator.ValidationUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.SubaccountOrg;
import com.els.modules.system.entity.UserPermissionGroup;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.excel.AccountExportServiceImpl;
import com.els.modules.system.excel.AccountOtherListExportServiceImpl;
import com.els.modules.system.rpc.service.SystemInvokeOrganizationInfoRpcService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.SubaccountOrgService;
import com.els.modules.system.service.UserPermissionGroupService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.vo.ElsSubAccountVO;
import com.els.modules.system.vo.UserRoleVO;
import com.els.rpc.service.ImGroupInvokeRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u7528\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/account/elsSubAccount"})
public class ElsSubAccountController
extends BaseController<ElsSubAccount, ElsSubAccountService> {
    private static final Logger log = LoggerFactory.getLogger(ElsSubAccountController.class);
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private UserPermissionGroupService userPermissionGroupService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PersonalSettingService personalSettingService;
    @Resource
    private SystemInvokeOrganizationInfoRpcService systemInvokeOrganizationInfoRpcService;
    @Autowired(required=false)
    private ImGroupInvokeRpcService baseImGroupService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SubaccountOrgService subaccountOrgService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:list"})
    public Result<IPage<ElsSubAccountVO>> queryPageList(ElsSubAccount user, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)user), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        ArrayList<Object> elsAccountList = new ArrayList<Object>();
        if (req.getParameterMap().containsKey("els_account")) {
            elsAccountList.addAll(Arrays.asList((Object[])req.getParameterMap().get("els_account")));
        } else {
            elsAccountList.add(TenantContext.getTenant());
        }
        queryWrapper.in((Object)"els_account", elsAccountList);
        IPage pageList = this.elsSubAccountService.page((IPage)page, (Wrapper)queryWrapper);
        List<String> codes = pageList.getRecords().stream().filter(x -> StrUtil.isNotEmpty((CharSequence)x.getOrgCode())).flatMap(x -> Arrays.stream(x.getOrgCode().split(","))).distinct().collect(Collectors.toList());
        Map<String, String> orgMap = this.systemInvokeOrganizationInfoRpcService.listDeptOrganization(codes);
        Map<String, String> roleMap = this.userRoleService.loadUserRole(pageList.getRecords().stream().map(BaseEntity::getId).collect(Collectors.toList()));
        String jsonString = JSON.toJSONString((Object)pageList);
        IPage page2 = (IPage)JSON.parseObject((String)jsonString, (TypeReference)new TypeReference<Page<ElsSubAccountVO>>(){}, (Feature[])new Feature[0]);
        for (ElsSubAccountVO elsSubAccount : page2.getRecords()) {
            String orgCode = elsSubAccount.getOrgCode();
            if (StrUtil.isNotEmpty((CharSequence)orgCode)) {
                ArrayList ids = Lists.newArrayList((Object[])orgCode.split(","));
                String org = ids.stream().filter(orgMap::containsKey).map(orgMap::get).collect(Collectors.joining(","));
                elsSubAccount.setOrgCode_dictText(org);
            }
            elsSubAccount.setSelectedroles_dictText(roleMap.get(elsSubAccount.getId()));
        }
        result.setSuccess(true);
        result.setResult((Object)page2);
        return result;
    }

    @RequestMapping(value={"/page"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:list"})
    public Result<IPage<ElsSubAccount>> queryPageList2(ElsSubAccount user, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)user), (Map)req.getParameterMap());
        queryWrapper.lambda().select(new SFunction[]{BaseEntity::getId, ElsSubAccount::getRealname, ElsSubAccount::getSubAccount});
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        ArrayList<Object> elsAccountList = new ArrayList<Object>();
        if (req.getParameterMap().containsKey("els_account")) {
            elsAccountList.addAll(Arrays.asList((Object[])req.getParameterMap().get("els_account")));
        } else {
            elsAccountList.add(TenantContext.getTenant());
        }
        queryWrapper.in((Object)"els_account", elsAccountList);
        IPage pageList = this.elsSubAccountService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @RequestMapping(value={"/list2"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:list"})
    public Result<?> queryPageList2(ElsSubAccount user, HttpServletRequest req) {
        String deptIds = req.getParameter("deptIds");
        String adminUserIds = req.getParameter("adminUserIds");
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)user), (Map)req.getParameterMap());
        queryWrapper.lambda().select(new SFunction[]{BaseEntity::getId, ElsSubAccount::getRealname, ElsSubAccount::getSubAccount});
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        if (CharSequenceUtil.isNotEmpty((CharSequence)deptIds)) {
            List split = Arrays.stream(deptIds.split(",")).collect(Collectors.toList());
            queryWrapper.lambda().in(ElsSubAccount::getOrgCode, split);
        }
        List pageList = this.elsSubAccountService.list((Wrapper)queryWrapper);
        if (CharSequenceUtil.isNotEmpty((CharSequence)adminUserIds)) {
            List userIds = Arrays.stream(adminUserIds.split(",")).collect(Collectors.toList());
            List userDeptIds = pageList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            userIds.removeAll(userDeptIds);
            if (CollUtil.isNotEmpty(userIds)) {
                queryWrapper.clear();
                queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
                queryWrapper.lambda().in(BaseEntity::getId, userIds);
            }
            List list = this.elsSubAccountService.list((Wrapper)queryWrapper);
            pageList = pageList.stream().filter(x -> userIds.contains(x.getId())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty((Collection)list)) {
                pageList.addAll(0, list);
            }
        }
        return Result.ok((Object)pageList);
    }

    @RequestMapping(value={"/otherList"}, method={RequestMethod.GET})
    @ApiOperation(value="\u4f9b\u5e94\u5546\u8d26\u53f7\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u4f9b\u5e94\u5546\u8d26\u53f7\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @RequiresPermissions(value={"supplierAccount#ElsSubAccount:list"})
    public Result<IPage<ElsSubAccountVO>> queryOtherPageList(ElsSubAccountVO user, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        if (!TenantContext.getTenant().equals(SysUtil.getPurchaseAccount())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APeyBjbWCQryV_d23d634", (String)"\u5f53\u524d\u8d26\u53f7\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u63a5\u53e3"));
        }
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)user), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.notIn((Object)"els_account", new Object[]{TenantContext.getTenant(), "100000"});
        IPage<ElsSubAccountVO> pageList = this.elsSubAccountService.selectSubAccountAndEnterprisePage((Page<ElsSubAccountVO>)page, (QueryWrapper<ElsSubAccountVO>)queryWrapper);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @RequestMapping(value={"/updateOtherPhone"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4f9b\u5e94\u5546\u8d26\u53f7\u5217\u8868\u624b\u673a\u53f7\u7ef4\u62a4", notes="\u4f9b\u5e94\u5546\u8d26\u53f7\u5217\u8868\u624b\u673a\u53f7\u7ef4\u62a4")
    @RequiresPermissions(value={"supplierAccount#ElsSubAccount:list"})
    public Result<?> updateOtherPhone(@RequestBody ElsSubAccount subAccount) {
        ElsSubAccount update = new ElsSubAccount();
        update.setPhone(subAccount.getPhone());
        update.setId(subAccount.getId());
        this.elsSubAccountService.updateById((Object)update);
        return Result.ok((Object)((Object)subAccount));
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u6dfb\u52a0", operateType=2)
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:add"})
    public Result<?> add(@RequestBody JSONObject jsonObject) {
        Result result = new Result();
        String selectedRoles = jsonObject.getString("selectedroles");
        ElsSubAccount user = (ElsSubAccount)((Object)JSON.parseObject((String)jsonObject.toJSONString(), ElsSubAccount.class));
        this.elsSubAccountService.checkTanentParam(this.getTenantId(), 1);
        ValidationUtil.validateForObject((Object)((Object)user));
        ElsSubAccount sysUser = this.elsSubAccountService.getUserBySubAccount(user.getSubAccount());
        if (sysUser != null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JeyIOMKW_d8bcd3b3", (String)"\u5b50\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff01"));
        }
        if (StrUtil.isNotBlank((CharSequence)user.getOrgCode())) {
            boolean includCompany = this.systemInvokeOrganizationInfoRpcService.checkOrgCode(user.getOrgCode());
            Assert.isTrue((!includCompany ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_xGxOiFRC_4b44d29c", (String)"\u90e8\u95e8\u4e0d\u80fd\u9009\u62e9\u516c\u53f8"));
        }
        user.setCreateTime(new Date());
        String salt = ConvertUtils.randomGen((int)8);
        user.setSalt(salt);
        String passwordEncode = PasswordUtil.encrypt((String)(TenantContext.getTenant() + "_" + user.getSubAccount()), (String)user.getPassword(), (String)salt);
        user.setPassword(passwordEncode);
        user.setStatus(1);
        user.setDeleted(CommonConstant.DEL_FLAG_0);
        this.elsSubAccountService.addUserWithRole(user, selectedRoles);
        this.saveUserPermissionGroup(user.getId(), jsonObject.getString("selectedGroups"));
        List<SubaccountOrg> subaccountOrgList = user.getSubaccountOrgList();
        if (subaccountOrgList != null && subaccountOrgList.size() > 0) {
            subaccountOrgList.forEach(org -> {
                org.setId(null);
                org.setUserId(user.getId());
                org.setUserName(user.getRealname());
            });
            this.subaccountOrgService.saveBatch(subaccountOrgList, 2000);
        }
        this.redisUtil.del(new String[]{"sys:org:user:" + user.getId()});
        try {
            this.baseImGroupService.initGroup(user.getId());
        }
        catch (Exception e) {
            log.error("::: \u521d\u59cb\u5316\u7528\u6237\u5206\u7ec4{}\u5931\u8d25==>{}", (Object)user.getId(), (Object)e.getMessage());
        }
        this.insertPersonalSetting(user);
        result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        return Result.ok((Object)((Object)user));
    }

    @AutoLog(value="\u6dfb\u52a0\u5176\u4ed6\u8d26\u53f7-\u6dfb\u52a0", operateType=2)
    @RequestMapping(value={"/addOther"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"supplierAccount#ElsSubAccount:add"})
    public Result<?> addOther(@RequestBody JSONObject jsonObject) {
        Result result = new Result();
        String selectedRoles = jsonObject.getString("selectedroles");
        String elsAccount = jsonObject.getString("elsAccount");
        this.elsSubAccountService.checkTanentParam(elsAccount, 1);
        ElsSubAccount user = (ElsSubAccount)((Object)JSON.parseObject((String)jsonObject.toJSONString(), ElsSubAccount.class));
        ValidationUtil.validateForObject((Object)((Object)user));
        ElsSubAccount sysUser = this.elsSubAccountService.getUserByAccount(elsAccount + "_" + user.getSubAccount());
        if (sysUser != null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JeyIOMKW_d8bcd3b3", (String)"\u5b50\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff01"));
        }
        user.setCreateTime(new Date());
        String salt = ConvertUtils.randomGen((int)8);
        user.setSalt(salt);
        String passwordEncode = PasswordUtil.encrypt((String)(elsAccount + "_" + user.getSubAccount()), (String)user.getPassword(), (String)salt);
        user.setPassword(passwordEncode);
        user.setStatus(1);
        user.setDeleted(CommonConstant.DEL_FLAG_0);
        this.elsSubAccountService.addUserWithRole(user, selectedRoles);
        try {
            this.baseImGroupService.initGroup(user.getId());
        }
        catch (Exception e) {
            log.error("::: \u521d\u59cb\u5316\u7528\u6237\u5206\u7ec4{}\u5931\u8d25==>{}", (Object)user.getId(), (Object)e.getMessage());
        }
        this.insertPersonalSetting(user);
        result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        return Result.ok((Object)((Object)user));
    }

    private void insertPersonalSetting(ElsSubAccount user) {
        List<String> list = Arrays.asList("EMAIL", "NEWS", "VOICE", "MSG", "WECHAT", "DINGTALK");
        ArrayList<PersonalSetting> personalSettings = new ArrayList<PersonalSetting>();
        for (String str : list) {
            PersonalSetting personalSetting = new PersonalSetting();
            personalSetting.setId(UUID.randomUUID().toString().replace("-", ""));
            personalSetting.setElsAccount(user.getElsAccount());
            personalSetting.setSubAccount(user.getSubAccount());
            personalSetting.setCreateBy(user.getCreateBy());
            personalSetting.setCreateTime(new Date());
            personalSetting.setUpdateBy(user.getUpdateBy());
            personalSetting.setUpdateTime(new Date());
            personalSetting.setReceiveType(str);
            personalSetting.setIsReceive(0);
            personalSettings.add(personalSetting);
        }
        this.personalSettingService.saveBatch(personalSettings);
    }

    private void saveUserPermissionGroup(String userId, String groups) {
        String[] groupArray;
        this.redisUtil.del(new String[]{"sys:permissionData:group:" + userId});
        this.userPermissionGroupService.remove((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId));
        if (StrUtil.isBlank((CharSequence)groups)) {
            return;
        }
        ArrayList<UserPermissionGroup> list = new ArrayList<UserPermissionGroup>();
        for (String groupId : groupArray = groups.split(",")) {
            UserPermissionGroup group = new UserPermissionGroup();
            group.setUserId(userId);
            group.setGroupId(groupId);
            list.add(group);
        }
        this.userPermissionGroupService.saveBatch(list);
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u7f16\u8f91", operateType=3)
    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:edit"})
    public Result<ElsSubAccount> edit(@RequestBody JSONObject jsonObject) {
        Result result = new Result();
        ElsSubAccount sysUser = (ElsSubAccount)((Object)this.elsSubAccountService.getById((Serializable)((Object)jsonObject.getString("id"))));
        if (sysUser == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            ElsSubAccount user = (ElsSubAccount)((Object)JSON.parseObject((String)jsonObject.toJSONString(), ElsSubAccount.class));
            ValidationUtil.validateForObject((Object)((Object)user));
            if (StrUtil.isNotBlank((CharSequence)user.getOrgCode())) {
                boolean includCompany = this.systemInvokeOrganizationInfoRpcService.checkOrgCode(user.getOrgCode());
                Assert.isTrue((!includCompany ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_xGxOiFRC_4b44d29c", (String)"\u90e8\u95e8\u4e0d\u80fd\u9009\u62e9\u516c\u53f8"));
            }
            user.setUpdateTime(new Date());
            user.setPassword(sysUser.getPassword());
            String roles = jsonObject.getString("selectedroles");
            if (StrUtil.isBlank((CharSequence)roles)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KyxOLV_81e5c6f0", (String)"\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            this.elsSubAccountService.editUserWithRole(user, roles);
            this.saveUserPermissionGroup(user.getId(), jsonObject.getString("selectedGroups"));
            this.subaccountOrgService.deleteByMainId(sysUser.getId());
            List<SubaccountOrg> subaccountOrgList = user.getSubaccountOrgList();
            if (subaccountOrgList != null && subaccountOrgList.size() > 0) {
                subaccountOrgList.forEach(org -> {
                    org.setId(null);
                    org.setUserId(user.getId());
                    org.setUserName(user.getRealname());
                });
                this.subaccountOrgService.saveBatch(subaccountOrgList, 2000);
            }
            this.redisUtil.del(new String[]{"sys:org:user:" + user.getId()});
            result.success("\u4fee\u6539\u6210\u529f!");
        }
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u4e2a\u4eba\u8bbe\u7f6e\u7f16\u8f91", operateType=3)
    @RequestMapping(value={"/editByPersonalSettings"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:edit"})
    public Result<ElsSubAccount> editByPersonalSettings(@RequestBody JSONObject jsonObject) {
        Result result = new Result();
        ElsSubAccount user = (ElsSubAccount)((Object)JSON.parseObject((String)jsonObject.toJSONString(), ElsSubAccount.class));
        ValidationUtil.validateForObject((Object)((Object)user));
        user.setSubAccount(null);
        user.setElsAccount(null);
        user.setRealname(null);
        user.setId(SysUtil.getLoginUser().getId());
        this.elsSubAccountService.updateById((Object)user);
        result.success("\u4fee\u6539\u6210\u529f!");
        return result;
    }

    @RequestMapping(value={"/querySubAccount"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"supplierAccount#ElsSubAccount:list"})
    public Result<?> querySubAccount(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="subAccount") String subAccount) {
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getByAccount(elsAccount, subAccount);
        return Result.ok((Object)((Object)elsSubAccount));
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u5220\u9664", operateType=4)
    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:list"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.elsSubAccountService.deleteUser(id);
        return Result.ok((String)I18nUtil.translate((String)"", (String)"\u5220\u9664\u7528\u6237\u6210\u529f"));
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u6279\u91cf\u5220\u9664", operateType=4)
    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:list"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.elsSubAccountService.deleteBatchUsers(ids);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_zRQGjDLR_1c589118", (String)"\u6279\u91cf\u5220\u9664\u7528\u6237\u6210\u529f"));
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u51bb\u7ed3&\u89e3\u51bb\u7528\u6237", operateType=3)
    @RequestMapping(value={"/frozenBatch"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:frozenBatch"})
    public Result<?> frozenBatch(@RequestBody JSONObject jsonObject) {
        Object[] arr;
        String ids = jsonObject.getString("ids");
        String status = jsonObject.getString("status");
        for (String string : arr = ids.split(",")) {
            if (!ConvertUtils.isNotEmpty((Object)string)) continue;
            ElsSubAccount account = (ElsSubAccount)((Object)this.elsSubAccountService.getById((Serializable)((Object)string)));
            if ("1".equals(status)) {
                this.elsSubAccountService.checkTanentParam(account.getElsAccount(), 1);
            }
            TenantContext.setTenant((String)account.getElsAccount());
            Role role = (Role)this.roleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"role_code", (Object)"companyAdmin")).eq((Object)"els_account", (Object)account.getElsAccount()));
            List userRoleList = this.userRoleService.list((Wrapper)new QueryWrapper().eq((Object)"role_id", (Object)role.getId()));
            List userIdList = userRoleList.stream().map(UserRole::getUserId).collect(Collectors.toList());
            List accountList = this.elsSubAccountService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)"1")).in((Object)"id", userIdList));
            if (accountList.size() == 1 && string.equals(((ElsSubAccount)((Object)accountList.get(0))).getId())) {
                throw new ELSBootException("\u8be5\u8d26\u53f7\u4e3a\u8be5\u79df\u6237\u552f\u4e00\u4f01\u4e1a\u7ba1\u7406\u5458\u4e0d\u80fd\u51bb\u7ed3\uff01");
            }
            this.elsSubAccountService.update((Object)new ElsSubAccount().setStatus(Integer.parseInt(status)), (Wrapper)new UpdateWrapper().lambda().eq(BaseEntity::getId, (Object)string));
        }
        if (arr.length > 0) {
            List accountList = this.elsSubAccountService.listByIds(Lists.newArrayList((Object[])arr));
            String[] accounts = (String[])accountList.stream().map(x -> String.format("%s::%s", "sys:cache:user", x.getElsAccount() + "_" + x.getSubAccount())).distinct().toArray(String[]::new);
            if (accounts.length > 0) {
                this.redisUtil.del(accounts);
            }
            ArrayList elsSubAccountDTOS = SysUtil.copyProperties((List)accountList, ElsSubAccountDTO.class);
            MqUtil.sendOperateEventMsg((String)TenantContext.getTenant(), (String)"ElsSubAccount", (String)"delete", (String)"deleteUserDataToMall", (Object)elsSubAccountDTOS);
        }
        return Result.ok();
    }

    @RequestMapping(value={"/queryById"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#elsSubAccount:get", "account#personalSetting:set"}, logical=Logical.OR)
    public Result<Object> queryById(@RequestParam(name="id") String id) {
        Result<Object> result = this.getUserInfo(id);
        return result;
    }

    @RequestMapping(value={"/queryCurrentUser"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#elsSubAccount:get", "account#personalSetting:set"}, logical=Logical.OR)
    public Result<Object> queryCurrentUser() {
        Result<Object> result = this.getUserInfo(SysUtil.getLoginUser().getId());
        return result;
    }

    private Result<Object> getUserInfo(String id) {
        Result result = new Result();
        ElsSubAccount sysUser = (ElsSubAccount)((Object)this.elsSubAccountService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (sysUser == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            List userRole = this.userRoleService.list((Wrapper)new QueryWrapper().lambda().eq(UserRole::getUserId, (Object)sysUser.getId()));
            sysUser.setSelectedroles(userRole.stream().map(UserRole::getRoleId).collect(Collectors.joining(",")));
            List permissionGroupList = this.userPermissionGroupService.list((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)sysUser.getId()));
            sysUser.setSelectedGroups(permissionGroupList.stream().map(UserPermissionGroup::getGroupId).collect(Collectors.joining(",")));
            List<SubaccountOrg> subaccountOrgList = this.subaccountOrgService.selectByMainId(sysUser.getId());
            sysUser.setSubaccountOrgList(subaccountOrgList);
            result.setResult((Object)sysUser);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/queryUserRole"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:list", "role#Role:list"}, logical=Logical.OR)
    public Result<List<String>> queryUserRole(@RequestParam(name="userid") String userid) {
        Result result = new Result();
        ArrayList<String> list = new ArrayList<String>();
        List userRole = this.userRoleService.list((Wrapper)new QueryWrapper().lambda().eq(UserRole::getUserId, (Object)userid));
        if (userRole == null || userRole.size() <= 0) {
            result.error500("\u672a\u627e\u5230\u7528\u6237\u76f8\u5173\u89d2\u8272\u4fe1\u606f");
        } else {
            for (UserRole sysUserRole : userRole) {
                list.add(sysUserRole.getRoleId());
            }
            result.setSuccess(true);
            result.setResult(list);
        }
        return result;
    }

    @RequestMapping(value={"/deliverTo"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:deliverTo"})
    public Result<?> deliverTo(@RequestParam(name="sourceAccountId") String sourceAccountId, @RequestParam(name="targetAccountId") String targetAccountId, @RequestParam(name="businessDeliverToType") String businessDeliverToType) {
        this.elsSubAccountService.deliverTo(sourceAccountId, targetAccountId, businessDeliverToType);
        return Result.ok((String)I18nUtil.translate((String)"i18n_title_operationSuccess", (String)"\u64cd\u4f5c\u6210\u529f\uff01"));
    }

    @RequestMapping(value={"/checkOnlyUser"}, method={RequestMethod.GET})
    public Result<Boolean> checkOnlyUser(ElsSubAccount sysUser) {
        Result result = new Result();
        result.setResult((Object)true);
        try {
            ElsSubAccount user = (ElsSubAccount)((Object)this.elsSubAccountService.getOne((Wrapper)new QueryWrapper((Object)sysUser)));
            if (user != null) {
                result.setSuccess(false);
                result.setMessage("\u7528\u6237\u8d26\u53f7\u5df2\u5b58\u5728");
                return result;
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setMessage(e.getMessage());
            return result;
        }
        result.setSuccess(true);
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u66f4\u6539\u7528\u6237\u5bc6\u7801", operateType=3)
    @RequestMapping(value={"/changPassword"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:changPassword"})
    public Result<?> changPassword(@RequestBody ElsSubAccount sysUser) {
        if (!this.getTenantId().equals(sysUser.getElsAccount())) {
            throw new ELSBootException("\u64cd\u4f5c\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u8f93\u5165\u53c2\u6570");
        }
        ElsSubAccount u = (ElsSubAccount)((Object)this.elsSubAccountService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ElsSubAccount::getElsAccount, (Object)this.getTenantId())).eq(ElsSubAccount::getSubAccount, (Object)sysUser.getSubAccount())));
        if (u == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_jDxMKW_782540b3", (String)"\u7528\u6237\u4e0d\u5b58\u5728"));
        }
        sysUser.setId(u.getId());
        return this.elsSubAccountService.changePassword(sysUser);
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u751f\u6210\u7528\u6237ID", operateType=1)
    @RequestMapping(value={"/generateUserId"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#elsSubAccount:get"})
    public Result<String> generateUserId() {
        Result result = new Result();
        System.out.println("\u6211\u6267\u884c\u4e86,\u751f\u6210\u7528\u6237ID==============================");
        String userId = UUID.randomUUID().toString().replace("-", "");
        result.setSuccess(true);
        result.setResult((Object)userId);
        return result;
    }

    @RequestMapping(value={"/queryUserRoleMap"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#elsSubAccount:get"})
    public Result<Map<String, String>> queryUserRole() {
        Result result = new Result();
        Map<String, String> map = this.userRoleService.queryUserRole();
        result.setResult(map);
        result.setSuccess(true);
        return result;
    }

    @RequestMapping(value={"/queryByIds"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#elsSubAccount:get"})
    public Result<Collection<ElsSubAccount>> queryByIds(@RequestParam String userIds) {
        Result result = new Result();
        String[] userId = userIds.split(",");
        List<String> idList = Arrays.asList(userId);
        List userRole = this.elsSubAccountService.listByIds(idList);
        result.setSuccess(true);
        result.setResult((Object)userRole);
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u66f4\u65b0\u5bc6\u7801", operateType=3)
    @RequestMapping(value={"/updatePassword"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"elsSubAccount#elsSubAccount:get"})
    public Result<?> updatePassword(@RequestBody JSONObject json) {
        String elsAccount = this.getTenantId();
        String subAccount = json.getString("subAccount");
        String oldpassword = json.getString("oldpassword");
        String password = json.getString("password");
        String confirmpassword = json.getString("confirmpassword");
        ElsSubAccount user = (ElsSubAccount)((Object)this.elsSubAccountService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ElsSubAccount::getSubAccount, (Object)subAccount)).eq(ElsSubAccount::getElsAccount, (Object)elsAccount)));
        if (user == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_jDxMKW_782540b3", (String)"\u7528\u6237\u4e0d\u5b58\u5728"));
        }
        return this.elsSubAccountService.resetPassword(subAccount, oldpassword, password, confirmpassword);
    }

    @RequestMapping(value={"/userRoleList"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:list", "role#Role:list"}, logical=Logical.OR)
    public Result<IPage<ElsSubAccount>> userRoleList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String roleId = req.getParameter("roleId");
        String subAccount = req.getParameter("subAccount");
        IPage<ElsSubAccount> pageList = this.elsSubAccountService.getUserByRoleId((Page<ElsSubAccount>)page, roleId, subAccount);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @RequestMapping(value={"/userNotRoleList"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:list", "role#Role:list"}, logical=Logical.OR)
    public Result<IPage<ElsSubAccount>> userNotRoleList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String roleId = req.getParameter("roleId");
        String subAccount = req.getParameter("subAccount");
        IPage<ElsSubAccount> pageList = this.elsSubAccountService.getUserNotInRoleId((Page<ElsSubAccount>)page, roleId, subAccount);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u7ed9\u6307\u5b9a\u89d2\u8272\u6dfb\u52a0\u7528\u6237", operateType=2)
    @RequestMapping(value={"/addSysUserRole"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:list", "role#Role:list"}, logical=Logical.OR)
    public Result<String> addSysUserRole(@RequestBody UserRoleVO sysUserRoleVO) {
        Result result = new Result();
        try {
            String sysRoleId = sysUserRoleVO.getRoleId();
            for (String sysUserId : sysUserRoleVO.getUserIdList()) {
                UserRole sysUserRole = new UserRole(sysUserId, sysRoleId);
                QueryWrapper queryWrapper = new QueryWrapper();
                ((QueryWrapper)queryWrapper.eq((Object)"role_id", (Object)sysRoleId)).eq((Object)"user_id", (Object)sysUserId);
                UserRole one = (UserRole)this.userRoleService.getOne((Wrapper)queryWrapper);
                if (one != null) continue;
                this.userRoleService.save(sysUserRole);
            }
            result.setMessage("\u6dfb\u52a0\u6210\u529f!");
            result.setSuccess(true);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setSuccess(false);
            result.setMessage("\u51fa\u9519\u4e86: " + e.getMessage());
            return result;
        }
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u5220\u9664\u6307\u5b9a\u89d2\u8272\u7684\u7528\u6237\u5173\u7cfb", operateType=4)
    @RequestMapping(value={"/deleteUserRole"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:list", "role#Role:list"}, logical=Logical.OR)
    public Result<UserRole> deleteUserRole(@RequestParam(name="roleId") String roleId, @RequestParam(name="userId") String userId) {
        Result result = new Result();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"role_id", (Object)roleId)).eq((Object)"user_id", (Object)userId);
            this.userRoleService.remove((Wrapper)queryWrapper);
            result.success("\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u5220\u9664\u5931\u8d25\uff01");
        }
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u6279\u91cf\u5220\u9664\u6307\u5b9a\u89d2\u8272\u7684\u7528\u6237\u5173\u7cfb", operateType=4)
    @RequestMapping(value={"/deleteUserRoleBatch"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:list", "role#Role:list"}, logical=Logical.OR)
    public Result<UserRole> deleteUserRoleBatch(@RequestParam(name="roleId") String roleId, @RequestParam(name="userIds") String userIds) {
        Result result = new Result();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"role_id", (Object)roleId)).in((Object)"user_id", Arrays.asList(userIds.split(",")));
            this.userRoleService.remove((Wrapper)queryWrapper);
            result.success("\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u5220\u9664\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/departUserList"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#elsSubAccount:get"})
    public Result<IPage<ElsSubAccount>> departUserList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String depId = req.getParameter("depId");
        String username = req.getParameter("username");
        IPage<ElsSubAccount> pageList = this.elsSubAccountService.getUserByDepId((Page<ElsSubAccount>)page, depId, username);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u6ce8\u518c", operateType=2)
    @PostMapping(value={"/register"})
    public Result<JSONObject> userRegister(@RequestBody JSONObject jsonObject, ElsSubAccount user) {
        Result result = new Result();
        String phone = jsonObject.getString("phone");
        String smscode = jsonObject.getString("smscode");
        Object code = this.redisUtil.get(phone);
        String username = jsonObject.getString("username");
        String password = jsonObject.getString("password");
        String email = jsonObject.getString("email");
        ElsSubAccount sysUser1 = this.elsSubAccountService.getUserBySubAccount(username);
        if (sysUser1 != null) {
            result.setMessage("\u7528\u6237\u540d\u5df2\u6ce8\u518c");
            result.setSuccess(false);
            return result;
        }
        ElsSubAccount sysUser2 = this.elsSubAccountService.getUserByPhone(phone);
        if (sysUser2 != null) {
            result.setMessage("\u8be5\u624b\u673a\u53f7\u5df2\u6ce8\u518c");
            result.setSuccess(false);
            return result;
        }
        ElsSubAccount sysUser3 = this.elsSubAccountService.getUserByEmail(email);
        if (sysUser3 != null) {
            result.setMessage("\u90ae\u7bb1\u5df2\u88ab\u6ce8\u518c");
            result.setSuccess(false);
            return result;
        }
        if (!smscode.equals(code)) {
            result.setMessage("\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef");
            result.setSuccess(false);
            return result;
        }
        try {
            user.setCreateTime(new Date());
            String salt = ConvertUtils.randomGen((int)8);
            String passwordEncode = PasswordUtil.encrypt((String)username, (String)password, (String)salt);
            user.setSalt(salt);
            user.setSubAccount(username);
            user.setRealname(username);
            user.setPassword(passwordEncode);
            user.setEmail(email);
            user.setPhone(phone);
            user.setStatus(1);
            user.setDeleted(CommonConstant.DEL_FLAG_0);
            user.setActivitiSync("1");
            this.elsSubAccountService.addUserWithRole(user, "ee8626f80f7c2619917b6236f3a7f02b");
            result.success("\u6ce8\u518c\u6210\u529f");
        }
        catch (Exception e) {
            result.error500("\u6ce8\u518c\u5931\u8d25");
        }
        return result;
    }

    @GetMapping(value={"/querySysUser"})
    public Result<Map<String, Object>> querySysUser(ElsSubAccount sysUser) {
        ElsSubAccount user;
        String phone = sysUser.getPhone();
        String username = sysUser.getSubAccount();
        Result result = new Result();
        HashMap<String, String> map = new HashMap<String, String>();
        if (ConvertUtils.isNotEmpty((Object)phone) && (user = this.elsSubAccountService.getUserByPhone(phone)) != null) {
            map.put("username", user.getSubAccount());
            map.put("phone", user.getPhone());
            result.setSuccess(true);
            result.setResult(map);
            return result;
        }
        if (ConvertUtils.isNotEmpty((Object)username) && (user = this.elsSubAccountService.getUserBySubAccount(username)) != null) {
            map.put("username", user.getSubAccount());
            map.put("phone", user.getPhone());
            result.setSuccess(true);
            result.setResult(map);
            return result;
        }
        result.setSuccess(false);
        result.setMessage("\u9a8c\u8bc1\u5931\u8d25");
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u7528\u6237\u624b\u673a\u53f7\u9a8c\u8bc1", operateType=1)
    @PostMapping(value={"/phoneVerification"})
    public Result<String> phoneVerification(@RequestBody JSONObject jsonObject) {
        Object code;
        Result result = new Result();
        String phone = jsonObject.getString("phone");
        String smscode = jsonObject.getString("smscode");
        if (!smscode.equals(code = this.redisUtil.get(phone))) {
            result.setMessage("\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef");
            result.setSuccess(false);
            return result;
        }
        this.redisUtil.set(phone, (Object)smscode);
        result.setResult((Object)smscode);
        result.setSuccess(true);
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u7528\u6237\u66f4\u6539\u5bc6\u7801", operateType=3)
    @GetMapping(value={"/passwordChange"})
    public Result<ElsSubAccount> passwordChange(@RequestParam(name="username") String username, @RequestParam(name="password") String password, @RequestParam(name="smscode") String smscode, @RequestParam(name="phone") String phone) {
        ElsSubAccount sysUser;
        Result result = new Result();
        Object object = this.redisUtil.get(phone);
        if (null == object) {
            result.setMessage("\u66f4\u6539\u5bc6\u7801\u5931\u8d25");
            result.setSuccess(false);
        }
        if (!smscode.equals(object)) {
            result.setMessage("\u66f4\u6539\u5bc6\u7801\u5931\u8d25");
            result.setSuccess(false);
        }
        if ((sysUser = (ElsSubAccount)((Object)this.elsSubAccountService.getOne((Wrapper)new LambdaQueryWrapper().eq(ElsSubAccount::getSubAccount, (Object)username)))) == null) {
            result.setMessage("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
            result.setSuccess(false);
            return result;
        }
        String salt = ConvertUtils.randomGen((int)8);
        sysUser.setSalt(salt);
        String passwordEncode = PasswordUtil.encrypt((String)sysUser.getSubAccount(), (String)password, (String)salt);
        sysUser.setPassword(passwordEncode);
        this.elsSubAccountService.updateById((Object)sysUser);
        result.setSuccess(true);
        result.setMessage("\u5bc6\u7801\u4fee\u6539\u5b8c\u6210\uff01");
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u7ed1\u5b9a\u624b\u673a\u53f7/\u90ae\u7bb1", operateType=3)
    @PostMapping(value={"/bindSubAccount"})
    @RequiresPermissions(value={"account#personalSetting:set"})
    public Result<?> bindSubAccount(@RequestBody JSONObject jsonObject) {
        log.info("ElsSubAccountController->bindSubAccount: jsonObject: " + jsonObject.toString());
        Result result = new Result();
        String bindType = jsonObject.getString("bindType");
        String elsAccount = this.getTenantId();
        String subAccount = SysUtil.getLoginUser().getSubAccount();
        String id = SysUtil.getLoginUser().getId();
        ElsSubAccount user = new ElsSubAccount();
        user.setId(id);
        user.setElsAccount(elsAccount);
        user.setSubAccount(subAccount);
        if ("phoneBind".equals(bindType)) {
            Object code;
            String phone = jsonObject.getString("phone");
            String smsCode = jsonObject.getString("smscode");
            if (!smsCode.equals(code = this.redisUtil.get("sys:sms:captcha:" + phone))) {
                result.setMessage("\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
                result.setSuccess(false);
                return result;
            }
            user.setPhone(phone);
        } else if ("emailBind".equals(bindType)) {
            Object ecode;
            String email = jsonObject.getString("email");
            ElsSubAccount sysUser2 = this.elsSubAccountService.getUserByEmail(email);
            if (sysUser2 != null) {
                result.setMessage("\u90ae\u7bb1\u5df2\u88ab\u7ed1\u5b9a\uff01");
                result.setSuccess(false);
                return result;
            }
            String emailCode = jsonObject.getString("emailcode");
            if (!emailCode.equals(ecode = this.redisUtil.get(email))) {
                result.setMessage("\u90ae\u7bb1\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
                result.setSuccess(false);
                return result;
            }
            user.setEmail(email);
        }
        user.setUpdateBy(subAccount);
        user.setUpdateTime(new Date());
        this.elsSubAccountService.updateById((Object)user);
        return Result.ok((Object)((Object)user));
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801", operateType=1)
    @PostMapping(value={"/sendEmailCode"})
    @RequiresPermissions(value={"account#personalSetting:set"})
    public Result<?> sendEmailCode(@RequestBody JSONObject jsonObject) {
        log.info("ElsSubAccountController->sendEmailCode: json: " + jsonObject);
        Result result = new Result();
        String receiveEmailAddress = jsonObject.getString("email");
        String subject = "\u90ae\u7bb1\u9a8c\u8bc1\u7801";
        String emailCode = RandomUtil.randomNumbers((int)6);
        String mailContent = "\u9a8c\u8bc1\u7801\u4e3a\uff1a" + emailCode;
        try {
            ElsEmailConfigDTO config = this.invokeBaseRpcService.getEmailConfig(TenantContext.getTenant());
            if (null == config) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LERjdER_891222af", (String)"\u672a\u914d\u7f6e\u90ae\u7bb1\u914d\u7f6e"));
            }
            ElsEmailBuilder.sendEmailWithEp((ElsEmailConfigDTO)config, (String)receiveEmailAddress, (String)subject, (String)mailContent, null, (boolean)false);
            this.redisUtil.set(receiveEmailAddress, (Object)emailCode, 600L);
            result.setMessage("\u90ae\u4ef6\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f");
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error("ElsSubAccountController->sendEmailCode error: ", (Throwable)e);
            result.setMessage("\u90ae\u4ef6\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            result.setSuccess(false);
            return result;
        }
        return result;
    }

    @GetMapping(value={"/getLoginUser"})
    @RequiresPermissions(value={"elsSubAccount#elsSubAccount:get"})
    public Result<?> getLoginUser() {
        LoginUser sysUser = SysUtil.getLoginUser();
        return Result.ok((Object)sysUser);
    }

    @RequestMapping(value={"/getSubAccounts"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#elsSubAccount:get"})
    public Result<IPage<ElsSubAccount>> getSubAccounts(ElsSubAccount user, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)user), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.elsSubAccountService.page((IPage)page, (Wrapper)queryWrapper);
        List accounts = pageList.getRecords();
        if (accounts != null) {
            for (ElsSubAccount elsSubAccount : accounts) {
                PurchaseOrganizationInfoDTO info;
                if (!StringUtils.isNotBlank((CharSequence)elsSubAccount.getOrgCode()) || (info = this.systemInvokeOrganizationInfoRpcService.selectById(elsSubAccount.getOrgCode())) == null) continue;
                elsSubAccount.setOrgCode(info.getOrgDesc());
            }
        }
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @RequestMapping(value={"/getByElsAccount"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"elsSubAccount#elsSubAccount:get"})
    public Result<?> getByElsAccount(ElsSubAccount user, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)user), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        Map parameters = req.getParameterMap();
        Set keys = parameters.keySet();
        String toElsAccount = null;
        String participants = null;
        for (String string : keys) {
            if ("participants".equals(string) && parameters.get(string) != null) {
                participants = ((String[])parameters.get(string))[0];
            }
            if (!"toElsAccount".equals(string) || parameters.get(string) == null) continue;
            toElsAccount = ((String[])parameters.get(string))[0];
        }
        if (StringUtils.isBlank(participants)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_VWiFWsUIdW_4b27149e", (String)"\u5148\u9009\u62e9\u3010\u53c2\u4e0e\u5bf9\u8c61\u3011"));
        }
        if ("purchase".equals(participants)) {
            queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        } else {
            queryWrapper.eq((Object)"els_account", toElsAccount);
        }
        IPage pageList = this.elsSubAccountService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @GetMapping(value={"/checkUserIsCustomerRole"})
    @RequiresPermissions(value={"elsSubAccount#elsSubAccount:get"})
    public Result<Object> checkUserIsCustomerRole() {
        LoginUser loginUser = SysUtil.getLoginUser();
        if (null == loginUser || !"100000".equals(loginUser.getElsAccount())) {
            return Result.ok((Object)false);
        }
        if ("100000".equals(loginUser.getElsAccount()) && "admin".equals(loginUser.getSubAccount())) {
            return Result.ok((Object)true);
        }
        Boolean customerRoleFlag = this.userRoleService.getCustomerRoleFlag(loginUser.getElsAccount(), loginUser.getSubAccount());
        return Result.ok((Object)customerRoleFlag);
    }

    @GetMapping(value={"/getCustomerUser"})
    @RequiresPermissions(value={"elsSubAccount#elsSubAccount:get"})
    public Result<Object> getCustomerUser() {
        return Result.ok((Object)((Object)this.userRoleService.getCustomerRoleUser()));
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, AccountExportServiceImpl.class);
    }

    @PostMapping(value={"/exportXlsOtherList"})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:exportOtherList"})
    public ModelAndView exportOtherList(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, AccountOtherListExportServiceImpl.class);
    }

    @ApiOperation(value="\u83b7\u53d6ERP\u6570\u636e", notes="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:getDataByErp"})
    public Result<?> getDataByErp() {
        this.elsSubAccountService.getDataByErp();
        return Result.ok();
    }

    @ApiOperation(value="SRM\u63a8\u9001\u5230ERP", notes="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.elsSubAccountService.pushDataToErp(ids);
        return Result.ok();
    }

    @RequestMapping(value={"/subAccountlist"}, method={RequestMethod.GET})
    public Result<?> querySubAccountByElsAccountPageList(ElsSubAccount user, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)user), (Map)req.getParameterMap());
        IPage<ElsSubAccount> elsSubAccountIPage = this.elsSubAccountService.selectWithoutElsAccountToSelectSubAccount((QueryWrapper<ElsSubAccount>)queryWrapper, pageNo, pageSize);
        return Result.ok(elsSubAccountIPage);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u91c7\u8d2d\u7ec4\u7ec7", notes="\u83b7\u53d6\u7528\u6237\u7684\u91c7\u8d2d\u7ec4\u7ec7")
    @GetMapping(value={"/getSubaccountOrg"})
    @RequiresPermissions(value={"elsSubAccount#ElsSubAccount:list"})
    public Result<?> getSubaccountOrg() {
        LoginUser loginUser = SysUtil.getLoginUser();
        List<SubaccountOrg> subaccountOrgList = this.subaccountOrgService.selectByMainId(loginUser.getId());
        List<Object> collect = new ArrayList();
        if (CollUtil.isNotEmpty(subaccountOrgList) && subaccountOrgList.size() > 0) {
            collect = subaccountOrgList.stream().filter(o -> "purchaseOrganization".equals(o.getOrgCategoryCode())).collect(Collectors.toList());
        }
        return Result.ok(collect);
    }
}

