/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.contractlock.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.contractlock.dto.SealDto;
import com.els.modules.electronsign.contractlock.entity.PurchaseCLCompanyInfo;
import com.els.modules.electronsign.contractlock.entity.PurchaseClPersonalInfo;
import com.els.modules.electronsign.contractlock.enumerate.CLAuthResultEnum;
import com.els.modules.electronsign.contractlock.enumerate.CLCertificationStatusEnum;
import com.els.modules.electronsign.contractlock.mapper.PurchaseCLCompanyInfoMapper;
import com.els.modules.electronsign.contractlock.service.PurchaseCLCompanyInfoService;
import com.els.modules.electronsign.contractlock.service.PurchaseClPersonalInfoService;
import com.els.modules.electronsign.contractlock.util.ClResultAnalysisUtil;
import com.els.modules.electronsign.contractlock.vo.ClCallback;
import com.els.modules.electronsign.contractlock.vo.ClCompanyCertificationVO;
import com.els.modules.electronsign.contractlock.vo.ClCompanySignVO;
import com.els.modules.electronsign.contractlock.vo.ClCompanyStaffVO;
import com.els.modules.electronsign.contractlock.vo.ClQueryCertificationVO;
import com.els.modules.electronsign.contractlock.vo.ClRoleVO;
import com.els.modules.electronsign.contractlock.vo.ClSealAuthVO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.system.rpc.service.SystemInvokeOrganizationInfoRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseCLCompanyInfoServiceImpl
extends BaseServiceImpl<PurchaseCLCompanyInfoMapper, PurchaseCLCompanyInfo>
implements PurchaseCLCompanyInfoService {
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseClPersonalInfoService personalInfoService;
    @Autowired
    private SystemInvokeOrganizationInfoRpcService systemInvokeOrganizationInfoRpcService;
    @Autowired
    private RedisUtil redisUtil;

    @SrmTransaction(rollbackFor={Exception.class})
    public void add(PurchaseCLCompanyInfo purchaseCLCompanyInfo) {
        if ("1".equals(purchaseCLCompanyInfo.getLoadingCompany())) {
            PurchaseOrganizationInfoDTO organizationInfo = this.systemInvokeOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", purchaseCLCompanyInfo.getCompanyCode());
            Assert.isTrue((boolean)true, (String)I18nUtil.translate((String)"i18n_alert_RCIH_264a3c82", (String)"\u516c\u53f8\u5f02\u5e38"));
            purchaseCLCompanyInfo.setCompanyName(organizationInfo.getOrgName());
        }
        Assert.isTrue((this.count((Wrapper)Wrappers.lambdaQuery().eq(PurchaseCLCompanyInfo::getCompanyName, (Object)purchaseCLCompanyInfo.getCompanyName())) == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_rRCIOMKWxqVBcI_9ebb70f", (String)"\u8be5\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa"));
        ((PurchaseCLCompanyInfoMapper)this.baseMapper).insert(purchaseCLCompanyInfo);
        this.processNewCompany(purchaseCLCompanyInfo);
    }

    public void processNewCompany(PurchaseCLCompanyInfo info) {
        JSONObject jsonObject;
        String status;
        ClQueryCertificationVO clQueryCertificationVO = new ClQueryCertificationVO();
        clQueryCertificationVO.setBase(new ClQueryCertificationVO.Param(info.getCompanyName()));
        Result<?> response = this.getIPassResponse(clQueryCertificationVO, "query-info-company");
        if (response.isSuccess() && StrUtil.isNotBlank((CharSequence)(status = (jsonObject = (JSONObject)response.getResult()).getString("status"))) && "AUTH_SUCCESS".equals(status)) {
            info.setCertificationStatus(CLCertificationStatusEnum.PASSED.getValue());
            info.setCompanyId(jsonObject.getString("id"));
            this.insertAdmin(info);
            info.setCertificationStartTime(new Date());
            this.updateInfo(info);
        }
    }

    public void edit(PurchaseCLCompanyInfo purchaseCLCompanyInfo) {
        if ("1".equals(purchaseCLCompanyInfo.getLoadingCompany())) {
            PurchaseOrganizationInfoDTO organizationInfo = this.systemInvokeOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", purchaseCLCompanyInfo.getCompanyCode());
            Assert.isTrue((boolean)true, (String)I18nUtil.translate((String)"i18n_alert_RCIH_264a3c82", (String)"\u516c\u53f8\u5f02\u5e38"));
            purchaseCLCompanyInfo.setCompanyName(organizationInfo.getOrgName());
        }
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseCLCompanyInfo::getCompanyName, (Object)purchaseCLCompanyInfo.getCompanyName())).ne(BaseEntity::getId, (Object)purchaseCLCompanyInfo.getId())) == 0 ? 1 : 0) != 0, (String)"\u8be5\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa");
        int count = ((PurchaseCLCompanyInfoMapper)this.baseMapper).updateById(purchaseCLCompanyInfo);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        if (!CLCertificationStatusEnum.PASSED.equals(purchaseCLCompanyInfo.getCertificationStatus())) {
            this.getCertificationInfo(purchaseCLCompanyInfo.getId());
        }
    }

    public void delete(String id) {
        ((PurchaseCLCompanyInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    public void deleteBatch(List<String> idList) {
        ((PurchaseCLCompanyInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    public void saveInfo(PurchaseCLCompanyInfo req) {
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        req.setElsAccount(TenantContext.getTenant());
        req.setCreateTime(new Date());
        req.setCreateBy(currentUser);
        ((PurchaseCLCompanyInfoMapper)this.baseMapper).insert(req);
    }

    public void updateInfo(PurchaseCLCompanyInfo req) {
        req.setUpdateTime(new Date());
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        req.setUpdateBy(currentUser);
        ((PurchaseCLCompanyInfoMapper)this.baseMapper).updateById(req);
    }

    public void handleDb(PurchaseCLCompanyInfo req) {
        if (StringUtils.isBlank((CharSequence)req.getId())) {
            this.saveInfo(req);
        } else {
            this.updateInfo(req);
        }
    }

    public PurchaseCLCompanyInfo submitCertification(PurchaseCLCompanyInfo req) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)req.getId()), (String)I18nUtil.translate((String)"i18n_field_VWsM_40db030c", (String)"\u8bf7\u5148\u4fdd\u5b58"));
        Result response = null;
        if (StringUtils.isBlank((CharSequence)req.getCompanyId())) {
            ClCompanyCertificationVO certificationInfo = (ClCompanyCertificationVO)SysUtil.copyProperties((Object)req, ClCompanyCertificationVO.class);
            certificationInfo.setApplicantInfo(new ClCompanyCertificationVO.ApplicantInfo(req.getApplyUserName(), req.getApplyContact(), req.getApplyContactType()));
            certificationInfo.setCallbackUrl(this.address + "/els/contractLock/purchaseCLCompanyInfo/noToken/callback/authCompany");
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)certificationInfo)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-auth-company"));
            response = ClResultAnalysisUtil.analysisResult((JSONObject)object);
            if (response.isSuccess()) {
                JSONObject jsonObject = (JSONObject)response.getResult();
                req.setCertificationPageUrl(jsonObject.getString("pageUrl"));
                req.setRequestId(jsonObject.getString("requestId"));
                req.setCertificationStatus(CLCertificationStatusEnum.UNDER_CERTIFICATION.getValue());
                this.handleDb(req);
            } else {
                Assert.isTrue((boolean)false, (String)response.getMessage());
            }
        }
        return req;
    }

    private void insertAdmin(PurchaseCLCompanyInfo company) {
        TenantContext.setTenant((String)company.getElsAccount());
        List list = this.personalInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseClPersonalInfo::getCompanyId, (Object)company.getCompanyId())).eq(PurchaseClPersonalInfo::getApplyContact, (Object)company.getApplyContact())).eq(PurchaseClPersonalInfo::getApplyUserName, (Object)company.getApplyUserName())).eq(BaseEntity::getDeleted, (Object)"0"));
        if (CollUtil.isNotEmpty((Collection)list)) {
            list.forEach(x -> {
                x.setRoleStr("ADMIN");
                x.setRealName("1");
                this.personalInfoService.updateById(x);
            });
        } else {
            PurchaseClPersonalInfo personalInfo = new PurchaseClPersonalInfo();
            personalInfo.setRoleStr("ADMIN");
            BeanUtil.copyProperties((Object)company, (Object)personalInfo, (String[])new String[0]);
            personalInfo.setCreateTime(new Date());
            personalInfo.setAuthPageUrl(null);
            personalInfo.setId(null);
            personalInfo.setRealName("1");
            this.personalInfoService.save((Object)personalInfo);
        }
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void getCertificationInfo(String id) {
        JSONObject jsonObject;
        Integer status;
        PurchaseCLCompanyInfo info = (PurchaseCLCompanyInfo)this.getById((Serializable)((Object)id));
        ClQueryCertificationVO clQueryCertificationVO = new ClQueryCertificationVO();
        clQueryCertificationVO.setBody(new ClQueryCertificationVO.Param(info.getCompanyName()));
        Result<?> response = this.getIPassResponse(clQueryCertificationVO, "query-auth-company");
        if (response.isSuccess() && ObjectUtil.isNotEmpty((Object)(status = (jsonObject = (JSONObject)response.getResult()).getInteger("status")))) {
            info.setCertificationStatus(status);
            if (status.equals(CLCertificationStatusEnum.PASSED.getValue())) {
                clQueryCertificationVO = new ClQueryCertificationVO();
                clQueryCertificationVO.setBase(new ClQueryCertificationVO.Param(info.getCompanyName()));
                response = this.getIPassResponse(clQueryCertificationVO, "query-info-company");
                jsonObject = (JSONObject)response.getResult();
                info.setCompanyId(jsonObject.getString("id"));
                this.insertAdmin(info);
            }
            info.setCertificationStartTime(new Date());
            this.updateInfo(info);
        }
    }

    public PurchaseCLCompanyInfo getAuthPage(String id) {
        PurchaseCLCompanyInfo info = (PurchaseCLCompanyInfo)this.getById((Serializable)((Object)id));
        ClQueryCertificationVO clQueryCertificationVO = new ClQueryCertificationVO();
        clQueryCertificationVO.setBody(new ClQueryCertificationVO.Param(info.getCompanyId(), new ClCompanyCertificationVO.ApplicantInfo(info.getApplyUserName(), info.getApplyContact(), info.getApplyContactType())));
        Result<?> response = this.getIPassResponse(clQueryCertificationVO, "get-auth-page");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            info.setAuthPageUrl(jsonObject.getString("pageUrl"));
            this.updateInfo(info);
            return info;
        }
        Assert.isTrue((boolean)false, (String)response.getMessage());
        return null;
    }

    public void addStaff(PurchaseClPersonalInfo purchaseClPersonalInfo) {
        this.personalInfoService.check(purchaseClPersonalInfo);
        ClCompanyStaffVO staffReq = new ClCompanyStaffVO();
        staffReq.setCompanyId(purchaseClPersonalInfo.getCompanyId());
        ClCompanyStaffVO.Body body = new ClCompanyStaffVO.Body();
        body.setUser(new ClCompanyCertificationVO.ApplicantInfo(purchaseClPersonalInfo.getApplyUserName(), purchaseClPersonalInfo.getApplyContact(), purchaseClPersonalInfo.getApplyContactType()));
        staffReq.setBody(body);
        Result<?> result = this.getIPassResponse(staffReq, "add-staff-company-personal");
        if (result.isSuccess()) {
            JSONObject jsonObject = (JSONObject)result.getResult();
            purchaseClPersonalInfo.setAccountId(jsonObject.getString("id"));
            purchaseClPersonalInfo.setRealName(jsonObject.getBoolean("realName") != false ? "1" : "0");
            if (StrUtil.isNotBlank((CharSequence)purchaseClPersonalInfo.getId())) {
                this.personalInfoService.edit(purchaseClPersonalInfo);
            } else {
                PurchaseCLCompanyInfo companyInfo = this.getByCompanyId(purchaseClPersonalInfo.getCompanyId());
                purchaseClPersonalInfo.setCreateTime(new Date());
                purchaseClPersonalInfo.setElsAccount(companyInfo.getElsAccount());
                purchaseClPersonalInfo.setCompanyId(companyInfo.getCompanyId());
                purchaseClPersonalInfo.setCompanyName(companyInfo.getCompanyName());
                this.personalInfoService.add(purchaseClPersonalInfo);
            }
        } else {
            Assert.isTrue((boolean)false, (String)result.getMessage());
        }
    }

    public PurchaseCLCompanyInfo getByCompanyId(String id) {
        return (PurchaseCLCompanyInfo)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(PurchaseCLCompanyInfo::getCompanyId, (Object)id));
    }

    public void removeStaff(PurchaseClPersonalInfo purchaseClPersonalInfo) {
        ClCompanyStaffVO staffReq = new ClCompanyStaffVO();
        staffReq.setCompanyId(purchaseClPersonalInfo.getCompanyId());
        ClCompanyStaffVO.Body body = new ClCompanyStaffVO.Body();
        body.setContact(purchaseClPersonalInfo.getApplyContact());
        body.setContactType(purchaseClPersonalInfo.getApplyContactType());
        staffReq.setBody(body);
        Result<?> result = this.getIPassResponse(staffReq, "remove-staff-company-personal");
        if (result.isSuccess()) {
            this.personalInfoService.delete(purchaseClPersonalInfo.getId());
        } else {
            Assert.isTrue((boolean)false, (String)result.getMessage());
        }
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void handleCallBackAuth(String contents) {
        ClCallback.CompanyAuth companyAuth = (ClCallback.CompanyAuth)JSON.parseObject((String)contents, ClCallback.CompanyAuth.class);
        PurchaseCLCompanyInfo dbInfo = this.selectByRequestId(companyAuth.getRequestId());
        if (ObjectUtil.isNotNull((Object)dbInfo)) {
            dbInfo.setCertificationStatus(CLAuthResultEnum.getSrmStatusByValue((Integer)companyAuth.getStatus()));
            dbInfo.setCompanyId(companyAuth.getCompanyId());
            dbInfo.setUpdateTime(new Date());
            this.updateById(dbInfo);
            if (CLAuthResultEnum.PASSED.getValue().equals(companyAuth.getStatus())) {
                this.insertAdmin(dbInfo);
            }
        }
    }

    public String signUrl(String id) {
        PurchaseCLCompanyInfo companyInfo = (PurchaseCLCompanyInfo)this.getById((Serializable)((Object)id));
        ClCompanySignVO companySignVO = new ClCompanySignVO();
        companySignVO.setCompanyId(companyInfo.getCompanyId());
        companySignVO.setAppName("\u4f01\u4f01\u901aSRM");
        companySignVO.setDomain(this.address);
        companySignVO.setLoginUrl("https://v5sit-micro.51qqt.com/user/login");
        companySignVO.setCasVerifyUrl(this.address + "/els/contractLock/purchaseCLCompanyInfo/noToken/casVerifyUrl");
        Result<?> result = this.getIPassResponse(companySignVO, "get-company-sign-login");
        if (result.isSuccess()) {
            String ticket = UUID.randomUUID().toString();
            ClCompanySignVO.ClCompanySignRpVO ticketVo = new ClCompanySignVO.ClCompanySignRpVO();
            ticketVo.setName(companyInfo.getApplyUserName());
            ticketVo.setContact(companyInfo.getApplyContact());
            this.redisUtil.set("contractLock:auth:ticket:" + ticket, (Object)ticketVo);
            String url = "https://cloudapi.qiyuesuo.cn/saas/ssogateway?ticket=" + ticket + "&pageType=SEAL_PAGE";
            return url;
        }
        Assert.isTrue((boolean)false, (String)result.getMessage());
        return null;
    }

    public ClCompanySignVO.ClCompanySignRpVO handleCasVerify(String ticket) {
        ClCompanySignVO.ClCompanySignRpVO ticketVo = (ClCompanySignVO.ClCompanySignRpVO)this.redisUtil.get("contractLock:auth:ticket:" + ticket);
        this.redisUtil.del(new String[]{"contractLock:auth:ticket:" + ticket});
        return ticketVo;
    }

    @SrmTransaction(rollbackFor={Exception.class})
    public void generateDefaultSeal(SealDto sealRq) {
        PurchaseCLCompanyInfo companyInfo = (PurchaseCLCompanyInfo)this.getById((Serializable)((Object)sealRq.getId()));
        List personalInfos = this.personalInfoService.listByIds((Collection)sealRq.getUserIds());
        if (StrUtil.isNotBlank((CharSequence)companyInfo.getDefaultSealId())) {
            List oldPns = this.personalInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseClPersonalInfo::getAddDefaultSeal, (Object)"1")).eq(PurchaseClPersonalInfo::getCompanyId, (Object)companyInfo.getCompanyId()));
            List oldIds = oldPns.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
            List nowIds = personalInfos.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
            List removes = oldPns.stream().filter(x -> !nowIds.contains(x.getId())).collect(Collectors.toList());
            List adds = personalInfos.stream().filter(x -> !oldIds.contains(x.getId())).collect(Collectors.toList());
            ClSealAuthVO clSealAuthVO = new ClSealAuthVO();
            clSealAuthVO.setCompanyId(companyInfo.getCompanyId());
            clSealAuthVO.getBody().setSealId(companyInfo.getDefaultSealId());
            clSealAuthVO.getBody().setSealImageInfo(null);
            clSealAuthVO.getBody().setName(null);
            if (CollUtil.isNotEmpty(removes)) {
                List us = removes.stream().map(x -> {
                    ClSealAuthVO.User u = new ClSealAuthVO.User();
                    u.setContact(x.getApplyContact());
                    u.setContactType(x.getApplyContactType());
                    return u;
                }).collect(Collectors.toList());
                clSealAuthVO.getBody().setOperate("REMOVE");
                clSealAuthVO.getBody().setSealUsers(us);
                Result<?> result = this.getIPassResponse(clSealAuthVO, "modify-auto-seal");
                Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
                this.personalInfoService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(PurchaseClPersonalInfo::getAddDefaultSeal, (Object)"0")).in(BaseEntity::getId, (Collection)removes.stream().map(x -> x.getId()).collect(Collectors.toList())));
            }
            if (CollUtil.isNotEmpty(adds)) {
                List as = adds.stream().map(x -> {
                    ClSealAuthVO.User u = new ClSealAuthVO.User();
                    u.setContact(x.getApplyContact());
                    u.setContactType(x.getApplyContactType());
                    return u;
                }).collect(Collectors.toList());
                clSealAuthVO.getBody().setOperate("ADD");
                clSealAuthVO.getBody().setSealUsers(as);
                Result<?> addResult = this.getIPassResponse(clSealAuthVO, "modify-auto-seal");
                Assert.isTrue((boolean)addResult.isSuccess(), (String)addResult.getMessage());
                this.personalInfoService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(PurchaseClPersonalInfo::getAddDefaultSeal, (Object)"1")).in(BaseEntity::getId, (Collection)adds.stream().map(x -> x.getId()).collect(Collectors.toList())));
            }
        } else {
            ClSealAuthVO clSealAuthVO = new ClSealAuthVO();
            clSealAuthVO.setCompanyId(companyInfo.getCompanyId());
            List us = personalInfos.stream().map(x -> {
                ClSealAuthVO.User u = new ClSealAuthVO.User();
                u.setContact(x.getApplyContact());
                u.setContactType(x.getApplyContactType());
                return u;
            }).collect(Collectors.toList());
            clSealAuthVO.getBody().setUsers(us);
            Result<?> result = this.getIPassResponse(clSealAuthVO, "create-auto-seal");
            Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
            JSONObject jsonObject = (JSONObject)result.getResult();
            String sealId = jsonObject.getString("id");
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)sealId), (String)I18nUtil.translate((String)"i18n_field_yVIHLvMid_26f57497", (String)"\u63a5\u53e3\u5f02\u5e38\uff0c\u672a\u8fd4\u56deid"));
            companyInfo.setDefaultSealId(sealId);
            personalInfos.forEach(p -> p.setAddDefaultSeal("1"));
            this.updateById(companyInfo);
            this.personalInfoService.updateBatchById((Collection)personalInfos);
        }
    }

    public SealDto defaultSeal(String id) {
        PurchaseCLCompanyInfo companyInfo = (PurchaseCLCompanyInfo)this.getById((Serializable)((Object)id));
        SealDto seal = new SealDto();
        List psns = this.personalInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseClPersonalInfo::getAddDefaultSeal, (Object)"1")).eq(PurchaseClPersonalInfo::getCompanyId, (Object)companyInfo.getCompanyId()));
        if (CollUtil.isNotEmpty((Collection)psns)) {
            seal.setUserIds(psns.stream().map(x -> x.getId()).collect(Collectors.toList()));
        }
        seal.setPsns(this.personalInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseClPersonalInfo::getCompanyId, (Object)companyInfo.getCompanyId())).eq(PurchaseClPersonalInfo::getRealName, (Object)"1")));
        seal.setId(id);
        return seal;
    }

    public void roleAdmin(String id, String operate) {
        ClRoleVO clRoleVO = new ClRoleVO();
        PurchaseClPersonalInfo personalInfo = (PurchaseClPersonalInfo)this.personalInfoService.getById((Serializable)((Object)id));
        clRoleVO.setCompanyId(personalInfo.getCompanyId());
        clRoleVO.getBody().setRole("SEAL_ADMIN");
        clRoleVO.getBody().setOperate(operate);
        clRoleVO.getBody().setUsers(Arrays.asList(new ClRoleVO.User(personalInfo.getApplyContact(), personalInfo.getApplyContactType())));
        Result<?> addResult = this.getIPassResponse(clRoleVO, "admin-psn-role");
        Assert.isTrue((boolean)addResult.isSuccess(), (String)addResult.getMessage());
        personalInfo.setRoleStr(operate.equals("ADD") ? "SEAL_ADMIN" : null);
        this.personalInfoService.updateById((Object)personalInfo);
    }

    private PurchaseCLCompanyInfo selectByRequestId(String requestId) {
        return ((PurchaseCLCompanyInfoMapper)this.baseMapper).selectByRequestId(requestId);
    }

    private Result<?> getIPassResponse(Object req, String iPassCode) {
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)req)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(iPassCode));
        return ClResultAnalysisUtil.analysisResult((JSONObject)object);
    }
}

