/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esign.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.modules.base.api.service.FileRpcService;
import com.els.modules.electronsign.esign.entity.PurchaseEsign;
import com.els.modules.electronsign.esign.entity.PurchaseEsignAttachment;
import com.els.modules.electronsign.esign.entity.PurchaseEsignSigners;
import com.els.modules.electronsign.esign.entity.SaleEsign;
import com.els.modules.electronsign.esign.entity.SaleEsignAttachment;
import com.els.modules.electronsign.esign.enumerate.EsignSignerStatusEmun;
import com.els.modules.electronsign.esign.enumerate.EsignStatusEmun;
import com.els.modules.electronsign.esign.mapper.PurchaseEsignAttachmentMapper;
import com.els.modules.electronsign.esign.mapper.PurchaseEsignMapper;
import com.els.modules.electronsign.esign.mapper.PurchaseEsignSignersMapper;
import com.els.modules.electronsign.esign.service.PurchaseEsignService;
import com.els.modules.electronsign.esign.service.SaleEsignService;
import com.els.modules.electronsign.esign.util.EsignResultAnalysisUtil;
import com.els.modules.electronsign.esign.vo.CreateFlowOneStep;
import com.els.modules.electronsign.esign.vo.EsignAttachmentsVO;
import com.els.modules.electronsign.esign.vo.EsignCopiersVO;
import com.els.modules.electronsign.esign.vo.EsignDocsVO;
import com.els.modules.electronsign.esign.vo.EsignFlowInfoVO;
import com.els.modules.electronsign.esign.vo.EsignSignerVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PurchaseEsignServiceImpl
extends BaseServiceImpl<PurchaseEsignMapper, PurchaseEsign>
implements PurchaseEsignService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEsignServiceImpl.class);
    private static final Integer A_SIGNED = 2;
    private static final Integer LOSE = 3;
    private static final Integer REFUSAL = 4;
    private static final String SIGN_FLOW_UPDATE = "SIGN_FLOW_UPDATE";
    private static final String SIGN_FLOW_FINISH = "SIGN_FLOW_FINISH";
    @Value(value="${els.path.upload}")
    private String uploadpath;
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    private String address = (String)((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig().get("service.address");
    @Autowired
    private PurchaseEsignMapper purchaseEsignMapper;
    @Autowired
    private PurchaseEsignSignersMapper purchaseEsignSignersMapper;
    @Autowired
    private PurchaseEsignAttachmentMapper purchaseEsignAttachmentMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleEsignService saleEsignService;
    @Autowired
    private FileRpcService fileRpcService;
    @Value(value="${els.storage.type}")
    private String storeType;

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseEsign purchaseEsign, List<PurchaseEsignSigners> purchaseEsignSignersList, List<PurchaseEsignAttachment> purchaseEsignAttachmentList) {
        purchaseEsign.setEsignNumber(this.invokeBaseRpcService.getNextCode("srmEsignNumber", (Object)purchaseEsign));
        LoginUser loginUser = SysUtil.getLoginUser();
        purchaseEsign.setElsAccount(loginUser.getElsAccount());
        purchaseEsign.setBusAccount("100000");
        purchaseEsign.setPurchaseName(loginUser.getEnterpriseName());
        this.purchaseEsignMapper.insert((Object)purchaseEsign);
        this.insertData(purchaseEsign, purchaseEsignSignersList, purchaseEsignAttachmentList);
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseEsign purchaseEsign, List<PurchaseEsignSigners> purchaseEsignSignersList, List<PurchaseEsignAttachment> purchaseEsignAttachmentList) {
        if (purchaseEsignSignersList != null && purchaseEsignSignersList.size() > 0) {
            purchaseEsign.setMaintenanceSignatory("1");
        }
        this.purchaseEsignMapper.updateById((Object)purchaseEsign);
        this.purchaseEsignSignersMapper.deleteByMainId(purchaseEsign.getId());
        this.purchaseEsignAttachmentMapper.deleteByMainId(purchaseEsign.getId());
        this.insertData(purchaseEsign, purchaseEsignSignersList, purchaseEsignAttachmentList);
    }

    private void insertData(PurchaseEsign purchaseEsign, List<PurchaseEsignSigners> purchaseEsignSignersList, List<PurchaseEsignAttachment> purchaseEsignAttachmentList) {
        if (purchaseEsignSignersList != null) {
            for (PurchaseEsignSigners purchaseEsignSigners : purchaseEsignSignersList) {
                purchaseEsignSigners.setHeadId(purchaseEsign.getId());
                SysUtil.setSysParam((BaseEntity)purchaseEsignSigners, (BaseEntity)purchaseEsign);
            }
            if (!purchaseEsignSignersList.isEmpty()) {
                this.purchaseEsignSignersMapper.insertBatchSomeColumn(purchaseEsignSignersList);
            }
        }
        if (purchaseEsignAttachmentList != null) {
            for (PurchaseEsignAttachment purchaseEsignAttachment : purchaseEsignAttachmentList) {
                purchaseEsignAttachment.setHeadId(purchaseEsign.getId());
                SysUtil.setSysParam((BaseEntity)purchaseEsignAttachment, (BaseEntity)purchaseEsign);
            }
            if (!purchaseEsignAttachmentList.isEmpty()) {
                this.purchaseEsignAttachmentMapper.insertBatchSomeColumn(purchaseEsignAttachmentList);
            }
        }
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseEsignSignersMapper.deleteByMainId(id);
        this.purchaseEsignAttachmentMapper.deleteByMainId(id);
        this.purchaseEsignMapper.deleteById((Serializable)((Object)id));
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseEsignSignersMapper.deleteByMainId(serializable.toString());
            this.purchaseEsignAttachmentMapper.deleteByMainId(serializable.toString());
            this.purchaseEsignMapper.deleteById(serializable);
        }
    }

    /*
     * Exception decompiling
     */
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void uploadToEsign(PurchaseEsign purchaseEsign, List<PurchaseEsignAttachment> purchaseEsignAttachmentList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void launchOneStepEsign(PurchaseEsign purchaseEsign, List<PurchaseEsignSigners> purchaseEsignSignersList, List<PurchaseEsignAttachment> purchaseEsignAttachmentList) {
        purchaseEsign.setLaunch("1");
        if ("1".equals(purchaseEsign.getAutoInitiate())) {
            purchaseEsign.setInitiate("1");
        }
        this.updateMain(purchaseEsign, purchaseEsignSignersList, purchaseEsignAttachmentList);
        PurchaseEsignSigners mainSinger = null;
        CreateFlowOneStep oneStep = new CreateFlowOneStep();
        ArrayList<EsignCopiersVO> copiersVOs = new ArrayList<EsignCopiersVO>();
        for (PurchaseEsignSigners esignSigners : purchaseEsignSignersList) {
            if ("1".equals(esignSigners.getPersonType())) {
                copiersVOs.add(new EsignCopiersVO(esignSigners));
                continue;
            }
            mainSinger = esignSigners;
        }
        oneStep.setCopiers(copiersVOs);
        ArrayList<EsignDocsVO> docs = new ArrayList<EsignDocsVO>();
        ArrayList<EsignAttachmentsVO> attachments = new ArrayList<EsignAttachmentsVO>();
        for (PurchaseEsignAttachment attachment : purchaseEsignAttachmentList) {
            if (!"1".equals(attachment.getUploaded())) continue;
            if ("1".equals(attachment.getEsignType())) {
                docs.add(new EsignDocsVO(attachment));
                continue;
            }
            attachments.add(new EsignAttachmentsVO(attachment));
        }
        oneStep.setAttachments(attachments);
        oneStep.setDocs(docs);
        String notifyUrl = "";
        notifyUrl = this.address.endsWith("/") ? this.address + "els/esign/purchaseEsign/noToken/callback" : this.address + "/els/esign/purchaseEsign/noToken/callback";
        EsignFlowInfoVO flowInfo = new EsignFlowInfoVO(purchaseEsign, mainSinger, notifyUrl);
        oneStep.setFlowInfo(flowInfo);
        ArrayList<EsignSignerVO> signers = new ArrayList<EsignSignerVO>();
        signers.add(new EsignSignerVO(mainSinger, docs, 1L));
        oneStep.setSigners(signers);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSONObject.parseObject((String)JSONObject.toJSONString((Object)oneStep)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("one-step-flow-start"));
        Result response = EsignResultAnalysisUtil.analysisResult((JSONObject)object);
        if (!response.isSuccess()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IxPWhAKmW_f40249c7", (String)"\u4e00\u6b65\u7b7e\u7f72\u53d1\u8d77\u5931\u8d25:") + response.getMessage());
        }
        JSONObject jsonObject = (JSONObject)response.getResult();
        purchaseEsign.setFlowId(jsonObject.getString("flowId"));
        purchaseEsign.setLaunch("1");
        purchaseEsign.setEsignStatus(EsignStatusEmun.UNFINISHED.getValue());
        if ("1".equals(purchaseEsign.getAutoInitiate())) {
            purchaseEsign.setInitiate("1");
        }
        this.updateById(purchaseEsign);
        for (PurchaseEsignSigners esignSigners : purchaseEsignSignersList) {
            esignSigners.setFlowId(purchaseEsign.getFlowId());
            this.purchaseEsignSignersMapper.updateById((Object)esignSigners);
        }
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void callback(JSONObject object) {
        if (SIGN_FLOW_UPDATE.equals(object.getString("action"))) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"flow_id", (Object)object.getString("flowId"));
            wrapper.eq((Object)"account_id", (Object)object.getString("accountId"));
            ((QueryWrapper)wrapper.eq((Object)"person_type", (Object)"0")).last(" limit 1");
            PurchaseEsignSigners esignSigners = (PurchaseEsignSigners)this.purchaseEsignSignersMapper.selectOne((Wrapper)wrapper);
            if (esignSigners != null) {
                if (A_SIGNED.equals(object.getInteger("signResult"))) {
                    esignSigners.setEsignStatus(EsignSignerStatusEmun.A_SIGNED.getValue());
                } else if (LOSE.equals(object.getInteger("signResult"))) {
                    esignSigners.setEsignStatus(EsignSignerStatusEmun.LOSE.getValue());
                    esignSigners.setReason((Object)object.getString("resultDescription"));
                } else if (REFUSAL.equals(object.getInteger("signResult"))) {
                    esignSigners.setEsignStatus(EsignSignerStatusEmun.REFUSAL.getValue());
                    esignSigners.setReason((Object)object.getString("resultDescription"));
                }
                this.purchaseEsignSignersMapper.updateById((Object)esignSigners);
            }
        } else if (SIGN_FLOW_FINISH.equals(object.getString("action"))) {
            QueryWrapper wrapper = new QueryWrapper();
            ((QueryWrapper)wrapper.eq((Object)"flow_id", (Object)object.getString("flowId"))).last(" limit 1");
            PurchaseEsign esign = (PurchaseEsign)this.purchaseEsignMapper.selectOne((Wrapper)wrapper);
            if (esign != null) {
                esign.setEsignStatus(object.getString("flowStatus"));
                if (EsignStatusEmun.UNDONE.getValue().equals(object.getString("flowStatus"))) {
                    esign.setLaunch("0");
                }
                esign.setReason(object.getString("statusDescription"));
                if (EsignStatusEmun.FINISHED.getValue().equals(esign.getEsignStatus())) {
                    if ("1".equals(esign.getAutoArchiving())) {
                        esign.setArchiving("1");
                    }
                    List<PurchaseEsignAttachment> attachments = this.purchaseEsignAttachmentMapper.selectByMainId(esign.getId());
                    JSONObject requestJSON = new JSONObject();
                    JSONObject bascis = new JSONObject();
                    bascis.put("flowId", (Object)esign.getFlowId());
                    requestJSON.put("base", (Object)bascis);
                    requestJSON.put("currentAccount", (Object)esign.getElsAccount());
                    JSONObject resultObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("flow-file-download"));
                    Result response = EsignResultAnalysisUtil.analysisResult((JSONObject)resultObject);
                    if (response.isSuccess()) {
                        JSONObject jsonObject = (JSONObject)response.getResult();
                        JSONArray array = jsonObject.getJSONArray("docs");
                        for (Object object2 : array) {
                            JSONObject doc = JSONObject.parseObject((String)object2.toString());
                            String filePath = doc.getString("fileUrl");
                            String fileName = doc.getString("fileName");
                            String fileId = doc.getString("fileId");
                            String savePath = this.downloadFile(filePath, fileName, esign.getElsAccount());
                            if (savePath.contains("\\")) {
                                savePath = savePath.replace("\\", "/");
                            }
                            for (PurchaseEsignAttachment attachment : attachments) {
                                if (!fileId.equals(attachment.getFileId()) || !"1".equals(attachment.getEsignType())) continue;
                                attachment.setEsignFilePath(savePath);
                                this.purchaseEsignAttachmentMapper.updateById(attachment);
                            }
                        }
                    }
                    if ("1".equals(esign.getAutoSend())) {
                        SaleEsign saleEsign = new SaleEsign();
                        BeanUtils.copyProperties((Object)esign, (Object)saleEsign);
                        saleEsign.setElsAccount(esign.getToElsAccount());
                        saleEsign.setToElsAccount(esign.getElsAccount());
                        saleEsign.setRelationId(esign.getId());
                        ArrayList<SaleEsignAttachment> saleEsignAttachments = new ArrayList<SaleEsignAttachment>();
                        for (PurchaseEsignAttachment purchaseEsignAttachment : attachments) {
                            SaleEsignAttachment attachment = new SaleEsignAttachment();
                            BeanUtils.copyProperties((Object)purchaseEsignAttachment, (Object)attachment);
                            attachment.setElsAccount(saleEsign.getElsAccount());
                            attachment.setId(null);
                            attachment.setHeadId(null);
                            saleEsignAttachments.add(attachment);
                        }
                        this.saleEsignService.saveMain(saleEsign, saleEsignAttachments);
                        esign.setRelationId(saleEsign.getId());
                        esign.setSendStatus("1");
                        ArrayList<String> receiveAccount = new ArrayList<String>();
                        receiveAccount.add(esign.getToElsAccount());
                        super.sendMessage(esign.getElsAccount(), "esign", "publish", esign.getId(), "purchaseEsignBusDataServiceImpl", receiveAccount);
                    }
                }
                this.updateById(esign);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadFile(String filePath, String fileName, String elsAccount) {
        InputStream inputStream = null;
        OutputStream os = null;
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
        String nowDay = dtf.format(time);
        try {
            int len;
            URL url = new URL(filePath);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setReadTimeout(3000);
            connection.setRequestProperty("User-Agent", "Mozilla/4.e ( compatible;MSIE 5.0; windows NT; DigExt)");
            inputStream = connection.getInputStream();
            File file = new File(this.uploadpath + File.separator + "esign" + File.separator + elsAccount + File.separator + nowDay);
            if (!file.exists()) {
                file.mkdirs();
            }
            byte[] bs = new byte[1024];
            fileName = File.separator + System.currentTimeMillis() + "_" + fileName;
            os = new FileOutputStream(file.getPath() + fileName);
            while ((len = inputStream.read(bs)) != -1) {
                os.write(bs, 0, len);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return File.separator + "esign" + File.separator + elsAccount + File.separator + nowDay + fileName;
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void send(String id) {
        ArrayList<SaleEsignAttachment> saleEsignAttachments;
        SaleEsign saleEsign;
        PurchaseEsign esign = (PurchaseEsign)this.getById((Serializable)((Object)id));
        if (esign != null) {
            saleEsign = new SaleEsign();
            BeanUtils.copyProperties((Object)esign, (Object)saleEsign);
            saleEsign.setElsAccount(esign.getToElsAccount());
            saleEsign.setToElsAccount(esign.getElsAccount());
            saleEsign.setRelationId(esign.getId());
            List<PurchaseEsignAttachment> attachments = this.purchaseEsignAttachmentMapper.selectByMainId(esign.getId());
            saleEsignAttachments = new ArrayList<SaleEsignAttachment>();
            for (PurchaseEsignAttachment purchaseEsignAttachment : attachments) {
                SaleEsignAttachment attachment = new SaleEsignAttachment();
                BeanUtils.copyProperties((Object)purchaseEsignAttachment, (Object)attachment);
                attachment.setElsAccount(saleEsign.getElsAccount());
                attachment.setId(null);
                attachment.setHeadId(null);
                saleEsignAttachments.add(attachment);
            }
        } else {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_tFxMK_c4afc444", (String)"\u5355\u636e\u4e0d\u5b58\u5728"));
        }
        this.saleEsignService.saveMain(saleEsign, saleEsignAttachments);
        esign.setRelationId(saleEsign.getId());
        esign.setSendStatus("1");
        this.updateById(esign);
        ArrayList<String> receiveAccount = new ArrayList<String>();
        receiveAccount.add(esign.getToElsAccount());
        super.sendMessage(esign.getElsAccount(), "esign", "publish", esign.getId(), "purchaseEsignBusDataServiceImpl", receiveAccount);
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmOrReject(PurchaseEsign esign, String operate) {
        if ("confirm".equals(operate)) {
            esign.setReturnFileConfirm("1");
        }
        if ("reject".equals(operate)) {
            esign.setReject("1");
        }
        SaleEsign saleEsign = (SaleEsign)this.saleEsignService.getById((Serializable)((Object)esign.getRelationId()));
        saleEsign.setReturnFileConfirm(esign.getReturnFileConfirm());
        saleEsign.setReject(esign.getReject());
        saleEsign.setRejectReason((Object)esign.getRejectReason());
        this.saleEsignService.updateById((Object)saleEsign);
        this.updateById(esign);
        ArrayList<String> receiveAccount = new ArrayList<String>();
        receiveAccount.add(esign.getToElsAccount());
        if ("confirm".equals(operate)) {
            super.sendMessage(esign.getElsAccount(), "esign", "confirm", esign.getId(), "purchaseEsignBusDataServiceImpl", receiveAccount);
        } else {
            super.sendMessage(esign.getElsAccount(), "esign", "refund", esign.getId(), "purchaseEsignBusDataServiceImpl", receiveAccount);
        }
    }

    public Result<?> flowQuery(String id) {
        PurchaseEsign esign = (PurchaseEsign)this.getById((Serializable)((Object)id));
        if (esign != null) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("query-esign-flow"));
            Result response = EsignResultAnalysisUtil.analysisResult((JSONObject)jsonObject);
            if (!response.isSuccess()) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_PWQLmhKmW_8344aceb", (String)"\u7b7e\u7f72\u6d41\u7a0b\u67e5\u8be2\u5931\u8d25:") + response.getMessage()));
            }
            JSONObject data = (JSONObject)response.getResult();
            String status = data.getString("flowStatus");
            if (EsignStatusEmun.FINISHED.getValue().equals(status)) {
                esign.setEsignStatus(EsignStatusEmun.FINISHED.getValue());
                if ("1".equals(esign.getAutoArchiving())) {
                    esign.setArchiving("1");
                }
                ((PurchaseEsignMapper)this.baseMapper).updateById((Object)esign);
            }
            return Result.ok((Object)response.getResult());
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFIqQGWtkSX_89985068", (String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548"));
    }

    public Result<?> signFileDownload(String id) {
        PurchaseEsign esign = (PurchaseEsign)this.getById((Serializable)((Object)id));
        if (esign != null) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("flow-file-download"));
            Result response = EsignResultAnalysisUtil.analysisResult((JSONObject)jsonObject);
            if (!response.isSuccess()) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_QLQAIKKySMKmW_255987a8", (String)"\u6d41\u7a0b\u6587\u6863\u4e0b\u8f7d\u94fe\u63a5\u83b7\u53d6\u5931\u8d25:") + response.getMessage()));
            }
            JSONObject object = (JSONObject)response.getResult();
            return Result.ok((Object)object.getJSONArray("docs"));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFIqQGWtkSX_89985068", (String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548"));
    }

    public JSONObject getDataById(String id) {
        PurchaseEsign purchaseEsign = (PurchaseEsign)this.getById((Serializable)((Object)id));
        Result result = Result.ok((Object)purchaseEsign);
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }
}

