/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.electronsign.esignv3.dto.OrgPsnAdminRp;
import com.els.modules.electronsign.esignv3.dto.OrgPsnAdminRq;
import com.els.modules.electronsign.esignv3.dto.OrgPsnRemoveRq;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3OrgPsn;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3Personal;
import com.els.modules.electronsign.esignv3.mapper.SaleEsignV3OrgPsnMapper;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3OrgPsnService;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3PersonalService;
import com.els.modules.electronsign.esignv3.vo.SaleV3OrgPsnVo;
import com.els.modules.electronsign.util.IpassUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleEsignV3OrgPsnServiceImpl
extends BaseServiceImpl<SaleEsignV3OrgPsnMapper, SaleEsignV3OrgPsn>
implements SaleEsignV3OrgPsnService {
    @Autowired
    private SaleEsignV3PersonalService personalService;
    @Autowired
    private IpassUtil ipassUtil;

    public void add(SaleEsignV3OrgPsn saleEsignV3OrgPsn) {
        SaleEsignV3Personal personal = (SaleEsignV3Personal)this.personalService.getById((Serializable)((Object)saleEsignV3OrgPsn.getPsnId()));
        OrgPsnAdminRq.Members members = new OrgPsnAdminRq.Members();
        members.setPsnId(saleEsignV3OrgPsn.getPsnCode());
        members.setMemberName(personal.getPsnName());
        members.setRole(saleEsignV3OrgPsn.getRole());
        OrgPsnAdminRq orgPsnAdminRq = OrgPsnAdminRq.builder().base(new OrgPsnAdminRq.Base(saleEsignV3OrgPsn.getOrgCode())).body(new OrgPsnAdminRq.Body(Arrays.asList(members))).build();
        OrgPsnAdminRp rp = (OrgPsnAdminRp)this.ipassUtil.sendRequest((Object)orgPsnAdminRq, "e3-org-psn-add", OrgPsnAdminRp.class);
        if (!rp.getAddedMembers().contains(personal.getPsnId())) {
            if (CollUtil.isNotEmpty(rp.getUnaddedMembers())) {
                throw new ELSBootException(rp.getUnaddedMembers().get(0).getFailedReason());
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_EPsyVIHVKHRvj_d3e483a9", (String)"E\u7b7e\u5b9d\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        ((SaleEsignV3OrgPsnMapper)this.baseMapper).insert((Object)saleEsignV3OrgPsn);
    }

    public void edit(SaleEsignV3OrgPsn saleEsignV3OrgPsn) {
        int count = ((SaleEsignV3OrgPsnMapper)this.baseMapper).updateById((Object)saleEsignV3OrgPsn);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    public void delete(String id) {
        ((SaleEsignV3OrgPsnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    public void deleteBatch(List<String> idList) {
        ((SaleEsignV3OrgPsnMapper)this.baseMapper).deleteBatchIds(idList);
    }

    public IPage<SaleV3OrgPsnVo> pageVo(Page<SaleV3OrgPsnVo> page, String orgId, boolean notAdmin, String sealId) {
        return ((SaleEsignV3OrgPsnMapper)this.baseMapper).pageVo(page, orgId, notAdmin, sealId);
    }

    public void removeStaff(SaleEsignV3OrgPsn saleEsignV3OrgPsn) {
        SaleEsignV3OrgPsn pev = (SaleEsignV3OrgPsn)this.getById((Serializable)((Object)saleEsignV3OrgPsn.getId()));
        OrgPsnRemoveRq orgPsnRemoveRq = new OrgPsnRemoveRq();
        orgPsnRemoveRq.getBase().setOrgId(pev.getOrgCode());
        orgPsnRemoveRq.getBase().setMemberPsnIds(pev.getPsnCode());
        OrgPsnAdminRp rp = (OrgPsnAdminRp)this.ipassUtil.sendRequest((Object)orgPsnRemoveRq, "e3-org-psn-remove", OrgPsnAdminRp.class);
        if (!rp.getDeletedMembers().contains(pev.getPsnCode())) {
            if (CollUtil.isNotEmpty(rp.getUnaddedMembers())) {
                throw new ELSBootException(rp.getUnaddedMembers().get(0).getFailedReason());
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_EPsyVIHVKHRvj_d3e483a9", (String)"E\u7b7e\u5b9d\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        this.removeById((Serializable)((Object)pev.getId()));
    }
}

