/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.PasswordUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.rpc.service.SystemInvokeOrganizationInfoRpcService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.UserRoleService;
import com.els.rpc.service.ImGroupInvokeRpcService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="elsSubAccountExcelHandler")
public class ElsSubAccountExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    private static final Logger log = LoggerFactory.getLogger(ElsSubAccountExcelHandler.class);
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired(required=false)
    private ImGroupInvokeRpcService baseImGroupService;
    @Autowired
    private SystemInvokeOrganizationInfoRpcService systemInvokeOrganizationInfoRpcService;
    @Autowired
    private PersonalSettingService personalSettingService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        String elsAccount = TenantContext.getTenant();
        List<Object> accountList = new ArrayList();
        List<Object> userRoleList = new ArrayList();
        List roleList = this.roleService.list();
        Map<String, String> roleMap = roleList.stream().collect(Collectors.toMap(Role::getRoleCode, Role::getId));
        Map deptMap = this.systemInvokeOrganizationInfoRpcService.getDeptOrganization(elsAccount);
        ArrayList<String> subAccountList = new ArrayList<String>();
        ArrayList errorDataList = new ArrayList();
        HashMap<String, Map> oldData = new HashMap<String, Map>();
        for (Map data2 : dataList) {
            String msg;
            String msg2;
            ElsSubAccount account = (ElsSubAccount)JSON.parseObject((String)JSON.toJSONString((Object)data2), ElsSubAccount.class);
            String roleCode = CharSequenceUtil.emptyToDefault((CharSequence)((String)data2.get("roleCode")), (String)"");
            String orgCode = account.getOrgCode();
            account.setId(IdWorker.getIdStr());
            account.setElsAccount(elsAccount);
            account.setOrgCode((String)deptMap.get(orgCode));
            String salt = ConvertUtils.randomGen((int)8);
            account.setSalt(salt);
            if (CharSequenceUtil.isEmpty((CharSequence)account.getPassword()) && CharSequenceUtil.isEmpty((CharSequence)account.getPhone())) {
                msg2 = I18nUtil.translate((String)"i18n_alert_wonltyxOeKLV_78b66ab1", (String)"\u5bc6\u7801\u548c\u624b\u673a\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg2, data2);
                continue;
            }
            if (CharSequenceUtil.isEmpty((CharSequence)account.getPassword()) && account.getPhone().length() < 6) {
                msg2 = I18nUtil.translate((String)"i18n_alert_ltyLWxiR_14ab630d", (String)"\u624b\u673a\u53f7\u4f4d\u6570\u4e0d\u6b63\u786e");
                this.errorAdd(excelImportDTO, msg2, data2);
                continue;
            }
            String password = StrUtil.isNotBlank((CharSequence)account.getPassword()) ? account.getPassword() : account.getPhone().substring(account.getPhone().length() - 6);
            String passwordEncode = PasswordUtil.encrypt((String)(elsAccount + "_" + account.getSubAccount()), (String)password, (String)salt);
            account.setPassword(passwordEncode);
            account.setStatus(Integer.valueOf(1));
            account.setDeleted(Integer.valueOf(0));
            List roleLists = CharSequenceUtil.split((CharSequence)roleCode, (CharSequence)",");
            List roles = roleLists.stream().filter(roleMap::containsKey).distinct().collect(Collectors.toList());
            if (roles.isEmpty()) {
                msg = I18nUtil.translate((String)"i18n_alert_KyAoNSWWWWWW_d2c467ab", (String)"\u89d2\u8272\u7f16\u7801\u9519\u8bef\uff1a") + roleCode;
                this.errorAdd(excelImportDTO, msg, data2);
                continue;
            }
            if (subAccountList.contains(account.getSubAccount())) {
                msg = I18nUtil.translate((String)"i18n_alert_uNjWFjVBjJey_a0e908ed", (String)"\u5bfc\u5165\u7684\u6570\u636e\u6709\u91cd\u590d\u7684\u5b50\u8d26\u53f7");
                this.errorAdd(excelImportDTO, msg, data2);
                continue;
            }
            subAccountList.add(account.getSubAccount());
            accountList.add(account);
            oldData.put(account.getSubAccount(), data2);
            for (String r : roles) {
                UserRole userRole = new UserRole(account.getId(), roleMap.get(r));
                userRoleList.add(userRole);
            }
        }
        if (CollUtil.isEmpty(accountList)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        List stringList = accountList.stream().map(ElsSubAccount::getSubAccount).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select(new SFunction[]{ElsSubAccount::getSubAccount});
        ((LambdaQueryWrapper)queryWrapper.in(ElsSubAccount::getSubAccount, stringList)).eq(BaseEntity::getElsAccount, (Object)elsAccount);
        List checkList = this.elsSubAccountService.list((Wrapper)queryWrapper);
        List existAccountList = checkList.stream().map(ElsSubAccount::getSubAccount).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(existAccountList)) {
            oldData.forEach((subAccount, data) -> {
                if (existAccountList.contains(subAccount)) {
                    String msg = I18nUtil.translate((String)"i18n_alert_HesMKdejJeyWWWWWW_dae4f254", (String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u5b50\u8d26\u53f7");
                    this.errorAdd(excelImportDTO, msg, (Map)data);
                    errorDataList.add(data);
                }
            });
        }
        accountList = accountList.stream().filter(x -> !existAccountList.contains(x.getSubAccount())).collect(Collectors.toList());
        List accountId = accountList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        userRoleList = userRoleList.stream().filter(x -> accountId.contains(x.getUserId())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(accountId)) {
            this.elsSubAccountService.checkTanentParam(elsAccount, Integer.valueOf(accountList.size()));
            this.elsSubAccountService.saveBatch(accountList);
            this.userRoleService.saveBatch(userRoleList);
            this.insertPersonalSetting(accountList);
            List userIdList = accountList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            try {
                this.baseImGroupService.initGroupBatch(userIdList);
            }
            catch (Exception e) {
                log.error("::: \u521d\u59cb\u5316\u7528\u6237\u5206\u7ec4{}\u5931\u8d25==>{}", userIdList, (Object)e.getMessage());
            }
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }

    private void insertPersonalSetting(List<ElsSubAccount> userList) {
        List<String> list = Arrays.asList("EMAIL", "NEWS", "VOICE", "MSG", "WECHAT", "DINGTALK");
        ArrayList<PersonalSetting> personalSettings = new ArrayList<PersonalSetting>();
        for (ElsSubAccount user : userList) {
            for (String str : list) {
                PersonalSetting personalSetting = new PersonalSetting();
                personalSetting.setId(UUID.randomUUID().toString().replace("-", ""));
                personalSetting.setElsAccount(user.getElsAccount());
                personalSetting.setSubAccount(user.getSubAccount());
                personalSetting.setCreateBy(user.getCreateBy());
                personalSetting.setCreateTime(new Date());
                personalSetting.setUpdateBy(user.getUpdateBy());
                personalSetting.setUpdateTime(new Date());
                personalSetting.setReceiveType(str);
                personalSetting.setIsReceive(Integer.valueOf(0));
                personalSettings.add(personalSetting);
            }
        }
        this.personalSettingService.saveBatch(personalSettings);
    }
}

