/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.SupplierGroup;
import com.els.modules.system.entity.SupplierGroupItem;
import com.els.modules.system.mapper.PermissionMapper;
import com.els.modules.system.mapper.SupplierGroupMapper;
import com.els.modules.system.model.TreeModel;
import com.els.modules.system.service.SupplierGroupItemService;
import com.els.modules.system.service.SupplierGroupService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SupplierGroupServiceImpl
extends BaseServiceImpl<SupplierGroupMapper, SupplierGroup>
implements SupplierGroupService {
    @Autowired
    private SupplierGroupItemService supplierGroupItemService;
    @Autowired
    private PermissionMapper permissionMapper;

    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SupplierGroup supplierGroup, List<SupplierGroupItem> supplierGroupItemList) {
        ((SupplierGroupMapper)this.baseMapper).insert((Object)supplierGroup);
        this.insertData(supplierGroup, supplierGroupItemList);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SupplierGroup supplierGroup, List<SupplierGroupItem> supplierGroupItemList) {
        int count = ((SupplierGroupMapper)this.baseMapper).updateById((Object)supplierGroup);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.supplierGroupItemService.deleteByMainId(supplierGroup.getId());
        this.insertData(supplierGroup, supplierGroupItemList);
    }

    private void insertData(SupplierGroup supplierGroup, List<SupplierGroupItem> supplierGroupItemList) {
        if (!CollectionUtils.isEmpty(supplierGroupItemList)) {
            for (SupplierGroupItem entity : supplierGroupItemList) {
                entity.setHeadId(supplierGroup.getId());
                entity.setElsAccount(TenantContext.getTenant());
            }
            this.supplierGroupItemService.saveBatch(supplierGroupItemList, 2000);
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.supplierGroupItemService.deleteByMainId(id);
        ((SupplierGroupMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    public Map<String, Object> queryTreeList() {
        ArrayList<String> ids = new ArrayList<String>();
        List companyList = this.permissionMapper.getLocalCompanyMenuList(TenantContext.getTenant()).stream().filter(o -> "2".equals(o.getMenuAttribute()) || "3".equals(o.getMenuAttribute())).collect(Collectors.toList());
        ArrayList<Permission> list = new ArrayList<Permission>(companyList);
        for (Permission permission : list) {
            ids.add(permission.getId());
            permission.setName(I18nUtil.translate((String)permission.getNameI18nKey(), (String)permission.getName()));
        }
        ArrayList<TreeModel> treeList = new ArrayList<TreeModel>();
        this.getTreeModelList(treeList, list, null);
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        resMap.put("treeList", treeList);
        resMap.put("ids", ids);
        return resMap;
    }

    private void getTreeModelList(List<TreeModel> treeList, List<Permission> metaList, TreeModel temp) {
        for (Permission permission : metaList) {
            String tempPid = permission.getParentId();
            TreeModel tree = new TreeModel(permission.getId(), tempPid, permission.getName(), permission.getRuleFlag(), permission.isLeaf());
            tree.setMenuType(permission.getMenuType());
            if (temp == null && ConvertUtils.isEmpty((Object)tempPid)) {
                treeList.add(tree);
                if (tree.getIsLeaf()) continue;
                this.getTreeModelList(treeList, metaList, tree);
                continue;
            }
            if (temp == null || tempPid == null || !tempPid.equals(temp.getKey())) continue;
            temp.getChildren().add(tree);
            if (tree.getIsLeaf()) continue;
            this.getTreeModelList(treeList, metaList, tree);
        }
    }
}

