/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esign.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.esign.entity.ElsEnterpriseCertificationInfo;
import com.els.modules.electronsign.esign.mapper.ElsEnterpriseCertificationInfoMapper;
import com.els.modules.electronsign.esign.service.ElsEnterpriseCertificationInfoService;
import com.els.modules.electronsign.esign.util.EsignResultAnalysisUtil;
import com.els.modules.electronsign.esign.vo.EnterpriseAuthCallBakVO;
import com.els.modules.electronsign.esign.vo.EnterpriseAuthenticationEO;
import com.els.modules.electronsign.esign.vo.EsignCreateOrgAccountVO;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.system.rpc.service.SystemInvokeOrganizationInfoRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsEnterpriseCertificationInfoServiceImpl
extends BaseServiceImpl<ElsEnterpriseCertificationInfoMapper, ElsEnterpriseCertificationInfo>
implements ElsEnterpriseCertificationInfoService {
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private ElsEnterpriseInfoMapper elsEnterpriseInfoMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SystemInvokeOrganizationInfoRpcService systemInvokeOrganizationInfoRpcService;

    public void saveElsEnterpriseCertificationInfo(ElsEnterpriseCertificationInfo elsEnterpriseCertificationInfo) {
        PurchaseOrganizationInfoDTO organizationInfo;
        elsEnterpriseCertificationInfo.setBusAccount("100000");
        elsEnterpriseCertificationInfo.setCertificationStatus("0");
        ElsEnterpriseInfo enterpriseInfo = this.elsEnterpriseInfoMapper.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            elsEnterpriseCertificationInfo.setEnterpriseId(enterpriseInfo.getId());
            elsEnterpriseCertificationInfo.setEnterpriseName(enterpriseInfo.getName());
        }
        if ("1".equals(elsEnterpriseCertificationInfo.getLoadingCompany()) && (organizationInfo = this.systemInvokeOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", elsEnterpriseCertificationInfo.getCompanyCode())) != null) {
            elsEnterpriseCertificationInfo.setCompanyName(organizationInfo.getOrgName());
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"company_name", (Object)elsEnterpriseCertificationInfo.getCompanyName());
        wrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        if (StringUtils.isNotBlank((CharSequence)elsEnterpriseCertificationInfo.getCreatedAccount())) {
            wrapper.eq((Object)"created_account", (Object)elsEnterpriseCertificationInfo.getCreatedAccount());
        } else {
            wrapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"created_account")).or()).eq((Object)"created_account", (Object)""));
        }
        if (!this.list((Wrapper)wrapper).isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rRCIOMKWxqVBcI_9ebb70f", (String)"\u8be5\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa"));
        }
        ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).insert(elsEnterpriseCertificationInfo);
    }

    public void updateElsEnterpriseCertificationInfo(ElsEnterpriseCertificationInfo elsEnterpriseCertificationInfo) {
        PurchaseOrganizationInfoDTO organizationInfo;
        if ("1".equals(elsEnterpriseCertificationInfo.getLoadingCompany()) && (organizationInfo = this.systemInvokeOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", elsEnterpriseCertificationInfo.getCompanyCode())) != null) {
            elsEnterpriseCertificationInfo.setCompanyName(organizationInfo.getOrgName());
        }
        ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).updateById(elsEnterpriseCertificationInfo);
    }

    public void delElsEnterpriseCertificationInfo(String id) {
        ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    public void delBatchElsEnterpriseCertificationInfo(List<String> idList) {
        ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    public Result<?> submitCertification(ElsEnterpriseCertificationInfo certificationInfo) {
        if (StringUtils.isBlank((CharSequence)certificationInfo.getId())) {
            this.saveElsEnterpriseCertificationInfo(certificationInfo);
        } else {
            this.updateElsEnterpriseCertificationInfo(certificationInfo);
        }
        Result response = null;
        if (StringUtils.isBlank((CharSequence)certificationInfo.getOrgId())) {
            EsignCreateOrgAccountVO accountVO = (EsignCreateOrgAccountVO)SysUtil.copyProperties((Object)certificationInfo, EsignCreateOrgAccountVO.class);
            accountVO.setThirdPartyUserId(accountVO.getIdNumber());
            accountVO.setCreator(certificationInfo.getAccountId());
            accountVO.setName(certificationInfo.getCompanyName());
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)accountVO)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("create-org-account"));
            response = EsignResultAnalysisUtil.analysisResult((JSONObject)object);
            if (response.isSuccess()) {
                JSONObject jsonObject = (JSONObject)response.getResult();
                certificationInfo.setOrgId(jsonObject.getString("orgId"));
                this.updateById(certificationInfo);
            } else {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_LiDJKmW_44a47b5", (String)"\u8ba4\u8bc1\u63d0\u4ea4\u5931\u8d25:") + response.getMessage()));
            }
        }
        String notifyUrl = "";
        notifyUrl = this.address.endsWith("/") ? this.address + "els/esign/elsEnterpriseCertificationInfo/callback/enterprise" : this.address + "/els/esign/elsEnterpriseCertificationInfo/callback/enterprise";
        EnterpriseAuthenticationEO authenticationEO = new EnterpriseAuthenticationEO(certificationInfo, notifyUrl);
        JSONObject requestJSON = new JSONObject();
        JSONObject bascis = new JSONObject();
        bascis.put("accountId", (Object)certificationInfo.getOrgId());
        requestJSON.put("base", (Object)bascis);
        requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)authenticationEO)));
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-org-auth-address"));
        response = EsignResultAnalysisUtil.analysisResult((JSONObject)object);
        if (!response.isSuccess()) {
            return Result.error((String)(I18nUtil.translate((String)"i18n_alert_LiDJKmW_44a47b5", (String)"\u8ba4\u8bc1\u63d0\u4ea4\u5931\u8d25:") + response.getMessage()));
        }
        JSONObject jsonObject = (JSONObject)response.getResult();
        certificationInfo.setShortLink(jsonObject.getString("shortLink"));
        certificationInfo.setLongLink(jsonObject.getString("url"));
        certificationInfo.setCertificationFlowId(jsonObject.getString("flowId"));
        certificationInfo.setCertificationStartTime(new Date());
        this.updateById(certificationInfo);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_LiDJLR_296e9080", (String)"\u8ba4\u8bc1\u63d0\u4ea4\u6210\u529f"));
    }

    public Result<?> getCertificationInfo(String id) {
        ElsEnterpriseCertificationInfo certificationInfo = (ElsEnterpriseCertificationInfo)this.getById((Serializable)((Object)id));
        if (certificationInfo != null) {
            JSONObject param = new JSONObject();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("flowId", certificationInfo.getCertificationFlowId());
            param.put("base", map);
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(param, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-auth-info"));
            Result response = EsignResultAnalysisUtil.analysisResult((JSONObject)jsonObject);
            if (!response.isSuccess()) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_tkKm_2f078e83", (String)"\u64cd\u4f5c\u5931\u8d25") + "\uff1a" + response.getMessage()));
            }
            JSONObject data = (JSONObject)response.getResult();
            String status = data.getString("status");
            if (!"SUCCESS".equals(status)) {
                if ("INIT".equals(status)) {
                    return Result.error((String)I18nUtil.translate((String)"i18n_alert_rVHWIhAWLiWtsLLiMWVKdVELCtLiKyHcLiW_763da9fc", (String)"\u8be5\u4fe1\u606f\u201c\u5df2\u53d1\u8d77\u201d\u8ba4\u8bc1\uff0c\u4f46\u8fd8\u672a\u8ba4\u8bc1\u5b8c\uff0c\u8bf7\u5728\u8be6\u60c5\u9875\u9762\u70b9\u51fb\u8ba4\u8bc1\u94fe\u63a5\u8fdb\u884c\u8ba4\u8bc1\uff01"));
                }
                if ("ING".equals(status)) {
                    return Result.error((String)I18nUtil.translate((String)"i18n_alert_rVHjLizELWHcsWWVLyVEoLiMLW_b5d7fad0", (String)"\u8be5\u4fe1\u606f\u7684\u8ba4\u8bc1\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\uff0c\u8bf7\u60a8\u8010\u5fc3\u7b49\u5f85\u8ba4\u8bc1\u5b8c\u6210\uff01"));
                }
                return Result.error((String)I18nUtil.translate((String)"i18n__rVHLizELWIKmWWVLVVLiW_8dcfc898", (String)"\u8be5\u4fe1\u606f\u8ba4\u8bc1\u72b6\u6001\u4e3a\u201c\u5df2\u5931\u8d25\u201d\uff0c\u8bf7\u60a8\u91cd\u65b0\u8ba4\u8bc1\uff01"));
            }
            certificationInfo.setCertificationStatus("1");
            ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).updateById(certificationInfo);
            return Result.ok((String)I18nUtil.translate((String)"i18n_title_operationSuccess", (String)"\u64cd\u4f5c\u6210\u529f\uff01"));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_VNjWWjSWmhxuIdjWFW_5a452366", (String)"\u4f20\u5165\u7684id\u6709\u8bef\uff0c\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff01"));
    }

    public void enterpriseCallBack(JSONObject object) {
        EnterpriseAuthCallBakVO authCallBakVO = (EnterpriseAuthCallBakVO)JSON.parseObject((String)object.toJSONString(), EnterpriseAuthCallBakVO.class);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"certification_flow_id", (Object)authCallBakVO.getFlowId());
        List certificationInfos = this.list((Wrapper)wrapper);
        if (!certificationInfos.isEmpty() && authCallBakVO.isSuccess()) {
            ElsEnterpriseCertificationInfo certificationInfo = (ElsEnterpriseCertificationInfo)certificationInfos.get(0);
            certificationInfo.setCertificationStatus("1");
            certificationInfo.setVerifyCode(authCallBakVO.getVerifycode());
            this.updateById(certificationInfo);
        }
    }

    public Result<?> modifyAuthInfo(ElsEnterpriseCertificationInfo certificationInfo) {
        JSONObject requestJSON = new JSONObject();
        JSONObject bascis = new JSONObject();
        bascis.put("orgId", (Object)certificationInfo.getOrgId());
        requestJSON.put("base", (Object)bascis);
        EsignCreateOrgAccountVO accountVO = (EsignCreateOrgAccountVO)SysUtil.copyProperties((Object)certificationInfo, EsignCreateOrgAccountVO.class);
        accountVO.setThirdPartyUserId(certificationInfo.getId());
        accountVO.setCreator(certificationInfo.getAccountId());
        accountVO.setName(certificationInfo.getCompanyName());
        requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)accountVO)));
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("modify-org-account"));
        Result response = EsignResultAnalysisUtil.analysisResult((JSONObject)object);
        if (!response.isSuccess()) {
            return Result.error((String)(I18nUtil.translate((String)"i18n_alert_crKmW_95bef49b", (String)"\u4fee\u6539\u5931\u8d25:") + response.getMessage()));
        }
        this.updateById(certificationInfo);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_crLR_25ddaeda", (String)"\u4fee\u6539\u6210\u529f"));
    }
}

