/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esign.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.contract.dto.SaleContractHeadDTO;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.electronsign.esign.entity.ElsEsign;
import com.els.modules.electronsign.esign.entity.ElsSigners;
import com.els.modules.electronsign.esign.enumerate.EsignBusTypeEnum;
import com.els.modules.electronsign.esign.enumerate.EsignRoleTypeEnum;
import com.els.modules.electronsign.esign.enumerate.EsignSignerStatusEmun;
import com.els.modules.electronsign.esign.enumerate.EsignStatusEmun;
import com.els.modules.electronsign.esign.enums.SrmPrintBussinessTypeEnum;
import com.els.modules.electronsign.esign.rpc.service.EsignInvokeBaseRpcService;
import com.els.modules.electronsign.esign.rpc.service.EsignInvokeContractRpcService;
import com.els.modules.electronsign.esign.rpc.service.EsignInvokeFinanceRpcService;
import com.els.modules.electronsign.esign.rpc.service.EsignInvokeOrderRpcService;
import com.els.modules.electronsign.esign.service.ElsEsignService;
import com.els.modules.electronsign.esign.service.ElsSignersService;
import com.els.modules.electronsign.esign.service.EsignOperationService;
import com.els.modules.electronsign.esign.util.EsignFileEncryptUtil;
import com.els.modules.electronsign.esign.util.EsignResultAnalysisUtil;
import com.els.modules.electronsign.esign.util.FileHelper;
import com.els.modules.electronsign.esign.util.PdfUtil;
import com.els.modules.electronsign.esign.vo.CreateFlowOneStep;
import com.els.modules.electronsign.esign.vo.ElsEsignVO;
import com.els.modules.electronsign.esign.vo.EsignAttachmentVO;
import com.els.modules.electronsign.esign.vo.EsignCopiersVO;
import com.els.modules.electronsign.esign.vo.EsignDocsVO;
import com.els.modules.electronsign.esign.vo.EsignFlowInfoVO;
import com.els.modules.electronsign.esign.vo.EsignSignerVO;
import com.els.modules.finance.api.enumerate.ConfirmElectronicSignStatusEmun;
import com.els.modules.finance.api.enumerate.ConfirmEsignStatusEnum;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.enumerate.EsignFinalStatusEnum;
import com.els.modules.reconciliation.api.dto.ReconciliationConfirmationDTO;
import com.els.modules.system.dto.ElsPrintConfigDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class EsignOperationServiceImpl
implements EsignOperationService {
    private static final Logger log = LoggerFactory.getLogger(EsignOperationServiceImpl.class);
    private static final Integer A_SIGNED = 2;
    private static final Integer LOSE = 3;
    private static final Integer REFUSAL = 4;
    private static final String SIGN_FLOW_UPDATE = "SIGN_FLOW_UPDATE";
    private static final String SIGN_FLOW_FINISH = "SIGN_FLOW_FINISH";
    @Value(value="${els.path.upload}")
    private String uploadpath;
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private EsignInvokeContractRpcService esignInvokeContractRpcService;
    @Autowired
    private EsignInvokeOrderRpcService esignInvokeOrderRpcService;
    @Resource
    private EsignInvokeFinanceRpcService esignInvokeFinanceRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsEsignService elsEsignService;
    @Autowired
    private ElsSignersService elsSignersService;
    @Autowired
    private EsignInvokeBaseRpcService esignInvokeBaseRpcService;

    public Result<?> uploadFile(ElsEsignVO esign, HttpServletRequest request, HttpServletResponse response) {
        block23: {
            String cookie = request.getHeader("cookie");
            if (StringUtils.isNotBlank((CharSequence)esign.getId())) {
                this.elsEsignService.updateById((Object)esign);
            } else {
                this.elsEsignService.save((Object)esign);
            }
            String busName = null;
            String busVersion = null;
            String busNumber = null;
            if (EsignBusTypeEnum.CONTRACT.getValue().equals(esign.getBusType())) {
                PurchaseContractHeadDTO contractBuyHead = this.esignInvokeContractRpcService.getPurchaseContractById(esign.getRelationId());
                busName = contractBuyHead.getContractName();
                busVersion = contractBuyHead.getContractVersion();
                busNumber = contractBuyHead.getContractNumber();
            } else if (EsignBusTypeEnum.ORDER.getValue().equals(esign.getBusType())) {
                PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.esignInvokeOrderRpcService.getPurchaseOrderById(esign.getRelationId());
                busName = purchaseOrderHeadDTO.getOrderNumber();
                busVersion = purchaseOrderHeadDTO.getOrderVersion();
                busNumber = purchaseOrderHeadDTO.getOrderNumber();
            }
            if (EsignBusTypeEnum.RECONCILIATION_CONFIRMATION.getValue().equals(esign.getBusType())) {
                ReconciliationConfirmationDTO reconciliationConfirmation = this.esignInvokeFinanceRpcService.getPurchaseReconciliationConfirmationById(esign.getRelationId());
                busName = reconciliationConfirmation.getPreparedByNumber();
                busNumber = reconciliationConfirmation.getPreparedByNumber();
            }
            InputStream inputStream = null;
            File file = null;
            try {
                if ("sale".equals(esign.getFirstSeal()) && !"1".equals(esign.getOnlineSealed())) {
                    List attachment = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(esign.getId());
                    if (attachment.isEmpty()) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RCLXVPWQI_dbdd64c5", (String)"\u4f9b\u65b9\u672a\u4e0a\u4f20\u7b7e\u7f72\u6587\u4ef6"));
                    }
                    String tempPath = this.uploadpath + ((PurchaseAttachmentDTO)attachment.get(0)).getFilePath();
                    file = new File(tempPath);
                } else {
                    file = this.getFileById(esign.getRelationId(), esign.getBusType(), busNumber, busVersion, esign.getReportUrl(), esign.getToken(), cookie);
                }
                if (file != null && file.exists()) {
                    String path = file.getPath();
                    log.info("path=" + path);
                    response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes("UTF-8"), "iso-8859-1"));
                    inputStream = new BufferedInputStream(new FileInputStream(file));
                    byte[] bytes = EsignFileEncryptUtil.getFileMD5Bytes1282(inputStream);
                    String contentMD5 = EsignFileEncryptUtil.getStringContentMD5(bytes);
                    int fileSize = bytes.length;
                    EsignAttachmentVO attachmentVO = null;
                    int lastIndexOf = path.lastIndexOf("/");
                    attachmentVO = path.endsWith(".pdf") ? new EsignAttachmentVO(contentMD5, path.substring(lastIndexOf + 1), Integer.valueOf(fileSize), null) : new EsignAttachmentVO(contentMD5, path.substring(lastIndexOf + 1), Integer.valueOf(fileSize), "application/octet-stream");
                    JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSONObject.parseObject((String)JSONObject.toJSONString((Object)attachmentVO)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("upload-file"));
                    Result responseResult = EsignResultAnalysisUtil.analysisResult((JSONObject)object);
                    if (!responseResult.isSuccess()) break block23;
                    JSONObject jsonObject = (JSONObject)responseResult.getResult();
                    String uploadUrl = jsonObject.getString("uploadUrl");
                    String fileId = jsonObject.getString("fileId");
                    esign.setFilesId(fileId);
                    esign.setDeleted(CommonConstant.DEL_FLAG_0);
                    esign.setFilesName(StrUtil.isNotBlank((CharSequence)busName) ? busName : esign.getBusinessScene() + ".pdf");
                    try {
                        FileHelper.streamUpload((String)path, (String)uploadUrl, (String)attachmentVO.getContentMd5());
                        esign.setUploaded("1");
                        this.elsEsignService.updateById((Object)esign);
                        break block23;
                    }
                    catch (Exception e) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_title_uploadError", (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a") + e.getMessage());
                    }
                }
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SMxuXVQI_34a31727", (String)"\u83b7\u53d6\u4e0d\u5230\u4e0a\u4f20\u6587\u4ef6"));
            }
            catch (Exception e) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_title_uploadError", (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a") + e.getMessage());
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                        if (EsignBusTypeEnum.ORDER.getValue().equals(esign.getBusType()) && file != null && file.exists()) {
                            file.delete();
                        }
                    }
                    catch (IOException e) {
                        log.error("printStackTrace:", (Throwable)e);
                    }
                }
            }
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_PWQIXVLR_d4866ee8", (String)"\u7b7e\u7f72\u6587\u4ef6\u4e0a\u4f20\u6210\u529f"));
    }

    public File getFileById(String id, String busType, String busNumber, String busVersion, String reportUrl, String token, String cookie) {
        String path = null;
        if (EsignBusTypeEnum.CONTRACT.getValue().equals(busType)) {
            String html = null;
            HttpHeaders headers = new HttpHeaders();
            headers.add("X-Access-Token", token);
            HttpEntity formEntity = new HttpEntity((MultiValueMap)headers);
            try {
                String url = this.address + "/els/contract/purchaseContractHead/getPreviewData";
                RestTemplate restTemplate = new RestTemplate();
                ResponseEntity responseEntity = restTemplate.exchange(url + "?id=" + id, HttpMethod.GET, formEntity, Result.class, new Object[0]);
                html = ((Result)responseEntity.getBody()).getResult().toString();
            }
            catch (Exception e) {
                log.error("busNumber[{}] getFileById error1:", (Object)busNumber, (Object)e);
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VmQIxOXV_825e3ab8", (String)"\u7a7a\u767d\u6587\u4ef6\u4e0d\u80fd\u4e0a\u4f20"));
            }
            if (StringUtils.isBlank((CharSequence)html)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VmQIxOXV_825e3ab8", (String)"\u7a7a\u767d\u6587\u4ef6\u4e0d\u80fd\u4e0a\u4f20"));
            }
            try {
                log.info("htmlToPdf uploadpath:{},html:{}\uff0cfilename:{}", new Object[]{this.uploadpath, html, busNumber + "_" + busVersion});
                path = PdfUtil.htmlToPdf(this.uploadpath, html, busNumber + "_" + busVersion, null);
            }
            catch (Exception e1) {
                log.error("busNumber[{}] getFileById error2:", (Object)busNumber, (Object)e1);
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QISMKmW_e0294b38", (String)"\u6587\u4ef6\u83b7\u53d6\u5931\u8d25\uff1a") + e1.getMessage());
            }
            log.info("id:{} getFileById is {}", (Object)id, (Object)path);
            File file = new File(path);
            return file;
        }
        if (EsignBusTypeEnum.ORDER.getValue().equals(busType)) {
            ElsPrintConfigDTO printConfigDTO = this.esignInvokeBaseRpcService.getElsPrintConfigByBusType(SysUtil.getLoginUser().getElsAccount(), SrmPrintBussinessTypeEnum.ORDER.getValue());
            if (printConfigDTO == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RRfWERWFWShbLXVQI_5122f3c4", (String)"\u7f3a\u5c11\u6253\u5370\u914d\u7f6e\u6570\u636e\uff0c\u65e0\u6cd5\u751f\u6210\u4e0a\u4f20\u6587\u4ef6"));
            }
            PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.esignInvokeOrderRpcService.getPurchaseOrderById(id);
            if ("ureport".equals(printConfigDTO.getPrintType())) {
                try {
                    File file = new File("tempOrder" + id + ".pdf");
                    file.createNewFile();
                    StringBuffer url = new StringBuffer();
                    url.append(reportUrl).append("/els/report/ureport/pdf?_u=mysql:").append(printConfigDTO.getPrintName()).append("&token=").append(token).append("&id=").append(purchaseOrderHeadDTO.getId());
                    log.info("uReport\u63a5\u53e3\u5730\u5740:{}", (Object)url.toString());
                    ((HttpRequest)((HttpRequest)HttpRequest.get((String)url.toString()).header("cookie", cookie)).header("Referer", reportUrl)).execute().writeBody(file);
                    return file;
                }
                catch (Exception e) {
                    log.error("busNumber[{}] getFileById error3:", (Object)busNumber, (Object)e);
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QISMKmW_e0294b38", (String)"\u6587\u4ef6\u83b7\u53d6\u5931\u8d25\uff1a") + e.getMessage());
                }
            }
        } else if (EsignBusTypeEnum.RECONCILIATION_CONFIRMATION.getValue().equals(busType) && EsignBusTypeEnum.RECONCILIATION_CONFIRMATION.getValue().equals(busType)) {
            try {
                File file = new File("tempOrder" + id + ".pdf");
                file.createNewFile();
                StringBuffer url = new StringBuffer();
                url.append(reportUrl).append("/els/report/ureport/pdf?_u=mysql:purchase_reconciliation_confirmation.ureport.xml").append("&token=").append(token).append("&id=").append(id);
                log.info("uReport\u63a5\u53e3\u5730\u5740:{}", (Object)url.toString());
                ((HttpRequest)((HttpRequest)HttpRequest.get((String)url.toString()).header("cookie", cookie)).header("Referer", reportUrl)).execute().writeBody(file);
                return file;
            }
            catch (Exception e) {
                log.error("busNumber[{}] getFileById error4:", (Object)busNumber, (Object)e);
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QISMKmW_e0294b38", (String)"\u6587\u4ef6\u83b7\u53d6\u5931\u8d25\uff1a") + e.getMessage());
            }
        }
        return null;
    }

    public Result<?> createFlowOneStep(ElsEsign esign) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"head_id", (Object)esign.getId());
        wrapper.eq((Object)"role_type", (Object)"0");
        List purhcaseSigners = this.elsSignersService.list((Wrapper)wrapper);
        wrapper.clear();
        wrapper.eq((Object)"head_id", (Object)esign.getId());
        wrapper.eq((Object)"role_type", (Object)"1");
        List saleSigners = this.elsSignersService.list((Wrapper)wrapper);
        ArrayList<EsignSignerVO> signerVOs = new ArrayList<EsignSignerVO>();
        if ("sale".equals(esign.getFirstSeal())) {
            if (!saleSigners.isEmpty()) {
                signerVOs.add(new EsignSignerVO((ElsSigners)saleSigners.get(0), 1L));
                signerVOs.add(new EsignSignerVO((ElsSigners)purhcaseSigners.get(0), 2L));
            } else {
                signerVOs.add(new EsignSignerVO((ElsSigners)purhcaseSigners.get(0), 1L));
            }
        } else {
            if (!saleSigners.isEmpty()) {
                signerVOs.add(new EsignSignerVO((ElsSigners)saleSigners.get(0), 2L));
            }
            signerVOs.add(new EsignSignerVO((ElsSigners)purhcaseSigners.get(0), 1L));
        }
        String notifyUrl = "";
        notifyUrl = this.address.endsWith("/") ? this.address + "els/esign/esignOperation/callback/esign" : this.address + "/els/esign/esignOperation/callback/esign";
        CreateFlowOneStep flowOneStep = new CreateFlowOneStep();
        flowOneStep.setSigners(signerVOs);
        ArrayList<EsignCopiersVO> copiersVOs = new ArrayList<EsignCopiersVO>();
        EsignCopiersVO copiersVO = new EsignCopiersVO();
        copiersVO.setCopierAccountId(((ElsSigners)purhcaseSigners.get(0)).getAccountId());
        copiersVO.setCopierIdentityAccountId(((ElsSigners)purhcaseSigners.get(0)).getOrgId());
        copiersVO.setCopierIdentityAccountType("1");
        copiersVOs.add(copiersVO);
        flowOneStep.setCopiers(copiersVOs);
        ArrayList<EsignDocsVO> docsVOs = new ArrayList<EsignDocsVO>();
        EsignDocsVO docsVO = new EsignDocsVO();
        docsVO.setFileId(esign.getFilesId());
        docsVO.setFileName(esign.getFilesName());
        docsVOs.add(docsVO);
        flowOneStep.setDocs(docsVOs);
        EsignFlowInfoVO flowInfoVO = new EsignFlowInfoVO(esign, (ElsSigners)purhcaseSigners.get(0), notifyUrl);
        flowOneStep.setFlowInfo(flowInfoVO);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSONObject.parseObject((String)JSONObject.toJSONString((Object)flowOneStep)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("one-step-flow-start"));
        Result response = EsignResultAnalysisUtil.analysisResult((JSONObject)object);
        if (!response.isSuccess()) {
            return Result.error((String)(I18nUtil.translate((String)"i18n_alert_IxPWhAKmW_f40249c7", (String)"\u4e00\u6b65\u7b7e\u7f72\u53d1\u8d77\u5931\u8d25:") + response.getMessage()));
        }
        JSONObject jsonObject = (JSONObject)response.getResult();
        esign.setFlowId(jsonObject.getString("flowId"));
        esign.setLaunch("1");
        esign.setEsignStatus(EsignStatusEmun.UNFINISHED.getValue());
        if ("1".equals(esign.getAutoInitiate())) {
            esign.setInitiate("1");
        }
        this.elsEsignService.updateById((Object)esign);
        ((ElsSigners)purhcaseSigners.get(0)).setFlowId(esign.getFlowId());
        this.elsSignersService.updateById(purhcaseSigners.get(0));
        if (!saleSigners.isEmpty()) {
            ((ElsSigners)saleSigners.get(0)).setFlowId(esign.getFlowId());
            this.elsSignersService.updateById(saleSigners.get(0));
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_hALR_28390cd5", (String)"\u53d1\u8d77\u6210\u529f"));
    }

    public void esignSigner(JSONObject object) {
        log.info("e\u7b7e\u5b9d\u7b7e\u7f72\u6d41\u7a0b\u56de\u8c03[{}]", (Object)object.toJSONString());
        if (SIGN_FLOW_UPDATE.equals(object.getString("action"))) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"flow_id", (Object)object.getString("flowId"));
            wrapper.eq((Object)"account_id", (Object)object.getString("accountId"));
            List signers = this.elsSignersService.list((Wrapper)wrapper);
            if (!signers.isEmpty()) {
                ElsSigners elsSigners = (ElsSigners)signers.get(0);
                if (A_SIGNED.equals(object.getInteger("signResult"))) {
                    elsSigners.setEsignStatus(EsignSignerStatusEmun.A_SIGNED.getValue());
                } else if (LOSE.equals(object.getInteger("signResult"))) {
                    elsSigners.setEsignStatus(EsignSignerStatusEmun.LOSE.getValue());
                    elsSigners.setReason(object.getString("resultDescription"));
                } else if (REFUSAL.equals(object.getInteger("signResult"))) {
                    elsSigners.setEsignStatus(EsignSignerStatusEmun.REFUSAL.getValue());
                    elsSigners.setReason(object.getString("resultDescription"));
                }
                this.elsSignersService.updateById((Object)elsSigners);
                ElsEsign esign = (ElsEsign)this.elsEsignService.getById((Serializable)((Object)elsSigners.getHeadId()));
                if (EsignRoleTypeEnum.PURCHASE.getValue().equals(elsSigners.getRoleType())) {
                    esign.setPurchaseEsignStatus(elsSigners.getEsignStatus());
                } else {
                    esign.setSaleEsignStatus(elsSigners.getEsignStatus());
                }
                this.elsEsignService.updateById((Object)esign);
            }
        } else if (SIGN_FLOW_FINISH.equals(object.getString("action"))) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"flow_id", (Object)object.getString("flowId"));
            List esigns = this.elsEsignService.list((Wrapper)wrapper);
            if (!esigns.isEmpty()) {
                PurchaseOrderHeadDTO purchaseOrderHeadDTO;
                ElsEsign esign = (ElsEsign)esigns.get(0);
                String flowStatus = object.getString("flowStatus");
                esign.setEsignStatus(flowStatus);
                if (EsignStatusEmun.UNDONE.getValue().equals(flowStatus)) {
                    esign.setLaunch("0");
                    esign.setPurchaseEsignStatus(EsignSignerStatusEmun.UNDONE.getValue());
                }
                if (EsignStatusEmun.FINISHED.getValue().equals(flowStatus)) {
                    if ("1".equals(esign.getAutoArchiving())) {
                        esign.setArchiving("1");
                    }
                    esign.setPurchaseEsignStatus(EsignSignerStatusEmun.A_SIGNED.getValue());
                    esign.setSaleEsignStatus(EsignSignerStatusEmun.A_SIGNED.getValue());
                }
                esign.setReason(object.getString("statusDescription"));
                this.elsEsignService.updateById((Object)esign);
                if (EsignBusTypeEnum.CONTRACT.getValue().equals(esign.getBusType())) {
                    PurchaseContractHeadDTO contractHead = this.esignInvokeContractRpcService.getPurchaseContractById(esign.getRelationId());
                    if (contractHead != null) {
                        if ("2".equals(flowStatus) && "1".equals(esign.getAutoArchiving())) {
                            contractHead.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
                        }
                        contractHead.setEndSign(esign.getEsignStatus());
                        this.esignInvokeContractRpcService.updatePurchaseEntityById(contractHead);
                        SaleContractHeadDTO saleContractHead = this.esignInvokeContractRpcService.getSaleContractById(contractHead.getRelationId());
                        if (saleContractHead != null) {
                            saleContractHead.setContractStatus(contractHead.getContractStatus());
                            saleContractHead.setEndSign(contractHead.getEndSign());
                            this.esignInvokeContractRpcService.updateSaleEntityById(saleContractHead);
                        }
                    }
                } else if (EsignBusTypeEnum.ORDER.getValue().equals(esign.getBusType()) && (purchaseOrderHeadDTO = this.esignInvokeOrderRpcService.getPurchaseOrderById(esign.getRelationId())) != null && "2".equals(flowStatus) && "1".equals(esign.getAutoArchiving())) {
                    purchaseOrderHeadDTO.setEsignFinalStatus(EsignFinalStatusEnum.FINAL.getValue());
                    this.esignInvokeOrderRpcService.updatePurchaseOrderById(purchaseOrderHeadDTO);
                    this.esignInvokeOrderRpcService.updateSaleOrderByRelationId(purchaseOrderHeadDTO);
                }
                if (EsignStatusEmun.FINISHED.getValue().equals(esign.getEsignStatus())) {
                    if ("1".equals(esign.getAutoArchiving())) {
                        this.handleConfirmStatus(esign, ConfirmEsignStatusEnum.FINISH.getValue(), ConfirmElectronicSignStatusEmun.FINISH.getValue());
                    } else {
                        this.handleConfirmStatus(esign, ConfirmEsignStatusEnum.ARCHIVED.getValue(), ConfirmElectronicSignStatusEmun.FINISH.getValue());
                    }
                }
                if (EsignStatusEmun.UNDONE.getValue().equals(esign.getEsignStatus())) {
                    this.handleConfirmStatus(esign, null, ConfirmElectronicSignStatusEmun.BACK.getValue());
                }
                if (EsignStatusEmun.EXPIRED.getValue().equals(esign.getEsignStatus())) {
                    this.handleConfirmStatus(esign, null, ConfirmElectronicSignStatusEmun.EXPIRED.getValue());
                }
                if (EsignStatusEmun.REFUSAL.getValue().equals(esign.getEsignStatus())) {
                    this.handleConfirmStatus(esign, null, ConfirmElectronicSignStatusEmun.REFUSAL.getValue());
                }
            }
        }
    }

    private void handleConfirmStatus(ElsEsign esign, String signStatus, String electronicSignStatus) {
        if (!EsignBusTypeEnum.RECONCILIATION_CONFIRMATION.getValue().equals(esign.getBusType())) {
            return;
        }
        ReconciliationConfirmationDTO confirmation = this.esignInvokeFinanceRpcService.getPurchaseReconciliationConfirmationById(esign.getRelationId());
        if (confirmation == null) {
            return;
        }
        if (StrUtil.isNotBlank((CharSequence)signStatus)) {
            confirmation.setSignStatus(signStatus);
        }
        if (StrUtil.isNotBlank((CharSequence)electronicSignStatus)) {
            confirmation.setElectronicSignStatus(electronicSignStatus);
        }
        this.esignInvokeFinanceRpcService.updatePurchaseConfirmationById(confirmation);
        if (StringUtils.isEmpty((CharSequence)confirmation.getRelationId())) {
            return;
        }
        ReconciliationConfirmationDTO purchaseConfirmation = this.esignInvokeFinanceRpcService.getSaleReconciliationConfirmationById(confirmation.getRelationId());
        if (purchaseConfirmation == null) {
            return;
        }
        if (StrUtil.isNotBlank((CharSequence)signStatus)) {
            purchaseConfirmation.setSignStatus(signStatus);
        }
        if (StrUtil.isNotBlank((CharSequence)electronicSignStatus)) {
            purchaseConfirmation.setElectronicSignStatus(electronicSignStatus);
        }
        this.esignInvokeFinanceRpcService.updateSaleConfirmationByRelationId(purchaseConfirmation);
    }

    public Result<?> startFlow(String id) {
        ElsEsign esign = (ElsEsign)this.elsEsignService.getById((Serializable)((Object)id));
        if ("1".equals(esign.getAutoInitiate())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFQLLJOvA_ca4b831f", (String)"\u8be5\u5355\u636e\u6d41\u7a0b\u4e3a\u81ea\u52a8\u5f00\u542f"));
        }
        if (esign != null && StringUtils.isNotBlank((CharSequence)esign.getFlowId())) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("flow-start"));
            Result response = EsignResultAnalysisUtil.analysisResult((JSONObject)object);
            if (!response.isSuccess()) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_QLvAKmW_3418ff05", (String)"\u6d41\u7a0b\u5f00\u8d77\u5931\u8d25:") + response.getMessage()));
            }
            esign.setInitiate("1");
            this.elsEsignService.updateById((Object)esign);
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_QLvALR_536ca7e8", (String)"\u6d41\u7a0b\u5f00\u542f\u6210\u529f"));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFsLhAIxPWQLWShvA_ed94197", (String)"\u8be5\u5355\u636e\u8fd8\u672a\u53d1\u8d77\u4e00\u6b65\u7b7e\u7f72\u6d41\u7a0b\uff0c\u65e0\u6cd5\u5f00\u542f"));
    }

    public Result<?> archiveFlow(String id) {
        ElsEsign esign = (ElsEsign)this.elsEsignService.getById((Serializable)((Object)id));
        if ("1".equals(esign.getAutoArchiving())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFQLLJOLA_ca4ba141", (String)"\u8be5\u5355\u636e\u6d41\u7a0b\u4e3a\u81ea\u52a8\u5f52\u6863"));
        }
        if (esign != null && EsignSignerStatusEmun.A_SIGNED.getValue().equals(esign.getPurchaseEsignStatus()) && EsignSignerStatusEmun.A_SIGNED.getValue().equals(esign.getSaleEsignStatus())) {
            PurchaseOrderHeadDTO purchaseOrderHeadDTO;
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("flow-archive"));
            Result response = EsignResultAnalysisUtil.analysisResult((JSONObject)object);
            if (!response.isSuccess()) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_QLLAKmW_27c1b3eb", (String)"\u6d41\u7a0b\u5f52\u6863\u5931\u8d25:") + response.getMessage()));
            }
            esign.setArchiving("1");
            esign.setEsignStatus(EsignStatusEmun.FINISHED.getValue());
            this.elsEsignService.updateById((Object)esign);
            if (EsignBusTypeEnum.CONTRACT.getValue().equals(esign.getBusType())) {
                PurchaseContractHeadDTO contractHead = this.esignInvokeContractRpcService.getPurchaseContractById(esign.getRelationId());
                if (contractHead != null) {
                    contractHead.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
                    this.esignInvokeContractRpcService.updatePurchaseEntityById(contractHead);
                    SaleContractHeadDTO saleContractHead = this.esignInvokeContractRpcService.getSaleContractById(contractHead.getRelationId());
                    if (saleContractHead != null) {
                        saleContractHead.setContractStatus(contractHead.getContractStatus());
                        this.esignInvokeContractRpcService.updateSaleEntityById(saleContractHead);
                    }
                }
            } else if (EsignBusTypeEnum.ORDER.getValue().equals(esign.getBusType()) && (purchaseOrderHeadDTO = this.esignInvokeOrderRpcService.getPurchaseOrderById(esign.getRelationId())) != null) {
                purchaseOrderHeadDTO.setEsignFinalStatus(EsignFinalStatusEnum.FINAL.getValue());
                this.esignInvokeOrderRpcService.updatePurchaseOrderById(purchaseOrderHeadDTO);
                this.esignInvokeOrderRpcService.updateSaleOrderByRelationId(purchaseOrderHeadDTO);
            }
            this.handleConfirmStatus(esign, ConfirmEsignStatusEnum.ARCHIVED.getValue(), ConfirmElectronicSignStatusEmun.FINISH.getValue());
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_QLLALR_53ddc58a", (String)"\u6d41\u7a0b\u5f52\u6863\u6210\u529f"));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_LPWMLjQLShHcLA_a16b54a3", (String)"\u672a\u7b7e\u7f72\u5b8c\u6210\u7684\u6d41\u7a0b\u65e0\u6cd5\u8fdb\u884c\u5f52\u6863"));
    }
}

