/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.config.EsignV3Properties;
import com.els.modules.electronsign.esign.enumerate.EsignRoleTypeEnum;
import com.els.modules.electronsign.esign.util.FileHelper;
import com.els.modules.electronsign.esignv3.dto.CallBackDto;
import com.els.modules.electronsign.esignv3.dto.FileRp;
import com.els.modules.electronsign.esignv3.dto.FileRq;
import com.els.modules.electronsign.esignv3.dto.SealsAuthRq;
import com.els.modules.electronsign.esignv3.dto.SealsOrgAuthRq;
import com.els.modules.electronsign.esignv3.dto.SealsRp;
import com.els.modules.electronsign.esignv3.dto.SealsRq;
import com.els.modules.electronsign.esignv3.entity.EsignV3SealsAuth;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3Org;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3Seals;
import com.els.modules.electronsign.esignv3.enums.SealAuthStatusEnum;
import com.els.modules.electronsign.esignv3.enums.SealCallBackEnum;
import com.els.modules.electronsign.esignv3.enums.SealRoleEnum;
import com.els.modules.electronsign.esignv3.enums.SealStatusEnum;
import com.els.modules.electronsign.esignv3.mapper.PurchaseEsignV3SealsMapper;
import com.els.modules.electronsign.esignv3.service.EsignV3SealsAuthService;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3OrgService;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3SealsService;
import com.els.modules.electronsign.util.IpassUtil;
import com.els.modules.system.enums.SealsTypeEnum;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseEsignV3SealsServiceImpl
extends BaseServiceImpl<PurchaseEsignV3SealsMapper, PurchaseEsignV3Seals>
implements PurchaseEsignV3SealsService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEsignV3SealsServiceImpl.class);
    @Autowired
    private IpassUtil ipassUtil;
    @Autowired
    private EsignV3Properties esignV3Properties;
    @Autowired
    private EsignV3SealsAuthService esignV3SealsAuthService;
    @Autowired
    private PurchaseEsignV3OrgService purchaseEsignV3OrgService;

    public void add(PurchaseEsignV3Seals purchaseEsignV3Seals) {
        ((PurchaseEsignV3SealsMapper)this.baseMapper).insert((Object)purchaseEsignV3Seals);
    }

    public void edit(PurchaseEsignV3Seals purchaseEsignV3Seals) {
        int count = ((PurchaseEsignV3SealsMapper)this.baseMapper).updateById((Object)purchaseEsignV3Seals);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    public void delete(String id) {
        ((PurchaseEsignV3SealsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    public void deleteBatch(List<String> idList) {
        ((PurchaseEsignV3SealsMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @SrmTransaction(rollbackFor={Exception.class})
    public void uploadToEsign(String id) {
        PurchaseEsignV3Seals seals = (PurchaseEsignV3Seals)this.getById((Serializable)((Object)id));
        String filePath = seals.getFilePath();
        Assert.notNull((Object)filePath, (String)"");
        InputStream inputStream = IpassUtil.getInputStreamFromUrl((String)filePath);
        byte[] bytes = IpassUtil.getFileMD5Bytes128((InputStream)inputStream);
        String contentMD5 = IpassUtil.getFileContentMD5((byte[])bytes);
        FileRq fileRq = new FileRq();
        fileRq.setFileSize(Long.valueOf(bytes.length));
        fileRq.setContentMd5(contentMD5);
        fileRq.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        fileRq.setContentType("application/octet-stream");
        FileRp fileRp = (FileRp)this.ipassUtil.sendRequest((Object)fileRq, "e3-upload-seals", FileRp.class);
        try {
            inputStream = IpassUtil.getInputStreamFromUrl((String)filePath);
            byte[] push = IoUtil.readBytes((InputStream)inputStream);
            FileHelper.streamUploadBytes((byte[])push, (String)fileRp.getFileUploadUrl(), (String)contentMD5, (String)"application/octet-stream");
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_title_uploadError", (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a") + e.getMessage());
        }
        SealsRq sealsRq = new SealsRq();
        BeanUtil.copyProperties((Object)seals, (Object)sealsRq, (String[])new String[0]);
        sealsRq.setSealImageFileKey(fileRp.getFileKey());
        IpassUtil.setNullValue((Object)sealsRq);
        SealsTypeEnum st = SealsTypeEnum.getByCode((String)seals.getSealType());
        SealsRp sealsRp = (SealsRp)this.ipassUtil.sendRequest((Object)sealsRq, st.getIpassCode(), SealsRp.class);
        seals.setSealId(sealsRp.getSealId());
        seals.setSealStatus(SealStatusEnum.BE_AUDIT.getCode());
        this.ipassUtil.callIpassCreateBack(seals.getElsAccount(), seals.getSealId(), this.esignV3Properties.getCallBackUrl() + "/esignv3/purchaseEsignV3Seals/noToken/callback", null);
        this.updateById(seals);
    }

    public void auth(SealsAuthRq sealsAuthRq) {
    }

    public void processCallback(JSONObject jsonObject) {
        CallBackDto.Seal callBackDto = (CallBackDto.Seal)jsonObject.toJavaObject(CallBackDto.Seal.class);
        SealCallBackEnum sealCallBackEnum = SealCallBackEnum.getByCode((String)callBackDto.getAction());
        PurchaseEsignV3Seals purchaseEsignV3Seals = ((PurchaseEsignV3SealsMapper)this.baseMapper).selectByRequestId(callBackDto.getSealId());
        if (ObjectUtil.isNotEmpty((Object)purchaseEsignV3Seals)) {
            this.processDb(purchaseEsignV3Seals, jsonObject, sealCallBackEnum);
        } else {
            try {
                for (int i = 0; i <= 4; ++i) {
                    log.info("\u7b49\u5f85\u6570\u636e\u6267\u884c,{}\u6b21", (Object)i);
                    Thread.sleep(5000L);
                    purchaseEsignV3Seals = ((PurchaseEsignV3SealsMapper)this.baseMapper).selectByRequestId(callBackDto.getSealId());
                    if (!ObjectUtil.isNotEmpty((Object)purchaseEsignV3Seals)) continue;
                    this.processDb(purchaseEsignV3Seals, jsonObject, sealCallBackEnum);
                    return;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public IPage<PurchaseEsignV3Seals> getSignSeal(Page<PurchaseEsignV3Seals> page, String orgId, String psnId, String sealType, String keyWord) {
        return ((PurchaseEsignV3SealsMapper)this.baseMapper).getSignSeal(page, orgId, psnId, sealType, keyWord);
    }

    public PurchaseEsignV3Seals orgAuth(SealsOrgAuthRq rq) {
        PurchaseEsignV3Seals purchaseEsignV3Seals = (PurchaseEsignV3Seals)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(PurchaseEsignV3Seals::getSealId, (Object)rq.getSealId()), false);
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)purchaseEsignV3Seals), (String)"purchaseEsignV3Seals is null");
        PurchaseEsignV3Org org = this.purchaseEsignV3OrgService.getByOrgId(purchaseEsignV3Seals.getOrgId());
        rq.setOrgId(purchaseEsignV3Seals.getOrgId());
        rq.setTransactorPsnId(org.getPsnId());
        rq.setEffectiveTime(Long.valueOf(rq.getEffectiveTimeDate().getTime()));
        rq.setExpireTime(Long.valueOf(rq.getExpireTimeDate().getTime()));
        JSONObject jsonObject = (JSONObject)this.ipassUtil.sendRequest((Object)rq, "e3-seal-org-qqt-auth", JSONObject.class);
        purchaseEsignV3Seals.setAuthorizationSignUrl(jsonObject.getString("authorizationSignUrl"));
        purchaseEsignV3Seals.setEffectiveTime(rq.getEffectiveTimeDate());
        purchaseEsignV3Seals.setExpireTime(rq.getExpireTimeDate());
        this.updateById(purchaseEsignV3Seals);
        return purchaseEsignV3Seals;
    }

    private void processDb(PurchaseEsignV3Seals purchaseEsignV3Seals, JSONObject jsonObject, SealCallBackEnum sealCallBackEnum) {
        sealCallBackEnum.processSeals(purchaseEsignV3Seals, null, jsonObject);
        if (sealCallBackEnum.equals((Object)SealCallBackEnum.SEAL_AUDIT)) {
            this.updateById(purchaseEsignV3Seals);
            if (SealStatusEnum.PASS.getCode().equals(purchaseEsignV3Seals.getSealStatus())) {
                EsignV3SealsAuth esignV3SealsAuth;
                TenantContext.setTenant((String)purchaseEsignV3Seals.getElsAccount());
                PurchaseEsignV3Org purchaseEsignV3Org = (PurchaseEsignV3Org)this.purchaseEsignV3OrgService.getOne((Wrapper)Wrappers.lambdaQuery().eq(PurchaseEsignV3Org::getOrgId, (Object)purchaseEsignV3Seals.getOrgId()), false);
                if (ObjectUtil.isNotEmpty((Object)purchaseEsignV3Org) && StrUtil.isNotBlank((CharSequence)purchaseEsignV3Org.getPsnId()) && ObjectUtil.isEmpty((Object)(esignV3SealsAuth = (EsignV3SealsAuth)this.esignV3SealsAuthService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EsignV3SealsAuth::getSealId, (Object)purchaseEsignV3Seals.getSealId())).eq(EsignV3SealsAuth::getOrgId, (Object)purchaseEsignV3Seals.getOrgId())).eq(EsignV3SealsAuth::getPsnId, (Object)purchaseEsignV3Org.getPsnId())).eq(BaseEntity::getElsAccount, (Object)purchaseEsignV3Seals.getElsAccount()))))) {
                    esignV3SealsAuth = new EsignV3SealsAuth();
                    esignV3SealsAuth.setSealId(purchaseEsignV3Seals.getSealId());
                    esignV3SealsAuth.setSealType(purchaseEsignV3Seals.getSealType());
                    esignV3SealsAuth.setOrgName(purchaseEsignV3Seals.getOrgName());
                    esignV3SealsAuth.setOrgId(purchaseEsignV3Seals.getOrgId());
                    esignV3SealsAuth.setPsnId(purchaseEsignV3Org.getPsnId());
                    esignV3SealsAuth.setPsnName(purchaseEsignV3Org.getPsnName());
                    esignV3SealsAuth.setSubAccount(purchaseEsignV3Org.getSubAccount());
                    esignV3SealsAuth.setSealRole(SealRoleEnum.ORG_ADMIN.getCode());
                    esignV3SealsAuth.setSealStatus(SealAuthStatusEnum.NOT_AUTH.getCode());
                    esignV3SealsAuth.setRoleType(EsignRoleTypeEnum.PURCHASE.getValue());
                    this.esignV3SealsAuthService.save((Object)esignV3SealsAuth);
                }
                TenantContext.clear();
            }
        }
    }
}

