/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.model.TreeModel;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.RolePermissionService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.UserRoleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/account/role"})
public class ElsRoleController {
    private static final Logger log = LoggerFactory.getLogger(ElsRoleController.class);
    @Autowired
    private RoleService roleService;
    @Autowired
    private RolePermissionService rolePermissionService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private UserRoleService userRoleService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"role#Role:list"})
    @PermissionDataView(businessType="role")
    public Result<IPage<Role>> queryPageList(Role role, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)role, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.roleService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @SrmValidated
    @AutoLog(value="\u89d2\u8272\u7ba1\u7406-\u6dfb\u52a0", operateType=2)
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"role#Role:add"})
    @PermissionDataOpt(businessType="role", beanClass=RoleService.class)
    public Result<Role> add(@RequestBody Role role) {
        Result result = new Result();
        try {
            if ("admin".equals(role.getRoleCode())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rAoxqjW_f0f8782b", (String)"\u8be5\u7f16\u7801\u4e0d\u53ef\u7528\uff01"));
            }
            role.setCreateTime(new Date());
            this.roleService.save((Object)role);
            result.success(I18nUtil.translate((String)"i18n_alert_SuLRW_34dd402d", (String)"\u6dfb\u52a0\u6210\u529f\uff01"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500(I18nUtil.translate((String)"i18n_alert_tkKm_2f078e83", (String)"\u64cd\u4f5c\u5931\u8d25"));
        }
        return result;
    }

    @SrmValidated
    @AutoLog(value="\u89d2\u8272\u7ba1\u7406-\u6dfb\u52a0\u89d2\u8272\u7528\u6237", operateType=2)
    @PostMapping(value={"/addRoleUser"})
    @RequiresPermissions(value={"role#Role:userSetting"})
    public Result<?> addRoleUser(@RequestParam(value="userId") String userId, @RequestParam(value="roleId") String roleId) {
        this.roleService.addRoleUser(userId, roleId);
        return Result.ok();
    }

    @SrmValidated
    @AutoLog(value="\u89d2\u8272\u7ba1\u7406-\u79fb\u9664\u89d2\u8272\u7528\u6237", operateType=4)
    @PostMapping(value={"/removeRoleUser"})
    @RequiresPermissions(value={"role#Role:userSetting"})
    public Result<?> removeRoleUser(@RequestParam(value="userId") String userId, @RequestParam(value="roleId") String roleId) {
        this.roleService.removeRoleUser(userId, roleId);
        return Result.ok();
    }

    @SrmValidated
    @AutoLog(value="\u89d2\u8272\u7ba1\u7406-\u590d\u5236", operateType=2)
    @RequestMapping(value={"/copy"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"role#Role:copy"})
    public Result<Role> copy(@RequestBody Role role) {
        Result result = new Result();
        try {
            if ("admin".equals(role.getRoleCode())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rAoxqjW_f0f8782b", (String)"\u8be5\u7f16\u7801\u4e0d\u53ef\u7528\uff01"));
            }
            role.setCreateTime(new Date());
            this.roleService.copy(role);
            result.success(I18nUtil.translate((String)"i18n_title_operationSuccess", (String)"\u64cd\u4f5c\u6210\u529f\uff01"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500(I18nUtil.translate((String)"i18n_alert_tkKm_2f078e83", (String)"\u64cd\u4f5c\u5931\u8d25"));
        }
        return result;
    }

    @SrmValidated
    @AutoLog(value="\u89d2\u8272\u7ba1\u7406-\u7f16\u8f91", operateType=3)
    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"role#Role:edit"})
    @PermissionDataOpt(businessType="role", beanClass=RoleService.class)
    public Result<Role> edit(@RequestBody Role role) {
        Result result = new Result();
        Role sysrole = (Role)this.roleService.getById((Serializable)((Object)role.getId()));
        if (sysrole == null) {
            result.error500(I18nUtil.translate((String)"i18n_alert_LYuIdKD_12f57c8c", (String)"\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53"));
        } else {
            role.setUpdateTime(new Date());
            boolean ok = this.roleService.updateById((Object)role);
            if (ok) {
                result.success("\u4fee\u6539\u6210\u529f!");
            }
        }
        return result;
    }

    @AutoLog(value="\u89d2\u8272\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664", operateType=4)
    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"role#Role:delete"})
    @PermissionDataOpt(businessType="role", beanClass=RoleService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        Result result = new Result();
        Role sysrole = (Role)this.roleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant()));
        if (sysrole == null) {
            return Result.ok();
        }
        if ("companyAdmin".equals(sysrole.getRoleCode()) || "admin".equals(sysrole.getRoleCode())) {
            result.error500("admin/companyAdmin " + I18nUtil.translate((String)"i18n_alert_KyxOQG_81e65bb4", (String)"\u89d2\u8272\u4e0d\u80fd\u5220\u9664\uff01"));
            return result;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{UserRole::getId});
        ((LambdaQueryWrapper)wrapper.eq(UserRole::getRoleId, (Object)id)).last(" limit 1");
        UserRole one = (UserRole)this.userRoleService.getOne((Wrapper)wrapper);
        if (null != one) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5f53\u524d\u89d2\u8272\u5df2\u5173\u8054\u7528\u6237\uff0c\u65e0\u6cd5\u5220\u9664!"));
        }
        this.roleService.deleteRole(id);
        return Result.ok();
    }

    @RequiresPermissions(value={"role#Role:view"})
    @RequestMapping(value={"/queryById"}, method={RequestMethod.GET})
    public Result<Role> queryById(@RequestParam(name="id") String id) {
        Result result = new Result();
        Role sysrole = (Role)this.roleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant()));
        if (sysrole == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)sysrole);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/queryall"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"role#Role:queryAll"})
    public Result<List<Role>> queryall() {
        Result result = new Result();
        List list = this.roleService.list();
        if (list == null || list.size() <= 0) {
            result.error500("\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f");
        } else {
            result.setResult((Object)list);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/queryAllByAccount/{elsAccount}"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"role#Role:queryAll"})
    public Result<List<Role>> queryAllByAccount(@PathVariable(value="elsAccount") String elsAccount) {
        String currentAccount = TenantContext.getTenant();
        TenantContext.setTenant((String)elsAccount);
        Result result = new Result();
        List list = this.roleService.list();
        if (list == null || list.size() <= 0) {
            result.error500("\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f");
        } else {
            result.setResult((Object)list);
            result.setSuccess(true);
        }
        TenantContext.setTenant((String)currentAccount);
        return result;
    }

    @AutoLog(value="\u89d2\u8272\u7ba1\u7406-\u4fdd\u5b58\u6570\u636e\u89c4\u5219\u81f3\u89d2\u8272\u83dc\u5355\u5173\u8054", operateType=2)
    @PostMapping(value={"/datarule"})
    @RequiresPermissions(value={"role#Role:datarule"})
    public Result<?> saveDatarule(@RequestBody JSONObject jsonObject) {
        try {
            String permissionId = jsonObject.getString("permissionId");
            String roleId = jsonObject.getString("roleId");
            String dataRuleIds = jsonObject.getString("dataRuleIds");
            log.info("\u4fdd\u5b58\u6570\u636e\u89c4\u5219>>\u83dc\u5355ID:" + permissionId + "\u89d2\u8272ID:" + roleId + "\u6570\u636e\u6743\u9650ID:" + dataRuleIds);
            LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RolePermission::getPermissionId, (Object)permissionId)).eq(RolePermission::getRoleId, (Object)roleId);
            RolePermission sysRolePermission = (RolePermission)this.rolePermissionService.getOne((Wrapper)query);
            if (sysRolePermission == null) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_VWsMKyntbWW_4190cc2f", (String)"\u8bf7\u5148\u4fdd\u5b58\u89d2\u8272\u83dc\u5355\u6743\u9650!"));
            }
            sysRolePermission.setDataRuleIds(dataRuleIds);
            this.rolePermissionService.updateById((Object)sysRolePermission);
        }
        catch (Exception e) {
            log.error("SysRoleController.saveDatarule()\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_sMKm_25b0066f", (String)"\u4fdd\u5b58\u5931\u8d25"));
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_savaSuccess", (String)"\u4fdd\u5b58\u6210\u529f!"));
    }

    @AutoLog(value="\u89d2\u8272\u7ba1\u7406-\u8be2\u83dc\u5355\u6743\u9650\u6811", operateType=1)
    @RequestMapping(value={"/queryTreeList"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"role#Role:list"})
    public Result<Map<String, Object>> queryTreeList() {
        Result result = new Result();
        ArrayList<String> ids = new ArrayList<String>();
        try {
            Object companyList;
            ArrayList<Permission> list = null;
            String elsAccount = TenantContext.getTenant();
            String adminFlag = AdminFlagUtil.getAdminFlag();
            if ("100000".equals(elsAccount)) {
                if ("1".equals(adminFlag)) {
                    LambdaQueryWrapper query = new LambdaQueryWrapper();
                    query.eq(Permission::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
                    query.eq(Permission::getElsAccount, (Object)elsAccount);
                    query.orderByAsc(Permission::getSortNo);
                    list = this.permissionService.list((Wrapper)query);
                } else {
                    companyList = this.permissionService.queryByAccount(elsAccount, SysUtil.getLoginUser().getSubAccount(), Integer.valueOf(0));
                    list = SysUtil.copyProperties((List)companyList, Permission.class);
                }
            } else {
                companyList = null;
                companyList = "1".equals(adminFlag) ? this.permissionService.getCompanyMenuList(elsAccount) : this.permissionService.queryByAccount(elsAccount, SysUtil.getLoginUser().getSubAccount(), Integer.valueOf(0));
                list = new ArrayList(companyList);
            }
            for (Permission sysPer : list) {
                ids.add(sysPer.getId());
            }
            ArrayList<TreeModel> treeList = new ArrayList<TreeModel>();
            this.getTreeModelList(treeList, list, null);
            HashMap<String, ArrayList<Object>> resMap = new HashMap<String, ArrayList<Object>>();
            resMap.put("treeList", treeList);
            resMap.put("ids", ids);
            result.setResult(resMap);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void getTreeModelList(List<TreeModel> treeList, List<Permission> metaList, TreeModel temp) {
        for (Permission permission : metaList) {
            String tempPid = permission.getParentId();
            TreeModel tree = new TreeModel(permission.getId(), tempPid, permission.getName(), permission.getRuleFlag(), permission.isLeaf());
            tree.setMenuType(permission.getMenuType());
            if (temp == null && ConvertUtils.isEmpty((Object)tempPid)) {
                treeList.add(tree);
                if (tree.getIsLeaf()) continue;
                this.getTreeModelList(treeList, metaList, tree);
                continue;
            }
            if (temp == null || tempPid == null || !tempPid.equals(temp.getKey())) continue;
            temp.getChildren().add(tree);
            if (tree.getIsLeaf()) continue;
            this.getTreeModelList(treeList, metaList, tree);
        }
    }
}

