/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.listener;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.trace.TraceIdHolder;
import com.els.common.trace.TraceIdUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.base.api.dto.MqMessagePersistenceDTO;
import com.els.modules.system.listener.schedule.DynamicScheduleJob;
import com.els.modules.system.listener.schedule.PermissionScheduledBuilder;
import com.els.modules.system.rpc.service.InvokeBaseRpcService;
import com.els.modules.system.service.PermissionService;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component(value="rebuildSaleMenuListener")
@EnableScheduling
public class RebuildSaleMenuListener
implements InitializingBean,
DynamicScheduleJob {
    private static final Logger log = LoggerFactory.getLogger(RebuildSaleMenuListener.class);
    @Resource
    private PermissionService permissionServiceImpl;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource(name="permissionScheduledBuilder")
    private PermissionScheduledBuilder permissionScheduledBuilder;
    private static final String JOBAUTHORIZE = "Srm:sale_jobauthorize:id:";

    @Bean(value={"inputReBuildSaleMenu"})
    public Consumer<String> receive() {
        return msgBody -> {
            try {
                if (StringUtils.isBlank((CharSequence)msgBody)) {
                    return;
                }
                JSONObject body = JSONObject.parseObject((String)msgBody);
                try {
                    String traceId = body.getString("traceId");
                    if (CharSequenceUtil.isEmpty((CharSequence)traceId)) {
                        traceId = "JOBAUTHORIZE" + TraceIdUtil.generateJobTraceId();
                        body.put("traceId", (Object)traceId);
                    }
                    TraceIdHolder.set((String)traceId);
                    log.info(":::\u63a5\u53d7\u5230\u6765\u81ea\u91c7\u8d2d\u8ba2\u5355\u53d8\u66f4\u6743\u9650\uff0c\u66f4\u6539\u9500\u552e\u6743\u9650\u7684\u6570\u636e\u4fe1\u606f:{}", (Object)body);
                    List dtoList = this.permissionServiceImpl.rebuildSaleMenuByMsg(body);
                    List elsAccountList = body.getJSONArray("elsAccount").toJavaList(String.class);
                    String purchase = (String)elsAccountList.get(0);
                    log.info("{}\u5bf9\u91c7\u8d2d:{}\u7684\u4f9b\u5e94\u5546\u8fdb\u884c\u6388\u6743\u5f00\u59cb", (Object)traceId, (Object)purchase);
                    this.run(dtoList);
                    log.info("{}\u5bf9\u91c7\u8d2d:{}\u7684\u4f9b\u5e94\u5546\u8fdb\u884c\u6388\u6743\u7ed3\u675f", (Object)traceId, (Object)purchase);
                }
                finally {
                    TraceIdHolder.remove();
                }
            }
            catch (Exception e) {
                log.error(":::MQ\u91cd\u65b0\u6784\u5efa\u9500\u552e\u83dc\u5355\u5f02\u5e38:{},error:{}", msgBody, (Object)e.getMessage());
                throw e;
            }
        };
    }

    private void run(List<MqMessagePersistenceDTO> dtos) {
        for (MqMessagePersistenceDTO dto : dtos) {
            boolean b = this.redisUtil.hasKey(JOBAUTHORIZE + dto.getId());
            if (b) continue;
            this.redisUtil.set(JOBAUTHORIZE + dto.getId(), (Object)dto.getId(), 86400L);
            JSONObject body = JSONObject.parseObject((String)dto.getMessageData());
            try {
                String elsAccount = body.getString("elsAccount");
                List toElsAccountList = body.getJSONArray("toElsAccountList").toJavaList(String.class);
                List addList = body.getJSONArray("addList").toJavaList(String.class);
                List deleteList = body.getJSONArray("deleteList").toJavaList(String.class);
                this.permissionServiceImpl.buildSaleMenu(toElsAccountList, elsAccount, addList, deleteList);
                dto.setSuccessFlag("1");
                dto.setUpdateTime(new Date());
            }
            catch (Exception e) {
                log.error(":::\u91cd\u65b0\u6784\u5efa\u9500\u552e\u83dc\u5355\u5f02\u5e38:{},error:{}", (Object)e.getMessage());
                Integer errorTimes = (Integer)ObjectUtil.defaultIfNull((Object)dto.getErrorTimes(), (Object)0);
                if (errorTimes >= 1) {
                    dto.setSuccessFlag("0");
                } else {
                    dto.setErrorTimes(Integer.valueOf(errorTimes + 1));
                }
                dto.setUpdateTime(new Date());
                dto.setErrorMessage(CharSequenceUtil.isEmpty((CharSequence)e.getMessage()) ? "\u91cd\u65b0\u6784\u5efa\u9500\u552e\u83dc\u5355\u5f02\u5e38" : e.getMessage());
            }
            this.invokeBaseRpcService.update(dto);
        }
    }

    @Scheduled(cron="0 0 2 ? * *")
    public void deleteChangePermissionScheduled() {
        this.invokeBaseRpcService.deleteLog(null);
    }

    public void afterPropertiesSet() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec() {
        try {
            log.info("\u7b2c\u4e00\u6b65:\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u5904\u7406\u83dc\u5355\u6388\u6743, dealChangePermissionScheduled");
            List dtos = this.invokeBaseRpcService.listToJob("permission", "changePermission");
            for (MqMessagePersistenceDTO dto : dtos) {
                boolean b = this.redisUtil.hasKey(JOBAUTHORIZE + dto.getId());
                if (b) continue;
                this.redisUtil.set(JOBAUTHORIZE + dto.getId(), (Object)dto.getId(), 86400L);
                JSONObject body = JSONObject.parseObject((String)dto.getMessageData());
                try {
                    String elsAccount = body.getString("elsAccount");
                    List toElsAccountList = body.getJSONArray("toElsAccountList").toJavaList(String.class);
                    List addList = body.getJSONArray("addList").toJavaList(String.class);
                    List deleteList = body.getJSONArray("deleteList").toJavaList(String.class);
                    String traceId = body.getString("traceId");
                    if (CharSequenceUtil.isNotEmpty((CharSequence)traceId)) {
                        TraceIdHolder.set((String)traceId);
                    }
                    this.permissionServiceImpl.buildSaleMenu(toElsAccountList, elsAccount, addList, deleteList);
                    dto.setSuccessFlag("1");
                    dto.setUpdateTime(new Date());
                }
                catch (Exception e) {
                    log.error(":::\u91cd\u65b0\u6784\u5efa\u9500\u552e\u83dc\u5355\u5f02\u5e38:{},error:{}", (Object)e.getMessage());
                    Integer errorTimes = (Integer)ObjectUtil.defaultIfNull((Object)dto.getErrorTimes(), (Object)0);
                    if (errorTimes >= 1) {
                        dto.setSuccessFlag("0");
                    } else {
                        dto.setErrorTimes(Integer.valueOf(errorTimes + 1));
                    }
                    dto.setUpdateTime(new Date());
                    dto.setErrorMessage(CharSequenceUtil.isEmpty((CharSequence)e.getMessage()) ? "\u91cd\u65b0\u6784\u5efa\u9500\u552e\u83dc\u5355\u5f02\u5e38" : e.getMessage());
                }
                this.invokeBaseRpcService.update(dto);
            }
        }
        finally {
            TraceIdHolder.remove();
        }
    }

    public String beanName() {
        return "rebuildSaleMenuListener";
    }
}

