/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.fadada.entity.SaleFadadaOrg;
import com.els.modules.electronsign.fadada.entity.SaleFadadaSealPsn;
import com.els.modules.electronsign.fadada.enums.FadadaSealStatusEnum;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaOrgMapper;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaSealPsnMapper;
import com.els.modules.electronsign.fadada.service.SaleFadadaSealPsnService;
import com.els.modules.electronsign.fadada.util.FadadaCallUtil;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleFadadaSealPsnServiceImpl
extends BaseServiceImpl<SaleFadadaSealPsnMapper, SaleFadadaSealPsn>
implements SaleFadadaSealPsnService {
    @Autowired
    private FadadaCallUtil fadadaCallUtil;
    @Autowired
    private SaleFadadaOrgMapper saleFadadaOrgMapper;

    @Override
    public void add(SaleFadadaSealPsn saleFadadaSealPsn) {
        QueryWrapper saleFadadaSealPsnQueryWrapper = new QueryWrapper();
        saleFadadaSealPsnQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        saleFadadaSealPsnQueryWrapper.eq((Object)"seal_id", (Object)saleFadadaSealPsn.getSealId());
        saleFadadaSealPsnQueryWrapper.eq((Object)"bus_account", (Object)saleFadadaSealPsn.getBusAccount());
        saleFadadaSealPsnQueryWrapper.eq((Object)"member_id", (Object)saleFadadaSealPsn.getMemberId());
        if (this.getOne((Wrapper)saleFadadaSealPsnQueryWrapper) != null) {
            throw new ELSBootException("\u6210\u5458 " + saleFadadaSealPsn.getMemberName() + " \u7684 " + saleFadadaSealPsn.getSealName() + " \u6743\u9650\u5df2\u5b58\u5728");
        }
        ((SaleFadadaSealPsnMapper)this.baseMapper).insert((Object)saleFadadaSealPsn);
    }

    @Override
    public void edit(SaleFadadaSealPsn saleFadadaSealPsn) {
        this.editHandle(saleFadadaSealPsn);
        int count = ((SaleFadadaSealPsnMapper)this.baseMapper).updateById((Object)saleFadadaSealPsn);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    public void editHandle(SaleFadadaSealPsn saleFadadaSealPsn) {
        QueryWrapper saleFadadaSealPsnQueryWrapper = new QueryWrapper();
        saleFadadaSealPsnQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        saleFadadaSealPsnQueryWrapper.eq((Object)"bus_account", (Object)saleFadadaSealPsn.getBusAccount());
        saleFadadaSealPsnQueryWrapper.eq((Object)"seal_id", (Object)saleFadadaSealPsn.getSealId());
        saleFadadaSealPsnQueryWrapper.eq((Object)"member_id", (Object)saleFadadaSealPsn.getMemberId());
        SaleFadadaSealPsn fadadaSealPsn = (SaleFadadaSealPsn)((Object)this.getOne((Wrapper)saleFadadaSealPsnQueryWrapper));
        if (fadadaSealPsn != null && !fadadaSealPsn.getId().equals(saleFadadaSealPsn.getId())) {
            throw new ELSBootException("\u6210\u5458 " + saleFadadaSealPsn.getMemberName() + " \u7684 " + saleFadadaSealPsn.getSealName() + " \u6743\u9650\u5df2\u5b58\u5728");
        }
    }

    @Override
    public void delete(String id) {
        ((SaleFadadaSealPsnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleFadadaSealPsnMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void sealGrantUrl(SaleFadadaSealPsn saleFadadaSealPsn) {
        if (StringUtils.isBlank((CharSequence)saleFadadaSealPsn.getId())) {
            this.add(saleFadadaSealPsn);
        } else {
            this.edit(saleFadadaSealPsn);
        }
        JSONObject requestObject = new JSONObject();
        requestObject.put("openCorpId", (Object)saleFadadaSealPsn.getOpenCorpId());
        requestObject.put("sealId", (Object)saleFadadaSealPsn.getSealId());
        requestObject.put("redirectUrl", (Object)this.fadadaCallUtil.getRedirectUrl());
        QueryWrapper saleFadadaOrgQueryWrapper = new QueryWrapper();
        saleFadadaOrgQueryWrapper.eq((Object)"open_corp_id", (Object)saleFadadaSealPsn.getOpenCorpId());
        saleFadadaOrgQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        SaleFadadaOrg saleFadadaOrg = (SaleFadadaOrg)((Object)this.saleFadadaOrgMapper.selectOne((Wrapper)saleFadadaOrgQueryWrapper));
        if (saleFadadaOrg != null) {
            requestObject.put("clientUserId", (Object)saleFadadaOrg.getClientUserId());
        }
        JSONObject memberInfo = new JSONObject();
        Long[] memberIds = new Long[]{Long.parseLong(saleFadadaSealPsn.getMemberId())};
        memberInfo.put("memberIds", (Object)memberIds);
        if (saleFadadaSealPsn.getGrantStartTime() != null) {
            memberInfo.put("grantStartTime", (Object)saleFadadaSealPsn.getGrantStartTime().getTime());
        }
        if (saleFadadaSealPsn.getGrantEndTime() != null) {
            memberInfo.put("grantEndTime", (Object)saleFadadaSealPsn.getGrantEndTime().getTime());
        }
        requestObject.put("memberInfo", (Object)memberInfo);
        requestObject.put("currentAccount", (Object)saleFadadaSealPsn.getBusAccount());
        JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_seal_grant");
        saleFadadaSealPsn.setSealGrantUrl(response.getString("sealGrantUrl"));
        saleFadadaSealPsn.setGrantStatus(FadadaSealStatusEnum.to_be_effective.getValue());
        ((SaleFadadaSealPsnMapper)this.baseMapper).updateById((Object)saleFadadaSealPsn);
    }
}

