/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.jdyxc.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseCreateAccountDto;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.dto.ConnectorConfigDTO;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.mapper.ThirdAccountMapper;
import com.els.modules.third.base.entity.ThirdPartyInstance;
import com.els.modules.third.base.entity.ThirdPartyInstanceXc;
import com.els.modules.third.base.enums.ThirdTypeEnum;
import com.els.modules.third.base.mapper.ThirdPartyInstanceMapper;
import com.els.modules.third.base.mapper.ThirdPartyInstanceXcMapper;
import com.els.modules.third.base.vo.ThirdPartyInstanceAndXcVo;
import com.els.modules.third.jdyxc.service.vo.OrderInstanceCallBackVO;
import com.els.modules.third.jdyxc.util.XcUtil;
import com.els.modules.third.util.CreateAccountUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class BizBusinessManager {
    private static final Logger log = LoggerFactory.getLogger(BizBusinessManager.class);
    public static String EXTERNAL_SYSTEM = "external_system";
    private String CLOUD_MARKET = "rocketmq.xcCallOrder.sendOrder";

    protected Boolean checkForUserId(String userId) {
        ThirdAccountMapper accountMapper = (ThirdAccountMapper)SpringContextUtils.getBean(ThirdAccountMapper.class);
        List list = accountMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(ThirdAccount::getUserId, (Object)userId));
        return CollectionUtils.isEmpty((Collection)list);
    }

    protected ThirdPartyInstanceAndXcVo getThirdPartyInstanceAndXcVo(String id) {
        ThirdPartyInstanceMapper instanceMapper = (ThirdPartyInstanceMapper)SpringContextUtils.getBean(ThirdPartyInstanceMapper.class);
        ThirdPartyInstanceXcMapper instanceXcMapper = (ThirdPartyInstanceXcMapper)SpringContextUtils.getBean(ThirdPartyInstanceXcMapper.class);
        ThirdPartyInstanceAndXcVo result = new ThirdPartyInstanceAndXcVo();
        log.info("BizBusinessManager-->getThirdPartyInstanceAndXcVo id\uff1a{}", (Object)id);
        ThirdPartyInstance instance = (ThirdPartyInstance)instanceMapper.selectById((Serializable)((Object)id));
        if (instance == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKAcWSMKm_6df691b2", (String)"\u4e0d\u5b58\u5728\u7c7b\u578b\uff0c\u83b7\u53d6\u5931\u8d25"));
        }
        ThirdPartyInstanceXc thirdPartyInstanceXc = (ThirdPartyInstanceXc)instanceXcMapper.selectById((Serializable)((Object)instance.getThirdId()));
        BeanUtils.copyProperties((Object)instance, (Object)result);
        BeanUtils.copyProperties((Object)thirdPartyInstanceXc, (Object)result);
        result.setId(instance.getId());
        return result;
    }

    protected ThirdPartyInstanceAndXcVo handlerOrderInfo(String orderIdEncry, Long orderId) throws Exception {
        log.info("BizBusinessManager-->handlerOrderInfo orderId\uff1a{}, orderIdEncry\uff1a{}", (Object)orderIdEncry, (Object)orderIdEncry);
        ThirdPartyInstanceAndXcVo dbXcVO = this.findThirdPartInstanceByOrderId(orderId.toString());
        if (null != dbXcVO) {
            return dbXcVO;
        }
        JSONObject detail = this.getOrderDetail(orderIdEncry);
        JSONObject orderInfo = detail.getJSONObject("orderInfo");
        JSONObject appInfo = detail.getJSONObject("appInfo");
        JSONObject buyerInfo = detail.getJSONObject("buyerInfo");
        JSONObject buyerCompanyInfo = detail.getJSONObject("buyerCompanyInfo");
        Integer buyTime = orderInfo.getInteger("buyTime");
        Long paytime = orderInfo.getLong("paytime");
        String appId = appInfo.getString("appId");
        String appName = appInfo.getString("appName");
        String unionId = buyerInfo.getString("unionId");
        String userName = buyerInfo.getString("userName");
        Date date = new Date();
        BaseCreateAccountDto accountDto = new BaseCreateAccountDto();
        accountDto.setUserUuid(orderId.toString() + "-" + buyerInfo.getString("unionId"));
        accountDto.setPhoneNumber(buyerInfo.getString("phone"));
        accountDto.setSubName(buyerInfo.getString("userName"));
        accountDto.setThirdType(ThirdTypeEnum.THIRD_JD_XC.getValue());
        accountDto.setSourceType(EXTERNAL_SYSTEM);
        if (null != buyerCompanyInfo && buyerCompanyInfo.containsKey((Object)"companyName")) {
            accountDto.setCompanyName(buyerCompanyInfo.getString("companyName"));
        } else {
            accountDto.setCompanyName("\u661f\u8fb0\u4e91\u5e02\u573a_" + this.getCompanyNumber());
        }
        String elsAccount = CreateAccountUtil.creationProcess(accountDto);
        ThirdPartyInstanceAndXcVo instanceAndXcVo = new ThirdPartyInstanceAndXcVo();
        if (!this.checkForOrderId(orderId.toString())) {
            instanceAndXcVo = this.saveInstance(elsAccount, orderIdEncry, orderId, detail, buyTime, paytime, appId, appName, unionId, userName, date);
            OrderInstanceCallBackVO callBackVO = new OrderInstanceCallBackVO();
            callBackVO.setId(IdWorker.getIdStr());
            callBackVO.setOrderIdEncry(orderIdEncry);
            callBackVO.setInstanceId(Long.valueOf(instanceAndXcVo.getId()));
            callBackVO.setServiceOpenTime(date.getTime());
            callBackVO.setServiceExpireTime(instanceAndXcVo.getInstanceExpireTime().getTime());
            callBackVO.setPushNumber(Double.valueOf("0"));
            callBackVO.setElsAccount("100000");
            JSONObject body = new JSONObject();
            body.put("data", (Object)callBackVO);
            body.put("level", (Object)0);
            MqUtil.sendOrderInstanceCallBack((String)body.toJSONString());
        }
        return instanceAndXcVo;
    }

    protected ThirdAccount getThirdRelationElsAccount(String orderId) {
        ThirdAccountMapper accountMapper = (ThirdAccountMapper)SpringContextUtils.getBean(ThirdAccountMapper.class);
        List list = accountMapper.selectList((Wrapper)new LambdaQueryWrapper().like(ThirdAccount::getThirdUserUuid, (Object)orderId));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (ThirdAccount)((Object)list.get(0));
        }
        return null;
    }

    protected ElsEnterpriseInfo getElsEnterpriseInfo(String orderId) {
        ThirdPartyInstanceAndXcVo xcVo = this.findThirdPartInstanceByOrderId(orderId);
        if (null == xcVo) {
            return null;
        }
        return ((ElsEnterpriseInfoMapper)SpringContextUtils.getBean(ElsEnterpriseInfoMapper.class)).getByElsAccount(xcVo.getElsAccount());
    }

    protected ThirdPartyInstanceAndXcVo saveInstance(String elsAccount, String orderIdEncry, Long orderId, JSONObject detail, Integer buyTime, Long paytime, String appId, String appName, String unionId, String userName, Date date) {
        ThirdPartyInstanceMapper instanceMapper = (ThirdPartyInstanceMapper)SpringContextUtils.getBean(ThirdPartyInstanceMapper.class);
        ThirdPartyInstanceXcMapper instanceXcMapper = (ThirdPartyInstanceXcMapper)SpringContextUtils.getBean(ThirdPartyInstanceXcMapper.class);
        log.info("BizBusiness-->handlerOrderInfo\u3010show\u3011input \u3010orderIdEncry:{}\u3001orderId:{}\u3001detail:{}\u3001buyTime:{}\u3001paytime:{}\u3001appId:{}\u3001appName:{}\u3001unionId:{}\u3001userName:{}\u3011", new Object[]{orderIdEncry, orderId, JSONObject.toJSONString((Object)detail), buyTime, paytime, appId, appName, unionId, userName});
        String orderNumber = detail.getJSONObject("orderInfo").getString("orderNumber");
        ThirdPartyInstanceAndXcVo instanceVO = new ThirdPartyInstanceAndXcVo();
        instanceVO.setOrderIdEncry(orderIdEncry);
        instanceVO.setElsAccount(elsAccount);
        instanceVO.setOrderNumber(orderNumber);
        instanceVO.setPayTime(new Date(paytime));
        instanceVO.setOrderInfo(this.getString(detail.getJSONObject("orderInfo")));
        instanceVO.setAppInfo(this.getString(detail.getJSONObject("appInfo")));
        instanceVO.setServiceInfo(this.getString(detail.getJSONObject("serviceInfo")));
        instanceVO.setSupplierInfo(this.getString(detail.getJSONObject("supplierInfo")));
        instanceVO.setContactInfo(this.getString(detail.getJSONArray("contactInfoList")));
        instanceVO.setProductEnvtInfo(this.getString(detail.getJSONObject("productEnvtInfo")));
        instanceVO.setBuyerInfo(this.getString(detail.getJSONObject("buyerInfo")));
        instanceVO.setBuyerCompanyInfo(this.getString(detail.getJSONObject("buyerCompanyInfo")));
        instanceVO.setOrderItemSummaryInfo(this.getString(detail.getJSONObject("orderItemSummaryInfoDTO")));
        instanceVO.setApiQuoteInfo(this.getString(detail.getJSONArray("apiQuoteInfoDTOList")));
        instanceVO.setBuyGroups(this.getString(detail.getJSONObject("buyGroups")));
        instanceVO.setGroupGrads(this.getString(detail.getJSONObject("groupGrads")));
        instanceVO.setModelInfos(this.getString(detail.getJSONObject("modelInfos")));
        instanceVO.setBuyFeatures(this.getString(detail.getJSONObject("buyFeatures")));
        instanceVO.setBuyServices(this.getString(detail.getJSONObject("buyServices")));
        instanceVO.setOrderPaymentItemList(this.getString(detail.getJSONArray("orderPaymentItemList")));
        instanceVO.setInstitutionInfo(this.getString(detail.getJSONObject("institutionInfo")));
        instanceVO.setSalesInfo(this.getString(detail.getJSONObject("salesInfo")));
        instanceVO.setOrderId(orderId.toString());
        instanceVO.setAccountId(unionId);
        instanceVO.setAccountName(userName);
        instanceVO.setProductId(appId);
        instanceVO.setProductName(appName);
        instanceVO.setTrial(CommonConstant.STATUS_YES);
        instanceVO.setTimeSpan(buyTime);
        instanceVO.setTimeUnit("m");
        instanceVO.setInstanceExpireTime(this.getInstanceExpireTime(date, buyTime));
        instanceVO.setStatus(CommonConstant.STATUS_NO);
        instanceVO.setNoticeState("1");
        ThirdPartyInstance instance = new ThirdPartyInstance();
        ThirdPartyInstanceXc instanceXc = new ThirdPartyInstanceXc();
        BeanUtils.copyProperties((Object)instanceVO, (Object)instance);
        BeanUtils.copyProperties((Object)instanceVO, (Object)instanceXc);
        instance.setDeleted(CommonConstant.STATUS_NO);
        instance.setStatus(CommonConstant.STATUS_NO);
        instanceXcMapper.insert((Object)instanceXc);
        instance.setThirdType(ThirdTypeEnum.THIRD_JD_XC.getValue());
        instance.setThirdId(instanceXc.getId());
        instanceMapper.insert((Object)instance);
        instanceVO.setId(instance.getId());
        return instanceVO;
    }

    public JSONObject getOrderDetail(String orderIdEncry) {
        String elsAccount = "100000";
        ConnectorConfigDTO configDto = XcUtil.getConnectorConfigDto((String)"100000");
        JSONObject urlParam = new JSONObject();
        urlParam.put("orderIdEncry", (Object)orderIdEncry);
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)elsAccount);
        param.put("srm_interface_code", (Object)"getXCYOrderDetail");
        param.put("url_param", (Object)urlParam);
        param.put("header_param", (Object)XcUtil.buildHeader((String)"/amkapi/order/orderDetail", (String)"GET", (Map)((Map)JSON.parseObject((String)urlParam.toJSONString(), Map.class)), (ConnectorConfigDTO)configDto));
        JSONObject result1 = ((InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class)).callInterface(elsAccount, "", param, (Object)new JSONObject());
        if (!result1.getBoolean("success").booleanValue()) {
            log.error("\u63a5\u53e3\u8bf7\u6c42\u51fa\u9519 {}", (Object)result1.toJSONString());
            throw new ELSBootException("\u63a5\u53e3\u8bf7\u6c42\u51fa\u9519\uff1a" + result1.toJSONString());
        }
        return XcUtil.getResultV2((JSONObject)result1);
    }

    public JSONObject getOrderList() {
        String elsAccount = "100000";
        ConnectorConfigDTO configDto = XcUtil.getConnectorConfigDto((String)"100000");
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)elsAccount);
        param.put("srm_interface_code", (Object)"getXCYOrderList");
        param.put("header_param", (Object)XcUtil.buildHeader((String)"/amkapi/supplier/orderList", (String)"GET", null, (ConnectorConfigDTO)configDto));
        JSONObject result = ((InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class)).callInterface(elsAccount, "", param, (Object)new JSONObject());
        if (!result.getBoolean("success").booleanValue()) {
            log.error("\u63a5\u53e3\u8bf7\u6c42\u51fa\u9519 {}", (Object)result.toJSONString());
            throw new ELSBootException("\u63a5\u53e3\u8bf7\u6c42\u51fa\u9519\uff1a" + result.toJSONString());
        }
        return XcUtil.getResultV2((JSONObject)result);
    }

    protected String getString(JSONObject jsonObject) {
        return JSONObject.toJSONString((Object)jsonObject);
    }

    protected String getString(JSONArray jsonObject) {
        return JSONObject.toJSONString((Object)jsonObject);
    }

    protected Date getInstanceExpireTime(Date date, Integer timeSpan) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, timeSpan);
        return cal.getTime();
    }

    protected String getCompanyNumber() {
        RedisUtil redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
        String result = "1";
        if (redisUtil.hasKey("xc_company_number")) {
            Integer count;
            Integer n = count = (Integer)redisUtil.get("xc_company_number");
            Integer n2 = count = Integer.valueOf(count + 1);
            redisUtil.set("xc_company_number", (Object)count);
            result = count.toString();
        } else {
            redisUtil.set("xc_company_number", (Object)1);
        }
        return result;
    }

    public ThirdPartyInstanceAndXcVo findThirdPartInstanceByOrderId(String orderId) {
        ThirdPartyInstanceXcMapper instanceXcMapper = (ThirdPartyInstanceXcMapper)SpringContextUtils.getBean(ThirdPartyInstanceXcMapper.class);
        ThirdPartyInstanceAndXcVo result = new ThirdPartyInstanceAndXcVo();
        ThirdPartyInstance instance = (ThirdPartyInstance)((ThirdPartyInstanceMapper)SpringContextUtils.getBean(ThirdPartyInstanceMapper.class)).selectOne((Wrapper)new LambdaQueryWrapper().eq(ThirdPartyInstance::getOrderId, (Object)orderId));
        if (null == instance) {
            return null;
        }
        ThirdPartyInstanceXc thirdPartyInstanceXc = (ThirdPartyInstanceXc)instanceXcMapper.selectById((Serializable)((Object)instance.getThirdId()));
        BeanUtils.copyProperties((Object)instance, (Object)result);
        BeanUtils.copyProperties((Object)thirdPartyInstanceXc, (Object)result);
        result.setId(instance.getId());
        return result;
    }

    public boolean checkForOrderId(String orderId) {
        ThirdPartyInstanceMapper instanceMapper = (ThirdPartyInstanceMapper)SpringContextUtils.getBean(ThirdPartyInstanceMapper.class);
        return CollectionUtils.isNotEmpty((Collection)instanceMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(ThirdPartyInstance::getOrderId, (Object)orderId)));
    }

    public void updateNoticeState(String id, String state) {
        ThirdPartyInstance instance = new ThirdPartyInstance();
        instance.setId(id);
        instance.setNoticeState(state);
        ((ThirdPartyInstanceMapper)SpringContextUtils.getBean(ThirdPartyInstanceMapper.class)).updateById((Object)instance);
    }
}

