/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.entity.PermissionGroup;
import com.els.modules.system.entity.PermissionSensitiveField;
import com.els.modules.system.entity.UserPermissionGroup;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.service.PermissionGroupService;
import com.els.modules.system.service.PermissionSensitiveFieldService;
import com.els.modules.system.service.UserPermissionGroupService;
import com.els.modules.system.vo.PermissionGroupVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u6743\u9650\u7ec4"})
@RestController
@RequestMapping(value={"/account/permissionGroup"})
public class PermissionGroupController
extends BaseController<PermissionGroup, PermissionGroupService> {
    @Autowired
    private PermissionGroupService permissionGroupService;
    @Autowired
    private UserPermissionGroupService userPermissionGroupService;
    @Autowired
    private PermissionDataService permissionDataService;
    @Resource
    private PermissionSensitiveFieldService permissionSensitiveFieldService;
    @Autowired
    private ElsSubAccountService subAccountService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"system#permissionGroup:list"})
    @PermissionDataView(businessType="permissionGroup")
    public Result<?> queryPageList(PermissionGroup permissionGroup, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)permissionGroup), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.permissionGroupService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u6570\u636e\u6743\u9650\u7ec4-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"system#permissionGroup:add"})
    @PermissionDataOpt(businessType="permissionGroup", beanClass=PermissionGroupService.class)
    public Result<?> add(@RequestBody PermissionGroupVO groupVO) {
        this.permissionGroupService.add(groupVO);
        return Result.ok((Object)((Object)groupVO));
    }

    @AutoLog(value="\u6570\u636e\u6743\u9650\u7ec4-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"system#permissionGroup:edit"})
    @PermissionDataOpt(businessType="permissionGroup", beanClass=PermissionGroupService.class)
    public Result<?> edit(@RequestBody PermissionGroupVO groupVO) {
        this.permissionGroupService.edit(groupVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6570\u636e\u6743\u9650\u7ec4-\u590d\u5236")
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @PostMapping(value={"/copy"})
    @RequiresPermissions(value={"system#permissionGroup:copy"})
    public Result<?> copy(@RequestBody PermissionGroup group) {
        this.permissionGroupService.copy(group);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6570\u636e\u6743\u9650\u7ec4-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"system#permissionGroup:delete"})
    @PermissionDataOpt(businessType="permissionGroup", beanClass=PermissionGroupService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.permissionGroupService.delete(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"system#permissionGroup:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PermissionGroup permissionGroup = (PermissionGroup)((Object)this.permissionGroupService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        List<PermissionData> permissionDataList = this.permissionDataService.selectByGroupId(id);
        PermissionGroupVO groupVO = new PermissionGroupVO();
        BeanUtils.copyProperties((Object)((Object)permissionGroup), (Object)((Object)groupVO));
        groupVO.setPermissionDataList(permissionDataList);
        List<PermissionSensitiveField> permissionSensitiveFieldList = this.permissionSensitiveFieldService.selectByMainId(id);
        groupVO.setPermissionSensitiveFieldList(permissionSensitiveFieldList);
        return Result.ok((Object)((Object)groupVO));
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7684\u6743\u9650\u7ec4", notes="\u67e5\u8be2\u6240\u6709\u7684\u6743\u9650\u7ec4")
    @GetMapping(value={"/queryAll"})
    @RequiresPermissions(value={"system#permissionGroup:queryAll"})
    public Result<?> queryAll() {
        List groupList = this.permissionGroupService.list((Wrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant()));
        return Result.ok((Object)groupList);
    }

    @AutoLog(value="\u6570\u636e\u6743\u9650\u7ec4-\u6388\u6743\u7528\u6237")
    @ApiOperation(value="\u6388\u6743\u7528\u6237", notes="\u6388\u6743\u7528\u6237")
    @PostMapping(value={"/addAuthUser"})
    @RequiresPermissions(value={"system#permissionGroup:authUser"})
    public Result<?> addAuthUser(@RequestBody UserPermissionGroup group) {
        this.userPermissionGroupService.add(group);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6570\u636e\u6743\u9650\u7ec4-\u79fb\u9664\u6388\u6743\u7528\u6237")
    @ApiOperation(value="\u79fb\u9664\u6388\u6743\u7528\u6237", notes="\u79fb\u9664\u6388\u6743\u7528\u6237")
    @PostMapping(value={"/removeAuthUser"})
    @RequiresPermissions(value={"system#permissionGroup:authUser"})
    public Result<?> removeAuthUser(@RequestBody UserPermissionGroup group) {
        this.userPermissionGroupService.remove(group);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/userInGroupList"})
    @RequiresPermissions(value={"system#permissionGroup:list"})
    public Result<?> queryInUserPageList(PermissionGroup permissionGroup, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        List userIdList = this.userPermissionGroupService.list((Wrapper)new QueryWrapper().eq((Object)"group_id", (Object)permissionGroup.getId())).stream().map(UserPermissionGroup::getUserId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.in(!userIdList.isEmpty(), (Object)"id", userIdList);
        queryWrapper.eq(userIdList.isEmpty(), (Object)"id", (Object)"1");
        queryWrapper.like(StrUtil.isNotBlank((CharSequence)permissionGroup.getSubAccount()), (Object)"sub_account", (Object)permissionGroup.getSubAccount());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.subAccountService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/userNotInGroupList"})
    @RequiresPermissions(value={"system#permissionGroup:list"})
    public Result<?> queryNotInUserPageList(PermissionGroup permissionGroup, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        List userIdList = this.userPermissionGroupService.list((Wrapper)new QueryWrapper().eq((Object)"group_id", (Object)permissionGroup.getId())).stream().map(UserPermissionGroup::getUserId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.notIn(!userIdList.isEmpty(), (Object)"id", userIdList);
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.like(StrUtil.isNotBlank((CharSequence)permissionGroup.getSubAccount()), (Object)"sub_account", (Object)permissionGroup.getSubAccount());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.subAccountService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }
}

