/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esign.controller;

import cn.hutool.core.io.StreamProgress;
import cn.hutool.http.HttpRequest;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.electronsign.esign.entity.ElsEsign;
import com.els.modules.electronsign.esign.entity.ElsSigners;
import com.els.modules.electronsign.esign.enumerate.EsignBusTypeEnum;
import com.els.modules.electronsign.esign.enums.SrmPrintBussinessTypeEnum;
import com.els.modules.electronsign.esign.rpc.service.EsignInvokeBaseRpcService;
import com.els.modules.electronsign.esign.rpc.service.EsignInvokeContractRpcService;
import com.els.modules.electronsign.esign.rpc.service.EsignInvokeFinanceRpcService;
import com.els.modules.electronsign.esign.rpc.service.EsignInvokeOrderRpcService;
import com.els.modules.electronsign.esign.service.ElsEnterpriseCertificationInfoService;
import com.els.modules.electronsign.esign.service.ElsEsignService;
import com.els.modules.electronsign.esign.service.ElsSignersService;
import com.els.modules.electronsign.esign.vo.ElsEsignVO;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.reconciliation.api.dto.ReconciliationConfirmationDTO;
import com.els.modules.system.dto.ElsPrintConfigDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.micrometer.core.instrument.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/esign/elsEsign"})
@Api(tags={"\u7535\u5b50\u7b7e\u7ae0"})
public class ElsEsignController
extends BaseController<ElsEsign, ElsEsignService> {
    @Autowired
    private ElsEsignService elsEsignService;
    @Autowired
    private ElsSignersService elsSignersService;
    @Autowired
    private ElsEnterpriseCertificationInfoService elsEnterpriseCertificationInfoService;
    @Autowired
    @Lazy
    private EsignInvokeContractRpcService esignInvokeContractRpcService;
    @Autowired
    private EsignInvokeOrderRpcService esignInvokeOrderRpcService;
    @Resource
    private EsignInvokeFinanceRpcService esignInvokeFinanceRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private EsignInvokeBaseRpcService esignInvokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"esign#esignFlow:list"})
    @PermissionDataView(businessType="eSign")
    public Result<?> queryPageList(ElsEsign elsEsign, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsEsign), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.elsEsignService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/saleList"})
    @RequiresPermissions(value={"esign#saleEsignFlow:list"})
    public Result<?> saleList(ElsEsign elsEsign, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsEsign), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"send_status", (Object)"1");
        IPage pageList = this.elsEsignService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"esign#esignFlow:edit", "esign#saleEsignFlow:signer", "esign#saleEsignFlow:signDoc"}, logical=Logical.OR)
    public Result<?> add(@RequestBody ElsEsignVO elsEsignPage) {
        ElsEsign elsEsign = new ElsEsign();
        BeanUtils.copyProperties((Object)((Object)elsEsignPage), (Object)((Object)elsEsign));
        this.elsEsignService.saveMain(elsEsign, elsEsignPage.getPurchaseSignersList(), elsEsignPage.getSaleSignersList());
        return Result.ok((Object)((Object)elsEsign));
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"esign#esignFlow:edit", "esign#saleEsignFlow:signer", "esign#saleEsignFlow:signDoc"}, logical=Logical.OR)
    public Result<?> edit(@RequestBody ElsEsignVO elsEsignPage) {
        ElsEsign elsEsign = new ElsEsign();
        BeanUtils.copyProperties((Object)((Object)elsEsignPage), (Object)((Object)elsEsign));
        this.elsEsignService.updateMain(elsEsign, elsEsignPage.getPurchaseSignersList(), elsEsignPage.getSaleSignersList(), elsEsignPage.getSaleAttachments());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"esign#esignFlow:cancel"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.elsEsignService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"esign#esignFlow:cancel"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.elsEsignService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"esign#esignFlow:detail", "esign#saleEsignFlow:detail"}, logical=Logical.OR)
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseContractHeadDTO purchaseContractHeadDTO;
        ElsEsign elsEsign = (ElsEsign)((Object)this.elsEsignService.getById((Serializable)((Object)id)));
        String contractType = "";
        if (elsEsign != null && "contract".equals(elsEsign.getBusType()) && StringUtils.isNotBlank((String)elsEsign.getRelationId()) && (purchaseContractHeadDTO = this.esignInvokeContractRpcService.getPurchaseContractById(elsEsign.getRelationId())) != null) {
            contractType = purchaseContractHeadDTO.getContractType();
        }
        ElsEsignVO elsEsignVO = new ElsEsignVO();
        BeanUtils.copyProperties((Object)((Object)elsEsign), (Object)((Object)elsEsignVO));
        elsEsignVO.setContractType(contractType);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"head_id", (Object)id);
        wrapper.eq((Object)"role_type", (Object)"0");
        elsEsignVO.setPurchaseSignersList(this.elsSignersService.list((Wrapper)wrapper));
        wrapper.clear();
        wrapper.eq((Object)"head_id", (Object)id);
        wrapper.eq((Object)"role_type", (Object)"1");
        elsEsignVO.setSaleSignersList(this.elsSignersService.list((Wrapper)wrapper));
        elsEsignVO.setPurchaseAttachments(this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(elsEsign.getId()));
        elsEsignVO.setSaleAttachments(this.invokeBaseRpcService.selectSaleAttachmentByMainId(elsEsign.getId()));
        return Result.ok((Object)((Object)elsEsignVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u7535\u5b50\u7b7e\u7ae0id\u67e5\u8be2\u7b7e\u7f72\u4eba", notes="\u901a\u8fc7\u7535\u5b50\u7b7e\u7ae0id\u67e5\u8be2\u7b7e\u7f72\u4eba")
    @GetMapping(value={"/queryElsSignersByMainId"})
    @RequiresPermissions(value={"esign#esignFlow:detail", "esign#saleEsignFlow:detail"}, logical=Logical.OR)
    public Result<?> queryElsSignersListByMainId(@RequestParam(name="id", required=true) String id) {
        List<ElsSigners> elsSignersList = this.elsSignersService.selectByMainId(id);
        return Result.ok(elsSignersList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/getSignerlist"})
    @RequiresPermissions(value={"esign#esignFlow:detail", "esign#saleEsignFlow:detail"}, logical=Logical.OR)
    public Result<?> getSignerlist(@RequestParam(name="id", required=true) String id, @RequestParam(name="signer", required=true) String signer, @RequestParam(name="createdAccount", required=false) String createdAccount, @RequestParam(name="busType", required=false) String busType, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        String elsAccount = null;
        String toElsAccount = null;
        if (EsignBusTypeEnum.CONTRACT.getValue().equals(busType)) {
            PurchaseContractHeadDTO contractHead = this.esignInvokeContractRpcService.getPurchaseContractById(id);
            if (contractHead == null) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_nexMK_c78c1619", (String)"\u5408\u540c\u4e0d\u5b58\u5728"));
            }
            elsAccount = contractHead.getElsAccount();
            toElsAccount = contractHead.getToElsAccount();
        } else if (EsignBusTypeEnum.ORDER.getValue().equals(busType)) {
            PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.esignInvokeOrderRpcService.getPurchaseOrderById(id);
            if (purchaseOrderHeadDTO == null) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_ItxMK_d6bfc0ca", (String)"\u8ba2\u5355\u4e0d\u5b58\u5728"));
            }
            elsAccount = purchaseOrderHeadDTO.getElsAccount();
            toElsAccount = purchaseOrderHeadDTO.getToElsAccount();
        } else if (EsignBusTypeEnum.RECONCILIATION_CONFIRMATION.getValue().equals(busType)) {
            ReconciliationConfirmationDTO reconciliationConfirmation = this.esignInvokeFinanceRpcService.getPurchaseReconciliationConfirmationById(id);
            if (reconciliationConfirmation == null) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_RLxxMK_577f2c76", (String)"\u786e\u8ba4\u51fd\u4e0d\u5b58\u5728"));
            }
            elsAccount = reconciliationConfirmation.getElsAccount();
            toElsAccount = reconciliationConfirmation.getToElsAccount();
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper();
        if ("purchase".equals(signer)) {
            wrapper.eq((Object)"els_account", (Object)elsAccount);
        } else {
            wrapper.eq((Object)"els_account", (Object)toElsAccount);
        }
        if (StringUtils.isNotBlank((String)createdAccount)) {
            wrapper.eq((Object)"created_account", (Object)createdAccount);
        }
        wrapper.isNotNull((Object)"org_id");
        IPage pageList = this.elsEnterpriseCertificationInfoService.page((IPage)page, (Wrapper)wrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u5173\u952e\u5b57\u5b9a\u4f4d")
    @ApiOperation(value="\u5173\u952e\u5b57\u5b9a\u4f4d", notes="\u5173\u952e\u5b57\u5b9a\u4f4d")
    @GetMapping(value={"/keyWordToAera"})
    @RequiresPermissions(value={"esign#esignFlow:initiate", "esign#saleEsignFlow:signer", "esign#saleEsignFlow:signDoc"}, logical=Logical.OR)
    public Result<?> keyWordToAera(@RequestParam(name="elsAccount", required=true) String elsAccount, @RequestParam(name="filesId", required=true) String filesId, @RequestParam(name="signWord", required=true) String signWord) {
        ElsSigners signers = new ElsSigners();
        signers.setElsAccount(elsAccount);
        signers.setFilesId(filesId);
        signers.setSignWord(signWord);
        return this.elsSignersService.keyWordToAera(signers);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u9000\u56de")
    @ApiOperation(value="\u9000\u56de", notes="\u9000\u56de")
    @GetMapping(value={"/sendBack"})
    @RequiresPermissions(value={"esign#esignFlow:back"})
    public Result<?> sendBack(@RequestParam(name="id", required=true) String id) {
        return this.elsEsignService.sendBack(id);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u64a4\u9500")
    @ApiOperation(value="\u64a4\u9500", notes="\u64a4\u9500")
    @GetMapping(value={"/backout"})
    @RequiresPermissions(value={"esign#esignFlow:cancel"})
    public Result<?> backout(@RequestParam(name="id", required=true) String id, @RequestParam(name="reason", required=true) String reason) {
        return this.elsEsignService.backout(id, reason);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d")
    @ApiOperation(value="\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d", notes="\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d")
    @GetMapping(value={"/signFileDownload"})
    @RequiresPermissions(value={"esign#esignFlow:down", "esign#saleEsignFlow:down"}, logical=Logical.OR)
    public Result<?> signFileDownload(@RequestParam(name="id", required=true) String id) {
        return this.elsEsignService.signFileDownload(id);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u5f85\u7b7e\u7f72\u6587\u6863\u9884\u89c8")
    @ApiOperation(value="\u5f85\u7b7e\u7f72\u6587\u6863\u9884\u89c8", notes="\u5f85\u7b7e\u7f72\u6587\u6863\u9884\u89c8")
    @GetMapping(value={"/viewEsignFile"})
    @RequiresPermissions(value={"esign#esignFlow:down", "esign#saleEsignFlow:down"}, logical=Logical.OR)
    public Result<?> viewEsignFile(@RequestParam(name="id", required=true) String id) {
        return this.elsEsignService.viewEsignFile(id);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u5355\u636e\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d")
    @ApiOperation(value="\u5355\u636e\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d", notes="\u5355\u636e\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d")
    @GetMapping(value={"/busSignFileDownload"})
    @RequiresPermissions(value={"esign#esignFlow:down", "esign#saleEsignFlow:down"}, logical=Logical.OR)
    public Result<?> busSignFileDownload(@RequestParam(name="id", required=true) String id, @RequestParam(name="busType", required=true) String busType) {
        return this.elsEsignService.busSignFileDownload(id, busType);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u6d41\u7a0b\u67e5\u8be2")
    @ApiOperation(value="\u6d41\u7a0b\u67e5\u8be2", notes="\u6d41\u7a0b\u67e5\u8be2")
    @GetMapping(value={"/flowQuery"})
    @RequiresPermissions(value={"esign#esignFlow:statusQuery"})
    public Result<?> flowQuery(@RequestParam(name="id", required=true) String id) {
        return this.elsEsignService.flowQuery(id);
    }

    @GetMapping(value={"/downloadOrder"})
    @RequiresPermissions(value={"esign#esignFlow:down", "esign#saleEsignFlow:down"}, logical=Logical.OR)
    public void download(@RequestParam(name="id", required=true) String id, @RequestParam(name="token", required=false) String token, @RequestParam(name="reportUrl", required=true) String reportUrl, @RequestParam(name="createAccount", required=true) String createAccount, @RequestParam(name="fileName", required=false) String fileName, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ElsPrintConfigDTO printConfigDTO;
        String cookie = request.getHeader("cookie");
        Object inputStream = null;
        ServletOutputStream outputStream = null;
        if (ConvertUtils.isEmpty((Object)token)) {
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                if (!"X-Access-Token".equals(name)) continue;
                token = request.getHeader(name);
            }
        }
        if ((printConfigDTO = this.esignInvokeBaseRpcService.getElsPrintConfigByBusType(createAccount, SrmPrintBussinessTypeEnum.ORDER.getValue())) == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RRfWERWFWShIKQI_7542006f", (String)"\u7f3a\u5c11\u6253\u5370\u914d\u7f6e\u6570\u636e\uff0c\u65e0\u6cd5\u4e0b\u8f7d\u6587\u4ef6"));
        }
        if ("ureport".equals(printConfigDTO.getPrintType())) {
            try {
                response.setHeader("Content-Type", "application/octet-stream");
                response.setHeader("Content-Disposition", "attachment;fileName=" + new String(fileName.getBytes("UTF-8"), "iso-8859-1"));
                outputStream = response.getOutputStream();
                StringBuffer url = new StringBuffer();
                url.append(reportUrl).append("/els/report/ureport/preview?_u=mysql:").append(printConfigDTO.getPrintName()).append("&token=").append(token).append("&id=").append(id);
                ((HttpRequest)HttpRequest.get((String)url.toString()).header("cookie", cookie)).execute().writeBody((OutputStream)outputStream, true, new StreamProgress(){

                    public void start() {
                    }

                    public void progress(long l) {
                    }

                    public void finish() {
                    }
                });
            }
            catch (Exception e) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_title_fileDownloadFailed", (String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a") + e.getMessage());
            }
        }
    }
}

