/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.AssertI18nUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.system.entity.ElsPasswordPolicy;
import com.els.modules.system.entity.ElsPasswordRecord;
import com.els.modules.system.entity.ElsPasswordSecurity;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsSubAccountLoginLockRecord;
import com.els.modules.system.enums.i18n.I18nElsPwSecurityEnum;
import com.els.modules.system.enums.i18n.I18nRecordOperaEnum;
import com.els.modules.system.mapper.ElsPasswordPolicyMapper;
import com.els.modules.system.mapper.ElsPasswordRecordMapper;
import com.els.modules.system.mapper.ElsPasswordSecurityMapper;
import com.els.modules.system.mapper.ElsSubAccountLoginLockRecordMapper;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.service.ElsPasswordSecurityService;
import com.els.modules.system.util.PwVerifyUtil;
import com.els.modules.system.vo.ElsPasswordSecurityVo;
import com.els.modules.system.vo.ElsPwSecurityEditVo;
import com.els.modules.system.vo.ElsPwSecuritySaveVo;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ElsPasswordSecurityServiceImpl
extends BaseServiceImpl<ElsPasswordSecurityMapper, ElsPasswordSecurity>
implements ElsPasswordSecurityService {
    @Resource
    ElsPasswordPolicyMapper pwPolicyMapper;
    @Resource
    ElsSubAccountMapper elsSubAccountMapper;
    @Resource
    ElsPasswordSecurityMapper elsPasswordSecurityMapper;
    @Resource
    ElsPasswordRecordMapper elsPasswordRecordMapper;
    @Autowired
    ElsSubAccountLoginLockRecordMapper elsSubAccountLoginLockRecordMapper;
    @Autowired
    private RedisUtil redisUtil;
    private ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors() * 2, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(200), r -> new Thread(r, "User-LoginLock"));

    private String getLoginErrorNumKey(String elsAccount, String elsSubAccount) {
        return "CACHE_LOGIN_ERROR_LOCK_" + elsAccount + "_" + elsSubAccount;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveElsPasswordSecurity(ElsPwSecuritySaveVo elsPwSecuritySaveVo) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(BaseEntity::getElsAccount, (Object)elsPwSecuritySaveVo.getElsAccount());
        AssertI18nUtil.isTrue((((ElsPasswordSecurityMapper)this.baseMapper).selectCount((Wrapper)lambdaQueryWrapper) > 0 ? 1 : 0) != 0, (Enum)I18nRecordOperaEnum.I18N_RECORD_ALREADY_EXISTS);
        ElsPasswordSecurity elsPasswordSecurity = new ElsPasswordSecurity();
        elsPasswordSecurity.setComplexity(elsPwSecuritySaveVo.getComplexity()).setMinLength(elsPwSecuritySaveVo.getMinLength()).setModifyInterval(elsPwSecuritySaveVo.getModifyInterval()).setErrorLockTime(elsPwSecuritySaveVo.getErrorLockTime()).setErrorLock(elsPwSecuritySaveVo.getErrorLock()).setAllowRepeatLogin(elsPwSecuritySaveVo.getAllowRepeatLogin());
        Date now = new Date();
        elsPasswordSecurity.setCreateTime(now).setUpdateTime(now);
        ((ElsPasswordSecurityMapper)this.baseMapper).insert((Object)elsPasswordSecurity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateElsPasswordSecurity(ElsPwSecurityEditVo elsPwSecurityEditVo) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(BaseEntity::getId, (Object)elsPwSecurityEditVo.getId())).eq(BaseEntity::getElsAccount, (Object)elsPwSecurityEditVo.getElsAccount());
        lambdaQueryWrapper.last(" limit 1");
        lambdaQueryWrapper.orderByDesc(BaseEntity::getUpdateTime);
        ElsPasswordSecurity one = (ElsPasswordSecurity)((Object)((ElsPasswordSecurityMapper)this.baseMapper).selectOne((Wrapper)lambdaQueryWrapper));
        AssertI18nUtil.isTrue((null == one ? 1 : 0) != 0, (Enum)I18nRecordOperaEnum.I18N_RECORD_NOT_EXISTS);
        Integer old = one.getErrorLockTime();
        ElsPasswordSecurity elsPasswordSecurity = new ElsPasswordSecurity();
        elsPasswordSecurity.setComplexity(elsPwSecurityEditVo.getComplexity()).setMinLength(elsPwSecurityEditVo.getMinLength()).setModifyInterval(elsPwSecurityEditVo.getModifyInterval()).setErrorLockTime(elsPwSecurityEditVo.getErrorLockTime()).setErrorLock(elsPwSecurityEditVo.getErrorLock()).setAllowRepeatLogin(elsPwSecurityEditVo.getAllowRepeatLogin()).setForcePwdHis(elsPwSecurityEditVo.getForcePwdHis()).setUpdateBy(elsPwSecurityEditVo.getUpdateBy()).setUpdateTime(new Date()).setId(elsPwSecurityEditVo.getId());
        ((ElsPasswordSecurityMapper)this.baseMapper).updateById((Object)elsPasswordSecurity);
        if (old != null && !old.equals(elsPasswordSecurity.getErrorLockTime())) {
            this.refreshLockTime(old, elsPasswordSecurity.getErrorLockTime());
        }
    }

    @Async
    public void refreshLockTime(Integer old, Integer errorLockTime) {
        long newTime = (long)((Integer)ObjectUtil.defaultIfNull((Object)errorLockTime, (Object)0)).intValue() * 60L;
        long oldTime = (long)old.intValue() * 60L;
        Set keys = this.redisUtil.getKeys("CACHE_LOGIN_ERROR_LOCK_" + TenantContext.getTenant() + "_*");
        for (String k : keys) {
            long fastTime = newTime - (oldTime - this.redisUtil.getExpire(k));
            this.redisUtil.set(k, this.redisUtil.get(k), fastTime > 0L ? fastTime : 1L);
        }
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ElsPasswordSecurityVo getElsPasswordSecurity(String elsAccount) {
        return ((ElsPasswordSecurityMapper)this.baseMapper).getElsPasswordSecurity(elsAccount);
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public String verifyModifyInterval(String elsAccount, String elsSubAccount) {
        String queryElsAccount = "cloud".equals(SysUtil.getDeployWay()) ? elsAccount : SysUtil.getPurchaseAccount();
        Integer modifyInterval = ((ElsPasswordSecurityMapper)this.baseMapper).getModifyInterval(queryElsAccount);
        if (modifyInterval == null) {
            return null;
        }
        Date lastModifyDate = this.pwPolicyMapper.getPwPolicyUpdateTime(elsAccount, elsSubAccount);
        if (lastModifyDate == null) {
            lastModifyDate = this.elsSubAccountMapper.getUserCreateDate(elsAccount, elsSubAccount);
        }
        if (lastModifyDate != null) {
            return PwVerifyUtil.pwModifyIntervalVerify(lastModifyDate, modifyInterval);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void verifyErrorLock(String elsAccount, String elsSubAccount) {
        String queryElsAccount = "cloud".equals(SysUtil.getDeployWay()) ? elsAccount : SysUtil.getPurchaseAccount();
        Integer errorLock = ((ElsPasswordSecurityMapper)this.baseMapper).getErrorLock(queryElsAccount);
        if (errorLock == null || errorLock <= 0) {
            return;
        }
        String loginErrorNumKey = this.getLoginErrorNumKey(elsAccount, elsSubAccount);
        Object cacheErrorNum = this.redisUtil.get(loginErrorNumKey);
        boolean flag = cacheErrorNum != null && Integer.parseInt(cacheErrorNum.toString()) > errorLock;
        ElsPasswordSecurityVo elsPasswordSecurity = this.elsPasswordSecurityMapper.getElsPasswordSecurity(queryElsAccount);
        if (null != elsPasswordSecurity && null != elsPasswordSecurity.getErrorLockTime() && -1 != elsPasswordSecurity.getErrorLockTime() && this.redisUtil.getExpire(loginErrorNumKey) == -1L && flag) {
            this.redisUtil.del(new String[]{loginErrorNumKey});
        }
        if (cacheErrorNum == null || Integer.parseInt(cacheErrorNum.toString()) < errorLock) {
            return;
        }
        Integer errorLockTime = 0;
        Integer errorNum = Integer.parseInt(cacheErrorNum.toString());
        if (null != elsPasswordSecurity) {
            errorLockTime = elsPasswordSecurity.getErrorLockTime();
        }
        if (errorNum > errorLock) {
            if (errorLockTime <= -1) {
                AssertI18nUtil.isTrue((boolean)true, (Enum)I18nElsPwSecurityEnum.I18N_LOGIN_ERROR_LOCK_FOREVER, (String[])new String[]{String.valueOf(errorLock)});
            } else {
                AssertI18nUtil.isTrue((boolean)true, (Enum)I18nElsPwSecurityEnum.I18N_LOGIN_ERROR_LOCK, (String[])new String[]{String.valueOf(errorLock), errorLockTime.toString()});
            }
        }
        if (null == errorLockTime || errorLockTime == 0) {
            return;
        }
        Integer lockTime = errorLockTime;
        this.poolExecutor.execute(() -> this.saveLoginLockRecord(elsAccount, elsSubAccount, lockTime));
        if (errorNum.equals(errorLock)) {
            errorNum = errorNum + 1;
        }
        if (errorLockTime <= -1) {
            this.redisUtil.set(loginErrorNumKey, (Object)errorNum);
            AssertI18nUtil.isTrue((boolean)true, (Enum)I18nElsPwSecurityEnum.I18N_LOGIN_ERROR_LOCK_FOREVER, (String[])new String[]{String.valueOf(cacheErrorNum)});
        } else {
            this.redisUtil.set(loginErrorNumKey, (Object)errorNum, (long)errorLockTime.intValue() * 60L);
            AssertI18nUtil.isTrue((boolean)true, (Enum)I18nElsPwSecurityEnum.I18N_LOGIN_ERROR_LOCK, (String[])new String[]{String.valueOf(cacheErrorNum), errorLockTime.toString()});
        }
    }

    public void saveLoginLockRecord(String elsAccount, String elsSubAccount, Integer errorLockTime) {
        ElsSubAccount userByAccount = this.elsSubAccountMapper.getUserByAccount(elsAccount + "_" + elsSubAccount);
        if (null == userByAccount) {
            return;
        }
        DateTime lockDate = DateUtil.date();
        ElsSubAccountLoginLockRecord record = new ElsSubAccountLoginLockRecord();
        record.setElsSubAccount(elsSubAccount);
        record.setElsAccount(elsAccount);
        record.setUserName(userByAccount.getRealname());
        record.setLockDate((Date)lockDate);
        record.setLockTime(errorLockTime);
        this.elsSubAccountLoginLockRecordMapper.insert((Object)record);
        ElsPasswordPolicy elsPasswordPolicy = this.getElsPasswordPolicy(elsAccount, elsSubAccount);
        if (null == elsPasswordPolicy) {
            elsPasswordPolicy = new ElsPasswordPolicy();
            elsPasswordPolicy.setElsAccount(elsAccount);
            elsPasswordPolicy.setElsSubAccount(elsSubAccount);
        }
        elsPasswordPolicy.setLastErrorLockTime((Date)lockDate);
        if (null == elsPasswordPolicy.getId()) {
            this.pwPolicyMapper.insert((Object)elsPasswordPolicy);
            return;
        }
        this.pwPolicyMapper.updateById((Object)elsPasswordPolicy);
    }

    private ElsPasswordPolicy getElsPasswordPolicy(String elsAccount, String elsSubAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ElsPasswordPolicy::getElsSubAccount, (Object)elsSubAccount)).last(" limit 1");
        wrapper.orderByDesc(BaseEntity::getUpdateTime);
        return (ElsPasswordPolicy)((Object)this.pwPolicyMapper.selectOne((Wrapper)wrapper));
    }

    @Override
    public void setUpLoginErrorNum(String elsAccount, String elsSubAccount) {
        String loginErrorNumKey = this.getLoginErrorNumKey(elsAccount, elsSubAccount);
        Object cacheErrorNum = this.redisUtil.get(loginErrorNumKey);
        String queryElsAccount = "cloud".equals(SysUtil.getDeployWay()) ? elsAccount : SysUtil.getPurchaseAccount();
        ElsPasswordSecurityVo elsPasswordSecurity = this.elsPasswordSecurityMapper.getElsPasswordSecurity(queryElsAccount);
        if (null == elsPasswordSecurity) {
            this.redisUtil.del(new String[]{loginErrorNumKey});
            return;
        }
        Integer errorLockTime = (Integer)ObjectUtil.defaultIfNull((Object)elsPasswordSecurity.getErrorLockTime(), (Object)0);
        long time = (long)errorLockTime.intValue() * 60L;
        if (time == 0L) {
            time = 1L;
        }
        if (cacheErrorNum == null) {
            if (errorLockTime <= -1) {
                this.redisUtil.set(loginErrorNumKey, (Object)1);
            } else {
                this.redisUtil.set(loginErrorNumKey, (Object)1, time);
            }
            return;
        }
        if (errorLockTime <= -1) {
            this.redisUtil.set(loginErrorNumKey, (Object)(Integer.parseInt(cacheErrorNum.toString()) + 1));
            return;
        }
        Integer num = Integer.parseInt(cacheErrorNum.toString()) + 1;
        this.redisUtil.set(loginErrorNumKey, (Object)num, this.redisUtil.getExpire(loginErrorNumKey));
    }

    @Override
    public void setRepeatLoginToken(String elsAccount, String elsSubAccount) {
        String queryElsAccount = "cloud".equals(SysUtil.getDeployWay()) ? elsAccount : SysUtil.getPurchaseAccount();
        ElsCompanySetDTO companySetDTO = ((InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class)).getElsCompanySetByElsAccountAndItemCode(queryElsAccount, "repeatLogin");
        if (companySetDTO != null && "1".equals(companySetDTO.getDefaultValue())) {
            return;
        }
        String loginToken = (String)this.redisUtil.get("sys:token:" + elsAccount + "_" + elsSubAccount);
        if (StringUtils.isBlank((CharSequence)loginToken)) {
            return;
        }
        this.redisUtil.set("sys:token:repeat:" + loginToken, (Object)loginToken);
        this.redisUtil.expire("sys:token:repeat:" + loginToken, 3600L);
    }

    @Override
    public void verifyfForcePwdHis(String editType, String elsAccount, String subAccount, String password) {
        ElsPasswordSecurityVo elsPasswordSecurity = this.elsPasswordSecurityMapper.getElsPasswordSecurity(elsAccount);
        if (null != elsPasswordSecurity && null != elsPasswordSecurity.getForcePwdHis() && 0 != elsPasswordSecurity.getForcePwdHis()) {
            LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ElsPasswordRecord::getElsSubAccount, (Object)subAccount)).eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0)).isNotNull(ElsPasswordRecord::getPassword)).ne(ElsPasswordRecord::getPassword, (Object)"")).isNotNull(ElsPasswordRecord::getSalt)).ne(ElsPasswordRecord::getSalt, (Object)"")).last(" limit " + elsPasswordSecurity.getForcePwdHis())).orderByDesc(BaseEntity::getUpdateTime);
            List records = this.elsPasswordRecordMapper.selectList((Wrapper)lambdaQueryWrapper);
            for (ElsPasswordRecord record : records) {
                String userpassword = PasswordUtil.encrypt((String)(elsAccount + "_" + subAccount), (String)password, (String)record.getSalt());
                String syspassword = record.getPassword();
                if (!syspassword.equals(userpassword)) continue;
                if ("1".equals(editType)) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APGRjwoxBnWRwovKiNcrwoKm_296fee8", (String)"\u5f53\u524d\u8bbe\u7f6e\u7684\u5bc6\u7801\u4e0d\u7b26\u5408\u5f3a\u5236\u5bc6\u7801\u5386\u53f2\u7b56\u7565\uff0c\u4fee\u6539\u5bc6\u7801\u5931\u8d25\u3002"));
                }
                if (!"2".equals(editType)) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APGRjwoxBnWRwovKiNsRwoKm_44a11c72", (String)"\u5f53\u524d\u8bbe\u7f6e\u7684\u5bc6\u7801\u4e0d\u7b26\u5408\u5f3a\u5236\u5bc6\u7801\u5386\u53f2\u7b56\u7565\uff0c\u91cd\u7f6e\u5bc6\u7801\u5931\u8d25\u3002"));
            }
        }
    }
}

