/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.util;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.config.IpaasConfig;
import com.els.modules.electronsign.config.EsignV3Properties;
import com.els.modules.electronsign.dto.CreateIpassCallBackRq;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class IpassUtil {
    private static final Logger log = LoggerFactory.getLogger(IpassUtil.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private EsignV3Properties esignV3Properties;
    private static final String SUCCESS = "200";
    private static final Integer SUCCESS_CODE = 0;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public void callIpassCreateBack(String elsAccount, String businessKey, String callbackUrl, String type) {
        CreateIpassCallBackRq req = CreateIpassCallBackRq.builder().elsAccount(elsAccount).businessKey(businessKey).callbackUrl(callbackUrl).type(type).build();
        log.info("callIpassCreateBack req:{}", (Object)JSON.toJSONString((Object)req));
        String body1 = (String)this.restTemplate.postForObject(this.esignV3Properties.getCreateCallbackUrl(), (Object)req, String.class, new Object[0]);
        log.info("callIpassCreateBack response:{}", (Object)body1);
    }

    public <T> T sendRequest(Object req, String iPassCode, Class<T> clazz) {
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)req)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(iPassCode));
        return IpassUtil.analysisResult(object, clazz);
    }

    public <T> T sendBaseRequest(Object req, String iPassCode, Class<T> clazz) {
        HashMap params = Maps.newHashMap();
        params.put("base", req);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)params)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(iPassCode));
        return IpassUtil.analysisResult(object, clazz);
    }

    public <T> T sendBaseAndChangeElsAccountRequest(Object req, String iPassCode, String elsAccount, Class<T> clazz) {
        HashMap params = Maps.newHashMap();
        params.put("base", req);
        params.put("currentAccount", elsAccount);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)params)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(iPassCode));
        return IpassUtil.analysisResult(object, clazz);
    }

    public <T> T sendBodyRequest(Object req, String iPassCode, Class<T> clazz) {
        HashMap params = Maps.newHashMap();
        params.put("body", req);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)params)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(iPassCode));
        return IpassUtil.analysisResult(object, clazz);
    }

    public static <T> T analysisResult(JSONObject object, Class<T> clazz) {
        if (SUCCESS.equals(object.getString("code")) || object.getBoolean("success").booleanValue()) {
            JSONObject jsonObject = object.getJSONObject("data");
            if (SUCCESS_CODE.equals(jsonObject.getInteger("code"))) {
                return (T)JSON.parseObject((String)jsonObject.getString("data"), clazz);
            }
            throw new ELSBootException(jsonObject.getString("message"));
        }
        throw new ELSBootException(object.getString("message"));
    }

    public static <T> T setNullValue(T source) {
        try {
            Field[] fields;
            for (Field field : fields = source.getClass().getDeclaredFields()) {
                if (!field.getGenericType().toString().equals("class java.lang.String")) continue;
                field.setAccessible(true);
                Object obj = field.get(source);
                if (obj == null || !obj.equals("")) continue;
                field.set(source, null);
            }
        }
        catch (Exception e) {
            log.error("setNullValue error", (Throwable)e);
        }
        return source;
    }

    public static String getFileContentMD5(byte[] bytes) {
        return new String(Base64.encodeBase64((byte[])bytes));
    }

    public static InputStream getInputStreamFromUrl(String urlStr) {
        InputStream inputStream = null;
        try {
            URL url = new URL(URLDecoder.decode(urlStr, "UTF-8"));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2");
            inputStream = conn.getInputStream();
        }
        catch (IOException e) {
            log.error("getInputStreamFromUrl error", (Throwable)e);
        }
        return inputStream;
    }

    public static File getFileFromUrl(String urlStr, String id) {
        try {
            File file = new File("tempOrder" + id + ".pdf");
            file.createNewFile();
            HttpRequest.get((String)urlStr).execute().writeBody(file);
            return file;
        }
        catch (IOException e) {
            log.error("getFileFromUrl error", (Throwable)e);
            return null;
        }
    }

    public static byte[] getFileMD5Bytes128(InputStream inputStream) {
        byte[] md5Bytes = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            int length = -1;
            while ((length = inputStream.read(buffer, 0, 1024)) != -1) {
                md5.update(buffer, 0, length);
            }
            md5Bytes = md5.digest();
            inputStream.close();
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return md5Bytes;
    }

    public static byte[] getFileMD5Bytes128(File file) {
        FileInputStream fis = null;
        byte[] md5Bytes = null;
        try {
            fis = new FileInputStream(file);
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            int length = -1;
            while ((length = fis.read(buffer, 0, 1024)) != -1) {
                md5.update(buffer, 0, length);
            }
            md5Bytes = md5.digest();
            fis.close();
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return md5Bytes;
    }
}

