/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.LicenseUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ElsBusinessRuleDTO;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.justauth.JustAuthUtil;
import com.els.modules.justauth.cache.CustomRedisStateCache;
import com.els.modules.justauth.entity.JustAuthConfig;
import com.els.modules.justauth.service.JustAuthConfigService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.entity.QrCodeToUrl;
import com.els.modules.system.entity.SubaccountOrg;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.enums.BusinessTypePathEnum;
import com.els.modules.system.model.SsoModel;
import com.els.modules.system.model.ThirdLoginModel;
import com.els.modules.system.rpc.service.InvokeBaseRpcService;
import com.els.modules.system.rpc.service.SystemInvokeOrganizationInfoRpcService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.SubaccountOrgService;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.vo.ElsSubAccountVO;
import com.els.modules.wechat.aes.WXBizMsgCrypt;
import com.els.modules.wechat.aes.WechatMessageUtil;
import com.els.shiro.authc.JwtToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.zhyd.oauth.AuthRequestBuilder;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.utils.AuthStateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/account/thirdLogin"})
@Api(tags={"\u7b2c\u4e09\u65b9\u767b\u5f55"})
public class ThirdLoginController {
    private static final Logger log = LoggerFactory.getLogger(ThirdLoginController.class);
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private ThirdAccountService thirdAccountService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Autowired
    private JustAuthConfigService justAuthConfigService;
    @Autowired
    private StaticConfig staticConfig;
    @Resource
    private CustomRedisStateCache redisStateCache;
    @Autowired
    private ElsTenantService elsTenantService;
    private String version = this.getClass().getPackage().getImplementationVersion();
    @Autowired
    private SystemInvokeOrganizationInfoRpcService systemInvokeOrganizationInfoRpcService;
    @Autowired
    private SubaccountOrgService subaccountOrgService;
    private static final String STATE_KEY = "sys:thirdLogin:state:";
    private static final String ACCOUNT_KEY = "sys:thirdLogin:account:";
    private static final String ACCOUNT_METHOD_KEY = "sys:thirdLogin:method:";

    private AuthRequest getAuthRequest(String elsAccount, String source, String type, Boolean flag) {
        JustAuthConfig config = this.justAuthConfigService.getOneConfig(elsAccount, JustAuthUtil.getAuthConfigType(source));
        if (config == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nICUixMKW_52a77674", (String)"\u7b2c\u4e09\u65b9\u51ed\u8bc1\u4e0d\u5b58\u5728!"));
        }
        String uri = "/user/qcLogin";
        if ("mobile".equals(type)) {
            uri = "/mobile";
        }
        if (flag.booleanValue()) {
            source = JustAuthUtil.getAuthType(source);
        }
        String redirectUri = (String)this.staticConfig.getConfig().get("service.address") + uri + "?type%3D" + source.toLowerCase();
        AuthConfig build = AuthConfig.builder().clientId(config.getClientId()).clientSecret(config.getClientSecret()).agentId(config.getAgentId()).redirectUri(redirectUri).build();
        if (CharSequenceUtil.isNotBlank((CharSequence)config.getUsertype())) {
            build.setUsertype(config.getUsertype());
        }
        source = JustAuthUtil.rebuildSource(source);
        AuthRequestBuilder authRequestBuilder = AuthRequestBuilder.builder().source(source.toLowerCase()).authConfig(build).authStateCache((AuthStateCache)this.redisStateCache);
        return authRequestBuilder.build();
    }

    @AutoLog(value="\u7b2c\u4e09\u65b9\u767b\u5f55-\u4e8c\u7ef4\u7801\u6e32\u67d3")
    @GetMapping(value={"/render/{source}"})
    public void render(@PathVariable(value="source") String source, HttpServletResponse response, HttpServletRequest request) throws IOException {
        String account = "cloud".equals(SysUtil.getDeployWay()) ? "100000" : SysUtil.getPurchaseAccount();
        AuthRequest authRequest = this.getAuthRequest(account, source.toUpperCase(), "pc", false);
        String state = AuthStateUtils.createState();
        String authorizeUrl = authRequest.authorize(state);
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8ba4\u8bc1\u5730\u5740\uff1a" + authorizeUrl);
        response.sendRedirect(authorizeUrl);
    }

    @AutoLog(value="\u7b2c\u4e09\u65b9\u767b\u5f55-\u4e8c\u7ef4\u7801\u6e32\u67d3")
    @GetMapping(value={"/render/{source}/{account}"})
    public void render(@PathVariable(value="source") String source, @PathVariable(value="account") String account, HttpServletResponse response, HttpServletRequest request) throws IOException {
        AuthRequest authRequest = this.getAuthRequest(account, source.toUpperCase(), "pc", false);
        String state = AuthStateUtils.createState();
        String authorizeUrl = authRequest.authorize(state);
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8ba4\u8bc1\u5730\u5740\uff1a" + authorizeUrl);
        response.sendRedirect(authorizeUrl);
    }

    @AutoLog(value="\u4f01\u4e1a\u5fae\u4fe1\u63a5\u6536\u6d88\u606f-\u901a\u77e5\u56de\u8c03")
    @GetMapping(value={"/noToken/thirdAuthorizeCallBack/{busAccount}"})
    public void thirdAuthorizeCallBack(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="msg_signature") String msgSignature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce, @RequestParam(value="echostr") String echostr, @PathVariable(value="busAccount") String busAccount) throws Exception {
        JustAuthConfig wechatMp = this.justAuthConfigService.getOneConfig(busAccount, "WECHAT_ENTERPRISE_DEVELOP");
        if (null == wechatMp) {
            throw new ELSBootException("\u4e0d\u5b58\u5728\u5fae\u4fe1\u4f01\u4e1a\u4ee3\u5f00\u53d1\u5e94\u7528\u914d\u7f6e");
        }
        String authCropId = request.getParameter("corpId");
        if (CharSequenceUtil.isNotBlank((CharSequence)authCropId) && "$CORPID$".contains(authCropId.toUpperCase())) {
            authCropId = null;
        }
        log.info("thirdAuthorizeCallBack authCropId:{}", (Object)authCropId);
        WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(wechatMp.getCustomAppToken(), wechatMp.getCustomAppKey(), CharSequenceUtil.emptyToDefault((CharSequence)authCropId, (String)wechatMp.getClientId()));
        try {
            String sEchoStr = wxcpt.VerifyURL(msgSignature, timestamp, nonce, echostr);
            log.info("thirdAuthorizeCallBack sEchoStr:{}", (Object)sEchoStr);
            response.getOutputStream().print(sEchoStr);
            response.setStatus(200);
            response.flushBuffer();
        }
        catch (Exception e) {
            log.error(":::callbackGet \u4f01\u4e1a\u5fae\u4fe1\u56de\u8c03\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    @AutoLog(value="\u4f01\u4e1a\u5fae\u4fe1\u63a5\u6536\u6d88\u606f-\u901a\u77e5\u63a8\u9001")
    @PostMapping(value={"/noToken/thirdAuthorizeCallBack/{busAccount}"})
    public void thirdAuthorize(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="msg_signature") String msgSignature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce, @PathVariable(value="busAccount") String busAccount) throws Exception {
        String authCropId = request.getParameter("corpId");
        if (CharSequenceUtil.isNotBlank((CharSequence)authCropId) && "$CORPID$".contains(authCropId.toUpperCase())) {
            authCropId = null;
        }
        log.info("thirdAuthorizeCallBack authCropId:{}", (Object)authCropId);
        Enumeration parameterNames = request.getParameterNames();
        String param = "";
        while (parameterNames.hasMoreElements()) {
            String element = (String)parameterNames.nextElement();
            String value = request.getParameter(element);
            if (!CharSequenceUtil.isNotBlank((CharSequence)value)) continue;
            param = param + element + "=" + value + "&";
        }
        log.info("thirdAuthorize param:{}", (Object)param);
        try {
            ServletInputStream inputStream = request.getInputStream();
            String sPostData = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            JustAuthConfig wechatMp = this.justAuthConfigService.getOneConfig(busAccount, "WECHAT_ENTERPRISE_DEVELOP");
            if (null == wechatMp) {
                throw new ELSBootException("\u4e0d\u5b58\u5728\u5fae\u4fe1\u4f01\u4e1a\u4ee3\u5f00\u53d1\u5e94\u7528\u914d\u7f6e");
            }
            WXBizMsgCrypt msgCrypt = new WXBizMsgCrypt(wechatMp.getCustomAppToken(), wechatMp.getCustomAppKey(), wechatMp.getClientId());
            Map<String, String> allData = WechatMessageUtil.parseXml(sPostData);
            String sMsg = msgCrypt.DecryptMsg(msgSignature, timestamp, nonce, sPostData);
            Map<String, String> map = WechatMessageUtil.parseXml(sMsg);
        }
        catch (Exception e) {
            log.error(":::\u4f01\u4e1a\u5fae\u4fe1\u63a5\u6536\u6d88\u606f-\u901a\u77e5\u63a8\u9001", (Object)e.getMessage());
        }
        response.getOutputStream().print("success");
        response.setStatus(200);
        response.flushBuffer();
    }

    @AutoLog(value="\u901a\u8fc7\u4e8c\u7ef4\u7801\u83b7\u53d6\u8df3\u8f6cUrl\u8def\u5f84")
    @PostMapping(value={"/qrcodeToUrl"})
    public Result<?> qrcodeToUrl(@RequestBody QrCodeToUrl qrCodeToUrl) throws Exception {
        String routeUrl = null;
        String token = qrCodeToUrl.getToken();
        String account = JwtUtil.getAccount((String)token);
        routeUrl = account != null && qrCodeToUrl.getBusAccount().equals(account.split("_")[0]) ? BusinessTypePathEnum.getPurchasePathByType(qrCodeToUrl.getBusinessType()) + "?id=" + qrCodeToUrl.getPurchaseId() : BusinessTypePathEnum.getSalePathByType(qrCodeToUrl.getBusinessType()) + "?id=" + qrCodeToUrl.getSaleId();
        return Result.ok((String)routeUrl);
    }

    @AutoLog(value="\u7b2c\u4e09\u65b9\u767b\u5f55-\u6388\u6743\u767b\u5f55")
    @GetMapping(value={"/render/{elsAccount}/{type}/{source}"})
    public void render2(@PathVariable(value="elsAccount") String elsAccount, @PathVariable(value="type") String type, @PathVariable(value="source") String source, @RequestParam(name="routeUri", required=false) String routeUri, HttpServletResponse response) throws IOException {
        AuthRequest authRequest = this.getAuthRequest(elsAccount, source.toUpperCase(), type, true);
        String state = AuthStateUtils.createState();
        String authorizeUrl = authRequest.authorize(state);
        JSONObject object = new JSONObject();
        if (StrUtil.isNotBlank((CharSequence)routeUri)) {
            object.put("routeUri", (Object)routeUri);
            this.redisUtil.set(STATE_KEY + state, (Object)object, 1800L);
        }
        this.redisUtil.set(ACCOUNT_KEY + state, (Object)elsAccount, 1800L);
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8ba4\u8bc1\u5730\u5740\uff1a" + authorizeUrl);
        response.sendRedirect(authorizeUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoLog(value="\u7b2c\u4e09\u65b9\u767b\u5f55-\u7b2c\u4e09\u65b9\u626b\u7801callback")
    @GetMapping(value={"/{source}/callback"})
    public Result<?> loginThird(@PathVariable(value="source") String source, AuthCallback callback) {
        AuthRequest authRequest;
        AuthResponse response;
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\uff1a" + source + " params\uff1a" + JSONObject.toJSONString((Object)callback));
        Object method = this.redisUtil.get(ACCOUNT_METHOD_KEY + callback.getState());
        if ("mpLoginThird".equals(method)) {
            return this.mpLoginThird(source, callback);
        }
        String elsAccount = SysUtil.getPurchaseAccount();
        boolean flag = false;
        if (this.redisUtil.get(ACCOUNT_KEY + callback.getState()) != null) {
            elsAccount = (String)this.redisUtil.get(ACCOUNT_KEY + callback.getState());
            flag = true;
        }
        boolean success = (response = (authRequest = this.getAuthRequest(elsAccount, source.toUpperCase(), "pc", flag)).login(callback)).getCode() == 2000;
        Result result = new Result();
        if (success) {
            JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()));
            log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\u6388\u6743\u6210\u529f,data:{}", (Object)data.toJSONString());
            String username = data.getString("username");
            String avatar = data.getString("avatar");
            String uuid = data.getString("uuid");
            if (CharSequenceUtil.isEmpty((CharSequence)username) && source.toUpperCase().contains("WECHAT_ENTERPRISE_DEVELOP")) {
                JSONObject rawUserInfo = data.getJSONObject("rawUserInfo");
                JSONObject userInfo = rawUserInfo.getJSONObject("user_info");
                log.info("WECHAT_ENTERPRISE_DEVELOP#userInfo:{}", (Object)userInfo.toJSONString());
                username = userInfo.getString("name");
                avatar = userInfo.getString("avatar");
                uuid = userInfo.getString("open_userid");
                String userId = userInfo.getString("userid");
                JSONObject corpInfo = rawUserInfo.getJSONObject("corp_info");
                String string = corpInfo.getString("corpid");
            }
            ThirdLoginModel tlm = new ThirdLoginModel(JustAuthUtil.getAuthConfigType(source.toUpperCase()), uuid, username, avatar);
            ThirdAccount thrid = this.getThirdAccounts(elsAccount, JustAuthUtil.getAuthConfigType(source.toUpperCase()), uuid);
            ThirdAccount user = null;
            if (thrid == null) {
                log.info(":::\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\u6388\u6743\u6210\u529f\uff0c\u65b0\u4fdd\u5b58\u7b2c\u4e09\u65b9\u7528\u6237.");
                user = this.saveThirdUser(tlm, elsAccount);
                JSONObject obj = new JSONObject();
                obj.put("thirdUserUuid", (Object)user.getId());
                result.setResult((Object)obj);
                result.success("\u64cd\u4f5c\u6210\u529f\u4f46\u6ca1\u6709\u7ed1\u5b9a\u8d26\u53f7\uff01");
            } else {
                log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\u6388\u6743\u6210\u529f\uff0c\u51c6\u5907\u751f\u6210token");
                user = thrid;
                String userId = user.getUserId();
                ElsSubAccount account = (ElsSubAccount)((Object)this.elsSubAccountService.getById((Serializable)((Object)userId)));
                if (null == account) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jDxMKW_782540b3", (String)"\u7528\u6237\u4e0d\u5b58\u5728"));
                }
                if (CommonConstant.USER_FREEZE.equals(account.getStatus())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rjDIOyW_d35fed0b", (String)"\u8be5\u7528\u6237\u5df2\u51bb\u7ed3\uff01"));
                }
                JSONObject busObj = (JSONObject)this.redisUtil.get(STATE_KEY + callback.getState());
                try {
                    TenantContext.setTenant((String)account.getElsAccount());
                    this.userInfo(account, (Result<JSONObject>)result, busObj);
                    log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\u6388\u6743\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
                }
                finally {
                    TenantContext.clear();
                }
            }
        } else {
            log.error(":::\u7b2c\u4e09\u65b9\u6388\u6743\u5f02\u5e38\u4fe1\u606f :{},code:{},{}", new Object[]{JSONObject.toJSONString((Object)response), response.getCode(), success});
            result.setSuccess(false);
            result.setMessage("\u7b2c\u4e09\u65b9\u767b\u5f55\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458:" + response.getMsg());
        }
        return result;
    }

    private ThirdAccount getThirdAccounts(String busAccount, String source, String uuid) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(ThirdAccount::getThirdUserUuid, (Object)uuid);
        query.eq(ThirdAccount::getThirdType, (Object)source);
        query.eq(ThirdAccount::getBusAccount, (Object)busAccount);
        query.orderByDesc(BaseEntity::getUpdateTime);
        List list = this.thirdAccountService.list((Wrapper)query).stream().filter(o -> CharSequenceUtil.isNotBlank((CharSequence)o.getUserId())).collect(Collectors.toList());
        log.info("\u7b2c\u4e09\u65b9\u6388\u6743\u767b\u5f55\u67e5\u8be2\u7528\u6237\u4fe1\u606f,busAccount:{},source:{},uuid:{},result:{}", new Object[]{busAccount, source, uuid, list});
        if (CollectionUtils.isNotEmpty(list)) {
            ThirdAccount thirdAccount = (ThirdAccount)((Object)list.get(0));
            if (CommonConstant.USER_FREEZE.equals(thirdAccount.getStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rjDIOyW_d35fed0b", (String)"\u8be5\u7528\u6237\u5df2\u51bb\u7ed3\uff01"));
            }
            return thirdAccount;
        }
        return null;
    }

    private void buildCompanySet(List<ElsCompanySetDTO> list, String logo, String name) {
        ElsCompanySetDTO elsCompanySetDTO1 = new ElsCompanySetDTO();
        elsCompanySetDTO1.setItemCode("companyShortName");
        elsCompanySetDTO1.setDefaultValue(name != null ? name : "");
        list.add(elsCompanySetDTO1);
        ElsCompanySetDTO elsCompanySetDTO2 = new ElsCompanySetDTO();
        elsCompanySetDTO2.setItemCode("companyLogo");
        elsCompanySetDTO2.setDefaultValue(logo != null ? logo : "");
        list.add(elsCompanySetDTO2);
    }

    private void buildCompanySet(List<ElsCompanySetDTO> list, String logo, String fullName, String shortName) {
        ElsCompanySetDTO elsCompanySetDTO1 = new ElsCompanySetDTO();
        elsCompanySetDTO1.setItemCode("companyShortName");
        elsCompanySetDTO1.setDefaultValue(shortName != null ? shortName : "");
        list.add(elsCompanySetDTO1);
        ElsCompanySetDTO elsCompanySetDTO2 = new ElsCompanySetDTO();
        elsCompanySetDTO2.setItemCode("companyLogo");
        elsCompanySetDTO2.setDefaultValue(logo != null ? logo : "");
        list.add(elsCompanySetDTO2);
        ElsCompanySetDTO elsCompanySetDTO3 = new ElsCompanySetDTO();
        elsCompanySetDTO3.setItemCode("companyName");
        elsCompanySetDTO3.setDefaultValue(fullName != null ? fullName : "");
        list.add(elsCompanySetDTO3);
    }

    private void setLogo(List<ElsCompanySetDTO> list, String elsAccount) {
        ElsTenant byElsAccount = this.elsTenantService.findByElsAccount(elsAccount);
        if ("cloud".equals(SysUtil.getDeployWay())) {
            if (byElsAccount != null && StrUtil.isNotBlank((CharSequence)byElsAccount.getCompanyLogo())) {
                this.buildCompanySet(list, byElsAccount.getCompanyLogo(), byElsAccount.getCompanyName(), byElsAccount.getCompanyShortName());
            } else {
                ElsTenant platformTenant = this.elsTenantService.findByElsAccount("100000");
                if (platformTenant != null) {
                    this.buildCompanySet(list, platformTenant.getCompanyLogo(), byElsAccount.getCompanyName(), byElsAccount.getCompanyShortName());
                } else {
                    this.buildCompanySet(list, null, byElsAccount.getCompanyName(), byElsAccount.getCompanyShortName());
                }
            }
        } else {
            Map<String, String> map = this.elsSubAccountService.getLogoSetByElsAccount(SysUtil.getPurchaseAccount());
            if (map != null) {
                this.buildCompanySet(list, map.get("enterprise_logo"), byElsAccount.getCompanyName(), byElsAccount.getCompanyShortName());
            } else {
                this.buildCompanySet(list, null, byElsAccount.getCompanyName(), byElsAccount.getCompanyShortName());
            }
        }
    }

    private Result<JSONObject> userInfo(ElsSubAccount sysUser, Result<JSONObject> result, JSONObject busObj) {
        ((LicenseUtil)SpringContextUtils.getBean(LicenseUtil.class)).check();
        String syspassword = sysUser.getPassword();
        String elsAccount = sysUser.getElsAccount();
        String subAccount = sysUser.getSubAccount();
        String token = JwtUtil.sign((String)(elsAccount + "_" + subAccount), (String)syspassword);
        this.redisUtil.set("sys:token:" + token, (Object)token);
        this.redisUtil.expire("sys:token:" + token, 3600000L * (long)SysUtil.getExpireTimeBase() / 1000L);
        this.redisUtil.set("sys:token:" + elsAccount + "_" + subAccount, (Object)token);
        this.redisUtil.expire("sys:token:" + elsAccount + "_" + subAccount, 3600000L * (long)SysUtil.getExpireTimeBase() / 1000L);
        String adminFlag = this.userRoleService.getAdminFlag(elsAccount, subAccount);
        this.redisUtil.set("sys:token:role:" + token, (Object)adminFlag, 172800L);
        List<ElsCompanySetDTO> list = this.baseRpcService.getCompanySetList(elsAccount);
        this.setLogo(list, elsAccount);
        JSONObject companySetObj = this.getObjBySet(list);
        ElsSubAccountVO elsSubAccountVO = new ElsSubAccountVO();
        BeanUtils.copyProperties((Object)((Object)sysUser), (Object)((Object)elsSubAccountVO));
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        elsSubAccountVO.setSerivceUrl((String)config.get("service.address"));
        String orgCode = elsSubAccountVO.getOrgCode();
        if (StringUtils.isNotBlank((CharSequence)orgCode)) {
            List<String> orgCodeList = Arrays.asList(orgCode.split(","));
            Map<String, String> orgMap = this.systemInvokeOrganizationInfoRpcService.listDeptOrganization(orgCodeList);
            String org = orgCodeList.stream().filter(orgMap::containsKey).map(orgMap::get).collect(Collectors.joining(","));
            elsSubAccountVO.setOrgCode_dictText(org);
        }
        List<SubaccountOrg> subaccountOrgList = this.subaccountOrgService.selectByMainId(sysUser.getId());
        elsSubAccountVO.setPassword(null);
        elsSubAccountVO.setSalt(null);
        elsSubAccountVO.setSecret(null);
        JSONObject obj = new JSONObject();
        obj.put("token", (Object)token);
        obj.put("userInfo", (Object)elsSubAccountVO);
        obj.put("companySet", (Object)companySetObj);
        obj.put("srmVersion", (Object)this.version);
        obj.put("userOrg", (Object)this.getUserOrg(subaccountOrgList));
        if (busObj != null) {
            obj.put("busObj", (Object)busObj);
        }
        result.setResult((Object)obj);
        result.success("\u767b\u5f55\u6210\u529f");
        JwtToken jwtToken = new JwtToken(token);
        SecurityUtils.getSubject().login((AuthenticationToken)jwtToken);
        this.redisUtil.del(new String[]{"shiro:cache:com.els.shiro.authc.ShiroRealm.authorizationCache:" + sysUser.getId()});
        return result;
    }

    private JSONObject getUserOrg(List<SubaccountOrg> subaccountOrgList) {
        JSONObject object = new JSONObject();
        if (subaccountOrgList.isEmpty()) {
            return object;
        }
        Map<String, List<SubaccountOrg>> orgMap = subaccountOrgList.stream().collect(Collectors.groupingBy(SubaccountOrg::getOrgCategoryCode));
        for (String orgCategoryCode : orgMap.keySet()) {
            JSONArray orgCodeArray = new JSONArray();
            List<SubaccountOrg> list = orgMap.get(orgCategoryCode);
            object.put(orgCategoryCode, (Object)list.get(0).getOrgCode());
            for (SubaccountOrg org : list) {
                orgCodeArray.add((Object)org.getOrgCode());
            }
            object.put(orgCategoryCode + "List", (Object)orgCodeArray);
        }
        return object;
    }

    private JSONArray getBusinessRuleList(List<ElsBusinessRuleDTO> list) {
        JSONArray jsonArray = new JSONArray();
        JSONObject object = null;
        String type = null;
        String action = null;
        String defaultValue = null;
        for (ElsBusinessRuleDTO ruleDTO : list) {
            object = new JSONObject();
            type = ruleDTO.getItemType();
            defaultValue = ruleDTO.getDefaultValue();
            if (!"switch".equals(type) || !"0".equals(defaultValue)) continue;
            action = ruleDTO.getBusinessType() + ":" + "hideBtn" + ":" + ruleDTO.getItemCode();
            object.put("action", (Object)action);
            object.put("status", (Object)defaultValue);
            object.put("type", (Object)type);
            object.put("describe", (Object)ruleDTO.getItemName());
            jsonArray.add((Object)object);
        }
        return jsonArray.isEmpty() ? new JSONArray() : jsonArray;
    }

    private JSONObject getObjBySet(List<ElsCompanySetDTO> list) {
        JSONObject result = new JSONObject();
        for (ElsCompanySetDTO set : list) {
            result.put(set.getItemCode(), (Object)set.getDefaultValue());
        }
        return result;
    }

    private ThirdAccount saveThirdUser(ThirdLoginModel tlm, String busAccount) {
        ThirdAccount user = new ThirdAccount();
        user.setId(IdWorker.getIdStr());
        user.setDeleted(CommonConstant.DEL_FLAG_0);
        user.setStatus(1);
        user.setThirdType(tlm.getSource());
        user.setAvatar(tlm.getAvatar());
        user.setRealname(tlm.getUsername());
        user.setThirdUserUuid(tlm.getUuid());
        user.setBusAccount(busAccount);
        this.thirdAccountService.saveThirdUser(user);
        return user;
    }

    @AutoLog(busModule="\u7b2c\u4e09\u65b9\u767b\u5f55", value="\u83b7\u53d6ssoToken")
    @ApiOperation(value="\u83b7\u53d6ssoToken", notes="\u83b7\u53d6ssoToken")
    @PostMapping(value={"/ssoToken"})
    public Result<?> ssoToken(@RequestBody SsoModel ssoModel) {
        String clientId = ssoModel.getClientId();
        if (StrUtil.isBlank((CharSequence)clientId)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_value_not_empty", (String)"${0}\u4e0d\u80fd\u4e3a\u7a7a"), new String[]{clientId});
        }
        String[] clientArray = clientId.split("_");
        if (clientArray.length == 1 || !clientId.contains("App_")) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWWWWWWmKxiRWWiRmKWWWWWWWWWWWW_939fab2d", (String)"clientId \u683c\u5f0f\u4e0d\u6b63\u786e\uff01\uff0c\u6b63\u786e\u683c\u5f0f\uff1axxx_App_xxx"));
        }
        String secret = ssoModel.getSecret();
        if (StrUtil.isBlank((CharSequence)secret)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_value_not_empty", (String)"${0}\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[]{"secret "}));
        }
        String subAccount = ssoModel.getSubAccount();
        if (StrUtil.isBlank((CharSequence)subAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_value_not_empty", (String)"${0}\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[]{"subAccount "}));
        }
        String elsAccount = clientArray[0];
        ElsSubAccount account = this.elsSubAccountService.getUserByAccount(clientId);
        if (account == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_title_ClientIdDoesNotExist", (String)"Client Id\u4e0d\u5b58\u5728\uff01"));
        }
        String userpassword = PasswordUtil.encrypt((String)clientId, (String)secret, (String)account.getSalt());
        String syspassword = account.getPassword();
        if (!syspassword.equals(userpassword)) {
            throw new ELSBootException("clientId " + I18nUtil.translate((String)"i18n_alert_WWWWWWWWWLiKmW_75264f56", (String)"\u8ba4\u8bc1\u5931\u8d25\uff01"));
        }
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getByAccount(elsAccount, subAccount);
        if (elsSubAccount == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_value_not_empty", (String)"${0}\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[]{"subAccount "}));
        }
        JSONObject result = new JSONObject();
        result.put("token", (Object)this.saveToken(elsSubAccount));
        return Result.ok((Object)result);
    }

    private String saveToken(ElsSubAccount account) {
        String token = JwtUtil.sign((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)account.getPassword());
        this.redisUtil.set("sys:token:" + token, (Object)token);
        this.redisUtil.expire("sys:token:" + token, 1800L);
        return token;
    }

    @AutoLog(value="\u7b2c\u4e09\u65b9\u767b\u5f55-\u6388\u6743\u767b\u5f55")
    @GetMapping(value={"/renderAll/{type}/{source}"})
    public void renderAll(@PathVariable(value="type") String type, @PathVariable(value="source") String source, @RequestParam(name="routeUri", required=false) String routeUri, HttpServletResponse response) throws IOException {
        AuthRequest authRequest = this.getAuthRequest(SysUtil.getPurchaseAccount(), source.toUpperCase(), type, true);
        String state = AuthStateUtils.createState();
        String authorizeUrl = authRequest.authorize(state);
        JSONObject object = new JSONObject();
        if (StrUtil.isNotBlank((CharSequence)routeUri)) {
            object.put("routeUri", (Object)routeUri);
            this.redisUtil.set(STATE_KEY + state, (Object)object, 1800L);
        }
        this.redisUtil.set(ACCOUNT_METHOD_KEY + state, (Object)"mpLoginThird", 1800L);
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8ba4\u8bc1\u5730\u5740\uff1a" + authorizeUrl);
        response.sendRedirect(authorizeUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<?> mpLoginThird(String source, AuthCallback callback) {
        log.info("\u516c\u4f17\u53f7\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\uff1a" + source + " params\uff1a" + JSONObject.toJSONString((Object)callback));
        AuthRequest authRequest = this.getAuthRequest(SysUtil.getPurchaseAccount(), source.toUpperCase(), "pc", true);
        AuthResponse response = authRequest.login(callback);
        boolean success = response.getCode() == 2000;
        Result result = new Result();
        if (success) {
            JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()));
            log.info("\u516c\u4f17\u53f7\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\u6388\u6743\u6210\u529f,data:{}", (Object)data.toJSONString());
            String username = data.getString("username");
            String avatar = data.getString("avatar");
            String uuid = data.getString("uuid");
            ThirdLoginModel tlm = new ThirdLoginModel(JustAuthUtil.getAuthConfigType(source.toUpperCase()), uuid, username, avatar);
            ThirdAccount thrid = this.getThirdAccounts(JustAuthUtil.getAuthConfigType(source.toUpperCase()), uuid);
            ThirdAccount user = null;
            if (thrid == null) {
                throw new ELSBootException("\u5fc5\u987b\u5148\u7ed1\u5b9a\u7528\u6237\u8d26\u53f7");
            }
            log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\u6388\u6743\u6210\u529f\uff0c\u51c6\u5907\u751f\u6210token");
            user = thrid;
            String userId = user.getUserId();
            ElsSubAccount account = (ElsSubAccount)((Object)this.elsSubAccountService.getById((Serializable)((Object)userId)));
            if (null == account) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jDxMKW_782540b3", (String)"\u7528\u6237\u4e0d\u5b58\u5728"));
            }
            if (CommonConstant.USER_FREEZE.equals(account.getStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rjDIOyW_d35fed0b", (String)"\u8be5\u7528\u6237\u5df2\u51bb\u7ed3\uff01"));
            }
            JSONObject busObj = (JSONObject)this.redisUtil.get(STATE_KEY + callback.getState());
            try {
                TenantContext.setTenant((String)account.getElsAccount());
                this.userInfo(account, (Result<JSONObject>)result, busObj);
                log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\u6388\u6743\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
            }
            finally {
                TenantContext.clear();
            }
        } else {
            log.error(":::\u7b2c\u4e09\u65b9\u6388\u6743\u5f02\u5e38\u4fe1\u606f :{},code:{},{}", new Object[]{JSONObject.toJSONString((Object)response), response.getCode(), success});
            throw new ELSBootException("\u7b2c\u4e09\u65b9\u767b\u5f55\u5f02\u5e38:{}", new String[]{response.getMsg()});
        }
        return result;
    }

    private ThirdAccount getThirdAccounts(String source, String uuid) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(ThirdAccount::getThirdUserUuid, (Object)uuid);
        query.eq(ThirdAccount::getThirdType, (Object)source);
        query.orderByDesc(BaseEntity::getUpdateTime);
        List list = this.thirdAccountService.list((Wrapper)query).stream().filter(o -> CharSequenceUtil.isNotBlank((CharSequence)o.getUserId())).collect(Collectors.toList());
        log.info("\u7b2c\u4e09\u65b9\u6388\u6743\u767b\u5f55\u67e5\u8be2\u7528\u6237\u4fe1\u606f:{},source:{},uuid:{},result:{}", new Object[]{source, uuid, list});
        if (CollectionUtils.isNotEmpty(list)) {
            ThirdAccount thirdAccount = (ThirdAccount)((Object)list.get(0));
            if (CommonConstant.USER_FREEZE.equals(thirdAccount.getStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rjDIOyW_d35fed0b", (String)"\u8be5\u7528\u6237\u5df2\u51bb\u7ed3\uff01"));
            }
            return thirdAccount;
        }
        return null;
    }
}

