/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.config.EsignV3Properties;
import com.els.modules.electronsign.enums.SrmSignatoryType;
import com.els.modules.electronsign.esign.enumerate.EsignRoleTypeEnum;
import com.els.modules.electronsign.esignv3.dto.CallBackDto;
import com.els.modules.electronsign.esignv3.dto.SealsAuthRp;
import com.els.modules.electronsign.esignv3.dto.SealsAuthRq;
import com.els.modules.electronsign.esignv3.entity.EsignV3SealsAuth;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3Personal;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3Seals;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3Personal;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3Seals;
import com.els.modules.electronsign.esignv3.enums.SealAuthStatusEnum;
import com.els.modules.electronsign.esignv3.mapper.EsignV3SealsAuthMapper;
import com.els.modules.electronsign.esignv3.service.EsignV3SealsAuthService;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3OrgService;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3PersonalService;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3SealsService;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3OrgService;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3PersonalService;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3SealsService;
import com.els.modules.electronsign.esignv3.vo.SealsAuthVo;
import com.els.modules.electronsign.util.IpassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class EsignV3SealsAuthServiceImpl
extends BaseServiceImpl<EsignV3SealsAuthMapper, EsignV3SealsAuth>
implements EsignV3SealsAuthService {
    @Autowired
    private PurchaseEsignV3PersonalService purchaseEsignV3PersonalService;
    @Autowired
    private SaleEsignV3PersonalService saleEsignV3PersonalService;
    @Autowired
    private IpassUtil ipassUtil;
    @Autowired
    private PurchaseEsignV3OrgService purchaseEsignV3OrgService;
    @Autowired
    private SaleEsignV3OrgService saleEsignV3OrgService;
    @Autowired
    private EsignV3Properties esignV3Properties;
    @Autowired
    @Lazy
    private PurchaseEsignV3SealsService purchaseEsignV3SealsService;
    @Autowired
    @Lazy
    private SaleEsignV3SealsService saleEsignV3SealsService;

    @Override
    public void add(EsignV3SealsAuth esignV3SealsAuth) {
        ((EsignV3SealsAuthMapper)this.baseMapper).insert((Object)esignV3SealsAuth);
    }

    @Override
    public void edit(EsignV3SealsAuth esignV3SealsAuth) {
        int count = ((EsignV3SealsAuthMapper)this.baseMapper).updateById((Object)esignV3SealsAuth);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((EsignV3SealsAuthMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((EsignV3SealsAuthMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public String saveAuth(SealsAuthVo sealsAuthVo) {
        BaseEntity purchaseEsignV3Org;
        Object[] psnIds = sealsAuthVo.getPsnId().split(",");
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(EsignV3SealsAuth::getPsnId, psnIds)).eq(EsignV3SealsAuth::getSealId, (Object)sealsAuthVo.getSealId())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(BaseEntity::getDeleted, (Object)"0")) == 0L ? 1 : 0) != 0, (String)"\u6b64\u5370\u7ae0\u548c\u5bf9\u5e94\u7684\u6210\u5458\u5df2\u6709\u76f8\u5173\u6388\u6743\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u63d0\u4ea4");
        ArrayList auths = Lists.newArrayList();
        for (Object psnId : psnIds) {
            EsignV3SealsAuth esignV3SealsAuth = (EsignV3SealsAuth)((Object)BeanUtil.copyProperties((Object)sealsAuthVo, EsignV3SealsAuth.class, (String[])new String[0]));
            esignV3SealsAuth.setPsnId((String)psnId);
            esignV3SealsAuth.setSealName(sealsAuthVo.getSealName());
            esignV3SealsAuth.setOrgName(sealsAuthVo.getOrgName());
            esignV3SealsAuth.setSealStatus(SealAuthStatusEnum.BE_AUTH.getCode());
            esignV3SealsAuth.setSealType(sealsAuthVo.getSealType());
            if (EsignRoleTypeEnum.PURCHASE.getValue().equals(sealsAuthVo.getRoleType())) {
                PurchaseEsignV3Personal purchaseEsignV3Personal = this.purchaseEsignV3PersonalService.getByPsnId((String)psnId);
                Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseEsignV3Personal)), (String)I18nUtil.translate((String)"i18n_field_LjVHIH_208e48ec", (String)"\u6210\u5458\u4fe1\u606f\u5f02\u5e38"));
                esignV3SealsAuth.setPsnName(purchaseEsignV3Personal.getPsnName());
                esignV3SealsAuth.setSubAccount(purchaseEsignV3Personal.getSubAccount());
            } else {
                SaleEsignV3Seals seals = this.saleEsignV3SealsService.getBySealId(sealsAuthVo.getSealId());
                SaleEsignV3Personal saleEsignV3Personal = this.saleEsignV3PersonalService.getByPsnId((String)psnId, seals.getElsAccount());
                Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)saleEsignV3Personal)), (String)I18nUtil.translate((String)"i18n_field_LjVHIH_208e48ec", (String)"\u6210\u5458\u4fe1\u606f\u5f02\u5e38"));
                saleEsignV3Personal.setPsnName(saleEsignV3Personal.getPsnName());
                esignV3SealsAuth.setSubAccount(saleEsignV3Personal.getSubAccount());
            }
            auths.add(esignV3SealsAuth);
        }
        SealsAuthRq sealsAuthRq = new SealsAuthRq();
        sealsAuthRq.setSealId(sealsAuthVo.getSealId());
        sealsAuthRq.setSealRole(sealsAuthVo.getSealRole());
        sealsAuthRq.setEffectiveTime(sealsAuthVo.getEffectiveTime().getTime());
        sealsAuthRq.setExpireTime(sealsAuthVo.getExpireTime().getTime());
        sealsAuthRq.setOrgId(sealsAuthVo.getOrgId());
        sealsAuthRq.setAuthorizedPsnIds(Arrays.asList(sealsAuthVo.getPsnId().split(",")));
        if (EsignRoleTypeEnum.PURCHASE.getValue().equals(sealsAuthVo.getRoleType())) {
            purchaseEsignV3Org = this.purchaseEsignV3OrgService.getByOrgId(sealsAuthVo.getOrgId());
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)purchaseEsignV3Org), (String)I18nUtil.translate((String)"i18n_field_WedWAEIH_589d98fd", (String)"\u5370\u7ae0\u6240\u5c5e\u4f01\u4e1a\u5f02\u5e38"));
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)purchaseEsignV3Org.getPsnId()), (String)I18nUtil.translate((String)"i18n_field_WedWAERvjIH_ea530c42", (String)"\u5370\u7ae0\u6240\u5c5e\u4f01\u4e1a\u7ba1\u7406\u5458\u5f02\u5e38"));
            sealsAuthRq.setTransactorPsnId(purchaseEsignV3Org.getPsnId());
        } else {
            purchaseEsignV3Org = this.saleEsignV3OrgService.getByOrgId(sealsAuthVo.getOrgId());
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)purchaseEsignV3Org), (String)I18nUtil.translate((String)"i18n_field_WedWAEIH_589d98fd", (String)"\u5370\u7ae0\u6240\u5c5e\u4f01\u4e1a\u5f02\u5e38"));
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)purchaseEsignV3Org.getPsnId()), (String)I18nUtil.translate((String)"i18n_field_WedWAERvjIH_ea530c42", (String)"\u5370\u7ae0\u6240\u5c5e\u4f01\u4e1a\u7ba1\u7406\u5458\u5f02\u5e38"));
            sealsAuthRq.setTransactorPsnId(purchaseEsignV3Org.getPsnId());
        }
        SealsAuthRp res = this.ipassUtil.sendRequest(sealsAuthRq, "e3-seal-org-auth", SealsAuthRp.class);
        this.saveBatch(auths);
        return res.getAuthorizationSignUrl();
    }

    @Override
    public void processSealsAuth(String roleType, String elsAccount, CallBackDto.SealAuth sealAuth, String status) {
        if (SealAuthStatusEnum.AUTHORIZED.getCode().equals(status)) {
            if (ObjectUtil.isNotEmpty((Object)sealAuth.getAuthorizedOrgId()) && this.esignV3Properties.getQqtOrgId().equals(sealAuth.getAuthorizedOrgId())) {
                if (roleType.equals(SrmSignatoryType.PURCHASE.getCode())) {
                    this.purchaseEsignV3SealsService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(PurchaseEsignV3Seals::getOrgAuth, (Object)"1")).eq(PurchaseEsignV3Seals::getSealId, (Object)sealAuth.getSealId())).eq(BaseEntity::getElsAccount, (Object)elsAccount));
                }
                if (roleType.equals(SrmSignatoryType.SALE.getCode())) {
                    this.saleEsignV3SealsService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(SaleEsignV3Seals::getOrgAuth, (Object)"1")).eq(SaleEsignV3Seals::getSealId, (Object)sealAuth.getSealId())).eq(BaseEntity::getElsAccount, (Object)elsAccount));
                }
            } else {
                this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(EsignV3SealsAuth::getSealStatus, (Object)status)).eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(EsignV3SealsAuth::getSealId, (Object)sealAuth.getSealId())).eq(EsignV3SealsAuth::getPsnId, (Object)sealAuth.getAuthorizedPsnId())).eq(EsignV3SealsAuth::getOrgId, (Object)sealAuth.getAuthorizerOrgId()));
            }
        } else if (ObjectUtil.isNotEmpty((Object)sealAuth.getAuthorizedOrgId()) && this.esignV3Properties.getQqtOrgId().equals(sealAuth.getAuthorizedOrgId())) {
            if (roleType.equals(SrmSignatoryType.PURCHASE.getCode())) {
                this.purchaseEsignV3SealsService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(PurchaseEsignV3Seals::getOrgAuth, (Object)"0")).eq(PurchaseEsignV3Seals::getSealId, (Object)sealAuth.getSealId())).eq(BaseEntity::getElsAccount, (Object)elsAccount));
            }
            if (roleType.equals(SrmSignatoryType.SALE.getCode())) {
                this.saleEsignV3SealsService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(SaleEsignV3Seals::getOrgAuth, (Object)"0")).eq(SaleEsignV3Seals::getSealId, (Object)sealAuth.getSealId())).eq(BaseEntity::getElsAccount, (Object)elsAccount));
            }
        } else {
            this.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(EsignV3SealsAuth::getSealId, (Object)sealAuth.getSealId())).eq(EsignV3SealsAuth::getPsnId, (Object)sealAuth.getAuthorizedPsnId())).eq(EsignV3SealsAuth::getOrgId, (Object)sealAuth.getAuthorizerOrgId()));
        }
    }

    public static void main(String[] args) {
        String json = "{\"code\":200,\"message\":\"\u64cd\u4f5c\u6210\u529f\uff01\",\"result\":{\"code\":0,\"data\":{\"authorizationSignUrl\":\"https://smlh5.esign.cn/mesign/guide?context=MEgLQIV7ZOEd&flowId=e7b6b5236da542d8a2b73939c67e0177&organ=true&appId=7438863424&linkSource=1&bizType=1&tsign_source_type=SIGN_LINK_WUKONG&tsign_source_detail=16R2mv%2F27h2Y5CkM9bwhboGU%2BEnKB2Ob4mWV%2FiN2RfCDfOmhZDBqc%2BZKIcl5MJg6YkK%2F6jqAifjIIP1FiHOmaF0t3JEdaB4SzyQaeuNm%2FZYkhUkyLaTo5w07TjAaOPIcdh49%2F2R9d%2FjmLBBgaTNG17myGCikt00vWLPzXtTf3WJ7ubV6oHOVQvc552Am1w4dVvG85M8BliZtX%2B7yQqOjYJOLgCLjDAQ0L6Yef7fR5Ka7cBOzGnAKGb8KniKacpCqB\",\"sealAuthBizIds\":[\"3a29e8f8-a505-444e-b1b1-79676d972a14\",\"729a6ef5-16ea-426c-9654-5eb69e080426\"],\"sealAuthorizeType\":1,\"sealAuthBizInfos\":[{\"sealAuthBizId\":\"3a29e8f8-a505-444e-b1b1-79676d972a14\",\"authorizedPsnId\":\"7cb809a45296474a8f75e68d80b88315\"},{\"sealAuthBizId\":\"729a6ef5-16ea-426c-9654-5eb69e080426\",\"authorizedPsnId\":\"4437d19e5eb744248a18984b9b0b80e1\"}],\"authorizationSignShortUrl\":\"https://smlt.esign.cn/ZwiqtlW4py5i\"},\"message\":\"\u6210\u529f\"},\"success\":true,\"timestamp\":1682324094044}";
    }
}

