/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.listener.schedule.model;

import cn.hutool.core.util.ObjectUtil;
import com.els.modules.system.listener.schedule.DynamicScheduleJob;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSchedulingRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DynamicSchedulingRunnable.class);
    private final DynamicScheduleJob scheduleJob;
    private final Integer second;

    public DynamicSchedulingRunnable(DynamicScheduleJob scheduleJob, Integer second) {
        this.scheduleJob = scheduleJob;
        this.second = second;
    }

    @Override
    public void run() {
        try {
            this.scheduleJob.exec();
        }
        catch (Exception ex) {
            log.error(String.format("### \u5b9a\u65f6\u4efb\u52a1\u5931\u8d25 - bean:%s,\u5f02\u5e38\u4fe1\u606f:{}", this.scheduleJob.beanName()), (Throwable)ex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicSchedulingRunnable that = (DynamicSchedulingRunnable)o;
        return this.scheduleJob.beanName().equals(that.scheduleJob.beanName()) && ObjectUtil.equals((Object)this.second, (Object)that.second);
    }

    public int hashCode() {
        return Objects.hash(this.scheduleJob.beanName(), this.second);
    }
}

