/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.qrcode.QrCodeUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.service.BusinessDeliverToRpcService;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.api.CommonAPI;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.system.vo.SysUserCacheInfo;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.service.AccountDeliverToService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.mapper.PermissionMapper;
import com.els.modules.system.mapper.UserRoleMapper;
import com.els.modules.system.rpc.service.InvokeBusinessDeliverToRpcService;
import com.els.modules.system.service.ElsPasswordPolicyService;
import com.els.modules.system.service.ElsPasswordSecurityService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.vo.ElsSubAccountVO;
import com.els.modules.system.vo.PermissionVO;
import com.els.modules.third.base.util.ClassCompareUtil;
import com.els.rpc.service.CoreInvokeOtherRpcService;
import com.j256.twofactorauth.TimeBasedOneTimePasswordUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ElsSubAccountServiceImpl
extends BaseOpenServiceImpl<ElsSubAccountMapper, ElsSubAccount, ElsSubAccount>
implements ElsSubAccountService {
    private static final Logger log = LoggerFactory.getLogger(ElsSubAccountServiceImpl.class);
    @Resource
    private ElsSubAccountMapper userMapper;
    @Resource
    private PermissionMapper permissionMapper;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Autowired
    private RoleService roleService;
    @Autowired
    private CommonAPI baseAPI;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Autowired
    private ElsPasswordPolicyService policyService;
    @Autowired
    private ElsPasswordSecurityService elsPasswordSecurityService;
    private static final String ACCCOUNT_LIST_PREFIX = "sys:account:permisson:";

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    public Result<?> resetPassword(String subAccount, String oldpassword, String newpassword, String confirmpassword) {
        ElsSubAccount user = this.userMapper.getUserByAccount(TenantContext.getTenant() + "_" + subAccount);
        String passwordEncode = PasswordUtil.encrypt((String)(TenantContext.getTenant() + "_" + subAccount), (String)oldpassword, (String)user.getSalt());
        if (!user.getPassword().equals(passwordEncode)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_OwoWNNSW_29bef277", (String)"\u65e7\u5bc6\u7801\u8f93\u5165\u9519\u8bef!"));
        }
        if (ConvertUtils.isEmpty((Object)newpassword)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_VwoxiTLVW_5c8c5208", (String)"\u65b0\u5bc6\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        }
        if (!newpassword.equals(confirmpassword)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_RmWNwoxIR_5a67fad7", (String)"\u4e24\u6b21\u8f93\u5165\u5bc6\u7801\u4e0d\u4e00\u81f4!"));
        }
        this.elsPasswordSecurityService.verifyfForcePwdHis("1", user.getElsAccount(), subAccount, newpassword);
        LoginUser loginUser = SysUtil.getLoginUser();
        String password = PasswordUtil.encrypt((String)(TenantContext.getTenant() + "_" + subAccount), (String)newpassword, (String)user.getSalt());
        this.policyService.updatePasswordOper(TenantContext.getTenant(), subAccount, user.getRealname(), loginUser.getSubAccount(), newpassword, user.getCreateTime(), password, user.getSalt());
        this.userMapper.update((Object)new ElsSubAccount().setPassword(password), (Wrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)user.getId()));
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_wosRLRW_ca627356", (String)"\u5bc6\u7801\u91cd\u7f6e\u6210\u529f!"));
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    public Result<?> changePassword(ElsSubAccount account) {
        String salt = ConvertUtils.randomGen((int)8);
        account.setSalt(salt);
        String password = account.getPassword();
        String passwordEncode = PasswordUtil.encrypt((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)password, (String)salt);
        account.setPassword(passwordEncode);
        this.userMapper.updateById((Object)account);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_wocrLRW_1e3a7b4c", (String)"\u5bc6\u7801\u4fee\u6539\u6210\u529f!"));
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    @SrmTransaction(rollbackFor={Exception.class})
    public boolean deleteUser(String userId) {
        this.removeById((Serializable)((Object)userId));
        return false;
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    @SrmTransaction(rollbackFor={Exception.class})
    public boolean deleteBatchUsers(String userIds) {
        this.removeByIds(Arrays.asList(userIds.split(",")));
        return false;
    }

    @Override
    public ElsSubAccount getUserBySubAccount(String subAccount) {
        return this.userMapper.getUserByAccount(TenantContext.getTenant() + "_" + subAccount);
    }

    @Override
    public ElsSubAccount getUserByAccount(String account) {
        return this.userMapper.getUserByAccount(account);
    }

    @Override
    public List<ElsSubAccount> getAccountByRoles(String elsAccount, List<String> roles) {
        List<String> strings;
        if (CollectionUtil.isNotEmpty(roles) && CollectionUtil.isNotEmpty(strings = this.roleService.loadUserIdByElsAccountAndRoleCode(elsAccount, roles))) {
            List list1 = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseEntity::getId, strings)).list();
            return list1;
        }
        return null;
    }

    @Override
    @SrmTransaction
    public void addUserWithRole(ElsSubAccount user, String roles) {
        this.save((Object)user);
        this.insertRole(user, roles);
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    @SrmTransaction
    public void editUserWithRole(ElsSubAccount user, String roles) {
        List roleList = this.roleService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(Role::getElsAccount, (Object)user.getElsAccount())).eq(Role::getRoleCode, (Object)"companyAdmin"));
        Assert.notEmpty((Collection)roleList, (String)I18nUtil.translate((String)"i18n_alert_AEslTMKRvjWWWWWWKy_e43c1dd7", (String)"\u4f01\u4e1a\u4e2d\u5fc5\u987b\u5b58\u5728\u7ba1\u7406\u5458[${0}]\u89d2\u8272", (String[])new String[]{"companyAdmin"}));
        String roleId = ((Role)roleList.get(0)).getId();
        if (!("," + roles + ",").contains("," + roleId + ",")) {
            List userRoles = this.userRoleMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(UserRole::getRoleId, (Object)roleId));
            Assert.notEmpty((Collection)userRoles, (String)I18nUtil.translate((String)"i18n_alert_AEslTMKRvjWWWWWWKy_325f6a36", (String)"\u4f01\u4e1a\u4e2d\u5fc5\u987b\u5b58\u5728\u7ba1\u7406\u5458\u89d2\u8272"));
        }
        this.updateById((Object)user);
        this.userRoleMapper.delete((Wrapper)new QueryWrapper().lambda().eq(UserRole::getUserId, (Object)user.getId()));
        this.redisUtil.del(new String[]{"ELSACCOUNT_SUBACCOUNT" + user.getElsAccount() + user.getSubAccount()});
        this.redisUtil.deleteByPrex(ACCCOUNT_LIST_PREFIX);
        this.insertRole(user, roles);
    }

    private void insertRole(ElsSubAccount user, String roles) {
        if (ConvertUtils.isNotEmpty((Object)roles)) {
            String[] arr;
            for (String roleId : arr = roles.split(",")) {
                UserRole userRole = new UserRole(user.getId(), roleId);
                this.userRoleMapper.insert(userRole);
            }
        }
    }

    @Override
    public List<String> getRole(String elsAccount, String subAccount) {
        return this.userRoleMapper.getRoleByUserName(elsAccount, subAccount);
    }

    @Override
    public Set<String> getUserRolesSet(String elsAccount, String subAccount) {
        List<String> roles = this.userRoleMapper.getRoleByUserName(elsAccount, subAccount);
        log.info("-------\u901a\u8fc7\u6570\u636e\u5e93\u8bfb\u53d6\u7528\u6237\u62e5\u6709\u7684\u89d2\u8272Rules------account\uff1a " + elsAccount + "_" + subAccount + ",Roles size: " + roles.size());
        return new HashSet<String>(roles);
    }

    @Override
    public Set<String> getUserPermissionsSet(String elsAccount, String subAccount) {
        HashSet<String> permissionSet = new HashSet<String>();
        List<PermissionVO> permissionList = null;
        String deployWay = SysUtil.getDeployWay();
        permissionList = "cloud".equals(deployWay) ? this.permissionMapper.queryByAccount(elsAccount, subAccount, 0) : this.permissionMapper.queryLocalByAccount(elsAccount, subAccount);
        for (PermissionVO po : permissionList) {
            if (!ConvertUtils.isNotEmpty((Object)po.getPerms())) continue;
            if (po.getPerms().contains(";")) {
                List<String> itemList = Arrays.asList(po.getPerms().split(";"));
                permissionSet.addAll(itemList);
                continue;
            }
            permissionSet.add(po.getPerms());
        }
        return permissionSet;
    }

    @Override
    public SysUserCacheInfo getCacheUser(String account) {
        SysUserCacheInfo info = new SysUserCacheInfo();
        info.setOneDepart(true);
        LoginUser user = this.baseAPI.getUserByAccount(account);
        if (user != null) {
            info.setSysUserCode(user.getSubAccount());
            info.setSysUserName(user.getRealname());
            info.setSysOrgCode(user.getOrgCode());
        }
        return info;
    }

    @Override
    public IPage<ElsSubAccount> getUserByDepId(Page<ElsSubAccount> page, String departId, String username) {
        return this.userMapper.getUserByDepId(page, departId, username);
    }

    @Override
    public IPage<ElsSubAccount> getUserByDepartIdAndQueryWrapper(Page<ElsSubAccount> page, String departId, QueryWrapper<ElsSubAccount> queryWrapper) {
        LambdaQueryWrapper lambdaQueryWrapper = queryWrapper.lambda();
        lambdaQueryWrapper.eq(BaseEntity::getDeleted, (Object)"0");
        lambdaQueryWrapper.inSql(BaseEntity::getId, "SELECT user_id FROM sys_user_depart WHERE dep_id = '" + departId + "'");
        return this.userMapper.selectPage((IPage)page, (Wrapper)lambdaQueryWrapper);
    }

    @Override
    public IPage<ElsSubAccount> getUserByRoleId(Page<ElsSubAccount> page, String roleId, String username) {
        return this.userMapper.getUserByRoleId(page, roleId, username, SysUtil.getLoginUser().getElsAccount());
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, key="#username")
    public void updateUserDepart(String username, String orgCode) {
        ((ElsSubAccountMapper)this.baseMapper).updateUserDepart(username, orgCode);
    }

    @Override
    public void accountFreezeJob() {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsSubAccount::getStatus, (Object)2)).le(ElsSubAccount::getAccountValidityDate, (Object)new Date())).isNotNull(ElsSubAccount::getAccountValidityDate)).update((Object)new ElsSubAccount());
    }

    @Override
    public ElsSubAccount getUserByPhone(String phone) {
        return this.userMapper.getUserByPhone(phone);
    }

    @Override
    public ElsSubAccount getUserByEmail(String email) {
        return this.userMapper.getUserByEmail(email);
    }

    public Result<?> checkUserIsEffective(ElsSubAccount account) {
        Result result = new Result();
        if (account == null) {
            result.error500(I18nUtil.translate((String)"i18n_alert_jDRSwoNSW_d7a449f8", (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef"));
            this.baseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u4e0d\u5b58\u5728\uff01", Integer.valueOf(1), null);
            return result;
        }
        if (CommonConstant.DEL_FLAG_1.equals(account.getDeleted())) {
            this.baseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d:" + account.getSubAccount() + "\u5df2\u6ce8\u9500\uff01", Integer.valueOf(1), null);
            result.error500(I18nUtil.translate((String)"i18n_alert_rjDIdXW_d3c8a06b", (String)"\u8be5\u7528\u6237\u5df2\u6ce8\u9500"));
            return result;
        }
        if (CommonConstant.USER_FREEZE.equals(account.getStatus())) {
            this.baseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d:" + account.getSubAccount() + "\u5df2\u51bb\u7ed3\uff01", Integer.valueOf(1), null);
            result.error500(I18nUtil.translate((String)"i18n_alert_rjDIOyW_d35fed0b", (String)"\u8be5\u7528\u6237\u5df2\u51bb\u7ed3"));
            return result;
        }
        return result;
    }

    @Override
    public ElsSubAccount getByAccount(String elsAccount, String subAccount) {
        return this.userMapper.getUserByAccount(elsAccount + "_" + subAccount);
    }

    @Override
    public Map<String, String> getLogoSetByElsAccount(String elsAccount) {
        return this.userMapper.getLogoSetByElsAccount(elsAccount);
    }

    @Override
    @SrmTransaction
    public void deliverTo(String sourceAccountId, String targetAccountId, String businessDeliverToType) {
        String[] deliverToTypes;
        for (String type : deliverToTypes = businessDeliverToType.split(",")) {
            if ("todo".equals(type)) {
                this.workTodoDeliverTo(sourceAccountId, targetAccountId);
                continue;
            }
            BusinessDeliverToRpcService rpcService = ((InvokeBusinessDeliverToRpcService)SpringContextUtils.getBean(InvokeBusinessDeliverToRpcService.class)).getRpcService(type);
            rpcService.workDeliverTo(sourceAccountId, targetAccountId);
        }
    }

    private void workTodoDeliverTo(String sourceAccountId, String targetAccountId) {
        ElsSubAccount sourceAccount = (ElsSubAccount)((Object)this.getById((Serializable)((Object)sourceAccountId)));
        ElsSubAccount targetAccount = (ElsSubAccount)((Object)this.getById((Serializable)((Object)targetAccountId)));
        String[] beans = SpringContextUtils.getApplicationContext().getBeanNamesForType(AccountDeliverToService.class);
        ElsSubAccountDTO sourceAccountDTO = (ElsSubAccountDTO)SysUtil.copyProperties((Object)((Object)sourceAccount), ElsSubAccountDTO.class);
        ElsSubAccountDTO targetAccountDTO = (ElsSubAccountDTO)SysUtil.copyProperties((Object)((Object)targetAccount), ElsSubAccountDTO.class);
        for (String bean : beans) {
            AccountDeliverToService service = (AccountDeliverToService)SpringContextUtils.getBean((String)bean, AccountDeliverToService.class);
            service.deliverTo(sourceAccountDTO, targetAccountDTO);
        }
    }

    @Override
    public List<ElsSubAccount> getAccountListByElsSubAccountWithoutUser(List<String> elsSubAccountList) {
        return ((ElsSubAccountMapper)this.baseMapper).selectWithoutElsAccountByElsSubAccount(elsSubAccountList);
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getAccount", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List elsSubAccountList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (ElsSubAccount subAccount : elsSubAccountList) {
            this.pushDataToErp(subAccount);
        }
    }

    private void pushDataToErp(ElsSubAccount elsSubAccount) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushAccount", (Object)elsSubAccount);
    }

    private List<String> recursionQuery(List<String> resultList, String elsAccount, String subAccount) {
        List itemList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).likeRight((Object)"superior_leader", (Object)subAccount));
        if (!itemList.isEmpty()) {
            for (ElsSubAccount item : itemList) {
                if (resultList.contains(item.getSubAccount())) continue;
                resultList.add(item.getSubAccount());
                this.recursionQuery(resultList, elsAccount, item.getSubAccount());
            }
        }
        return resultList;
    }

    @Override
    public List<String> getAccountListByLeader(String elsAccount, String subAccount) {
        ArrayList<String> resultList = (ArrayList<String>)this.redisUtil.get(ACCCOUNT_LIST_PREFIX + elsAccount + subAccount);
        if (resultList != null) {
            return resultList;
        }
        resultList = new ArrayList<String>();
        resultList.add(subAccount);
        this.recursionQuery(resultList, elsAccount, subAccount);
        this.redisUtil.set(ACCCOUNT_LIST_PREFIX + elsAccount + subAccount, resultList);
        return resultList;
    }

    @Override
    public String getOtpQr(String elsAccount, String subAccount) {
        ElsSubAccount account = this.getByAccount(elsAccount, subAccount);
        if (account == null) {
            throw new ELSBootException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        String secret = account.getSecret();
        if (StrUtil.isBlank((CharSequence)secret)) {
            secret = TimeBasedOneTimePasswordUtil.generateBase32Secret((int)32);
            ElsSubAccount update = new ElsSubAccount();
            update.setSecret(secret);
            update.setId(account.getId());
            this.updateById((Object)update);
        }
        return this.createQr(elsAccount, subAccount, secret);
    }

    @Override
    public String resetOtpQr(String elsAccount, String subAccount) {
        ElsSubAccount account = this.getByAccount(elsAccount, subAccount);
        if (account == null) {
            throw new ELSBootException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        String secret = TimeBasedOneTimePasswordUtil.generateBase32Secret((int)32);
        ElsSubAccount update = new ElsSubAccount();
        update.setSecret(secret);
        update.setId(account.getId());
        this.updateById((Object)update);
        return this.createQr(elsAccount, subAccount, secret);
    }

    @Override
    public IPage<ElsSubAccount> selectWithoutElsAccountToSelectSubAccount(QueryWrapper<ElsSubAccount> queryWrapper, Integer pageNo, Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.page((IPage)page, (Wrapper)queryWrapper);
        return pageList;
    }

    @Override
    public IPage<ElsSubAccount> getUserNotInRoleId(Page<ElsSubAccount> page, String roleId, String subAccount) {
        return ((ElsSubAccountMapper)this.baseMapper).getUserNotInRoleId(page, roleId, subAccount, SysUtil.getLoginUser().getElsAccount());
    }

    private String createQr(String elsAccount, String subAccount, String secret) {
        String otpauth = "otpauth://totp/" + elsAccount + "_" + subAccount + "?secret=" + secret + "&digits=6";
        BufferedImage image = QrCodeUtil.generate((String)otpauth, (int)300, (int)300);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", stream);
        }
        catch (IOException e) {
            log.error("createQr_failed:", (Throwable)e);
        }
        String base64 = Base64.encode((byte[])stream.toByteArray());
        return "data:image/png;base64," + base64;
    }

    @Override
    public List<ElsSubAccountVO> getUserListByPhone(String phone) {
        List<ElsSubAccountVO> accountList = ((ElsSubAccountMapper)this.baseMapper).getUserListByPhone(phone);
        return accountList;
    }

    @Override
    public void checkTanentParam(String elsAccount, Integer count) {
        log.info("current_deploy_way:" + SysUtil.getDeployWay());
        if ("local".equals(SysUtil.getDeployWay())) {
            return;
        }
        CoreInvokeOtherRpcService rpcService = (CoreInvokeOtherRpcService)SpringContextUtils.getBean(CoreInvokeOtherRpcService.class);
        JSONObject body = new JSONObject();
        body.put("elsAccount", (Object)elsAccount);
        body.put("paramCode", (Object)"SubAccountLimitCount");
        JSONObject result = rpcService.callPanshi("getTenantParam", body);
        log.info("callPanshi_result:" + result.toJSONString());
        if (result.getIntValue("code") != 200) {
            return;
        }
        String checkParam = result.getString("result");
        if ("unlimit".equals(checkParam)) {
            return;
        }
        long currentCount = this.count((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"status", (Object)"1")).eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0));
        log.info("current_subAccount_count:" + currentCount);
        int limitCount = Integer.valueOf(checkParam);
        if ((currentCount += (long)count.intValue()) > (long)limitCount) {
            throw new ELSBootException("\u64cd\u4f5c\u5931\u8d25\uff01\u5f53\u524d\u53ef\u7528\u8d26\u53f7\u6570\u91cf\u8d85\u51fa\u6700\u5927\u8d26\u53f7\u6570\u9650\u5236\uff0c\u6700\u5927\u8d26\u53f7\u6570\u4e3a\uff1a" + limitCount);
        }
    }

    @Override
    public IPage<ElsSubAccountVO> selectSubAccountAndEnterprisePage(Page<ElsSubAccountVO> page, QueryWrapper<ElsSubAccountVO> queryWrapper) {
        return ((ElsSubAccountMapper)this.baseMapper).selectSubAccountAndEnterprisePage(page, queryWrapper);
    }

    @Override
    public List<ElsSubAccountVO> selectSubAccountAndEnterpriseList(QueryWrapper<ElsSubAccountVO> queryWrapper) {
        return ((ElsSubAccountMapper)this.baseMapper).selectSubAccountAndEnterpriseList(queryWrapper);
    }

    @Override
    public long selectSubAccountAndEnterpriseCount(QueryWrapper<ElsSubAccountVO> queryWrapper) {
        return ((ElsSubAccountMapper)this.baseMapper).selectSubAccountAndEnterpriseCount(queryWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean createUserIfNotExist(ElsSubAccount account) {
        String tenant = TenantContext.getTenant();
        try {
            TenantContext.setTenant((String)account.getElsAccount());
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{BaseEntity::getId});
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ElsSubAccount::getElsAccount, (Object)account.getElsAccount())).eq(ElsSubAccount::getSubAccount, (Object)account.getSubAccount())).last(" limit 1");
            ElsSubAccount elsSubAccount = (ElsSubAccount)((Object)((ElsSubAccountMapper)this.baseMapper).selectOne((Wrapper)wrapper));
            if (null != elsSubAccount) {
                account.setId(elsSubAccount.getId());
                Boolean bl = true;
                return bl;
            }
            this.save((Object)account);
            Boolean bl = false;
            return bl;
        }
        finally {
            if (StrUtil.isNotBlank((CharSequence)tenant)) {
                TenantContext.setTenant((String)tenant);
            } else {
                TenantContext.clear();
            }
        }
    }

    @Override
    public IPage<ElsSubAccount> pageWithRole(Page<ElsSubAccount> page, QueryWrapper<ElsSubAccount> queryWrapper, String selectedroles) {
        if (StrUtil.isEmpty((CharSequence)selectedroles)) {
            return ((ElsSubAccountMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)queryWrapper);
        }
        return ((ElsSubAccountMapper)this.baseMapper).pageWithRole(page, queryWrapper, selectedroles, SysUtil.getLoginUser().getElsAccount());
    }

    @Override
    public IPage<ElsSubAccount> pageWithUserId(Page<ElsSubAccount> page, QueryWrapper<ElsSubAccount> queryWrapper, String selectedroles) {
        if (StrUtil.isEmpty((CharSequence)selectedroles)) {
            return ((ElsSubAccountMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)queryWrapper);
        }
        List roleIds = StrUtil.split((CharSequence)selectedroles, (CharSequence)",");
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(UserRole::getRoleId, (Collection)roleIds);
        List userRoles = this.userRoleMapper.selectList((Wrapper)wrapper);
        if (userRoles.isEmpty()) {
            return new Page();
        }
        List userIds = userRoles.stream().map(UserRole::getUserId).collect(Collectors.toList());
        queryWrapper.lambda().in(BaseEntity::getId, userIds);
        return ((ElsSubAccountMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)queryWrapper);
    }

    @Override
    public void batchSaveMain(List<ElsSubAccount> purchaseOrganizationInfoList, List<String> saveColumn, String sourceType) {
        String elsAccount = purchaseOrganizationInfoList.get(0).getElsAccount();
        ArrayList<ElsSubAccount> insertInfo = new ArrayList<ElsSubAccount>();
        ArrayList<ElsSubAccount> updateInfo = new ArrayList<ElsSubAccount>();
        String[] fieldMapping = saveColumn.toArray(new String[saveColumn.size()]);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(ElsSubAccount::getElsAccount, (Object)elsAccount)).eq(ElsSubAccount::getSourceSystem, (Object)sourceType);
        Map collect = this.list((Wrapper)wrapper).stream().collect(Collectors.toMap(ElsSubAccount::getSourceId, Function.identity()));
        for (ElsSubAccount subAccount : purchaseOrganizationInfoList) {
            if (collect.containsKey(subAccount.getSourceId())) {
                ElsSubAccount dbInfo = (ElsSubAccount)((Object)collect.get(subAccount.getSourceId()));
                if (0 >= fieldMapping.length || ClassCompareUtil.appointCompareObject((Object)((Object)dbInfo), (Object)((Object)subAccount), (String[])fieldMapping)) continue;
                subAccount.setId(dbInfo.getId());
                ClassCompareUtil.merger((Object)((Object)subAccount), (Object)((Object)dbInfo));
                updateInfo.add(subAccount);
                continue;
            }
            String password = StringUtils.isNotBlank((CharSequence)subAccount.getPassword()) ? subAccount.getPassword() : "123456";
            String salt = StringUtils.isNotBlank((CharSequence)subAccount.getSalt()) ? subAccount.getSalt() : ConvertUtils.randomGen((int)8);
            String passwordEncode = PasswordUtil.encrypt((String)(elsAccount + "_" + subAccount.getSubAccount()), (String)password, (String)salt);
            subAccount.setPassword(passwordEncode);
            subAccount.setSalt(salt);
            insertInfo.add(subAccount);
        }
        if (CollUtil.isNotEmpty(insertInfo)) {
            this.saveBatch(insertInfo, 2000);
        }
        if (CollUtil.isNotEmpty(updateInfo)) {
            this.updateBatchById(updateInfo, 2000);
        }
    }
}

