/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.jdyxc.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ConnectorConfigDTO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.third.base.entity.ThirdPartyInstance;
import com.els.modules.third.base.entity.ThirdPartyInstanceXc;
import com.els.modules.third.base.enums.ThirdTypeEnum;
import com.els.modules.third.base.mapper.ThirdPartyInstanceMapper;
import com.els.modules.third.base.mapper.ThirdPartyInstanceXcMapper;
import com.els.modules.third.base.util.FieldConvertUtil;
import com.els.modules.third.base.vo.ThirdPartyInstanceAndXcVo;
import com.els.modules.third.jdyxc.dto.RespParamDto;
import com.els.modules.third.jdyxc.dto.ResultDto;
import com.els.modules.third.jdyxc.service.MarketBusinessService;
import com.els.modules.third.jdyxc.util.KingdeeCloudApiUtil;
import com.els.modules.third.jdyxc.util.XcMarketUtil;
import com.els.modules.third.jdyxc.util.XcUtil;
import com.els.modules.third.jdyxc.vo.CallbackVo;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/thirdParty/xc/"})
@RestController
public class JdyXcController {
    private static final Logger log = LoggerFactory.getLogger(JdyXcController.class);
    @Autowired
    private ThirdAccountService thirdAccountService;
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private StaticConfig staticConfig;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private UserRoleService userRoleService;

    @GetMapping(path={"/testConvertJson"})
    public void testConvertJson() {
        String elsAccount = "100000";
        String strJson = "[{\"id\":\"1799251355420877824\",\"bill_no\":\"CGDD-202310-0001\",\"bill_date\":\"2023-10-19\",\"bill_status\":\"C\",\"create_time\":\"2023-10-19 11:51:16\",\"modify_time\":\"2023-10-19 12:23:37\",\"creator_id\":\"11860018\",\"creator_name\":\"\u4efb\u6625\u4e9a\",\"creator_number\":\"u15601684165\",\"modifier_id\":\"11860018\",\"modifier_name\":\"\u4efb\u6625\u4e9a\",\"modifier_number\":\"u15601684165\",\"remark\":\"\",\"dept_id\":\"\",\"dept_name\":\"\",\"dept_number\":\"\",\"emp_id\":\"1753736582097086464\",\"emp_name\":\"\u51af\u777f\u797a\",\"emp_number\":\"ZY00001\",\"supplier_name\":\"\u65e0\u9521\u6d3e\u5473\u4f18\u5546\u8d38\u6709\u9650\u516c\u53f8\",\"supplier_number\":\"GYS00001\",\"io_status\":\"A\",\"currency_id\":\"100000\",\"contact_phone\":\"15995269383\",\"contact_country_id\":\"1000001\",\"contact_country_name\":\"\u4e2d\u56fd\",\"contact_country_number\":\"001\",\"contact_province_id\":\"\",\"contact_province_name\":\"\",\"contact_province_number\":\"\",\"contact_city_id\":\"\",\"contact_city_name\":\"\",\"contact_city_number\":\"\",\"contact_district_id\":\"\",\"contact_district_name\":\"\",\"contact_district_number\":\"\",\"contact_address\":\"\u65e0\u9521\u5e02\u6881\u6eaa\u533a\u91d1\u6865\u526f\u98df\u54c1\u5e02\u573a9\u53f7\u697c960\u53f7\",\"material_entity\":[{\"id\":\"1799251355420876800\",\"material_id\":\"1728211148068628480\",\"material_name\":\"78g\u514b\u4e3d\u5b89\u5496\u5561\u5939\u5fc3\u6761\u997c\u5e72\",\"material_number\":\"000004\",\"material_model\":\"1*24\",\"material_help_code\":\"\",\"stock_name\":\"\u4e0a\u6d77\u4e91\u829d\u541b\u4fe1\u606f\u6280\u672f\u53d1\u5c55\u6709\u9650\u516c\u53f8\",\"stock_number\":\"CK0001\",\"sp_name\":\"\",\"delivery_date\":\"2023-10-19\",\"sp_number\":\"\",\"barcode\":\"8801111186070\",\"price\":140.1769911504,\"tax_price\":158.4,\"base_unit_name\":\"\u7bb1\",\"base_unit_number\":\"\u7bb1\",\"unit_name\":\"\u7bb1\",\"unit_number\":\"\u7bb1\",\"qty\":1,\"all_amount\":158.4,\"tax_amount\":18.22,\"cess\":13,\"close_state\":\"1\"},{\"id\":\"1799251355420876800\",\"material_id\":\"1728211148068628480\",\"material_name\":\"78g\u514b\u4e3d\u5b89\u5496\u5561\u5939\u5fc3\u6761\u997c\u5e72\",\"material_number\":\"000004\",\"material_model\":\"1*24\",\"material_help_code\":\"\",\"stock_name\":\"\u4e0a\u6d77\u4e91\u829d\u541b\u4fe1\u606f\u6280\u672f\u53d1\u5c55\u6709\u9650\u516c\u53f8\",\"stock_number\":\"CK0001\",\"sp_name\":\"\",\"delivery_date\":\"2023-10-19\",\"sp_number\":\"\",\"barcode\":\"8801111186070\",\"price\":140.1769911504,\"tax_price\":158.4,\"base_unit_name\":\"\u7bb1\",\"base_unit_number\":\"\u7bb1\",\"unit_name\":\"\u7bb1\",\"unit_number\":\"\u7bb1\",\"qty\":1,\"all_amount\":158.4,\"tax_amount\":18.22,\"cess\":13,\"close_state\":\"1\"}],\"due_date\":\"2023-10-19\",\"dispatcher_linkman\":\"\",\"dispatcher_phone\":\"\"},{\"id\":\"1799251355420877824\",\"bill_no\":\"CGDD-202310-0001\",\"bill_date\":\"2023-10-19\",\"bill_status\":\"C\",\"create_time\":\"2023-10-19 11:51:16\",\"modify_time\":\"2023-10-19 12:23:37\",\"creator_id\":\"11860018\",\"creator_name\":\"\u4efb\u6625\u4e9a\",\"creator_number\":\"u15601684165\",\"modifier_id\":\"11860018\",\"modifier_name\":\"\u4efb\u6625\u4e9a\",\"modifier_number\":\"u15601684165\",\"remark\":\"\",\"dept_id\":\"\",\"dept_name\":\"\",\"dept_number\":\"\",\"emp_id\":\"1753736582097086464\",\"emp_name\":\"\u51af\u777f\u797a\",\"emp_number\":\"ZY00001\",\"supplier_name\":\"\u65e0\u9521\u6d3e\u5473\u4f18\u5546\u8d38\u6709\u9650\u516c\u53f8\",\"supplier_number\":\"GYS00001\",\"io_status\":\"A\",\"currency_id\":\"100000\",\"contact_phone\":\"15995269383\",\"contact_country_id\":\"1000001\",\"contact_country_name\":\"\u4e2d\u56fd\",\"contact_country_number\":\"001\",\"contact_province_id\":\"\",\"contact_province_name\":\"\",\"contact_province_number\":\"\",\"contact_city_id\":\"\",\"contact_city_name\":\"\",\"contact_city_number\":\"\",\"contact_district_id\":\"\",\"contact_district_name\":\"\",\"contact_district_number\":\"\",\"contact_address\":\"\u65e0\u9521\u5e02\u6881\u6eaa\u533a\u91d1\u6865\u526f\u98df\u54c1\u5e02\u573a9\u53f7\u697c960\u53f7\",\"material_entity\":[{\"id\":\"1799251355420876800\",\"material_id\":\"1728211148068628480\",\"material_name\":\"78g\u514b\u4e3d\u5b89\u5496\u5561\u5939\u5fc3\u6761\u997c\u5e72\",\"material_number\":\"000004\",\"material_model\":\"1*24\",\"material_help_code\":\"\",\"stock_name\":\"\u4e0a\u6d77\u4e91\u829d\u541b\u4fe1\u606f\u6280\u672f\u53d1\u5c55\u6709\u9650\u516c\u53f8\",\"stock_number\":\"CK0001\",\"sp_name\":\"\",\"delivery_date\":\"2023-10-19\",\"sp_number\":\"\",\"barcode\":\"8801111186070\",\"price\":140.1769911504,\"tax_price\":158.4,\"base_unit_name\":\"\u7bb1\",\"base_unit_number\":\"\u7bb1\",\"unit_name\":\"\u7bb1\",\"unit_number\":\"\u7bb1\",\"qty\":1,\"all_amount\":158.4,\"tax_amount\":18.22,\"cess\":13,\"close_state\":\"1\"},{\"id\":\"1799251355420876800\",\"material_id\":\"1728211148068628480\",\"material_name\":\"78g\u514b\u4e3d\u5b89\u5496\u5561\u5939\u5fc3\u6761\u997c\u5e72\",\"material_number\":\"000004\",\"material_model\":\"1*24\",\"material_help_code\":\"\",\"stock_name\":\"\u4e0a\u6d77\u4e91\u829d\u541b\u4fe1\u606f\u6280\u672f\u53d1\u5c55\u6709\u9650\u516c\u53f8\",\"stock_number\":\"CK0001\",\"sp_name\":\"\",\"delivery_date\":\"2023-10-19\",\"sp_number\":\"\",\"barcode\":\"8801111186070\",\"price\":140.1769911504,\"tax_price\":158.4,\"base_unit_name\":\"\u7bb1\",\"base_unit_number\":\"\u7bb1\",\"unit_name\":\"\u7bb1\",\"unit_number\":\"\u7bb1\",\"qty\":1,\"all_amount\":158.4,\"tax_amount\":18.22,\"cess\":13,\"close_state\":\"1\"}],\"due_date\":\"2023-10-19\",\"dispatcher_linkman\":\"\",\"dispatcher_phone\":\"\"}]";
        String srmInterfaceCode = "getPurchaseOrderDetail_01";
        FieldConvertUtil fieldConvertUtil = new FieldConvertUtil();
        System.out.println(fieldConvertUtil.convertJson(elsAccount, srmInterfaceCode, (Object)strJson, null));
    }

    @PostMapping(path={"/callBack/{elsAccount}"})
    public void callBack(@RequestBody @Valid CallbackVo callbackVo, @PathVariable String elsAccount, @RequestHeader HashMap<String, String> headerMap, @RequestParam HashMap<String, String> paramMap) {
        log.info("\u91d1\u8776 callbackVo = {}", (Object)JSONObject.toJSONString((Object)callbackVo));
        TenantContext.setTenant((String)elsAccount);
        ConnectorConfigDTO config = XcUtil.getConnectorConfigDto((String)elsAccount);
        if (null == config) {
            throw new RuntimeException("\u5c1a\u672a\u914d\u7f6e\u79d8\u94a5\u4fe1\u606f");
        }
        String fbk1 = config.getFbk1();
        String fbk2 = config.getFbk2();
        try {
            if (!XcMarketUtil.checkSign(headerMap, paramMap, (String)fbk2)) {
                throw new RuntimeException("\u7b7e\u540d\u6821\u9a8c\u5f02\u5e38");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)callbackVo));
        jsonObject.put("elsAccount", (Object)elsAccount);
        String bizType = jsonObject.getString("bizType");
        ((MarketBusinessService)SpringContextUtils.getBean((String)bizType, MarketBusinessService.class)).handlerBusiness(jsonObject);
    }

    @GetMapping(path={"/callBackJop"})
    public Object callBackJop(HttpServletRequest request) {
        Map requestHeaders = XcMarketUtil.getHeaders((HttpServletRequest)request);
        Map requestParams = XcMarketUtil.getParam((HttpServletRequest)request);
        log.info("BizServiceImpl-->doMessage\u3010show\u3011requestHeaders:{}", (Object)JSON.toJSONString((Object)requestHeaders));
        log.info("BizServiceImpl-->doMessage\u3010show\u3011requestParams:{}", (Object)JSON.toJSONString((Object)requestParams));
        RespParamDto respParam = new RespParamDto();
        try {
            ConnectorConfigDTO config = XcUtil.getConnectorConfigDto((String)"100000");
            String clientSecret = config.getFbk2();
            String requestSign = (String)requestHeaders.get("x-api-signature");
            HashMap reqHeaderParamMap = new HashMap();
            reqHeaderParamMap.put("X-Api-ClientID", requestHeaders.get("x-api-clientid"));
            reqHeaderParamMap.put("X-Api-Auth-Version", requestHeaders.get("x-api-auth-version"));
            reqHeaderParamMap.put("X-Api-TimeStamp", requestHeaders.get("x-api-timestamp"));
            reqHeaderParamMap.put("X-Api-Nonce", requestHeaders.get("x-api-nonce"));
            String paramData = null;
            if (CollectionUtil.isNotEmpty((Map)requestParams)) {
                paramData = KingdeeCloudApiUtil.processParam2((Map)requestParams);
            }
            String serviceSign = XcMarketUtil.getSign(reqHeaderParamMap, (String)clientSecret, (String)"/els/thirdParty/xc/callBackJop", (String)"POST", (String)paramData);
            log.info("requestSign\uff1a{}", (Object)requestSign);
            log.info("serviceSign\uff1a{}", (Object)serviceSign);
            if (!requestSign.equals(serviceSign)) {
                throw new RuntimeException("\u7b7e\u540d\u6821\u9a8c\u5f02\u5e38");
            }
            JSONObject jsonObject = JSON.parseObject((String)XcMarketUtil.getRequestBody((HttpServletRequest)request));
            log.info("BizServiceImpl-->doMessage\u3010show\u3011 paramDto {}:" + JSONObject.toJSONString((Object)jsonObject));
            String type = null;
            if (jsonObject.containsKey((Object)"bizType")) {
                type = jsonObject.getString("bizType");
            } else if (jsonObject.containsKey((Object)"type")) {
                type = jsonObject.getString("type");
            }
            MarketBusinessService marketBusinessService = (MarketBusinessService)SpringContextUtils.getBean((String)type, MarketBusinessService.class);
            respParam = marketBusinessService.handlerBusiness(jsonObject);
        }
        catch (Exception e) {
            respParam.setStatus("1");
            respParam.setMsg(e.getMessage());
            log.error(e.getMessage());
            e.printStackTrace();
        }
        ResultDto responseResult = ResultDto.success((Object)respParam);
        log.info("recieveMessage responseResult:" + responseResult);
        return responseResult;
    }

    @GetMapping(path={"/login"})
    public void login(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String cipherCode = request.getParameter("cipherCode");
        String iv = request.getParameter("iv");
        log.info("iv:{},  cipherCode:{}", (Object)iv, (Object)cipherCode);
        ConnectorConfigDTO config = XcUtil.getConnectorConfigDto((String)"100000");
        if (null == config) {
            throw new RuntimeException("\u5c1a\u672a\u914d\u7f6e\u79d8\u94a5\u4fe1\u606f");
        }
        String result = XcMarketUtil.decryptBody((String)cipherCode, (String)iv, (String)config.getFbk2());
        JSONObject resultJSON = JSONObject.parseObject((String)result);
        JSONObject data = resultJSON.getJSONObject("data");
        String accountId = data.getString("accountid");
        String serviceId = data.getString("serviceid");
        String uId = data.getString("uid");
        ThirdPartyInstanceAndXcVo instance = this.getThirdPartyInstanceAndXcVo(serviceId);
        if (null == instance) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_XLRKItVH_167f7ef2", (String)"\u5c1a\u672a\u5173\u8054\u8ba2\u5355\u4fe1\u606f"));
        }
        String userUuId = instance.getOrderId() + "-" + uId;
        ThirdAccount thirdAccount = this.thirdAccountService.getThirdAccountByOpenId(userUuId, ThirdTypeEnum.THIRD_JD_XC.getValue());
        ElsSubAccount account = (ElsSubAccount)((Object)this.elsSubAccountService.getById((Serializable)((Object)thirdAccount.getUserId())));
        String serviceAddress = (String)this.staticConfig.getConfig().get("service.address");
        StringBuffer url = new StringBuffer(serviceAddress).append("/publicHome");
        this.thirdLoginSRM(response, account, url.toString());
    }

    protected ThirdPartyInstanceAndXcVo getThirdPartyInstanceAndXcVo(String id) {
        ThirdPartyInstanceMapper instanceMapper = (ThirdPartyInstanceMapper)SpringContextUtils.getBean(ThirdPartyInstanceMapper.class);
        ThirdPartyInstanceXcMapper instanceXcMapper = (ThirdPartyInstanceXcMapper)SpringContextUtils.getBean(ThirdPartyInstanceXcMapper.class);
        ThirdPartyInstanceAndXcVo result = new ThirdPartyInstanceAndXcVo();
        log.info("BizBusinessManager-->getThirdPartyInstanceAndXcVo id\uff1a{}", (Object)id);
        ThirdPartyInstance instance = (ThirdPartyInstance)instanceMapper.selectById((Serializable)((Object)id));
        if (instance == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKAcWSMKm_6df691b2", (String)"\u4e0d\u5b58\u5728\u7c7b\u578b\uff0c\u83b7\u53d6\u5931\u8d25"));
        }
        ThirdPartyInstanceXc thirdPartyInstanceXc = (ThirdPartyInstanceXc)instanceXcMapper.selectById((Serializable)((Object)instance.getThirdId()));
        BeanUtils.copyProperties((Object)instance, (Object)result);
        BeanUtils.copyProperties((Object)thirdPartyInstanceXc, (Object)result);
        result.setId(instance.getId());
        return result;
    }

    public void thirdLoginSRM(HttpServletResponse response, ElsSubAccount account, String httpUrl) throws IOException {
        if (null != account.getAccountValidityDate()) {
            Date accountValidityDate = account.getAccountValidityDate();
            Date timeDate = new Date();
            if (timeDate.getTime() > accountValidityDate.getTime()) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LjeDIRjXAWWdVVKHRvjW_2e44c8f3", (String)"\u60a8\u7684\u8d26\u6237\u5df2\u8fc7\u6709\u6548\u671f\u9650\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
            }
        }
        String elsAccount = account.getElsAccount();
        String subAccount = account.getSubAccount();
        String password = account.getPassword();
        String token = JwtUtil.sign((String)(elsAccount + "_" + subAccount), (String)password);
        this.redisUtil.set("sys:token:" + token, (Object)token);
        Integer expiresIn = 43200;
        this.redisUtil.expire("sys:token:" + token, (long)expiresIn.intValue());
        TenantContext.setTenant((String)elsAccount);
        String adminFlag = this.userRoleService.getAdminFlag(elsAccount, subAccount);
        this.redisUtil.set("sys:token:role:" + token, (Object)adminFlag);
        response.setStatus(301);
        response.setHeader("Location", httpUrl);
        StringBuffer sb = new StringBuffer(httpUrl).append("?token=").append(token).append("&loginType=thirdLogin");
        log.info("login url:{}", (Object)sb.toString());
        response.sendRedirect(sb.toString());
    }
}

