/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.jdyxc.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.dto.ConnectorConfigDTO;
import com.els.modules.third.base.entity.ThirdPartyInstance;
import com.els.modules.third.base.mapper.ThirdPartyInstanceMapper;
import com.els.modules.third.jdyxc.service.vo.OrderInstanceCallBackVO;
import com.els.modules.third.jdyxc.util.XcUtil;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;

@Component
public class OrderInstanceCallBackConsumer {
    private static final Logger log = LoggerFactory.getLogger(OrderInstanceCallBackConsumer.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Bean(value={"orderInstanceCallBack"})
    public Consumer<Message<String>> orderInstanceCallBack() {
        return message -> {
            String key = (String)message.getHeaders().get((Object)"ROCKET_KEYS");
            String msgBody = (String)message.getPayload();
            String msgStatus = this.invokeBaseRpcService.getMsgStatusById(key);
            if ("1".equals(msgStatus)) {
                log.error("\u6d88\u606fID\uff1a" + key + " \u5df2\u7ecf\u6d88\u8d39\uff0c\u4e0d\u80fd\u91cd\u590d\u6d88\u8d39\uff01");
                return;
            }
            String errorInfo = "";
            if (StringUtils.isBlank((CharSequence)msgBody)) {
                return;
            }
            JSONObject body = JSONObject.parseObject((String)msgBody);
            log.info("\u63a5\u6536\u6d88\u606f,\u6d88\u606f\u5185\u5bb9:" + body.toJSONString());
            try {
                JSONObject data = body.getJSONObject("data");
                OrderInstanceCallBackVO callBackVO = (OrderInstanceCallBackVO)JSON.parseObject((String)data.toJSONString(), OrderInstanceCallBackVO.class);
                String elsAccount = "100000";
                JSONObject obj = new JSONObject();
                JSONObject bodyParam = new JSONObject();
                bodyParam.put("orderIdEncry", (Object)callBackVO.getOrderIdEncry());
                bodyParam.put("thirdPartyInstanceId", (Object)callBackVO.getInstanceId().toString());
                bodyParam.put("thirdPartyInstanceName", (Object)callBackVO.getInstanceName());
                obj.put("bus_account", (Object)data.getString("elsAccount"));
                obj.put("srm_interface_code", (Object)"PushOrderInstanceCallBack");
                obj.put("body", (Object)bodyParam);
                obj.put("header_param", (Object)XcUtil.buildHeader((String)"/amkapi/order/orderInstanceCallBack", (String)"POST", null, (ConnectorConfigDTO)XcUtil.getConnectorConfigDto((String)"100000")));
                JSONObject result = ((InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class)).callInterface(elsAccount, "", obj, (Object)new JSONObject());
                if (!result.getBoolean("success").booleanValue()) {
                    Integer level = body.getInteger("level");
                    body.put("level", (Object)(level + 1));
                    MqUtil.sendOrderInstanceCallBack((String)body.toJSONString());
                    return;
                }
                ThirdPartyInstance instance = new ThirdPartyInstance();
                instance.setId(callBackVO.getInstanceId().toString());
                instance.setNoticeState("0");
                ((ThirdPartyInstanceMapper)SpringContextUtils.getBean(ThirdPartyInstanceMapper.class)).updateById((Object)instance);
                msgStatus = "1";
            }
            catch (Exception e) {
                log.error("save log failed:", (Throwable)e);
                msgStatus = "2";
                errorInfo = e.getMessage();
            }
            finally {
                this.invokeBaseRpcService.updateRecord(key, msgStatus, errorInfo);
            }
        };
    }
}

