/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.mail.MailUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.api.dto.BaseCreateAccountDto;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.TemplateParseUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.service.SrmToIPaasRpcService;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.message.api.dto.ElsMsgConfigHeadDTO;
import com.els.modules.message.api.dto.MsgConfigItemDTO;
import com.els.modules.message.api.service.MsgConfigRpcService;
import com.els.modules.supplier.api.enumerate.SourceTypeEnum;
import com.els.modules.system.entity.CompanyPermission;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.mapper.PermissionMapper;
import com.els.modules.system.mapper.RoleMapper;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.RolePermissionService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.service.impl.RolePermissionServiceImpl;
import com.els.modules.third.base.enums.ThirdTypeEnum;
import com.els.modules.third.base.util.ThirdUtil;
import com.els.rpc.service.ImGroupInvokeRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CreateAccountUtil {
    private static final Logger log = LoggerFactory.getLogger(CreateAccountUtil.class);
    public static final String ACCOUNT_PERMISSION = "sys:createAccount:permission:";
    public static final String IPASS_ELSACCOUNT = "iPaas.elsAccount";
    public static final String CLOUD_MARKET = "rocketmq.cloudMarket.dealOrder";

    public static String creationProcess(BaseCreateAccountDto accountDto) {
        log.info("CreateAccountUtil-->createAccount \u3010show\u3011 input param\uff1acompanyName\uff1a{} userUuid\uff1a{} phoneNumber\uff1a{}", new Object[]{accountDto.getCompanyName(), accountDto.getUserUuid(), accountDto.getPhoneNumber()});
        SrmToIPaasRpcService srmToIPaasService = (SrmToIPaasRpcService)SpringContextUtils.getBean(SrmToIPaasRpcService.class);
        ElsEnterpriseInfoMapper elsEnterpriseInfoMapper = (ElsEnterpriseInfoMapper)SpringContextUtils.getBean(ElsEnterpriseInfoMapper.class);
        InvokeBaseRpcService invokeBaseRpcService = (InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class);
        ElsEnterpriseInfo elsEnterpriseInfo = null;
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ElsEnterpriseInfo::getName, (Object)accountDto.getCompanyName());
        List enterpriseInfoList = elsEnterpriseInfoMapper.selectList((Wrapper)queryWrapper);
        if (CollUtil.isNotEmpty((Collection)enterpriseInfoList)) {
            return ((ElsEnterpriseInfo)((Object)enterpriseInfoList.get(0))).getElsAccount();
        }
        JSONObject result = srmToIPaasService.callIPaasInterface(ThirdUtil.getIpaaSData((String)accountDto.getCompanyName(), (String)SourceTypeEnum.BUSINESS_PROMOTION.getValue(), (String)"100000"), "valueAddedApplication", invokeBaseRpcService.getIpaasInterfaceCode("get-enterprise-info"));
        log.info("result info:{}", (Object)JSON.toJSONString((Object)result));
        if (result.getBoolean("success").booleanValue()) {
            elsEnterpriseInfo = (ElsEnterpriseInfo)((Object)JSONObject.parseObject((String)result.getJSONObject("data").toJSONString(), ElsEnterpriseInfo.class));
            ElsEnterpriseInfo enterpriseInfo = elsEnterpriseInfoMapper.getByElsAccount(elsEnterpriseInfo.getElsAccount());
            if (enterpriseInfo == null) {
                elsEnterpriseInfo.setDeleted(0);
                elsEnterpriseInfoMapper.insert((Object)elsEnterpriseInfo);
            } else {
                elsEnterpriseInfo.setId(enterpriseInfo.getId());
                elsEnterpriseInfoMapper.updateById((Object)elsEnterpriseInfo);
            }
        } else {
            return null;
        }
        srmToIPaasService.callIPaasInterface(ThirdUtil.getIpaaSRelationData((String)"100000", (String)elsEnterpriseInfo.getElsAccount()), "enterpriseRelationship", null);
        CreateAccountUtil.createAccount(elsEnterpriseInfo.getElsAccount(), "1001", accountDto);
        CreateAccountUtil.sendMsg(accountDto, elsEnterpriseInfo.getElsAccount());
        return elsEnterpriseInfo.getElsAccount();
    }

    public static String createAccount(BaseCreateAccountDto accountDto) {
        log.info("CreateAccountUtil-->createAccount \u3010show\u3011 input param\uff1acompanyName\uff1a{} userUuid\uff1a{} phoneNumber\uff1a{}", new Object[]{accountDto.getCompanyName(), accountDto.getUserUuid(), accountDto.getPhoneNumber()});
        ElsEnterpriseInfo dbEntInfo = ((ElsEnterpriseInfoMapper)SpringContextUtils.getBean(ElsEnterpriseInfoMapper.class)).getByName(accountDto.getCompanyName());
        if (null != dbEntInfo) {
            return dbEntInfo.getElsAccount();
        }
        return CreateAccountUtil.creationProcess(accountDto);
    }

    public static void createAccount(String elsAccount, String subAccount, BaseCreateAccountDto accountDto) {
        ThirdAccount thirdAccount;
        ThirdAccountService accountService = (ThirdAccountService)SpringContextUtils.getBean(ThirdAccountService.class);
        ElsSubAccountService elsSubAccountService = (ElsSubAccountService)SpringContextUtils.getBean(ElsSubAccountService.class);
        ImGroupInvokeRpcService baseImGroupService = (ImGroupInvokeRpcService)SpringContextUtils.getBean(ImGroupInvokeRpcService.class);
        PermissionMapper permissionMapper = (PermissionMapper)SpringContextUtils.getBean(PermissionMapper.class);
        AccountRpcService accountRpcService = (AccountRpcService)SpringContextUtils.getBean(AccountRpcService.class);
        ElsTenantService elsTenantService = (ElsTenantService)SpringContextUtils.getBean(ElsTenantService.class);
        RoleService roleService = (RoleService)SpringContextUtils.getBean(RoleService.class);
        RolePermissionService rolePermissionService = (RolePermissionService)SpringContextUtils.getBean(RolePermissionService.class);
        ThirdAccountService thirdAccountService = (ThirdAccountService)SpringContextUtils.getBean(ThirdAccountService.class);
        if (StringUtils.isNotBlank((CharSequence)accountDto.getUserUuid()) && null != (thirdAccount = accountService.findByOpenId(accountDto.getUserUuid(), accountDto.getThirdType()))) {
            log.error("CreateAccountUtil-->createAccount\u3010show\u3011\u8be5\u7b2c\u4e09\u65b9\u8d26\u53f7\u7c7b\u578b:{},userUuid:{},\u5df2\u7ed1\u5b9a\u8d26\u53f7:{}", new Object[]{accountDto.getThirdType(), accountDto.getUserUuid(), thirdAccount.getElsAccount()});
            return;
        }
        ElsSubAccount account = new ElsSubAccount();
        account.setElsAccount(elsAccount);
        account.setSubAccount(subAccount);
        account.setRealname(StringUtils.isEmpty((CharSequence)accountDto.getSubName()) ? "\u4e91\u5e02\u573a\u7528\u6237" : accountDto.getSubName());
        if (!StringUtils.isEmpty((CharSequence)accountDto.getPhoneNumber())) {
            account.setPhone(accountDto.getPhoneNumber());
        }
        account.setStatus(1);
        account.setSalt(ConvertUtils.randomGen((int)8));
        String passwordEncode = PasswordUtil.encrypt((String)(elsAccount + "_" + account.getSubAccount()), (String)"123456", (String)account.getSalt());
        account.setPassword(passwordEncode);
        account.setDeleted(CommonConstant.DEL_FLAG_0);
        account.setEmail(accountDto.getEmail());
        account.setAvatar(accountDto.getAvatar());
        account.setSourceType(accountDto.getSourceType());
        account.setSourceSystem(accountDto.getThirdType());
        if (null != accountDto.getExpirationTime()) {
            account.setAccountValidityDate(accountDto.getExpirationTime());
        }
        Role role = CreateAccountUtil.createOrGetRole(accountDto, elsAccount);
        boolean exist = elsSubAccountService.createUserIfNotExist(account);
        if (!exist) {
            ((UserRoleService)SpringContextUtils.getBean(UserRoleService.class)).save(new UserRole(account.getId(), role.getId()));
            baseImGroupService.initGroup(account.getId());
        }
        accountRpcService.savePersonalSetting(accountRpcService.buildPersonalSetting(elsAccount, account.getSubAccount()));
        elsTenantService.createIfNotExistElsTenant(elsAccount, accountDto.getCompanyName());
        String roleElsAccount = "100000";
        if ("1001".equals(subAccount) && !exist) {
            Role purchaseRole = roleService.getRoleByElsAccountAndSysCode(roleElsAccount, accountDto.getSourceType());
            if (null == purchaseRole) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u91c7\u8d2d\u65b9\u672a\u627e\u5230\u5bf9\u5e94\u89d2\u8272"));
            }
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(RolePermission::getRoleId, (Object)purchaseRole.getId());
            List list1 = rolePermissionService.list((Wrapper)wrapper);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)list1)) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5bf9\u5e94\u89d2\u8272\u5c1a\u672a\u914d\u7f6e\u6743\u9650"));
            }
            List permissionId = list1.stream().map(RolePermission::getPermissionId).collect(Collectors.toList());
            List list = permissionMapper.selectBatchIds(permissionId);
            if (list != null) {
                permissionMapper.deleteCompanyMeunByAccount(null, elsAccount);
                CreateAccountUtil.handleCompanyPermissionData(list, role, elsAccount);
            }
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ThirdAccount::getThirdType, (Object)accountDto.getThirdType())).eq(ThirdAccount::getThirdUserUuid, (Object)accountDto.getUserUuid())).eq(ThirdAccount::getUserId, (Object)account.getId());
        long count = thirdAccountService.count((Wrapper)wrapper);
        if (count == 0L) {
            ThirdAccount user = new ThirdAccount();
            user.setDeleted(CommonConstant.DEL_FLAG_0);
            user.setStatus(1);
            user.setThirdType(accountDto.getThirdType());
            user.setRealname(accountDto.getSubName());
            user.setThirdUserUuid(accountDto.getUserUuid());
            user.setUserId(account.getId());
            user.setElsAccount(elsAccount);
            user.setAvatar(accountDto.getAvatar());
            user.setCreateTime(new Date());
            thirdAccountService.save((Object)user);
        }
    }

    private static void handleCompanyPermissionData(List<Permission> list, Role role, String elsAccount) {
        PermissionMapper permissionMapper = (PermissionMapper)SpringContextUtils.getBean(PermissionMapper.class);
        ArrayList<CompanyPermission> companyPermissions = new ArrayList<CompanyPermission>();
        for (Permission permission : list) {
            CompanyPermission companyPermission = new CompanyPermission();
            companyPermission.setId(IdWorker.getIdStr());
            companyPermission.setElsAccount(elsAccount);
            companyPermission.setPermissionId(permission.getId());
            companyPermission.setName(permission.getName());
            companyPermission.setSortNo(permission.getSortNo());
            companyPermission.setIcon(permission.getIcon());
            companyPermission.setIconColor(permission.getIconColor());
            companyPermission.setRuleFlag(permission.getRuleFlag());
            companyPermission.setStatus(permission.getStatus());
            companyPermission.setUpdateTime(new Date());
            companyPermissions.add(companyPermission);
        }
        if (CollUtil.isNotEmpty(companyPermissions)) {
            permissionMapper.insertCompanyMeunBatch(companyPermissions);
            ArrayList<RolePermission> RolePermissionList = new ArrayList<RolePermission>();
            for (CompanyPermission companyPermission : companyPermissions) {
                RolePermission rolePermission = new RolePermission();
                rolePermission.setElsAccount(elsAccount);
                rolePermission.setRoleId(role.getId());
                rolePermission.setPermissionId(companyPermission.getPermissionId());
                RolePermissionList.add(rolePermission);
            }
            RolePermissionServiceImpl rolePermissionServiceImpl = (RolePermissionServiceImpl)SpringUtil.getBean(RolePermissionServiceImpl.class);
            rolePermissionServiceImpl.saveBatch(RolePermissionList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Role createOrGetRole(BaseCreateAccountDto accountDto, String elsAccount) {
        RoleMapper roleMapper = (RoleMapper)SpringContextUtils.getBean(RoleMapper.class);
        RoleService roleService = (RoleService)SpringContextUtils.getBean(RoleService.class);
        String tenant = TenantContext.getTenant();
        try {
            TenantContext.setTenant((String)elsAccount);
            Role role = roleService.getRoleByElsAccountAndSysCode(elsAccount, "companyAdmin");
            if (role == null) {
                role = new Role();
                role.setElsAccount(elsAccount);
                role.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
                role.setRoleCode("companyAdmin");
                if (StringUtils.isNotBlank((CharSequence)accountDto.getThirdType())) {
                    role.setDescription(accountDto.getThirdType());
                }
                roleMapper.insert(role);
            }
            Role role2 = role;
            return role2;
        }
        finally {
            TenantContext.clear();
            if (StrUtil.isNotBlank((CharSequence)tenant)) {
                TenantContext.setTenant((String)tenant);
            }
        }
    }

    public static void sendMsg(BaseCreateAccountDto accountDto, String elsAccount) {
        Executor executor = (Executor)SpringContextUtils.getBean((String)"srmPoolExecutor", Executor.class);
        executor.execute(() -> {
            String businessType = "msgReceive";
            String operation = "registerAccount";
            MsgConfigRpcService rpcService = (MsgConfigRpcService)SpringContextUtils.getBean(MsgConfigRpcService.class);
            InvokeBaseRpcService baseRpcService = (InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class);
            String account = "100000";
            List list = rpcService.getByOperation(account, businessType, operation);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                List items = rpcService.findListByMainId(((ElsMsgConfigHeadDTO)list.get(0)).getId());
                for (MsgConfigItemDTO item : items) {
                    List sendSMS;
                    if ("2".equals(item.getMsgType())) {
                        String msgContent = TemplateParseUtil.getTemplateText((String)"", (String)item.getMsgContent(), (Map)CreateAccountUtil.getParamMap(accountDto, elsAccount));
                        List sendMall = baseRpcService.queryDictItemsByCode("send_mall", "100000");
                        if (!CollectionUtils.isEmpty((Collection)sendMall)) {
                            List collect = sendMall.stream().map(DictDTO::getValue).collect(Collectors.toList());
                            for (String to : collect) {
                                try {
                                    MailUtil.send((String)to, (String)"", null, (String)item.getMsgTitle(), (String)msgContent, (boolean)true, (File[])new File[0]);
                                }
                                catch (Exception e) {
                                    log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff1a" + to);
                                }
                            }
                        }
                    }
                    if (!"4".equals(item.getMsgType()) || CollectionUtils.isEmpty((Collection)(sendSMS = baseRpcService.queryDictItemsByCode("send_sms", "100000")))) continue;
                    List phoneNumbers = sendSMS.stream().map(DictDTO::getValue).collect(Collectors.toList());
                    for (Object object : phoneNumbers) {
                    }
                }
            }
        });
    }

    private static JSONObject getParamMap(BaseCreateAccountDto accountDto, String elsAccount) {
        ElsSubAccount userByAccount = ((ElsSubAccountService)SpringContextUtils.getBean(ElsSubAccountService.class)).getUserByAccount(elsAccount);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("companyName", accountDto.getCompanyName());
        paramsMap.put("thirdType", ThirdTypeEnum.getByValue((String)accountDto.getThirdType()));
        paramsMap.put("elsAccount", elsAccount);
        if (null != userByAccount) {
            paramsMap.put("userName", StringUtils.isBlank((CharSequence)userByAccount.getRealname()) ? "\u672a\u77e5" : userByAccount.getRealname());
            paramsMap.put("phone", StringUtils.isBlank((CharSequence)userByAccount.getPhone()) ? "\u672a\u77e5" : userByAccount.getPhone());
            paramsMap.put("email", StringUtils.isBlank((CharSequence)userByAccount.getEmail()) ? "\u672a\u77e5" : userByAccount.getEmail());
        } else {
            paramsMap.put("userName", "\u672a\u77e5");
            paramsMap.put("phone", "\u672a\u77e5");
            paramsMap.put("email", "\u672a\u77e5");
        }
        return new JSONObject(paramsMap);
    }
}

