/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ConvertUtils;
import com.els.common.util.EmailBuilder;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.base.api.dto.ElsEmailConfigDTO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.service.ElsPasswordPolicyService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ForgetPasswordService;
import com.els.modules.system.util.PasswordUtil;
import com.els.modules.system.vo.ForgetPasswordVO;
import com.els.rpc.service.InvokeBaseRpcService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class ForgetPasswordServiceImpl
implements ForgetPasswordService {
    private static final Logger log = LoggerFactory.getLogger(ForgetPasswordServiceImpl.class);
    @Resource
    private ElsSubAccountMapper userMapper;
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsPasswordPolicyService policyService;

    @Override
    public Result<?> getUserInfo(ForgetPasswordVO forgetPasswordVO) {
        if (null == forgetPasswordVO.getAccount()) {
            return Result.error((String)"\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getUserByAccount(forgetPasswordVO.getAccount());
        if (null == elsSubAccount) {
            return Result.error((String)"\u8d26\u53f7\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        BeanUtils.copyProperties((Object)((Object)elsSubAccount), (Object)forgetPasswordVO);
        if (null != forgetPasswordVO.getPhone()) {
            String phone = forgetPasswordVO.getPhone().replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
            forgetPasswordVO.setPhone(phone);
        }
        if (null != forgetPasswordVO.getEmail()) {
            String email = forgetPasswordVO.getEmail().replaceAll("(\\w?)(\\w+)(\\w)(@\\w+\\.[a-z]+(\\.[a-z]+)?)", "$1****$3$4");
            forgetPasswordVO.setEmail(email);
        }
        return Result.ok((Object)forgetPasswordVO);
    }

    @Override
    public Result<?> verifyUserPhone(ForgetPasswordVO forgetPasswordVO) {
        if (null == forgetPasswordVO.getPhone()) {
            return Result.error((String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        ElsSubAccount userByAccount = this.elsSubAccountService.getUserByAccount(forgetPasswordVO.getAccount());
        Assert.notNull((Object)((Object)userByAccount), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        if (StringUtils.isEmpty((Object)userByAccount.getPhone()) && StringUtils.isEmpty((Object)userByAccount.getEmail())) {
            return Result.error((String)"\u8be5\u8d26\u53f7\u5c1a\u672a\u7ed1\u5b9a\u624b\u673a\u6216\u8005\u90ae\u7bb1\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
        }
        if (!userByAccount.getPhone().equals(forgetPasswordVO.getPhone())) {
            return Result.error((String)"\u624b\u673a\u53f7\u7801\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        Result result = this.elsSubAccountService.checkUserIsEffective(userByAccount);
        if (!result.isSuccess()) {
            return Result.error((String)result.getMessage());
        }
        Object object = this.redisUtil.get(userByAccount.getPhone());
        if (object != null) {
            return Result.ok((Object)forgetPasswordVO);
        }
        String captcha = RandomUtil.randomNumbers((int)6);
        JSONObject obj = new JSONObject();
        obj.put("code", (Object)captcha);
        obj.put("minute", (Object)5);
        obj.put("operation", (Object)"get");
        JSONObject msgBody = new JSONObject();
        msgBody.put("msgKey", (Object)userByAccount.getId());
        msgBody.put("busAccount", (Object)userByAccount.getElsAccount());
        msgBody.put("businessType", (Object)"verificationCode");
        msgBody.put("operateType", (Object)"sendMsm");
        JSONObject sendObj = new JSONObject();
        sendObj.put("elsAccount", (Object)"100000");
        sendObj.put("subAccount", (Object)"1001");
        sendObj.put("realname", (Object)"\u7cfb\u7edf\u53d1\u9001");
        msgBody.put("sendObj", (Object)sendObj);
        JSONArray receiveList = new JSONArray();
        JSONObject receive = new JSONObject();
        receive.put("toElsAccount", (Object)userByAccount.getElsAccount());
        JSONArray toSubAccountList = new JSONArray();
        toSubAccountList.add((Object)userByAccount);
        receive.put("toSubAccountList", (Object)toSubAccountList);
        receiveList.add((Object)receive);
        msgBody.put("receiveList", (Object)receiveList);
        msgBody.put("businessObj", (Object)obj);
        MqUtil.sendBusMsg((String)msgBody.toJSONString());
        this.redisUtil.set(userByAccount.getPhone(), (Object)captcha, 600L);
        return Result.ok((Object)forgetPasswordVO);
    }

    @Override
    public Result<?> verifyCode(ForgetPasswordVO forgetPasswordVO) {
        if (null == forgetPasswordVO.getPhone()) {
            return Result.error((String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\uff01");
        }
        if (null == forgetPasswordVO.getCode()) {
            return Result.error((String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\uff01");
        }
        ElsSubAccount userByAccount = this.elsSubAccountService.getUserByAccount(forgetPasswordVO.getAccount());
        Assert.notNull((Object)((Object)userByAccount), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        if (StringUtils.isEmpty((Object)userByAccount.getPhone())) {
            return Result.error((String)"\u8be5\u8d26\u53f7\u5c1a\u672a\u7ed1\u5b9a\u624b\u673a\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
        }
        if (!userByAccount.getPhone().equals(forgetPasswordVO.getPhone())) {
            return Result.error((String)"\u624b\u673a\u53f7\u7801\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        Result result = this.elsSubAccountService.checkUserIsEffective(userByAccount);
        if (!result.isSuccess()) {
            return Result.error((String)result.getMessage());
        }
        Object obj = this.redisUtil.get(forgetPasswordVO.getPhone());
        if (null == obj) {
            return Result.error((String)"\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01");
        }
        if (!obj.toString().equals(forgetPasswordVO.getCode())) {
            return Result.error((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01");
        }
        return Result.ok((Object)forgetPasswordVO);
    }

    @Override
    public Result<?> verifyEmail(ForgetPasswordVO forgetPasswordVO) {
        if (null == forgetPasswordVO.getEmail()) {
            return Result.error((String)"\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        ElsSubAccount userByAccount = this.elsSubAccountService.getUserByAccount(forgetPasswordVO.getAccount());
        Assert.notNull((Object)((Object)userByAccount), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        if (StringUtils.isEmpty((Object)userByAccount.getEmail())) {
            return Result.error((String)"\u8be5\u8d26\u53f7\u5c1a\u672a\u7ed1\u5b9a\u90ae\u7bb1\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
        }
        if (!forgetPasswordVO.getEmail().equals(userByAccount.getEmail())) {
            return Result.error((String)"\u90ae\u7bb1\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        Result result = this.elsSubAccountService.checkUserIsEffective(userByAccount);
        if (!result.isSuccess()) {
            return Result.error((String)result.getMessage());
        }
        String password = PasswordUtil.getPasswords();
        forgetPasswordVO.setPassword(password);
        String salt = ConvertUtils.randomGen((int)8);
        userByAccount.setSalt(salt);
        String passwordEncode = com.els.common.util.PasswordUtil.encrypt((String)forgetPasswordVO.getAccount(), (String)password, (String)salt);
        userByAccount.setPassword(passwordEncode);
        this.userMapper.updateById((Object)userByAccount);
        ElsEmailConfigDTO config = this.invokeBaseRpcService.getEmailConfig(userByAccount.getElsAccount());
        if (null == config) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LERjdER_891222af", (String)"\u672a\u914d\u7f6e\u90ae\u7bb1\u914d\u7f6e"));
        }
        EmailBuilder.sendEmailWithEp((ElsEmailConfigDTO)config, (String)userByAccount.getEmail(), (String)"\u5bc6\u7801\u4fee\u6539\u6210\u529f,\u8bf7\u91cd\u65b0\u767b\u5f55", (String)("\u65b0\u5bc6\u7801\u4e3a\uff1a" + password), null, (boolean)false);
        return Result.ok((String)"\u4fee\u6539\u5bc6\u7801\u6210\u529f\u3002");
    }

    @Override
    public Result<?> resetPassword(ForgetPasswordVO forgetPasswordVO) {
        if (null == forgetPasswordVO.getPassword()) {
            return Result.error((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        if (null == forgetPasswordVO.getNewPassword()) {
            return Result.error((String)"\u786e\u8ba4\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        if (!forgetPasswordVO.getPassword().equals(forgetPasswordVO.getNewPassword())) {
            return Result.error((String)"\u4e24\u6b21\u8f93\u5165\u5bc6\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getUserByAccount(forgetPasswordVO.getAccount());
        Result result = this.elsSubAccountService.checkUserIsEffective(elsSubAccount);
        if (!result.isSuccess()) {
            return Result.error((String)result.getMessage());
        }
        this.policyService.updatePasswordOper(elsSubAccount.getElsAccount(), elsSubAccount.getSubAccount(), elsSubAccount.getRealname(), elsSubAccount.getSubAccount(), forgetPasswordVO.getNewPassword(), elsSubAccount.getCreateTime());
        String salt = ConvertUtils.randomGen((int)8);
        elsSubAccount.setSalt(salt);
        String passwordEncode = com.els.common.util.PasswordUtil.encrypt((String)forgetPasswordVO.getAccount(), (String)forgetPasswordVO.getPassword(), (String)salt);
        elsSubAccount.setPassword(passwordEncode);
        this.userMapper.updateById((Object)elsSubAccount);
        return Result.ok((String)"\u4fee\u6539\u5bc6\u7801\u6210\u529f\u3002");
    }
}

