/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contractlock.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contractlock.entity.SaleClSeals;
import com.els.modules.contractlock.enumerate.CLEnableEnum;
import com.els.modules.contractlock.mapper.SaleClSealsMapper;
import com.els.modules.contractlock.service.SaleClPersonalInfoService;
import com.els.modules.contractlock.service.SaleClSealsService;
import com.els.modules.contractlock.util.ClResultAnalysisUtil;
import com.els.modules.contractlock.vo.ClCallback;
import com.els.modules.contractlock.vo.ClQuerySealListVO;
import com.els.modules.contractlock.vo.ClSealVO;
import com.els.modules.contractlock.vo.SaleClSealsVo;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleClSealsServiceImpl
extends BaseServiceImpl<SaleClSealsMapper, SaleClSeals>
implements SaleClSealsService {
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleClPersonalInfoService saleClPersonalInfoService;

    private void insert(SaleClSeals saleClSeals) {
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        saleClSeals.setBusAccount(TenantContext.getTenant());
        saleClSeals.setCreateAccount(TenantContext.getTenant());
        saleClSeals.setCreateTime(new Date());
        saleClSeals.setCreateBy(currentUser);
        ((SaleClSealsMapper)this.baseMapper).insert((Object)saleClSeals);
    }

    private void update(SaleClSeals saleClSeals) {
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        saleClSeals.setUpdateTime(new Date());
        saleClSeals.setUpdateBy(currentUser);
        int count = ((SaleClSealsMapper)this.baseMapper).updateById((Object)saleClSeals);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void add(SaleClSeals saleClSeals) {
        this.insert(saleClSeals);
    }

    @Override
    public void edit(SaleClSeals saleClSeals) {
        if (StrUtil.isNotBlank((CharSequence)saleClSeals.getOperateStatus())) {
            String status = saleClSeals.getOperateStatus();
            Assert.isTrue((status.equals(CLEnableEnum.ENABLE.getValue()) || status.equals(CLEnableEnum.DISABLE.getValue()) ? 1 : 0) != 0, (String)"seals operateStatus error");
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)saleClSeals.getCompanyId()), (String)"companyId is null");
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)saleClSeals.getSealId()), (String)"\u8bf7\u5148\u63a8\u9001\u5370\u7ae0\u5230\u5951\u7ea6\u9501");
            ClSealVO clSealVO = new ClSealVO();
            ClSealVO.Body body = new ClSealVO.Body();
            body.setSealId(saleClSeals.getSealId());
            body.setOperate(saleClSeals.getOperateStatus());
            clSealVO.setCompanyId(saleClSeals.getCompanyId());
            clSealVO.setBody(body);
            Result<?> response = this.getIPassResponse(clSealVO, "modify-seal-status");
            if (!response.isSuccess()) {
                Assert.isTrue((boolean)false, (String)response.getMessage());
            }
        }
        this.update(saleClSeals);
    }

    @Override
    public void delete(String id) {
        SaleClSeals seals = (SaleClSeals)((Object)this.getById((Serializable)((Object)id)));
        Assert.isTrue((boolean)StrUtil.equals((CharSequence)CLEnableEnum.ENABLE.getValue(), (CharSequence)seals.getOperateStatus()), (String)"\u8bf7\u5148\u7981\u7528\u5370\u7ae0");
        if (StrUtil.equals((CharSequence)CLEnableEnum.DISABLE.getValue(), (CharSequence)seals.getOperateStatus())) {
            ClSealVO clSealVO = new ClSealVO();
            ClSealVO.Body base = new ClSealVO.Body();
            base.setSealId(seals.getSealId());
            clSealVO.setCompanyId(seals.getCompanyId());
            clSealVO.setBase(base);
            Result<?> response = this.getIPassResponse(clSealVO, "delete-seal");
            if (!response.isSuccess()) {
                Assert.isTrue((boolean)false, (String)response.getMessage());
            }
        }
        ((SaleClSealsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleClSealsMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void push(SaleClSeals saleClSeals) {
        ClSealVO clSealVO = new ClSealVO();
        ClSealVO.Body body = new ClSealVO.Body();
        BeanUtil.copyProperties((Object)((Object)saleClSeals), (Object)body, (String[])new String[0]);
        body.setFileName(saleClSeals.getFilePath());
        body.setCallbackUrl(this.address + "/els/contractLock/saleClSeals/noToken/callback/create");
        clSealVO.setCompanyId(saleClSeals.getCompanyId());
        if ("".equals(body.getSealSpec())) {
            body.setSealSpec(null);
        }
        ArrayList userBeans = Lists.newArrayList();
        if (StrUtil.isNotBlank((CharSequence)saleClSeals.getUserIds())) {
            String[] ids = saleClSeals.getUserIds().split(",");
            List infos = this.saleClPersonalInfoService.listByIds(Arrays.asList(ids));
            userBeans.addAll(infos.stream().map(x -> {
                ClSealVO.UserBean userBean = new ClSealVO.UserBean();
                userBean.setContact(x.getApplyContact());
                userBean.setContactType(x.getApplyContactType());
                return userBean;
            }).collect(Collectors.toList()));
        }
        body.setSealUsers(userBeans);
        clSealVO.setBody(body);
        Result<?> response = this.getIPassResponse(clSealVO, "add-seal-image");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            String applyId = jsonObject.getString("applyId");
            saleClSeals.setApplyId(applyId);
            saleClSeals.setUploaded("1");
            this.update(saleClSeals);
        } else {
            Assert.isTrue((boolean)false, (String)response.getMessage());
        }
    }

    @Override
    public void refresh() {
        List list = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).isNotNull(SaleClSeals::getCompanyId));
        List<String> companyIds = list.stream().map(x -> x.getCompanyId()).collect(Collectors.toList());
        companyIds.forEach(id -> {
            ClQuerySealListVO vo = new ClQuerySealListVO();
            vo.setCompanyId((String)id);
            Result<?> response = this.getIPassResponse(vo, "query-seal-list");
        });
    }

    @Override
    public void handleCallBack(ClCallback.Seals seals) {
        SaleClSeals saleClSeals = ((SaleClSealsMapper)this.baseMapper).selectByRequestId(seals.getApplyId());
        if (ObjectUtil.isNotNull((Object)((Object)saleClSeals))) {
            ClCallback.Detail detail = seals.getDetail();
            saleClSeals.setSealId(detail.getSealId());
            saleClSeals.setSealType(detail.getSealType());
            saleClSeals.setOperateStatus(CLEnableEnum.ENABLE.getValue());
            this.updateById((Object)saleClSeals);
        }
    }

    @Override
    public SaleClSealsVo getByIdShow(String id) {
        SaleClSeals clSeals = (SaleClSeals)((Object)this.getById((Serializable)((Object)id)));
        if (ObjectUtil.isNotNull((Object)((Object)clSeals))) {
            String[] ids;
            List infos;
            SaleClSealsVo vo = new SaleClSealsVo();
            BeanUtil.copyProperties((Object)((Object)clSeals), (Object)((Object)vo), (String[])new String[0]);
            if (StrUtil.isNotBlank((CharSequence)clSeals.getUserIds()) && CollUtil.isNotEmpty((Collection)(infos = this.saleClPersonalInfoService.listByIds(Arrays.asList(ids = clSeals.getUserIds().split(",")))))) {
                vo.setUserNames(infos.stream().map(x -> x.getApplyUserName()).distinct().collect(Collectors.joining(",")));
            }
            return vo;
        }
        return null;
    }

    private Result<?> getIPassResponse(Object req, String iPassCode) {
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)req)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(iPassCode));
        return ClResultAnalysisUtil.analysisResult(object);
    }
}

