/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.enums.AccountStatusEnum;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.vo.InitPermissionVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u79df\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/account/elsTenant"})
public class ElsTenantController
extends BaseController<ElsTenant, ElsTenantService> {
    @Autowired
    private ElsTenantService elsTenantService;
    @Autowired
    private PermissionService permissionService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsTenant elsTenant, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsTenant), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsTenantService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u79df\u6237\u7ba1\u7406-\u6dfb\u52a0", logType=2, operateType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsTenant elsTenant) {
        elsTenant.setAccountStatus(AccountStatusEnum.NORMAL.getCode());
        this.elsTenantService.saveElsTenant(elsTenant);
        return Result.ok((Object)((Object)elsTenant));
    }

    @AutoLog(value="\u79df\u6237\u7ba1\u7406-\u7f16\u8f91", logType=2, operateType=3)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsTenant elsTenant) {
        this.elsTenantService.updateElsTenant(elsTenant);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u79df\u6237\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.elsTenantService.delElsTenant(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u79df\u6237\u7ba1\u7406-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.elsTenantService.delBatchElsTenant(idList);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u79df\u6237\u7ba1\u7406-\u521d\u59cb\u5316\u6743\u9650")
    @ApiOperation(value="\u521d\u59cb\u5316\u6743\u9650", notes="\u521d\u59cb\u5316\u6743\u9650")
    @PostMapping(value={"/initPermission"})
    public Result<?> initPermission(@RequestBody InitPermissionVO param) {
        List<String> arrayList = param.getElsAccountList();
        if (!CollectionUtils.isEmpty(arrayList)) {
            for (String elsAccount : arrayList) {
                if (!elsAccount.equals("100000")) continue;
                throw new ELSBootException("\u4e0d\u80fd\u521d\u59cb\u5316100000\u53f7\u6743\u9650\uff01");
            }
            this.permissionService.initAccountPermissionList(arrayList, param.getRole());
        }
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ElsTenant elsTenant = (ElsTenant)((Object)this.elsTenantService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)elsTenant));
    }

    @AutoLog(value="\u79df\u6237\u7ba1\u7406-\u51bb\u7ed3/\u89e3\u51bb", logType=2, operateType=3)
    @ApiOperation(value="\u51bb\u7ed3/\u89e3\u51bb", notes="\u51bb\u7ed3/\u89e3\u51bb")
    @GetMapping(value={"/frozenOpt"})
    public Result<?> frozenOpt(@RequestParam(name="id", required=true) String id) {
        ElsTenant elsTenant = (ElsTenant)((Object)this.elsTenantService.getById((Serializable)((Object)id)));
        String accountStatus = AccountStatusEnum.NORMAL.getCode();
        if (accountStatus.equals(elsTenant.getAccountStatus())) {
            accountStatus = AccountStatusEnum.FROZEN.getCode();
        }
        this.elsTenantService.update((Object)new ElsTenant().setAccountStatus(accountStatus), (Wrapper)new UpdateWrapper().lambda().eq(BaseEntity::getId, (Object)id));
        return Result.ok((Object)((Object)elsTenant));
    }

    @ApiOperation(value="\u767b\u5f55\u9875\u67e5\u8be2\u79df\u6237\u4fe1\u606f", notes="\u767b\u5f55\u9875\u67e5\u8be2\u79df\u6237\u4fe1\u606f")
    @GetMapping(value={"/noToken/queryByParam"})
    public Result<?> queryByParam(String elsAccount) {
        ElsTenant tenant = this.elsTenantService.findByElsAccount(elsAccount);
        return Result.ok((Object)((Object)tenant));
    }
}

