/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.api.CommonAPI;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.MD5Util;
import com.els.common.util.MqUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.encryption.EncryptedString;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ElsBusinessRuleDTO;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.sms.api.dto.SmsDto;
import com.els.modules.sms.api.dto.SmsResult;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.model.LoginModel;
import com.els.modules.system.rpc.service.InvokeBaseRpcService;
import com.els.modules.system.rpc.service.InvokeSmsRpcService;
import com.els.modules.system.service.ElsPasswordSecurityService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.vo.ElsSubAccountVO;
import com.els.shiro.authc.JwtToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/account"})
@Api(tags={"\u7528\u6237\u767b\u5f55"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private CommonAPI sysBaseAPI;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ElsTenantService elsTenantService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private ThirdAccountService thirdAccountService;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Resource
    private InvokeSmsRpcService invokeSmsRpcService;
    @Autowired
    private ElsPasswordSecurityService pwSecurityService;
    private String version = this.getClass().getPackage().getImplementationVersion();
    private static final String BASE_CHECK_CODES = "azxctyuipqwergfdsvbnlkjhmTQURGZXHFDSAWEPMLKCVBJYN1234567890";

    @ApiOperation(value="\u767b\u5f55\u63a5\u53e3")
    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public Result<JSONObject> login(@RequestBody LoginModel sysLoginModel) {
        log.info(":::doLogin:{}", (Object)sysLoginModel);
        Result<JSONObject> result = new Result<JSONObject>();
        TenantContext.setTenant((String)sysLoginModel.getElsAccount());
        sysLoginModel.setElsAccount(sysLoginModel.getElsAccount().trim());
        this.pwSecurityService.verifyErrorLock(sysLoginModel.getElsAccount().trim(), sysLoginModel.getSubAccount().trim());
        result = this.checkUser(sysLoginModel);
        MqUtil.sendLogMsg((String)sysLoginModel.getElsAccount(), (String)("\u8d26\u53f7: " + sysLoginModel.getElsAccount() + "_" + sysLoginModel.getSubAccount() + ",\u767b\u5f55\u6210\u529f\uff01\u65f6\u95f4\uff1a" + DateUtil.formatDateTime((Date)new Date())), (Integer)1, null);
        return result;
    }

    @AutoLog(value="\u901a\u8fc7token\u767b\u5f55", logType=1)
    @RequestMapping(value={"/loginByToken"}, method={RequestMethod.GET})
    public Result<?> loginByToken(@RequestParam(name="token", required=true) String token) {
        String account = JwtUtil.getAccount((String)token);
        if (StrUtil.isBlank((CharSequence)account)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"token \u683c\u5f0f\u9519\u8bef\uff01"));
        }
        TenantContext.setTenant((String)account.split("_")[0]);
        ElsSubAccount subAccount = this.elsSubAccountService.getUserByAccount(account);
        if (!JwtUtil.verify((String)token, (String)account, (String)subAccount.getPassword())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWWKXWVVVEHW_8bdef769", (String)"Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55!"));
        }
        Result<JSONObject> result = new Result<JSONObject>();
        if (!"100000".equals(subAccount.getElsAccount()) && !(result = this.elsTenantService.checkTenantIsEffective(subAccount.getElsAccount())).isSuccess()) {
            return result;
        }
        this.userInfo(subAccount, result);
        MqUtil.sendLogMsg((String)subAccount.getElsAccount(), (String)("\u8d26\u53f7: " + subAccount.getElsAccount() + "_" + subAccount.getSubAccount() + ",\u767b\u5f55\u6210\u529f\uff01\u65f6\u95f4\uff1a" + DateUtil.formatDateTime((Date)new Date())), (Integer)1, null);
        return result;
    }

    @ApiOperation(value="\u79fb\u52a8\u7aef\u767b\u5f55\u63a5\u53e3")
    @RequestMapping(value={"/loginForMobile"}, method={RequestMethod.POST})
    public Result<JSONObject> loginForMobile(@RequestBody LoginModel sysLoginModel) {
        Result<JSONObject> result = this.checkUser(sysLoginModel);
        MqUtil.sendLogMsg((String)sysLoginModel.getElsAccount(), (String)("\u7528\u6237\u540d: " + sysLoginModel.getSubAccount() + ",\u79fb\u52a8\u7aef\u767b\u5f55\u6210\u529f\uff01"), (Integer)1, null);
        return result;
    }

    private Result<JSONObject> checkUser(LoginModel sysLoginModel) {
        Result result = new Result();
        String elsAccount = sysLoginModel.getElsAccount();
        String subAccount = sysLoginModel.getSubAccount();
        String password = sysLoginModel.getPassword();
        if (!"100000".equals(elsAccount) && !(result = this.elsTenantService.checkTenantIsEffective(elsAccount)).isSuccess()) {
            throw new ELSBootException(result.getMessage());
        }
        ElsSubAccount sysUser = this.elsSubAccountService.getUserBySubAccount(subAccount);
        result = this.elsSubAccountService.checkUserIsEffective(sysUser);
        if (!result.isSuccess()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)result.getMessage()));
        }
        String userpassword = PasswordUtil.encrypt((String)(elsAccount + "_" + sysUser.getSubAccount()), (String)password, (String)sysUser.getSalt());
        String syspassword = sysUser.getPassword();
        if (!syspassword.equals(userpassword)) {
            this.pwSecurityService.setUpLoginErrorNum(elsAccount, sysUser.getSubAccount());
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef"));
        }
        if (null != sysUser.getAccountValidityDate()) {
            Date accountValidityDate = sysUser.getAccountValidityDate();
            Date timeDate = new Date();
            if (timeDate.getTime() > accountValidityDate.getTime()) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u60a8\u7684\u8d26\u6237\u5df2\u8fc7\u6709\u6548\u671f\u9650\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
            }
        }
        this.pwSecurityService.setRepeatLoginToken(elsAccount, sysUser.getSubAccount());
        this.userInfo(sysUser, (Result<JSONObject>)result);
        if (StrUtil.isNotBlank((CharSequence)sysLoginModel.getThirdUserUuid())) {
            this.bindUserId(sysUser.getId(), elsAccount, sysLoginModel.getThirdUserUuid());
        }
        return result;
    }

    private void bindUserId(String userId, String elsAccount, String thirdUserUuid) {
        ThirdAccount thirdAccount = (ThirdAccount)((Object)this.thirdAccountService.getById((Serializable)((Object)thirdUserUuid)));
        if (null == thirdAccount) {
            return;
        }
        thirdAccount.setUserId(userId);
        thirdAccount.setElsAccount(elsAccount);
        this.thirdAccountService.updateById((Object)thirdAccount);
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.POST})
    public Result<Object> logout(HttpServletRequest request, HttpServletResponse response) {
        String token = request.getHeader("X-Access-Token");
        if (ConvertUtils.isEmpty((Object)token)) {
            return Result.ok((String)"\u9000\u51fa\u767b\u5f55\u6210\u529f\uff01");
        }
        String account = JwtUtil.getAccount((String)token);
        LoginUser sysUser = this.sysBaseAPI.getUserByAccount(account);
        if (sysUser != null) {
            MqUtil.sendLogMsg((String)sysUser.getElsAccount(), (String)("\u8d26\u53f7: " + account + ",\u9000\u51fa\u6210\u529f\uff01\u65f6\u95f4\uff1a" + DateUtil.formatDateTime((Date)new Date())), (Integer)4, null);
            log.info(" \u8d26\u53f7:  " + account + ",\u9000\u51fa\u6210\u529f\uff01 ");
            this.redisUtil.del(new String[]{"sys:token:" + token});
            this.redisUtil.del(new String[]{"sys:token:" + account});
            this.redisUtil.del(new String[]{"sys:token:repeat:" + token});
            this.redisUtil.del(new String[]{"shiro:cache:com.els.modules.shiro.authc.ShiroRealm.authorizationCache:" + sysUser.getId()});
            this.redisUtil.del(new String[]{String.format("%s::%s", "sys:cache:user", account)});
            this.redisUtil.del(new String[]{"sys:token:role:" + token});
            SecurityUtils.getSubject().logout();
        }
        return Result.ok((String)"\u9000\u51fa\u767b\u5f55\u6210\u529f\uff01");
    }

    @AutoLog(value="\u53d1\u77ed\u4fe1\u77ed\u4fe1\u63a5\u53e3", logType=1)
    @PostMapping(value={"/sms"})
    public Result<String> sms(@RequestBody SmsDto smsDto) {
        ElsSubAccount sysUser;
        Result result = new Result();
        if (!"1".equals(smsDto.getSmsmode()) && !(result = this.elsSubAccountService.checkUserIsEffective(sysUser = this.elsSubAccountService.getUserByPhone(smsDto.getMobile()))).isSuccess()) {
            return result;
        }
        SmsResult smsResult = this.invokeSmsRpcService.sendSms(smsDto);
        result.setSuccess(smsResult.isSuccess());
        result.setMessage(smsResult.getMessage());
        return result;
    }

    @AutoLog(value="\u624b\u673a\u53f7\u767b\u5f55\u63a5\u53e3", logType=1)
    @ApiOperation(value="\u624b\u673a\u53f7\u767b\u5f55\u63a5\u53e3")
    @PostMapping(value={"/phoneLogin"})
    public Result<JSONObject> phoneLogin(@RequestBody JSONObject jsonObject) {
        Object code;
        Result result = new Result();
        String phone = jsonObject.getString("mobile");
        ElsSubAccount sysUser = this.elsSubAccountService.getUserByPhone(phone);
        result = this.elsSubAccountService.checkUserIsEffective(sysUser);
        if (!result.isSuccess()) {
            return result;
        }
        String smscode = jsonObject.getString("captcha");
        if (!smscode.equals(code = this.redisUtil.get(phone))) {
            result.setMessage("\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef");
            return result;
        }
        this.userInfo(sysUser, (Result<JSONObject>)result);
        MqUtil.sendLogMsg((String)sysUser.getElsAccount(), (String)("\u7528\u6237\u540d: " + sysUser.getSubAccount() + ",\u767b\u5f55\u6210\u529f\uff01"), (Integer)1, null);
        return result;
    }

    private Result<JSONObject> userInfo(ElsSubAccount sysUser, Result<JSONObject> result) {
        String syspassword = sysUser.getPassword();
        String elsAccount = sysUser.getElsAccount();
        String subAccount = sysUser.getSubAccount();
        String token = JwtUtil.sign((String)(elsAccount + "_" + subAccount), (String)syspassword);
        this.redisUtil.set("sys:token:" + token, (Object)token);
        this.redisUtil.expire("sys:token:" + token, 3600L);
        this.redisUtil.set("sys:token:" + elsAccount + "_" + subAccount, (Object)token);
        this.redisUtil.expire("sys:token:" + elsAccount + "_" + subAccount, 3600L);
        String adminFlag = this.userRoleService.getAdminFlag(elsAccount, subAccount);
        this.redisUtil.set("sys:token:role:" + token, (Object)adminFlag, 86400L);
        List<ElsCompanySetDTO> list = this.baseRpcService.getCompanySetList(elsAccount);
        ElsTenant byElsAccount = this.elsTenantService.findByElsAccount(elsAccount);
        ElsCompanySetDTO elsCompanySetDTO1 = new ElsCompanySetDTO();
        elsCompanySetDTO1.setItemCode("companyShortName");
        elsCompanySetDTO1.setDefaultValue(byElsAccount != null ? byElsAccount.getCompanyShortName() : "");
        list.add(elsCompanySetDTO1);
        ElsCompanySetDTO elsCompanySetDTO2 = new ElsCompanySetDTO();
        elsCompanySetDTO2.setItemCode("companyLogo");
        elsCompanySetDTO2.setDefaultValue(byElsAccount != null ? byElsAccount.getCompanyLogo() : "");
        list.add(elsCompanySetDTO2);
        JSONObject companySetObj = this.getObjBySet(list);
        ElsSubAccountVO elsSubAccountVO = new ElsSubAccountVO();
        BeanUtils.copyProperties((Object)((Object)sysUser), (Object)((Object)elsSubAccountVO));
        List userRole = this.userRoleService.list((Wrapper)new QueryWrapper().lambda().eq(UserRole::getUserId, (Object)sysUser.getId()));
        StringBuilder str = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)userRole)) {
            for (UserRole sysUserRole : userRole) {
                if (str.length() == 0) {
                    str.append(sysUserRole.getRoleId());
                    continue;
                }
                str.append(",").append(sysUserRole.getRoleId());
            }
        }
        elsSubAccountVO.setSelectedroles(str.toString());
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        elsSubAccountVO.setSerivceUrl((String)config.get("service.address"));
        Map<String, String> map = this.elsSubAccountService.getLogoSetByElsAccount(elsAccount);
        if (map != null) {
            elsSubAccountVO.setAliasName(map.get("alias"));
            elsSubAccountVO.setEnterpriseName(map.get("name"));
            elsSubAccountVO.setEnterpriseLogo(companySetObj.getString("enterpriseLogo") != null && "1".equals(companySetObj.getString("enterpriseLogo")) && map.get("enterprise_logo") != null ? map.get("enterprise_logo") : "");
        }
        List<ElsBusinessRuleDTO> businessRulets = this.baseRpcService.getBusinessRuletList(elsAccount);
        JSONArray businessRuleList = this.getBusinessRuleList(businessRulets);
        companySetObj.put("businessRuleList", (Object)businessRuleList);
        JSONObject obj = new JSONObject();
        obj.put("token", (Object)token);
        obj.put("userInfo", (Object)elsSubAccountVO);
        obj.put("companySet", (Object)companySetObj);
        obj.put("srmVersion", (Object)this.version);
        result.setResult((Object)obj);
        result.success("\u767b\u5f55\u6210\u529f");
        JwtToken jwtToken = new JwtToken(token);
        SecurityUtils.getSubject().login((AuthenticationToken)jwtToken);
        return result;
    }

    private JSONArray getBusinessRuleList(List<ElsBusinessRuleDTO> list) {
        JSONArray jsonArray = new JSONArray();
        JSONObject object = null;
        String type = null;
        String action = null;
        String defaultValue = null;
        for (ElsBusinessRuleDTO ruleDTO : list) {
            object = new JSONObject();
            type = ruleDTO.getItemType();
            defaultValue = ruleDTO.getDefaultValue();
            if (!"switch".equals(type) || !"0".equals(defaultValue)) continue;
            action = ruleDTO.getBusinessType() + ":" + "hideBtn" + ":" + ruleDTO.getItemCode();
            object.put("action", (Object)action);
            object.put("status", (Object)defaultValue);
            object.put("type", (Object)type);
            object.put("describe", (Object)ruleDTO.getItemName());
            jsonArray.add((Object)object);
        }
        return jsonArray.isEmpty() ? new JSONArray() : jsonArray;
    }

    private JSONObject getObjBySet(List<ElsCompanySetDTO> list) {
        JSONObject result = new JSONObject();
        if (list != null) {
            for (ElsCompanySetDTO set : list) {
                result.put(set.getItemCode(), (Object)set.getDefaultValue());
            }
        }
        return result;
    }

    @AutoLog(value="\u83b7\u53d6\u52a0\u5bc6\u5b57\u7b26\u4e32", logType=2, operateType=1)
    @GetMapping(value={"/getEncryptedString"})
    public Result<Map<String, String>> getEncryptedString() {
        Result result = new Result();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", EncryptedString.getKey());
        map.put("iv", EncryptedString.getIv());
        result.setResult(map);
        return result;
    }

    @AutoLog(value="\u83b7\u53d6\u9a8c\u8bc1\u7801", logType=2, operateType=1)
    @ApiOperation(value="\u83b7\u53d6\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/getCheckCode"})
    public Result<Map<String, String>> getCheckCode() {
        Result result = new Result();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String code = RandomUtil.randomString((String)BASE_CHECK_CODES, (int)4);
            String key = MD5Util.md5Encode((String)(code + System.currentTimeMillis()), (String)"utf-8");
            this.redisUtil.set(key, (Object)code, 180L);
            map.put("key", key);
            map.put("code", code);
            result.setResult(map);
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setSuccess(false);
        }
        return result;
    }
}

