/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contractlock.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contractlock.entity.SaleClPersonalInfo;
import com.els.modules.contractlock.mapper.SaleClPersonalInfoMapper;
import com.els.modules.contractlock.service.SaleClPersonalInfoService;
import com.els.modules.contractlock.util.ClResultAnalysisUtil;
import com.els.modules.contractlock.vo.ClCallback;
import com.els.modules.contractlock.vo.ClPersonalCertificationVO;
import com.els.modules.contractlock.vo.ClQueryCertificationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleClPersonalInfoServiceImpl
extends BaseServiceImpl<SaleClPersonalInfoMapper, SaleClPersonalInfo>
implements SaleClPersonalInfoService {
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public void updateInfo(SaleClPersonalInfo saleClPersonalInfo) {
        saleClPersonalInfo.setUpdateTime(new Date());
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        saleClPersonalInfo.setUpdateBy(currentUser);
        ((SaleClPersonalInfoMapper)this.baseMapper).updateById((Object)saleClPersonalInfo);
        this.getCertificationInfo(saleClPersonalInfo.getId());
    }

    public void saveInfo(SaleClPersonalInfo saleClPersonalInfo) {
        saleClPersonalInfo.setCreateAccount(TenantContext.getTenant());
        saleClPersonalInfo.setCreateTime(new Date());
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        saleClPersonalInfo.setCreateBy(currentUser);
        ((SaleClPersonalInfoMapper)this.baseMapper).insert((Object)saleClPersonalInfo);
        this.getCertificationInfo(saleClPersonalInfo.getId());
    }

    public void handleDb(SaleClPersonalInfo req) {
        if (StringUtils.isBlank((CharSequence)req.getId())) {
            this.saveInfo(req);
        } else {
            this.updateInfo(req);
        }
    }

    @Override
    public void add(SaleClPersonalInfo saleClPersonalInfo) {
        this.saveInfo(saleClPersonalInfo);
    }

    @Override
    public void edit(SaleClPersonalInfo saleClPersonalInfo) {
        this.updateInfo(saleClPersonalInfo);
    }

    @Override
    public void delete(String id) {
        ((SaleClPersonalInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleClPersonalInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void submitCertification(SaleClPersonalInfo req) {
        req.setCertificationStartTime(new Date());
        this.handleDb(req);
        ClPersonalCertificationVO certificationInfo = (ClPersonalCertificationVO)SysUtil.copyProperties((Object)((Object)req), ClPersonalCertificationVO.class);
        certificationInfo.setUsername(req.getApplyUserName());
        certificationInfo.setUser(new ClPersonalCertificationVO.User(req.getApplyContact(), req.getApplyContactType()));
        certificationInfo.setCallbackUrl(this.address + "/els/contractLock/saleClPersonalInfo/noToken/callback/personal");
        ClResultAnalysisUtil.handleEmptyStr(certificationInfo);
        Result<?> response = this.getIPassResponse(certificationInfo, "get-auth-personal");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            req.setCertificationPageUrl(jsonObject.getString("authUrl"));
            req.setAuthId(jsonObject.getString("authId"));
            this.updateById((Object)req);
        } else {
            Assert.isTrue((boolean)false, (String)response.getMessage());
        }
    }

    @Override
    public void getCertificationInfo(String id) {
        SaleClPersonalInfo info = (SaleClPersonalInfo)((Object)this.getById((Serializable)((Object)id)));
        ClQueryCertificationVO clQueryCertificationVO = new ClQueryCertificationVO();
        ClQueryCertificationVO.Param base = new ClQueryCertificationVO.Param();
        if (StrUtil.isNotBlank((CharSequence)info.getAuthId())) {
            base.setAuthId(info.getAuthId());
        } else {
            base.setUser(null);
        }
        clQueryCertificationVO.setBase(base);
        Result<?> response = this.getIPassResponse(clQueryCertificationVO, "query-auth-personal");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            Boolean realName = jsonObject.getBoolean("realName");
            if (realName != null && realName.booleanValue()) {
                info.setRealName("1");
            } else {
                info.setRealName("0");
            }
            this.updateById((Object)info);
        }
    }

    @Override
    public void handleCallBackAuth(String contents) {
        ClCallback.PersonalAuth personalAuth = (ClCallback.PersonalAuth)JSON.parseObject((String)contents, ClCallback.PersonalAuth.class);
        SaleClPersonalInfo dbInfo = ((SaleClPersonalInfoMapper)this.baseMapper).selectByRequestId(personalAuth.getAuthId());
        if (ObjectUtil.isNotNull((Object)((Object)dbInfo)) && "1".equals(personalAuth.getStatus())) {
            dbInfo.setRealName("1");
            dbInfo.setUpdateTime(new Date());
            this.updateById((Object)dbInfo);
        }
    }

    private Result<?> getIPassResponse(Object req, String iPassCode) {
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)req)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(iPassCode));
        return ClResultAnalysisUtil.analysisResult(object);
    }
}

