/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.esign.entity.ElsSubaccountCertificationInfo;
import com.els.modules.esign.mapper.ElsSubaccountCertificationInfoMapper;
import com.els.modules.esign.service.ElsSubaccountCertificationInfoService;
import com.els.modules.esign.util.EsignResultAnalysisUtil;
import com.els.modules.esign.vo.EsignCreatePersonAccountVO;
import com.els.modules.esign.vo.PersonAuthCallBakVO;
import com.els.modules.esign.vo.PersonAuthenticationEO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsSubaccountCertificationInfoServiceImpl
extends BaseServiceImpl<ElsSubaccountCertificationInfoMapper, ElsSubaccountCertificationInfo>
implements ElsSubaccountCertificationInfoService {
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private ElsEnterpriseInfoMapper elsEnterpriseInfoMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void saveElsSubaccountCertificationInfo(ElsSubaccountCertificationInfo elsSubaccountCertificationInfo) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"sub_account_id", (Object)elsSubaccountCertificationInfo.getSubAccountId());
        wrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        if (StringUtils.isNotBlank((CharSequence)elsSubaccountCertificationInfo.getCreatedAccount())) {
            wrapper.eq((Object)"created_account", (Object)elsSubaccountCertificationInfo.getCreatedAccount());
        } else {
            wrapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"created_account")).or()).eq((Object)"created_account", (Object)""));
        }
        if (!this.list((Wrapper)wrapper).isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rLieyIOMKWxqVBcI_6af1162d", (String)"\u8be5\u8ba4\u8bc1\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa"));
        }
        elsSubaccountCertificationInfo.setBusAccount("100000");
        elsSubaccountCertificationInfo.setCertificationStatus("0");
        ElsEnterpriseInfo enterpriseInfo = this.elsEnterpriseInfoMapper.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            elsSubaccountCertificationInfo.setCompanyName(enterpriseInfo.getName());
        }
        ((ElsSubaccountCertificationInfoMapper)this.baseMapper).insert((Object)elsSubaccountCertificationInfo);
    }

    @Override
    public void updateElsSubaccountCertificationInfo(ElsSubaccountCertificationInfo elsSubaccountCertificationInfo) {
        ((ElsSubaccountCertificationInfoMapper)this.baseMapper).updateById((Object)elsSubaccountCertificationInfo);
    }

    @Override
    public void delElsSubaccountCertificationInfo(String id) {
        ((ElsSubaccountCertificationInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsSubaccountCertificationInfo(List<String> idList) {
        ((ElsSubaccountCertificationInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Result<?> submintCertification(ElsSubaccountCertificationInfo elsSubaccountCertificationInfo) {
        if (StringUtils.isBlank((CharSequence)elsSubaccountCertificationInfo.getId())) {
            this.saveElsSubaccountCertificationInfo(elsSubaccountCertificationInfo);
        } else {
            this.updateElsSubaccountCertificationInfo(elsSubaccountCertificationInfo);
        }
        Result<?> response = null;
        if (StringUtils.isBlank((CharSequence)elsSubaccountCertificationInfo.getAccountId())) {
            EsignCreatePersonAccountVO accountVO = (EsignCreatePersonAccountVO)SysUtil.copyProperties((Object)((Object)elsSubaccountCertificationInfo), EsignCreatePersonAccountVO.class);
            accountVO.setThirdPartyUserId(accountVO.getIdNumber());
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)accountVO)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("create-person-account"));
            response = EsignResultAnalysisUtil.analysisResult(jsonObject);
            if (response.isSuccess()) {
                ElsSubaccountCertificationInfo certificationInfo = (ElsSubaccountCertificationInfo)((Object)JSON.parseObject((String)response.getResult().toString(), ElsSubaccountCertificationInfo.class));
                elsSubaccountCertificationInfo.setAccountId(certificationInfo.getAccountId());
                this.updateById((Object)elsSubaccountCertificationInfo);
            } else {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_LiDJKmW_44a47b5", (String)"\u8ba4\u8bc1\u63d0\u4ea4\u5931\u8d25:") + response.getMessage()));
            }
        }
        String notifyUrl = "";
        notifyUrl = this.address.endsWith("/") ? this.address + "els/esign/elsSubaccountCertificationInfo/callback/person" : this.address + "/els/esign/elsSubaccountCertificationInfo/callback/person";
        PersonAuthenticationEO authenticationEO = new PersonAuthenticationEO(elsSubaccountCertificationInfo, notifyUrl);
        JSONObject requestJSON = new JSONObject();
        JSONObject base = new JSONObject();
        base.put("accountId", (Object)elsSubaccountCertificationInfo.getAccountId());
        requestJSON.put("base", (Object)base);
        requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)authenticationEO)));
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-person-auth-address"));
        response = EsignResultAnalysisUtil.analysisResult(object);
        if (!response.isSuccess()) {
            return Result.error((String)(I18nUtil.translate((String)"i18n_alert_LiDJKmW_44a47b5", (String)"\u8ba4\u8bc1\u63d0\u4ea4\u5931\u8d25:") + response.getMessage()));
        }
        JSONObject jsonObject = (JSONObject)response.getResult();
        elsSubaccountCertificationInfo.setShortLink(jsonObject.getString("shortLink"));
        elsSubaccountCertificationInfo.setLongLink(jsonObject.getString("url"));
        elsSubaccountCertificationInfo.setEsignFlowId(jsonObject.getString("flowId"));
        elsSubaccountCertificationInfo.setCertificationStartTime(new Date());
        this.updateById((Object)elsSubaccountCertificationInfo);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_LiDJLR_296e9080", (String)"\u8ba4\u8bc1\u63d0\u4ea4\u6210\u529f"));
    }

    @Override
    public Result<?> getCertificationInfo(String id) {
        ElsSubaccountCertificationInfo certificationInfo = (ElsSubaccountCertificationInfo)((Object)this.getById((Serializable)((Object)id)));
        if (certificationInfo != null) {
            JSONObject param = new JSONObject();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("flowId", certificationInfo.getEsignFlowId());
            param.put("base", map);
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(param, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-auth-info"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(jsonObject);
            if (!response.isSuccess()) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_tkKm_2f078e83", (String)"\u64cd\u4f5c\u5931\u8d25") + "\uff1a" + response.getMessage()));
            }
            JSONObject data = (JSONObject)response.getResult();
            String status = data.getString("status");
            if (!"SUCCESS".equals(status)) {
                if ("INIT".equals(status)) {
                    return Result.error((String)I18nUtil.translate((String)"i18n_alert_rVHWIhAWLiWtsLLiMWVKdVELCtLiKyHcLiW_763da9fc", (String)"\u8be5\u4fe1\u606f\u201c\u5df2\u53d1\u8d77\u201d\u8ba4\u8bc1\uff0c\u4f46\u8fd8\u672a\u8ba4\u8bc1\u5b8c\uff0c\u8bf7\u5728\u8be6\u60c5\u9875\u9762\u70b9\u51fb\u8ba4\u8bc1\u94fe\u63a5\u8fdb\u884c\u8ba4\u8bc1\uff01"));
                }
                if ("ING".equals(status)) {
                    return Result.error((String)I18nUtil.translate((String)"i18n_alert_rVHjLizELWHcsWWVLyVEoLiMLW_b5d7fad0", (String)"\u8be5\u4fe1\u606f\u7684\u8ba4\u8bc1\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\uff0c\u8bf7\u60a8\u8010\u5fc3\u7b49\u5f85\u8ba4\u8bc1\u5b8c\u6210\uff01"));
                }
                return Result.error((String)I18nUtil.translate((String)"i18n__rVHLizELWIKmWWVLVVLiW_8dcfc898", (String)"\u8be5\u4fe1\u606f\u8ba4\u8bc1\u72b6\u6001\u4e3a\u201c\u5df2\u5931\u8d25\u201d\uff0c\u8bf7\u60a8\u91cd\u65b0\u8ba4\u8bc1\uff01"));
            }
            certificationInfo.setCertificationStatus("1");
            ((ElsSubaccountCertificationInfoMapper)this.baseMapper).updateById((Object)certificationInfo);
            return Result.ok((String)I18nUtil.translate((String)"i18n_title_operationSuccess", (String)"\u64cd\u4f5c\u6210\u529f\uff01"));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_VNjWWjSWmhxuIdjWFW_5a452366", (String)"\u4f20\u5165\u7684id\u6709\u8bef\uff0c\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff01"));
    }

    @Override
    public void personCallBack(JSONObject object) {
        PersonAuthCallBakVO authCallBakVO = (PersonAuthCallBakVO)JSON.parseObject((String)object.toJSONString(), PersonAuthCallBakVO.class);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"esign_flow_id", (Object)authCallBakVO.getFlowId());
        List certificationInfos = this.list((Wrapper)wrapper);
        if (!certificationInfos.isEmpty()) {
            ElsSubaccountCertificationInfo certificationInfo = (ElsSubaccountCertificationInfo)((Object)certificationInfos.get(0));
            JSONObject obj = new JSONObject();
            if (authCallBakVO.isSuccess()) {
                certificationInfo.setCertificationStatus("1");
                certificationInfo.setVerifyCode(authCallBakVO.getVerifycode());
                this.updateById((Object)certificationInfo);
                obj.put("authResult", (Object)"\u6210\u529f");
            } else {
                obj.put("authResult", (Object)"\u5931\u8d25");
            }
        }
    }

    @Override
    public Result<?> modifyAuthInfo(ElsSubaccountCertificationInfo elsSubaccountCertificationInfo) {
        JSONObject requestJSON = new JSONObject();
        JSONObject bascis = new JSONObject();
        bascis.put("accountId", (Object)elsSubaccountCertificationInfo.getAccountId());
        requestJSON.put("base", (Object)bascis);
        EsignCreatePersonAccountVO accountVO = (EsignCreatePersonAccountVO)SysUtil.copyProperties((Object)((Object)elsSubaccountCertificationInfo), EsignCreatePersonAccountVO.class);
        accountVO.setThirdPartyUserId(elsSubaccountCertificationInfo.getSubAccountId());
        requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)accountVO)));
        JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("modify-person-account"));
        Result<?> response = EsignResultAnalysisUtil.analysisResult(jsonObject);
        if (!response.isSuccess()) {
            return Result.error((String)(I18nUtil.translate((String)"i18n_alert_crKmW_95bef49b", (String)"\u4fee\u6539\u5931\u8d25:") + response.getMessage()));
        }
        this.updateById((Object)elsSubaccountCertificationInfo);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_crLR_25ddaeda", (String)"\u4fee\u6539\u6210\u529f"));
    }

    @Override
    public Result<?> silentAuth(ElsSubaccountCertificationInfo elsSubaccountCertificationInfo) {
        JSONObject requestJSON = new JSONObject();
        JSONObject bascis = new JSONObject();
        bascis.put("accountId", (Object)elsSubaccountCertificationInfo.getAccountId());
        requestJSON.put("base", (Object)bascis);
        JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("silent-auth-account"));
        Result<?> response = EsignResultAnalysisUtil.analysisResult(jsonObject);
        if (!response.isSuccess()) {
            return Result.error((String)(I18nUtil.translate((String)"i18n_alert_crKmW_95bef49b", (String)"\u4fee\u6539\u5931\u8d25:") + response.getMessage()));
        }
        elsSubaccountCertificationInfo.setSilentAuthStatus("1");
        this.updateById((Object)elsSubaccountCertificationInfo);
        return Result.ok((String)I18nUtil.translate((String)"i18n_title_successfulAuthorizationThanksSupport", (String)"\u6388\u6743\u6210\u529f"));
    }
}

